-- MySQL dump 10.13  Distrib 8.0.31, for macos12.6 (arm64)
--
-- Host: localhost    Database: martfury
-- ------------------------------------------------------
-- Server version	8.0.31

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'5627LNmLdaihHsVjZ68zEpVjgj3eSxLx',1,'2022-11-10 21:04:40','2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
INSERT INTO `ads` VALUES (1,'Top Slider Image 1','2027-11-11 00:00:00','not_set','VC2C8Q1UGCBG','promotion/1.jpg','/products',0,1,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(2,'Top Slider Image 2','2027-11-11 00:00:00','not_set','NBDWRXTSVZ8N','promotion/2.jpg','/products',0,2,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(3,'Homepage middle 1','2027-11-11 00:00:00','not_set','IZ6WU8KUALYD','promotion/3.jpg','/products',0,3,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(4,'Homepage middle 2','2027-11-11 00:00:00','not_set','ILSFJVYFGCPZ','promotion/4.jpg','/products',0,4,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(5,'Homepage middle 3','2027-11-11 00:00:00','not_set','ZDOZUZZIU7FT','promotion/5.jpg','/products',0,5,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(6,'Homepage big 1','2027-11-11 00:00:00','not_set','Q9YDUIC9HSWS','promotion/6.jpg','/products',0,6,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(7,'Homepage bottom small','2027-11-11 00:00:00','not_set','SSFOIB1D7OGZ','promotion/7.jpg','/products',0,7,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(8,'Product sidebar','2027-11-11 00:00:00','product-sidebar','5AJRTDTYKVR9','promotion/8.jpg','/products',0,8,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(9,'Homepage big 2','2027-11-11 00:00:00','not_set','IZ6WU8KUALYE','promotion/9.jpg','/products',0,9,'published','2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
INSERT INTO `ads_translations` VALUES ('vi',1,'Top Slider Image 1','promotion/1.jpg','/vi/products'),('vi',2,'Top Slider Image 2','promotion/2.jpg','/vi/products'),('vi',3,'Homepage middle 1','promotion/3.jpg','/vi/products'),('vi',4,'Homepage middle 2','promotion/4.jpg','/vi/products'),('vi',5,'Homepage middle 3','promotion/5.jpg','/vi/products'),('vi',6,'Homepage big 1','promotion/6.jpg','/vi/products'),('vi',7,'Homepage bottom small','promotion/7.jpg','/vi/products'),('vi',8,'Product sidebar','promotion/8.jpg','/vi/products'),('vi',9,'Homepage big 2','promotion/9.jpg','/vi/products');
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` text COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_user` int unsigned NOT NULL,
  `reference_id` int unsigned NOT NULL,
  `reference_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` int NOT NULL,
  `author_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `parent_id` (`parent_id`),
  KEY `status` (`status`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Ecommerce',0,'Ad ratione sit qui officiis eius reprehenderit et. Tenetur qui inventore nulla qui numquam ipsum qui sapiente. Quia qui non ab ut quo eum repudiandae et.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,1,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(2,'Fashion',0,'Fugit est eos facilis debitis repellendus non. Eos quam eum velit molestias asperiores. Itaque nihil porro asperiores ratione dolores optio quia sit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(3,'Electronic',0,'Velit qui nihil consectetur ad. Et nam et veritatis reprehenderit quibusdam numquam vel. Distinctio sint sed repellendus animi et ut autem. Maiores fuga quia molestiae.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(4,'Commercial',0,'Dolores in eos et dolor. Hic nihil consequuntur qui itaque quos. Amet maiores sit vel nemo minima. Id occaecati nesciunt minus quia suscipit deserunt.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2022-11-10 21:04:38','2022-11-10 21:04:38');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
INSERT INTO `categories_translations` VALUES ('vi',1,'Thương mại điện tử',NULL),('vi',2,'Thời trang',NULL),('vi',3,'Điện tử',NULL),('vi',4,'Thương mại',NULL);
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state_id` int unsigned NOT NULL,
  `country_id` int unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` int NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Afton Lebsack','nona.grady@example.net','+1-726-407-0262','7709 O\'Hara Harbor Apt. 233\nJonathonmouth, WY 86487-6831','Eveniet qui optio suscipit optio.','Natus maxime neque aperiam animi quibusdam tempora. Iusto et assumenda magni voluptate. Voluptatem occaecati ut optio vitae. Cumque eos voluptatum vel consequatur natus harum et suscipit. Placeat sit optio deleniti suscipit amet iste mollitia. Delectus nesciunt voluptatibus vero sed adipisci accusamus. In officia voluptatem expedita atque rem neque sed. Fuga amet ut vel.','read','2022-11-10 21:04:37','2022-11-10 21:04:37'),(2,'Ms. Heaven Jakubowski','schowalter.marlon@example.net','+1-657-313-2504','76305 Lorna Knoll\nPort Maximetown, MI 14012','Enim laboriosam explicabo et aut nisi optio.','Aut ut dolore libero inventore. Modi culpa nostrum illo vel illo harum. Laboriosam iure qui omnis deleniti in omnis soluta. Et est hic provident. Magnam expedita voluptatem totam similique. Eveniet et optio unde odit doloremque deleniti fugit blanditiis. Nostrum tenetur quam nesciunt fuga culpa. Impedit nisi cumque accusamus corporis quia. Porro natus aperiam ea dolores. Sed ut maxime et et sed sit.','read','2022-11-10 21:04:37','2022-11-10 21:04:37'),(3,'Domenick D\'Amore','lionel.buckridge@example.com','304.528.1965','523 Tyreek Orchard Apt. 082\nNew Stephania, CT 34427','Placeat aut ea omnis quas itaque commodi itaque.','Voluptas et earum laudantium quae. Et corporis voluptatum quis labore qui. Dolor autem odit nobis quibusdam tempore vel. Doloribus aut nihil consequatur soluta hic. Ex officia illum earum. Quas praesentium itaque non eum aliquid voluptates incidunt. Voluptates velit tempora consequatur. Laudantium atque omnis esse et voluptatem eos tempora. Quia sint adipisci totam ut omnis quis. Consequatur quibusdam ut error inventore mollitia est ea. Voluptatem eaque suscipit culpa excepturi aliquid.','read','2022-11-10 21:04:37','2022-11-10 21:04:37'),(4,'Mr. Narciso West I','tupton@example.net','+1.308.875.7437','7567 Camila Inlet Suite 925\nLake Mckenna, SC 76322','Dolores non atque placeat iure.','Illo sed ut dolorem non ea reprehenderit ut. Natus quia in sed eaque. Nostrum quaerat perspiciatis est accusantium. Sit omnis beatae eum reprehenderit aut error. Nisi voluptates exercitationem exercitationem delectus. Repellendus doloribus facere id pariatur autem expedita cumque. Non ea sit recusandae voluptates accusamus. Nobis non quis laborum quis esse necessitatibus. Repellat quis aliquam alias in. Culpa inventore iusto magnam est est nemo sapiente.','unread','2022-11-10 21:04:37','2022-11-10 21:04:37'),(5,'Mrs. Lonie Franecki MD','fcorwin@example.com','+1.240.247.5427','69144 Parker Ports Suite 515\nNorth Ezekiel, AR 98166','Quibusdam sit amet exercitationem.','Dolorum ullam dicta magnam nemo quia et. Sed nobis doloribus ut aut saepe sapiente rerum. Natus neque et sunt velit quasi et tempora. Molestiae beatae veritatis neque labore. Odit quam accusamus et voluptatibus minus cupiditate quae deserunt. Amet saepe odit eos iste. Atque illum nobis non molestiae ipsam. Possimus accusamus eum sed animi. Et occaecati omnis sed molestiae. Magnam placeat nisi labore rerum numquam sed at quasi. Ab sit nobis possimus.','unread','2022-11-10 21:04:37','2022-11-10 21:04:37'),(6,'Mr. Giovanny Greenfelder II','chad.nader@example.net','+1.979.210.9803','75696 Okuneva Groves\nPort Georgette, AZ 34325','Distinctio in sed aspernatur repudiandae.','Dolore dolore odio earum facere ea adipisci dolor. Aut ducimus quis aut ut ut. Et earum ut quos nihil fugiat nobis excepturi sit. Et qui aut error qui libero rerum aut. Tempora esse odit a. Labore numquam sint sit et fuga non sed. Ipsam aperiam commodi facilis vel eius excepturi maiores reiciendis. Perspiciatis cumque et iusto qui dicta consequatur corporis.','unread','2022-11-10 21:04:37','2022-11-10 21:04:37'),(7,'Eliza Langosh','deffertz@example.org','+15053662169','688 Joe Lake Apt. 022\nGottliebstad, AL 59721-9502','Sed sequi nobis explicabo.','Aut labore hic commodi commodi. Consequatur ipsum animi consequatur repellendus alias aliquam hic. Facere perferendis eius qui aliquid voluptatibus velit unde. Quo occaecati sed blanditiis iusto repellat laborum. Est quidem itaque quas laboriosam repudiandae sunt et. Saepe quas earum necessitatibus enim aut et consectetur. Et et et in eius. Minus aut officia sequi itaque sunt maiores. Perspiciatis quisquam voluptatem deserunt velit est error. Dolorum magni fuga numquam nulla sit.','read','2022-11-10 21:04:37','2022-11-10 21:04:37'),(8,'Prof. Grace Simonis I','eveline87@example.net','+1-952-594-3451','43097 Braun Run Apt. 209\nNew Marciaside, KY 97399-7551','Esse ab magni ut modi laborum.','Hic enim provident perferendis. Dolores sint et voluptatibus odio dolorum. Qui ut ut non aut. Odio molestiae modi libero assumenda. Tempora modi ab possimus odio. Nam tenetur molestiae ea iure voluptatum ab molestias. Fuga omnis et beatae vel debitis. Architecto amet ipsam dolor dolore molestiae a accusantium. Consequuntur ut et fugiat nostrum placeat id. Velit eius non asperiores inventore quos.','unread','2022-11-10 21:04:37','2022-11-10 21:04:37'),(9,'Cheyanne Bauch','johnathan67@example.net','+1-669-552-4313','2675 Quitzon Fort Apt. 747\nBinsville, PA 71205-3767','Quia fugit necessitatibus eos soluta ex.','Non delectus nulla qui qui earum voluptates officiis. Beatae mollitia labore sed nostrum provident nihil perspiciatis. Soluta illo necessitatibus natus et. Ullam quia unde qui aliquam magnam recusandae. Et quis aliquid facere cupiditate non consequatur. Omnis mollitia quibusdam voluptate omnis. Dolores pariatur ipsa excepturi aut consequuntur. Consequatur magni cumque placeat nam ullam nemo quae.','read','2022-11-10 21:04:37','2022-11-10 21:04:37'),(10,'Lurline Sporer','carleton.schmidt@example.org','+1-734-394-2174','1677 Willms Extensions Suite 597\nEast Maiyahaven, IN 11242-6054','Et voluptatem iste id incidunt eos.','Rerum impedit veniam itaque est blanditiis. Tenetur deserunt voluptatem officiis ut. Et nihil aspernatur in autem quod. Aliquid consectetur fugiat cum explicabo. Eaque cupiditate fuga hic omnis dolorem aperiam. Temporibus ab provident ipsa laborum similique voluptates. Soluta aut quia et architecto aut eveniet. Incidunt officiis autem quia praesentium recusandae eos. Illum explicabo eaque et ut ea quisquam est perferendis. Omnis non dolor quod dolores ut. Quia sit ipsum corrupti doloremque.','unread','2022-11-10 21:04:37','2022-11-10 21:04:37');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` int NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` int unsigned NOT NULL,
  `widget_id` int unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands`
--

DROP TABLE IF EXISTS `ec_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `website` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands`
--

LOCK TABLES `ec_brands` WRITE;
/*!40000 ALTER TABLE `ec_brands` DISABLE KEYS */;
INSERT INTO `ec_brands` VALUES (1,'Fashion live',NULL,NULL,'brands/1.jpg','published',0,1,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(2,'Hand crafted',NULL,NULL,'brands/2.jpg','published',1,1,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(3,'Mestonix',NULL,NULL,'brands/3.jpg','published',2,1,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(4,'Sunshine',NULL,NULL,'brands/4.jpg','published',3,1,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(5,'Pure',NULL,NULL,'brands/5.jpg','published',4,1,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(6,'Anfold',NULL,NULL,'brands/6.jpg','published',5,1,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(7,'Automotive',NULL,NULL,'brands/7.jpg','published',6,1,'2022-11-10 21:04:30','2022-11-10 21:04:30');
/*!40000 ALTER TABLE `ec_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_brands_translations`
--

DROP TABLE IF EXISTS `ec_brands_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_brands_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_brands_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_brands_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_brands_translations`
--

LOCK TABLES `ec_brands_translations` WRITE;
/*!40000 ALTER TABLE `ec_brands_translations` DISABLE KEYS */;
INSERT INTO `ec_brands_translations` VALUES ('vi',1,'Fashion live',NULL),('vi',2,'Hand crafted',NULL),('vi',3,'Mestonix',NULL),('vi',4,'Sunshine',NULL),('vi',5,'Pure',NULL),('vi',6,'Anfold',NULL),('vi',7,'Automotive',NULL);
/*!40000 ALTER TABLE `ec_brands_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_cart`
--

DROP TABLE IF EXISTS `ec_cart`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_cart` (
  `identifier` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `instance` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`identifier`,`instance`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_cart`
--

LOCK TABLES `ec_cart` WRITE;
/*!40000 ALTER TABLE `ec_cart` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_cart` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_currencies`
--

DROP TABLE IF EXISTS `ec_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned DEFAULT '0',
  `order` int unsigned DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_currencies`
--

LOCK TABLES `ec_currencies` WRITE;
/*!40000 ALTER TABLE `ec_currencies` DISABLE KEYS */;
INSERT INTO `ec_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(2,'EUR','€',0,2,1,0,0.84,'2022-11-10 21:04:30','2022-11-10 21:04:30'),(3,'VND','₫',0,0,2,0,23203,'2022-11-10 21:04:30','2022-11-10 21:04:30');
/*!40000 ALTER TABLE `ec_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_addresses`
--

DROP TABLE IF EXISTS `ec_customer_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` int unsigned NOT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_addresses`
--

LOCK TABLES `ec_customer_addresses` WRITE;
/*!40000 ALTER TABLE `ec_customer_addresses` DISABLE KEYS */;
INSERT INTO `ec_customer_addresses` VALUES (1,'Berneice Klein','customer@botble.com','+17573310260','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',1,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','67581'),(2,'Berneice Klein','customer@botble.com','+12123103583','ZM','Wyoming','Predovicstad','563 Burdette Underpass',1,0,'2022-11-10 21:04:37','2022-11-10 21:04:37','78804'),(3,'Dr. Brad Thiel','vendor@botble.com','+12792063467','SZ','Maine','Lake Lourdesmouth','98918 Trystan Turnpike Suite 841',2,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','01372-7453'),(4,'Dr. Brad Thiel','vendor@botble.com','+16814314955','UZ','Texas','Quigleyton','510 Janis Ports Apt. 451',2,0,'2022-11-10 21:04:37','2022-11-10 21:04:37','42581-4912'),(5,'Benjamin Ullrich','reynolds.adrien@example.org','+17862843339','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',3,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','54906'),(6,'Karli VonRueden Sr.','vkub@example.org','+13099371127','CN','Tennessee','Schimmelfurt','601 Quigley Circle',4,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','87422-4680'),(7,'Miss Jayda Erdman','cade.cremin@example.org','+13236726833','NR','New Mexico','Daretown','21488 Krystel Dam',5,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','87007'),(8,'Vella Oberbrunner','reilly18@example.org','+19304994609','GU','Nevada','Coraton','482 Stehr Glen',6,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','36894'),(9,'Lonzo Bauch Jr.','lorna.block@example.net','+12408489996','RS','North Dakota','Port Elmerborough','154 Berge Extension Suite 744',7,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','93671-8125'),(10,'Eli Powlowski','addie.schoen@example.com','+18453156386','PF','Maine','North Hectorstad','78271 Steuber Gateway',8,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','64118'),(11,'Kaelyn Hilpert II','maximilian.feest@example.com','+16802533230','FJ','New York','O\'Connerberg','237 Christopher Brook',9,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','96089-4621'),(12,'Mr. Garry Bins I','gmclaughlin@example.org','+14584402296','BE','Washington','Ondrickaberg','9317 Clyde Skyway Apt. 775',10,1,'2022-11-10 21:04:37','2022-11-10 21:04:37','39641');
/*!40000 ALTER TABLE `ec_customer_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_password_resets`
--

DROP TABLE IF EXISTS `ec_customer_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `ec_customer_password_resets_email_index` (`email`),
  KEY `ec_customer_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_password_resets`
--

LOCK TABLES `ec_customer_password_resets` WRITE;
/*!40000 ALTER TABLE `ec_customer_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customer_recently_viewed_products`
--

DROP TABLE IF EXISTS `ec_customer_recently_viewed_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customer_recently_viewed_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customer_recently_viewed_products`
--

LOCK TABLES `ec_customer_recently_viewed_products` WRITE;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_customer_recently_viewed_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_customers`
--

DROP TABLE IF EXISTS `ec_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `is_vendor` tinyint(1) NOT NULL DEFAULT '0',
  `vendor_verified_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_customers_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_customers`
--

LOCK TABLES `ec_customers` WRITE;
/*!40000 ALTER TABLE `ec_customers` DISABLE KEYS */;
INSERT INTO `ec_customers` VALUES (1,'Berneice Klein','customer@botble.com','$2y$10$OTd3xWXlHuK/eYhlv57pw.4dBJp2UckMIxw26riV3QXQpkEIILp5S','customers/9.jpg','1982-10-13','+19375399244',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:37','2022-11-11 04:04:37',NULL,'activated',0,NULL),(2,'Dr. Brad Thiel','vendor@botble.com','$2y$10$Ck4f6ftGoU8v3e9Zh/rR6O5vdJ9vs4Ryok.F9zpAJqJgoyzaiv/4O','customers/1.jpg','1990-11-03','+12158861719',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:42','2022-11-11 04:04:37',NULL,'activated',1,'2022-11-11 04:04:42'),(3,'Benjamin Ullrich','reynolds.adrien@example.org','$2y$10$x0VFcGU53zrw0bYoBWA5aOKhkbmTDrkXMU4p3bgz5lQDhvdRfa4hi','customers/1.jpg','1979-10-26','+15155228324',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:37','2022-11-11 04:04:37',NULL,'activated',0,NULL),(4,'Karli VonRueden Sr.','vkub@example.org','$2y$10$RV/bsidfSvJdPB9nqlD06uM.NMCsUolBjfbyiFZZGPl4Yq1XydQr6','customers/2.jpg','1997-10-29','+17604571819',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:37','2022-11-11 04:04:37',NULL,'activated',0,NULL),(5,'Miss Jayda Erdman','cade.cremin@example.org','$2y$10$HX851CiSeEa.eatz1L66eeLHtFgUXlN2YT1PrxKdli9C3ek3yaNF2','customers/3.jpg','1992-10-21','+14842526742',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:42','2022-11-11 04:04:37',NULL,'activated',1,'2022-11-11 04:04:42'),(6,'Vella Oberbrunner','reilly18@example.org','$2y$10$Fh2onet3pACnukr4jvyzbexlwXZDyZnz9bZkk61/NGMvLjScBPtUS','customers/4.jpg','1999-10-28','+18457293397',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:42','2022-11-11 04:04:37',NULL,'activated',1,'2022-11-11 04:04:42'),(7,'Lonzo Bauch Jr.','lorna.block@example.net','$2y$10$4FCZv5vxffZHX5Z5k1/A7.0m9vIPMOq05rmZF9tn7bC5YxCPEFcAK','customers/5.jpg','1976-11-02','+13608781570',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:42','2022-11-11 04:04:37',NULL,'activated',1,'2022-11-11 04:04:42'),(8,'Eli Powlowski','addie.schoen@example.com','$2y$10$.juOJkrmpTRuA40LG7jaaeK.qqR0MtEjnAV6qxLvLZqVQYtmHu9W2','customers/6.jpg','1984-11-10','+14782538629',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:37','2022-11-11 04:04:37',NULL,'activated',0,NULL),(9,'Kaelyn Hilpert II','maximilian.feest@example.com','$2y$10$A.VJ7OZWkFKrognZa4Ivj.Vtu/Oany3U.5k41h5U3csc9gJlebMGy','customers/7.jpg','1980-10-21','+17543822413',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:42','2022-11-11 04:04:37',NULL,'activated',1,'2022-11-11 04:04:42'),(10,'Mr. Garry Bins I','gmclaughlin@example.org','$2y$10$aNcEqAki.S72v2F/8BfBhOI2BYFtgXlu/dNQwfTmBXFgQPOCbmL9q','customers/8.jpg','1973-10-13','+15853269556',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:42','2022-11-11 04:04:37',NULL,'activated',1,'2022-11-11 04:04:42');
/*!40000 ALTER TABLE `ec_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_customers`
--

DROP TABLE IF EXISTS `ec_discount_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_customers` (
  `discount_id` int unsigned NOT NULL,
  `customer_id` int unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_customers`
--

LOCK TABLES `ec_discount_customers` WRITE;
/*!40000 ALTER TABLE `ec_discount_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_product_collections`
--

DROP TABLE IF EXISTS `ec_discount_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_product_collections` (
  `discount_id` int unsigned NOT NULL,
  `product_collection_id` int unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_collection_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_product_collections`
--

LOCK TABLES `ec_discount_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_discount_product_collections` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discount_products`
--

DROP TABLE IF EXISTS `ec_discount_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discount_products` (
  `discount_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  PRIMARY KEY (`discount_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discount_products`
--

LOCK TABLES `ec_discount_products` WRITE;
/*!40000 ALTER TABLE `ec_discount_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discount_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_discounts`
--

DROP TABLE IF EXISTS `ec_discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_discounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `value` double DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'coupon',
  `can_use_with_promotion` tinyint(1) NOT NULL DEFAULT '0',
  `discount_on` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_quantity` int unsigned DEFAULT NULL,
  `type_option` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'amount',
  `target` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'all-orders',
  `min_order_price` decimal(15,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_discounts_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_discounts`
--

LOCK TABLES `ec_discounts` WRITE;
/*!40000 ALTER TABLE `ec_discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_discounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sale_products`
--

DROP TABLE IF EXISTS `ec_flash_sale_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sale_products` (
  `flash_sale_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `price` double unsigned DEFAULT NULL,
  `quantity` int unsigned DEFAULT NULL,
  `sold` int unsigned NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sale_products`
--

LOCK TABLES `ec_flash_sale_products` WRITE;
/*!40000 ALTER TABLE `ec_flash_sale_products` DISABLE KEYS */;
INSERT INTO `ec_flash_sale_products` VALUES (1,1,53.7675,9,5),(1,2,17.82,13,1),(1,3,8.2,16,2),(1,4,140.0688,15,3),(1,5,292.06,14,5),(1,6,345.87,9,3),(1,7,343.04,12,1),(1,8,734.31,13,5),(1,9,215.66,6,2),(1,10,696,20,3);
/*!40000 ALTER TABLE `ec_flash_sale_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales`
--

DROP TABLE IF EXISTS `ec_flash_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` datetime NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales`
--

LOCK TABLES `ec_flash_sales` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales` DISABLE KEYS */;
INSERT INTO `ec_flash_sales` VALUES (1,'Winter Sale','2022-12-11 00:00:00','published','2022-11-10 21:04:37','2022-11-10 21:04:37');
/*!40000 ALTER TABLE `ec_flash_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_flash_sales_translations`
--

DROP TABLE IF EXISTS `ec_flash_sales_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_flash_sales_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_flash_sales_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_flash_sales_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_flash_sales_translations`
--

LOCK TABLES `ec_flash_sales_translations` WRITE;
/*!40000 ALTER TABLE `ec_flash_sales_translations` DISABLE KEYS */;
INSERT INTO `ec_flash_sales_translations` VALUES ('vi',1,'Khuyến mãi mùa đông.');
/*!40000 ALTER TABLE `ec_flash_sales_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_option_value`
--

DROP TABLE IF EXISTS `ec_global_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_option_value` (
  `option_id` bigint NOT NULL COMMENT 'option id',
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_option_value`
--

LOCK TABLES `ec_global_option_value` WRITE;
/*!40000 ALTER TABLE `ec_global_option_value` DISABLE KEYS */;
INSERT INTO `ec_global_option_value` VALUES (1,'1 Year',0,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(1,'2 Year',10,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(1,'3 Year',20,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(2,'4GB',0,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(2,'8GB',10,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(2,'16GB',20,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(3,'Core i5',0,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(3,'Core i7',10,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(3,'Core i9',20,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(4,'128GB',0,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(4,'256GB',10,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(4,'512GB',20,9999,0,'2022-11-10 21:04:41','2022-11-10 21:04:41');
/*!40000 ALTER TABLE `ec_global_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_global_options`
--

DROP TABLE IF EXISTS `ec_global_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_global_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'option type',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_global_options`
--

LOCK TABLES `ec_global_options` WRITE;
/*!40000 ALTER TABLE `ec_global_options` DISABLE KEYS */;
INSERT INTO `ec_global_options` VALUES (1,'Warranty','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(2,'RAM','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(3,'CPU','Botble\\Ecommerce\\Option\\OptionType\\RadioButton',1,'2022-11-10 21:04:41','2022-11-10 21:04:41'),(4,'HDD','Botble\\Ecommerce\\Option\\OptionType\\Dropdown',0,'2022-11-10 21:04:41','2022-11-10 21:04:41');
/*!40000 ALTER TABLE `ec_global_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_grouped_products`
--

DROP TABLE IF EXISTS `ec_grouped_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_grouped_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_product_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `fixed_qty` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_grouped_products`
--

LOCK TABLES `ec_grouped_products` WRITE;
/*!40000 ALTER TABLE `ec_grouped_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_grouped_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoice_items`
--

DROP TABLE IF EXISTS `ec_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoice_items`
--

LOCK TABLES `ec_invoice_items` WRITE;
/*!40000 ALTER TABLE `ec_invoice_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_invoices`
--

DROP TABLE IF EXISTS `ec_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_tax_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` int unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_invoices_code_unique` (`code`),
  KEY `ec_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `ec_invoices_payment_id_index` (`payment_id`),
  KEY `ec_invoices_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_invoices`
--

LOCK TABLES `ec_invoices` WRITE;
/*!40000 ALTER TABLE `ec_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_option_value`
--

DROP TABLE IF EXISTS `ec_option_value`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_option_value` (
  `option_id` bigint NOT NULL COMMENT 'option id',
  `option_value` tinytext COLLATE utf8mb4_unicode_ci COMMENT 'option value',
  `affect_price` double DEFAULT NULL COMMENT 'value of price of this option affect',
  `order` int NOT NULL DEFAULT '9999',
  `affect_type` tinyint NOT NULL DEFAULT '0' COMMENT '0. fixed 1. percent',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_option_value`
--

LOCK TABLES `ec_option_value` WRITE;
/*!40000 ALTER TABLE `ec_option_value` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_option_value` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_options`
--

DROP TABLE IF EXISTS `ec_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Name of options',
  `option_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'option type',
  `product_id` bigint NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '9999',
  `required` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Checked if this option is required',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_options`
--

LOCK TABLES `ec_options` WRITE;
/*!40000 ALTER TABLE `ec_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_addresses`
--

DROP TABLE IF EXISTS `ec_order_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_addresses` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` int unsigned NOT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'shipping_address',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_addresses`
--

LOCK TABLES `ec_order_addresses` WRITE;
/*!40000 ALTER TABLE `ec_order_addresses` DISABLE KEYS */;
INSERT INTO `ec_order_addresses` VALUES (1,'Eli Powlowski','+18453156386','addie.schoen@example.com','PF','Maine','North Hectorstad','78271 Steuber Gateway',1,'64118','shipping_address'),(2,'Eli Powlowski','+18453156386','addie.schoen@example.com','PF','Maine','North Hectorstad','78271 Steuber Gateway',2,'64118','shipping_address'),(3,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',3,'87422-4680','shipping_address'),(4,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',4,'87422-4680','shipping_address'),(5,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',5,'87422-4680','shipping_address'),(6,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',6,'87422-4680','shipping_address'),(7,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',7,'54906','shipping_address'),(8,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',8,'54906','shipping_address'),(9,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',9,'87422-4680','shipping_address'),(10,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',10,'87422-4680','shipping_address'),(11,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',11,'87422-4680','shipping_address'),(12,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',12,'87422-4680','shipping_address'),(13,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',13,'67581','shipping_address'),(14,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',14,'67581','shipping_address'),(15,'Eli Powlowski','+18453156386','addie.schoen@example.com','PF','Maine','North Hectorstad','78271 Steuber Gateway',15,'64118','shipping_address'),(16,'Eli Powlowski','+18453156386','addie.schoen@example.com','PF','Maine','North Hectorstad','78271 Steuber Gateway',16,'64118','shipping_address'),(17,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',17,'67581','shipping_address'),(18,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',18,'67581','shipping_address'),(19,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',19,'67581','shipping_address'),(20,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',20,'67581','shipping_address'),(21,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',21,'67581','shipping_address'),(22,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',22,'67581','shipping_address'),(23,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',23,'87422-4680','shipping_address'),(24,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',24,'87422-4680','shipping_address'),(25,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',25,'87422-4680','shipping_address'),(26,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',26,'87422-4680','shipping_address'),(27,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',27,'87422-4680','shipping_address'),(28,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',28,'54906','shipping_address'),(29,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',29,'54906','shipping_address'),(30,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',30,'54906','shipping_address'),(31,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',31,'67581','shipping_address'),(32,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',32,'67581','shipping_address'),(33,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',33,'87422-4680','shipping_address'),(34,'Karli VonRueden Sr.','+13099371127','vkub@example.org','CN','Tennessee','Schimmelfurt','601 Quigley Circle',34,'87422-4680','shipping_address'),(35,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',35,'54906','shipping_address'),(36,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',36,'54906','shipping_address'),(37,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',37,'54906','shipping_address'),(38,'Benjamin Ullrich','+17862843339','reynolds.adrien@example.org','GG','North Carolina','Unashire','484 Rath Lodge Apt. 858',38,'54906','shipping_address'),(39,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',39,'67581','shipping_address'),(40,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',40,'67581','shipping_address'),(41,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',41,'67581','shipping_address'),(42,'Berneice Klein','+17573310260','customer@botble.com','UG','Florida','East Samara','87404 Schinner Ferry Apt. 024',42,'67581','shipping_address');
/*!40000 ALTER TABLE `ec_order_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_histories`
--

DROP TABLE IF EXISTS `ec_order_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `order_id` int unsigned NOT NULL,
  `extras` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=184 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_histories`
--

LOCK TABLES `ec_order_histories` WRITE;
/*!40000 ALTER TABLE `ec_order_histories` DISABLE KEYS */;
INSERT INTO `ec_order_histories` VALUES (1,'create_order_from_seeder','Order is created from the checkout page',NULL,1,NULL,'2022-10-28 13:04:42','2022-10-28 13:04:42'),(2,'confirm_order','Order was verified by %user_name%',0,1,NULL,'2022-10-28 13:04:42','2022-10-28 13:04:42'),(3,'confirm_payment','Payment was confirmed (amount $1,698.80) by %user_name%',0,1,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(4,'create_shipment','Created shipment for order',0,1,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(5,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(6,'create_order_from_seeder','Order is created from the checkout page',NULL,2,NULL,'2022-11-04 05:04:42','2022-11-04 05:04:42'),(7,'confirm_order','Order was verified by %user_name%',0,2,NULL,'2022-11-04 05:04:42','2022-11-04 05:04:42'),(8,'confirm_payment','Payment was confirmed (amount $2,904.30) by %user_name%',0,2,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(9,'create_shipment','Created shipment for order',0,2,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(10,'create_order_from_seeder','Order is created from the checkout page',NULL,3,NULL,'2022-10-26 01:04:42','2022-10-26 01:04:42'),(11,'confirm_order','Order was verified by %user_name%',0,3,NULL,'2022-10-26 01:04:42','2022-10-26 01:04:42'),(12,'confirm_payment','Payment was confirmed (amount $44.55) by %user_name%',0,3,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(13,'create_shipment','Created shipment for order',0,3,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(14,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(15,'create_order_from_seeder','Order is created from the checkout page',NULL,4,NULL,'2022-10-29 05:04:42','2022-10-29 05:04:42'),(16,'confirm_order','Order was verified by %user_name%',0,4,NULL,'2022-10-29 05:04:42','2022-10-29 05:04:42'),(17,'create_shipment','Created shipment for order',0,4,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(18,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(19,'create_order_from_seeder','Order is created from the checkout page',NULL,5,NULL,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(20,'confirm_order','Order was verified by %user_name%',0,5,NULL,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(21,'confirm_payment','Payment was confirmed (amount $3,884.30) by %user_name%',0,5,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(22,'create_shipment','Created shipment for order',0,5,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(23,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,5,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(24,'create_order_from_seeder','Order is created from the checkout page',NULL,6,NULL,'2022-11-01 21:04:42','2022-11-01 21:04:42'),(25,'confirm_order','Order was verified by %user_name%',0,6,NULL,'2022-11-01 21:04:42','2022-11-01 21:04:42'),(26,'confirm_payment','Payment was confirmed (amount $2,374.60) by %user_name%',0,6,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(27,'create_shipment','Created shipment for order',0,6,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(28,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(29,'create_order_from_seeder','Order is created from the checkout page',NULL,7,NULL,'2022-10-30 13:04:42','2022-10-30 13:04:42'),(30,'confirm_order','Order was verified by %user_name%',0,7,NULL,'2022-10-30 13:04:42','2022-10-30 13:04:42'),(31,'create_shipment','Created shipment for order',0,7,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(32,'create_order_from_seeder','Order is created from the checkout page',NULL,8,NULL,'2022-10-31 23:04:42','2022-10-31 23:04:42'),(33,'confirm_order','Order was verified by %user_name%',0,8,NULL,'2022-10-31 23:04:42','2022-10-31 23:04:42'),(34,'create_shipment','Created shipment for order',0,8,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(35,'create_order_from_seeder','Order is created from the checkout page',NULL,9,NULL,'2022-11-01 13:04:42','2022-11-01 13:04:42'),(36,'confirm_order','Order was verified by %user_name%',0,9,NULL,'2022-11-01 13:04:42','2022-11-01 13:04:42'),(37,'confirm_payment','Payment was confirmed (amount $578.60) by %user_name%',0,9,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(38,'create_shipment','Created shipment for order',0,9,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(39,'create_order_from_seeder','Order is created from the checkout page',NULL,10,NULL,'2022-11-01 13:04:42','2022-11-01 13:04:42'),(40,'confirm_order','Order was verified by %user_name%',0,10,NULL,'2022-11-01 13:04:42','2022-11-01 13:04:42'),(41,'confirm_payment','Payment was confirmed (amount $4,769.90) by %user_name%',0,10,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(42,'create_shipment','Created shipment for order',0,10,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(43,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,10,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(44,'create_order_from_seeder','Order is created from the checkout page',NULL,11,NULL,'2022-11-09 15:04:42','2022-11-09 15:04:42'),(45,'confirm_order','Order was verified by %user_name%',0,11,NULL,'2022-11-09 15:04:42','2022-11-09 15:04:42'),(46,'confirm_payment','Payment was confirmed (amount $469.70) by %user_name%',0,11,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(47,'create_shipment','Created shipment for order',0,11,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(48,'create_order_from_seeder','Order is created from the checkout page',NULL,12,NULL,'2022-11-09 15:04:42','2022-11-09 15:04:42'),(49,'confirm_order','Order was verified by %user_name%',0,12,NULL,'2022-11-09 15:04:42','2022-11-09 15:04:42'),(50,'confirm_payment','Payment was confirmed (amount $3,701.40) by %user_name%',0,12,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(51,'create_shipment','Created shipment for order',0,12,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(52,'create_order_from_seeder','Order is created from the checkout page',NULL,13,NULL,'2022-11-02 17:04:42','2022-11-02 17:04:42'),(53,'confirm_order','Order was verified by %user_name%',0,13,NULL,'2022-11-02 17:04:42','2022-11-02 17:04:42'),(54,'create_shipment','Created shipment for order',0,13,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(55,'create_order_from_seeder','Order is created from the checkout page',NULL,14,NULL,'2022-11-05 01:04:42','2022-11-05 01:04:42'),(56,'confirm_order','Order was verified by %user_name%',0,14,NULL,'2022-11-05 01:04:42','2022-11-05 01:04:42'),(57,'confirm_payment','Payment was confirmed (amount $1,875.30) by %user_name%',0,14,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(58,'create_shipment','Created shipment for order',0,14,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(59,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(60,'create_order_from_seeder','Order is created from the checkout page',NULL,15,NULL,'2022-11-05 11:04:42','2022-11-05 11:04:42'),(61,'confirm_order','Order was verified by %user_name%',0,15,NULL,'2022-11-05 11:04:42','2022-11-05 11:04:42'),(62,'create_shipment','Created shipment for order',0,15,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(63,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,15,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(64,'create_order_from_seeder','Order is created from the checkout page',NULL,16,NULL,'2022-11-02 05:04:42','2022-11-02 05:04:42'),(65,'confirm_order','Order was verified by %user_name%',0,16,NULL,'2022-11-02 05:04:42','2022-11-02 05:04:42'),(66,'confirm_payment','Payment was confirmed (amount $1,276.00) by %user_name%',0,16,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(67,'create_shipment','Created shipment for order',0,16,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(68,'create_order_from_seeder','Order is created from the checkout page',NULL,17,NULL,'2022-11-04 21:04:42','2022-11-04 21:04:42'),(69,'confirm_order','Order was verified by %user_name%',0,17,NULL,'2022-11-04 21:04:42','2022-11-04 21:04:42'),(70,'create_shipment','Created shipment for order',0,17,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(71,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,17,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(72,'create_order_from_seeder','Order is created from the checkout page',NULL,18,NULL,'2022-10-31 21:04:42','2022-10-31 21:04:42'),(73,'confirm_order','Order was verified by %user_name%',0,18,NULL,'2022-10-31 21:04:42','2022-10-31 21:04:42'),(74,'confirm_payment','Payment was confirmed (amount $2,608.20) by %user_name%',0,18,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(75,'create_shipment','Created shipment for order',0,18,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(76,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(77,'create_order_from_seeder','Order is created from the checkout page',NULL,19,NULL,'2022-11-07 05:04:42','2022-11-07 05:04:42'),(78,'confirm_order','Order was verified by %user_name%',0,19,NULL,'2022-11-07 05:04:42','2022-11-07 05:04:42'),(79,'confirm_payment','Payment was confirmed (amount $1,313.40) by %user_name%',0,19,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(80,'create_shipment','Created shipment for order',0,19,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(81,'create_order_from_seeder','Order is created from the checkout page',NULL,20,NULL,'2022-11-04 11:04:42','2022-11-04 11:04:42'),(82,'confirm_order','Order was verified by %user_name%',0,20,NULL,'2022-11-04 11:04:42','2022-11-04 11:04:42'),(83,'confirm_payment','Payment was confirmed (amount $608.30) by %user_name%',0,20,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(84,'create_shipment','Created shipment for order',0,20,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(85,'create_order_from_seeder','Order is created from the checkout page',NULL,21,NULL,'2022-11-03 09:04:42','2022-11-03 09:04:42'),(86,'confirm_order','Order was verified by %user_name%',0,21,NULL,'2022-11-03 09:04:42','2022-11-03 09:04:42'),(87,'create_shipment','Created shipment for order',0,21,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(88,'create_order_from_seeder','Order is created from the checkout page',NULL,22,NULL,'2022-11-03 09:04:42','2022-11-03 09:04:42'),(89,'confirm_order','Order was verified by %user_name%',0,22,NULL,'2022-11-03 09:04:42','2022-11-03 09:04:42'),(90,'confirm_payment','Payment was confirmed (amount $2,374.60) by %user_name%',0,22,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(91,'create_shipment','Created shipment for order',0,22,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(92,'create_order_from_seeder','Order is created from the checkout page',NULL,23,NULL,'2022-11-10 03:04:42','2022-11-10 03:04:42'),(93,'confirm_order','Order was verified by %user_name%',0,23,NULL,'2022-11-10 03:04:42','2022-11-10 03:04:42'),(94,'confirm_payment','Payment was confirmed (amount $1,733.90) by %user_name%',0,23,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(95,'create_shipment','Created shipment for order',0,23,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(96,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(97,'create_order_from_seeder','Order is created from the checkout page',NULL,24,NULL,'2022-11-08 15:04:42','2022-11-08 15:04:42'),(98,'confirm_order','Order was verified by %user_name%',0,24,NULL,'2022-11-08 15:04:42','2022-11-08 15:04:42'),(99,'confirm_payment','Payment was confirmed (amount $1,664.70) by %user_name%',0,24,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(100,'create_shipment','Created shipment for order',0,24,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(101,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(102,'create_order_from_seeder','Order is created from the checkout page',NULL,25,NULL,'2022-11-08 15:04:42','2022-11-08 15:04:42'),(103,'confirm_order','Order was verified by %user_name%',0,25,NULL,'2022-11-08 15:04:42','2022-11-08 15:04:42'),(104,'confirm_payment','Payment was confirmed (amount $1,366.20) by %user_name%',0,25,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(105,'create_shipment','Created shipment for order',0,25,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(106,'create_order_from_seeder','Order is created from the checkout page',NULL,26,NULL,'2022-11-08 05:04:42','2022-11-08 05:04:42'),(107,'confirm_order','Order was verified by %user_name%',0,26,NULL,'2022-11-08 05:04:42','2022-11-08 05:04:42'),(108,'create_shipment','Created shipment for order',0,26,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(109,'create_order_from_seeder','Order is created from the checkout page',NULL,27,NULL,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(110,'confirm_order','Order was verified by %user_name%',0,27,NULL,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(111,'confirm_payment','Payment was confirmed (amount $2,608.20) by %user_name%',0,27,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(112,'create_shipment','Created shipment for order',0,27,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(113,'create_order_from_seeder','Order is created from the checkout page',NULL,28,NULL,'2022-11-05 15:04:42','2022-11-05 15:04:42'),(114,'confirm_order','Order was verified by %user_name%',0,28,NULL,'2022-11-05 15:04:42','2022-11-05 15:04:42'),(115,'confirm_payment','Payment was confirmed (amount $1,215.98) by %user_name%',0,28,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(116,'create_shipment','Created shipment for order',0,28,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(117,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,28,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(118,'create_order_from_seeder','Order is created from the checkout page',NULL,29,NULL,'2022-11-09 17:04:42','2022-11-09 17:04:42'),(119,'confirm_order','Order was verified by %user_name%',0,29,NULL,'2022-11-09 17:04:42','2022-11-09 17:04:42'),(120,'create_shipment','Created shipment for order',0,29,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(121,'create_order_from_seeder','Order is created from the checkout page',NULL,30,NULL,'2022-11-06 05:04:42','2022-11-06 05:04:42'),(122,'confirm_order','Order was verified by %user_name%',0,30,NULL,'2022-11-06 05:04:42','2022-11-06 05:04:42'),(123,'create_shipment','Created shipment for order',0,30,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(124,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(125,'create_order_from_seeder','Order is created from the checkout page',NULL,31,NULL,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(126,'confirm_order','Order was verified by %user_name%',0,31,NULL,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(127,'create_shipment','Created shipment for order',0,31,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(128,'create_order_from_seeder','Order is created from the checkout page',NULL,32,NULL,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(129,'confirm_order','Order was verified by %user_name%',0,32,NULL,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(130,'confirm_payment','Payment was confirmed (amount $2,437.30) by %user_name%',0,32,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(131,'create_shipment','Created shipment for order',0,32,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(132,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(133,'create_order_from_seeder','Order is created from the checkout page',NULL,33,NULL,'2022-11-06 17:04:42','2022-11-06 17:04:42'),(134,'confirm_order','Order was verified by %user_name%',0,33,NULL,'2022-11-06 17:04:42','2022-11-06 17:04:42'),(135,'create_shipment','Created shipment for order',0,33,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(136,'create_order_from_seeder','Order is created from the checkout page',NULL,34,NULL,'2022-11-10 11:04:42','2022-11-10 11:04:42'),(137,'confirm_order','Order was verified by %user_name%',0,34,NULL,'2022-11-10 11:04:42','2022-11-10 11:04:42'),(138,'create_shipment','Created shipment for order',0,34,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(139,'create_order_from_seeder','Order is created from the checkout page',NULL,35,NULL,'2022-11-07 21:04:42','2022-11-07 21:04:42'),(140,'confirm_order','Order was verified by %user_name%',0,35,NULL,'2022-11-07 21:04:42','2022-11-07 21:04:42'),(141,'create_shipment','Created shipment for order',0,35,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(142,'create_order_from_seeder','Order is created from the checkout page',NULL,36,NULL,'2022-11-10 05:04:42','2022-11-10 05:04:42'),(143,'confirm_order','Order was verified by %user_name%',0,36,NULL,'2022-11-10 05:04:42','2022-11-10 05:04:42'),(144,'confirm_payment','Payment was confirmed (amount $3,701.40) by %user_name%',0,36,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(145,'create_shipment','Created shipment for order',0,36,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(146,'create_order_from_seeder','Order is created from the checkout page',NULL,37,NULL,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(147,'confirm_order','Order was verified by %user_name%',0,37,NULL,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(148,'confirm_payment','Payment was confirmed (amount $2,070.50) by %user_name%',0,37,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(149,'create_shipment','Created shipment for order',0,37,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(150,'create_order_from_seeder','Order is created from the checkout page',NULL,38,NULL,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(151,'confirm_order','Order was verified by %user_name%',0,38,NULL,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(152,'confirm_payment','Payment was confirmed (amount $3,701.40) by %user_name%',0,38,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(153,'create_shipment','Created shipment for order',0,38,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(154,'create_order_from_seeder','Order is created from the checkout page',NULL,39,NULL,'2022-11-10 13:04:42','2022-11-10 13:04:42'),(155,'confirm_order','Order was verified by %user_name%',0,39,NULL,'2022-11-10 13:04:42','2022-11-10 13:04:42'),(156,'confirm_payment','Payment was confirmed (amount $589.60) by %user_name%',0,39,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(157,'create_shipment','Created shipment for order',0,39,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(158,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(159,'create_order_from_seeder','Order is created from the checkout page',NULL,40,NULL,'2022-11-10 05:04:42','2022-11-10 05:04:42'),(160,'confirm_order','Order was verified by %user_name%',0,40,NULL,'2022-11-10 05:04:42','2022-11-10 05:04:42'),(161,'confirm_payment','Payment was confirmed (amount $2,507.40) by %user_name%',0,40,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(162,'create_shipment','Created shipment for order',0,40,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(163,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(164,'create_order_from_seeder','Order is created from the checkout page',NULL,41,NULL,'2022-11-10 17:04:42','2022-11-10 17:04:42'),(165,'confirm_order','Order was verified by %user_name%',0,41,NULL,'2022-11-10 17:04:42','2022-11-10 17:04:42'),(166,'confirm_payment','Payment was confirmed (amount $578.60) by %user_name%',0,41,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(167,'create_shipment','Created shipment for order',0,41,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(168,'create_order_from_seeder','Order is created from the checkout page',NULL,42,NULL,'2022-11-10 13:04:42','2022-11-10 13:04:42'),(169,'confirm_order','Order was verified by %user_name%',0,42,NULL,'2022-11-10 13:04:42','2022-11-10 13:04:42'),(170,'create_shipment','Created shipment for order',0,42,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(171,'update_status','Order confirmed by %user_name%',0,1,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(172,'update_status','Order confirmed by %user_name%',0,3,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(173,'update_status','Order confirmed by %user_name%',0,5,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(174,'update_status','Order confirmed by %user_name%',0,6,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(175,'update_status','Order confirmed by %user_name%',0,10,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(176,'update_status','Order confirmed by %user_name%',0,14,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(177,'update_status','Order confirmed by %user_name%',0,18,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(178,'update_status','Order confirmed by %user_name%',0,23,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(179,'update_status','Order confirmed by %user_name%',0,24,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43'),(180,'update_status','Order confirmed by %user_name%',0,28,NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44'),(181,'update_status','Order confirmed by %user_name%',0,32,NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44'),(182,'update_status','Order confirmed by %user_name%',0,39,NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44'),(183,'update_status','Order confirmed by %user_name%',0,40,NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44');
/*!40000 ALTER TABLE `ec_order_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_product`
--

DROP TABLE IF EXISTS `ec_order_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int unsigned NOT NULL,
  `qty` int NOT NULL,
  `price` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `product_options` text COLLATE utf8mb4_unicode_ci COMMENT 'product option data',
  `product_id` int unsigned DEFAULT NULL,
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `restock_quantity` int unsigned DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'physical',
  `times_downloaded` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_product`
--

LOCK TABLES `ec_order_product` WRITE;
/*!40000 ALTER TABLE `ec_order_product` DISABLE KEYS */;
INSERT INTO `ec_order_product` VALUES (1,1,3,548.00,54.80,'[]',NULL,31,'Red & Black Headphone',NULL,2613.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(2,2,2,427.00,42.70,'[]',NULL,37,'Nikon HD camera',NULL,1354.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(3,2,2,956.00,95.60,'[]',NULL,64,'Aveeno Moisturizing Body Shower 450ml',NULL,1504.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(4,3,1,40.50,4.05,'[]',NULL,27,'Smart Watches',NULL,551.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(5,4,2,20.00,2.00,'[]',NULL,29,'Beat Headphone',NULL,1024.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(6,5,3,1253.00,125.30,'[]',NULL,52,'Xbox One Wireless Controller Black Color',NULL,1737.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(7,6,3,766.00,76.60,'[]',NULL,73,'Ciate Palemore Lipstick Bold Red Color',NULL,2169.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(8,7,3,20.00,2.00,'[]',NULL,30,'Beat Headphone',NULL,1536.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(9,8,1,526.00,52.60,'[]',NULL,46,'Samsung Smart Phone (Digital)',NULL,535.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(10,9,1,526.00,52.60,'[]',NULL,46,'Samsung Smart Phone (Digital)',NULL,535.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(11,10,3,1160.00,116.00,'[]',NULL,49,'Herschel Leather Duffle Bag In Brown Color',NULL,1758.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(12,10,2,559.00,55.90,'[]',NULL,54,'EPSION Plaster Printer',NULL,1110.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(13,11,1,427.00,42.70,'[]',NULL,37,'Nikon HD camera',NULL,677.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(14,12,3,1194.00,119.40,'[]',NULL,45,'Smart Televisions',NULL,2361.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(15,13,2,526.00,52.60,'[]',NULL,46,'Samsung Smart Phone (Digital)',NULL,1070.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(16,13,2,535.00,53.50,'[]',NULL,55,'Sound Intone I65 Earphone White Version (Digital)',NULL,1030.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(17,14,2,893.00,89.30,'[]',NULL,68,'MVMTH Classical Leather Watch In Black (Digital)',NULL,1444.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(18,15,3,1194.00,119.40,'[]',NULL,42,'Smart Televisions',NULL,2361.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(19,15,1,893.00,89.30,'[]',NULL,68,'MVMTH Classical Leather Watch In Black (Digital)',NULL,722.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(20,16,1,1160.00,116.00,'[]',NULL,49,'Herschel Leather Duffle Bag In Brown Color',NULL,586.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(21,17,2,859.00,85.90,'[]',NULL,36,'Smart Watch External (Digital)',NULL,1244.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(22,17,1,1160.00,116.00,'[]',NULL,47,'Herschel Leather Duffle Bag In Brown Color',NULL,586.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(23,17,1,400.00,40.00,'[]',NULL,69,'Baxter Care Hair Kit For Bearded Mens',NULL,691.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(24,18,2,1242.00,124.20,'[]',NULL,65,'NYX Beauty Couton Pallete Makeup 12',NULL,1290.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(25,19,1,1194.00,119.40,'[]',NULL,43,'Smart Televisions',NULL,787.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(26,20,1,553.00,55.30,'[]',NULL,59,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,605.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(27,21,3,584.00,58.40,'[]',NULL,57,'B&O Play Mini Bluetooth Speaker',NULL,2082.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(28,22,3,766.00,76.60,'[]',NULL,73,'Ciate Palemore Lipstick Bold Red Color',NULL,2169.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(29,23,2,536.00,53.60,'[]',NULL,41,'Audio Equipment',NULL,1798.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(30,23,1,553.00,55.30,'[]',NULL,60,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,605.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(31,24,3,537.00,53.70,'[]',NULL,61,'Apple MacBook Air Retina 12-Inch Laptop',NULL,2037.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(32,25,1,1242.00,124.20,'[]',NULL,66,'NYX Beauty Couton Pallete Makeup 12',NULL,645.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(33,26,1,1253.00,125.30,'[]',NULL,51,'Xbox One Wireless Controller Black Color',NULL,579.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(34,27,2,1242.00,124.20,'[]',NULL,65,'NYX Beauty Couton Pallete Makeup 12',NULL,1290.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(35,28,1,80.25,8.03,'[]',NULL,24,'Dual Camera 20MP (Digital)',NULL,760.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(36,28,2,537.00,53.70,'[]',NULL,62,'Apple MacBook Air Retina 12-Inch Laptop',NULL,1358.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(37,29,3,40.50,4.05,'[]',NULL,27,'Smart Watches',NULL,1653.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(38,30,3,526.00,52.60,'[]',NULL,46,'Samsung Smart Phone (Digital)',NULL,1605.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(39,31,3,40.50,4.05,'[]',NULL,27,'Smart Watches',NULL,1653.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(40,32,1,1160.00,116.00,'[]',NULL,48,'Herschel Leather Duffle Bag In Brown Color',NULL,586.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(41,32,2,553.00,55.30,'[]',NULL,60,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,1210.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(42,33,1,584.00,58.40,'[]',NULL,58,'B&O Play Mini Bluetooth Speaker',NULL,694.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(43,34,2,1242.00,124.20,'[]',NULL,65,'NYX Beauty Couton Pallete Makeup 12',NULL,1290.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(44,35,2,40.50,4.05,'[]',NULL,27,'Smart Watches',NULL,1102.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(45,36,3,1194.00,119.40,'[]',NULL,45,'Smart Televisions',NULL,2361.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(46,37,1,859.00,85.90,'[]',NULL,35,'Smart Watch External (Digital)',NULL,622.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(47,37,2,536.00,53.60,'[]',NULL,41,'Audio Equipment',NULL,1798.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(48,38,3,1194.00,119.40,'[]',NULL,42,'Smart Televisions',NULL,2361.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(49,39,1,536.00,53.60,'[]',NULL,38,'Audio Equipment',NULL,899.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(50,40,2,1194.00,119.40,'[]',NULL,45,'Smart Televisions',NULL,1574.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(51,41,1,526.00,52.60,'[]',NULL,46,'Samsung Smart Phone (Digital)',NULL,535.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(52,42,3,536.00,53.60,'[]',NULL,41,'Audio Equipment',NULL,2697.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','physical',0),(53,42,2,553.00,55.30,'[]',NULL,60,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,1210.00,0,'2022-11-10 21:04:43','2022-11-10 21:04:43','physical',0);
/*!40000 ALTER TABLE `ec_order_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_referrals`
--

DROP TABLE IF EXISTS `ec_order_referrals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_referrals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(39) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_page` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `landing_params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referral` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fclid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_source` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_campaign` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_medium` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_term` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `utm_content` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referrer_url` text COLLATE utf8mb4_unicode_ci,
  `referrer_domain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_order_referrals_order_id_index` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_referrals`
--

LOCK TABLES `ec_order_referrals` WRITE;
/*!40000 ALTER TABLE `ec_order_referrals` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_referrals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_return_items`
--

DROP TABLE IF EXISTS `ec_order_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_return_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_return_id` int unsigned NOT NULL COMMENT 'Order return id',
  `order_product_id` int unsigned NOT NULL COMMENT 'Order product id',
  `product_id` int unsigned NOT NULL COMMENT 'Product id',
  `product_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int NOT NULL COMMENT 'Quantity return',
  `price` decimal(15,2) NOT NULL COMMENT 'Price Product',
  `reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_return_items`
--

LOCK TABLES `ec_order_return_items` WRITE;
/*!40000 ALTER TABLE `ec_order_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_order_returns`
--

DROP TABLE IF EXISTS `ec_order_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_order_returns` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` int unsigned NOT NULL COMMENT 'Order ID',
  `store_id` int unsigned DEFAULT NULL COMMENT 'Store ID',
  `user_id` int unsigned NOT NULL COMMENT 'Customer ID',
  `reason` text COLLATE utf8mb4_unicode_ci COMMENT 'Reason return order',
  `order_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Order current status',
  `return_status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Return status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_order_returns_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_order_returns`
--

LOCK TABLES `ec_order_returns` WRITE;
/*!40000 ALTER TABLE `ec_order_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_order_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_orders`
--

DROP TABLE IF EXISTS `ec_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned NOT NULL,
  `shipping_option` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'default',
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `shipping_amount` decimal(15,2) DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `coupon_code` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discount_amount` decimal(15,2) DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `is_confirmed` tinyint(1) NOT NULL DEFAULT '0',
  `discount_description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_finished` tinyint(1) DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `store_id` int unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ec_orders_code_unique` (`code`),
  KEY `ec_orders_user_id_status_created_at_index` (`user_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_orders`
--

LOCK TABLES `ec_orders` WRITE;
/*!40000 ALTER TABLE `ec_orders` DISABLE KEYS */;
INSERT INTO `ec_orders` VALUES (1,'#10000001',8,'1','default','completed',1698.80,54.80,0.00,NULL,NULL,0.00,1644.00,1,NULL,1,'2022-11-10 21:04:43','XGBeWCYuhYMYRQZgLPt47hWHeBNQp',1,'2022-10-28 13:04:42','2022-11-10 21:04:43',1),(2,'#10000002',8,'1','default','pending',2904.30,138.30,0.00,NULL,NULL,0.00,2766.00,1,NULL,1,NULL,'Oiu6BVz1JcSFZ3hCDaHqdevy3c9gw',2,'2022-11-04 05:04:42','2022-11-10 21:04:42',2),(3,'#10000003',4,'1','default','completed',44.55,4.05,0.00,NULL,NULL,0.00,40.50,1,NULL,1,'2022-11-10 21:04:43','Vaap103zOt4KJmFj61iImSxanGEEl',3,'2022-10-26 01:04:42','2022-11-10 21:04:43',4),(4,'#10000004',4,'1','default','completed',42.00,2.00,0.00,NULL,NULL,0.00,40.00,1,NULL,1,'2022-11-10 21:04:42','v2t2bN4Kywf4ib9rCSqJONa68O2p2',4,'2022-10-29 05:04:42','2022-11-10 21:04:42',2),(5,'#10000005',4,'1','default','completed',3884.30,125.30,0.00,NULL,NULL,0.00,3759.00,1,NULL,1,'2022-11-10 21:04:43','MYCKRZDYN21UxZRWV7XYPdeVMGhhk',5,'2022-11-09 09:04:42','2022-11-10 21:04:43',5),(6,'#10000006',4,'1','default','completed',2374.60,76.60,0.00,NULL,NULL,0.00,2298.00,1,NULL,1,'2022-11-10 21:04:43','v83RkYGa4G8qlMCsLQEUVgJ28g3zI',6,'2022-11-01 21:04:42','2022-11-10 21:04:43',4),(7,'#10000007',3,'1','default','pending',62.00,2.00,0.00,NULL,NULL,0.00,60.00,1,NULL,1,NULL,'jjL4Ry4fNy9UDsJU4fbKcdP5BosB1',7,'2022-10-30 13:04:42','2022-11-10 21:04:42',2),(8,'#10000008',3,'1','default','pending',578.60,52.60,0.00,NULL,NULL,0.00,526.00,1,NULL,1,NULL,'wFMPbfCRa8O0NsWkT95RogauZJyOU',8,'2022-10-31 23:04:42','2022-11-10 21:04:42',1),(9,'#10000009',4,'1','default','pending',578.60,52.60,0.00,NULL,NULL,0.00,526.00,1,NULL,1,NULL,'OvB74Dy6j4RcH86IocM7URtP87SYP',9,'2022-11-01 13:04:42','2022-11-10 21:04:42',1),(10,'#10000010',4,'1','default','completed',4769.90,171.90,0.00,NULL,NULL,0.00,4598.00,1,NULL,1,'2022-11-10 21:04:43','exUXz4SfUBQMpjBBxX1CjGvhZVxto',10,'2022-11-01 13:04:42','2022-11-10 21:04:43',6),(11,'#10000011',4,'1','default','pending',469.70,42.70,0.00,NULL,NULL,0.00,427.00,1,NULL,1,NULL,'hFfbEjFbnlIWn5djS0WU9kRzTdJBu',11,'2022-11-09 15:04:42','2022-11-10 21:04:42',2),(12,'#10000012',4,'1','default','pending',3701.40,119.40,0.00,NULL,NULL,0.00,3582.00,1,NULL,1,NULL,'GhWOcmUbu1XSjneP2dNhtHEMV7JkO',12,'2022-11-09 15:04:42','2022-11-10 21:04:42',3),(13,'#10000013',1,'1','default','pending',2228.10,106.10,0.00,NULL,NULL,0.00,2122.00,1,NULL,1,NULL,'IFBfuEWbZZRBr20L6QLoUHLPlPgj4',13,'2022-11-02 17:04:42','2022-11-10 21:04:42',1),(14,'#10000014',1,'1','default','completed',1875.30,89.30,0.00,NULL,NULL,0.00,1786.00,1,NULL,1,'2022-11-10 21:04:43','mqRIsZsydv5rtBROwGjJXXl1ltWc9',14,'2022-11-05 01:04:42','2022-11-10 21:04:43',3),(15,'#10000015',8,'1','default','completed',4683.70,208.70,0.00,NULL,NULL,0.00,4475.00,1,NULL,1,'2022-11-10 21:04:42','Ikxh4VUywRztmKai278t320ivsGWj',15,'2022-11-05 11:04:42','2022-11-10 21:04:42',3),(16,'#10000016',8,'1','default','pending',1276.00,116.00,0.00,NULL,NULL,0.00,1160.00,1,NULL,1,NULL,'RFdw4oB2sXdfnaPRVT2txvjqw8ByJ',16,'2022-11-02 05:04:42','2022-11-10 21:04:42',6),(17,'#10000017',1,'1','default','completed',3519.90,241.90,0.00,NULL,NULL,0.00,3278.00,1,NULL,1,'2022-11-10 21:04:42','t3UHija0Tk4ZoQPHNkTSQTIGRXkCE',17,'2022-11-04 21:04:42','2022-11-10 21:04:42',6),(18,'#10000018',1,'1','default','completed',2608.20,124.20,0.00,NULL,NULL,0.00,2484.00,1,NULL,1,'2022-11-10 21:04:43','404aCOLDYXHQuzNvT07ColvlDAkRK',18,'2022-10-31 21:04:42','2022-11-10 21:04:43',1),(19,'#10000019',1,'1','default','pending',1313.40,119.40,0.00,NULL,NULL,0.00,1194.00,1,NULL,1,NULL,'o99xj0RBoYckv5Bqvbng1jnDXdE4v',19,'2022-11-07 05:04:42','2022-11-10 21:04:42',3),(20,'#10000020',1,'1','default','pending',608.30,55.30,0.00,NULL,NULL,0.00,553.00,1,NULL,1,NULL,'uJKec1nR5n4Q7UUXI3C39JMKUJY99',20,'2022-11-04 11:04:42','2022-11-10 21:04:42',6),(21,'#10000021',1,'1','default','pending',1810.40,58.40,0.00,NULL,NULL,0.00,1752.00,1,NULL,1,NULL,'M39Q7gnDB6ivjNwkSwz8yOgueqQiZ',21,'2022-11-03 09:04:42','2022-11-10 21:04:42',3),(22,'#10000022',1,'1','default','pending',2374.60,76.60,0.00,NULL,NULL,0.00,2298.00,1,NULL,1,NULL,'bIZOguifE9F6NCt5gtLbkWBnmBZJg',22,'2022-11-03 09:04:42','2022-11-10 21:04:42',4),(23,'#10000023',4,'1','default','completed',1733.90,108.90,0.00,NULL,NULL,0.00,1625.00,1,NULL,1,'2022-11-10 21:04:43','2qs4RiroDYn6UmuUf5muSscsMTYGK',23,'2022-11-10 03:04:42','2022-11-10 21:04:43',6),(24,'#10000024',4,'1','default','completed',1664.70,53.70,0.00,NULL,NULL,0.00,1611.00,1,NULL,1,'2022-11-10 21:04:43','smqMaEhKJp4peYNq0mJHW8EGqCvDA',24,'2022-11-08 15:04:42','2022-11-10 21:04:43',3),(25,'#10000025',4,'1','default','pending',1366.20,124.20,0.00,NULL,NULL,0.00,1242.00,1,NULL,1,NULL,'I5j1OnwSme1EyoKPg6qzO7jpWd1Wl',25,'2022-11-08 15:04:42','2022-11-10 21:04:42',1),(26,'#10000026',4,'1','default','pending',1378.30,125.30,0.00,NULL,NULL,0.00,1253.00,1,NULL,1,NULL,'oAR5IOjwqFebZRrzR1zrUJjy9HcW8',26,'2022-11-08 05:04:42','2022-11-10 21:04:42',5),(27,'#10000027',4,'1','default','pending',2608.20,124.20,0.00,NULL,NULL,0.00,2484.00,1,NULL,1,NULL,'byia5ksM30RC45GdON0MjKernbPxy',27,'2022-11-08 21:04:42','2022-11-10 21:04:42',1),(28,'#10000028',3,'1','default','completed',1215.98,61.73,0.00,NULL,NULL,0.00,1154.25,1,NULL,1,'2022-11-10 21:04:44','xm1BaIvcEzZyCi9ijSqgR64qEkhJw',28,'2022-11-05 15:04:42','2022-11-10 21:04:44',3),(29,'#10000029',3,'1','default','pending',125.55,4.05,0.00,NULL,NULL,0.00,121.50,1,NULL,1,NULL,'xl9UEhkd3T5K3R67aaKYWTalaqfOq',29,'2022-11-09 17:04:42','2022-11-10 21:04:42',4),(30,'#10000030',3,'1','default','completed',1630.60,52.60,0.00,NULL,NULL,0.00,1578.00,1,NULL,1,'2022-11-10 21:04:42','yzbL5Zz9cfyzoAvEzDJ7lzaFeTmKO',30,'2022-11-06 05:04:42','2022-11-10 21:04:42',1),(31,'#10000031',1,'1','default','pending',125.55,4.05,0.00,NULL,NULL,0.00,121.50,1,NULL,1,NULL,'GQlouAizcaWONuDlTJd9iLwEBIdPc',31,'2022-11-08 21:04:42','2022-11-10 21:04:42',4),(32,'#10000032',1,'1','default','completed',2437.30,171.30,0.00,NULL,NULL,0.00,2266.00,1,NULL,1,'2022-11-10 21:04:44','uW3GPMy1Zv49JKFwIUfBLVPaj9LHZ',32,'2022-11-09 09:04:42','2022-11-10 21:04:44',6),(33,'#10000033',4,'1','default','pending',642.40,58.40,0.00,NULL,NULL,0.00,584.00,1,NULL,1,NULL,'v52a5sgFMPF255d24LTh9PP8cecew',33,'2022-11-06 17:04:42','2022-11-10 21:04:42',3),(34,'#10000034',4,'1','default','pending',2608.20,124.20,0.00,NULL,NULL,0.00,2484.00,1,NULL,1,NULL,'vxOHvZt8rPhetEexSThuMyht59zhp',34,'2022-11-10 11:04:42','2022-11-10 21:04:42',1),(35,'#10000035',3,'1','default','pending',85.05,4.05,0.00,NULL,NULL,0.00,81.00,1,NULL,1,NULL,'JAT0wzTMU2VATqBweiUNS4MmlrMkZ',35,'2022-11-07 21:04:42','2022-11-10 21:04:42',4),(36,'#10000036',3,'1','default','pending',3701.40,119.40,0.00,NULL,NULL,0.00,3582.00,1,NULL,1,NULL,'XqwTCFL132vE2ksuSeG9utptghVj7',36,'2022-11-10 05:04:42','2022-11-10 21:04:42',3),(37,'#10000037',3,'1','default','pending',2070.50,139.50,0.00,NULL,NULL,0.00,1931.00,1,NULL,1,NULL,'KCe4HXECuy0w2o2xrs6nQEzpKjVlZ',37,'2022-11-09 09:04:42','2022-11-10 21:04:42',6),(38,'#10000038',3,'1','default','pending',3701.40,119.40,0.00,NULL,NULL,0.00,3582.00,1,NULL,1,NULL,'4lDa4QM6MlqccpDTNh6FWL4dHn1ss',38,'2022-11-08 21:04:42','2022-11-10 21:04:42',3),(39,'#10000039',1,'1','default','completed',589.60,53.60,0.00,NULL,NULL,0.00,536.00,1,NULL,1,'2022-11-10 21:04:44','qsYwqT7ENlyrdKgJNZ4PHQh2TqKhQ',39,'2022-11-10 13:04:42','2022-11-10 21:04:44',6),(40,'#10000040',1,'1','default','completed',2507.40,119.40,0.00,NULL,NULL,0.00,2388.00,1,NULL,1,'2022-11-10 21:04:44','bc1id1xI6wTwj3OYe1uSvYVzigDav',40,'2022-11-10 05:04:42','2022-11-10 21:04:44',3),(41,'#10000041',1,'1','default','pending',578.60,52.60,0.00,NULL,NULL,0.00,526.00,1,NULL,1,NULL,'Izs1Y9njDGdp4gka3dYQQQ27v8UJM',41,'2022-11-10 17:04:42','2022-11-10 21:04:42',1),(42,'#10000042',1,'1','default','pending',2822.90,108.90,0.00,NULL,NULL,0.00,2714.00,1,NULL,1,NULL,'RVtUn9Sy6s8xPul6tBeoJIEEwoYFQ',42,'2022-11-10 13:04:42','2022-11-10 21:04:43',6);
/*!40000 ALTER TABLE `ec_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `display_layout` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'swatch_dropdown',
  `is_searchable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_comparable` tinyint unsigned NOT NULL DEFAULT '1',
  `is_use_in_product_listing` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `use_image_from_product_variation` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets`
--

LOCK TABLES `ec_product_attribute_sets` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets` VALUES (1,'Color','color','visual',1,1,1,'published',0,'2022-11-10 21:04:36','2022-11-10 21:04:36',0),(2,'Size','size','text',1,1,1,'published',1,'2022-11-10 21:04:36','2022-11-10 21:04:36',0);
/*!40000 ALTER TABLE `ec_product_attribute_sets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attribute_sets_translations`
--

DROP TABLE IF EXISTS `ec_product_attribute_sets_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attribute_sets_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attribute_sets_id` int NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attribute_sets_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attribute_sets_translations`
--

LOCK TABLES `ec_product_attribute_sets_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` DISABLE KEYS */;
INSERT INTO `ec_product_attribute_sets_translations` VALUES ('vi',1,'Màu sắc'),('vi',2,'Kích thước');
/*!40000 ALTER TABLE `ec_product_attribute_sets_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes`
--

DROP TABLE IF EXISTS `ec_product_attributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` int unsigned NOT NULL,
  `title` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_attributes_attribute_set_id_status_index` (`attribute_set_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes`
--

LOCK TABLES `ec_product_attributes` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes` DISABLE KEYS */;
INSERT INTO `ec_product_attributes` VALUES (1,1,'Green','green','#5FB7D4',NULL,1,1,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(2,1,'Blue','blue','#333333',NULL,0,2,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(3,1,'Red','red','#DA323F',NULL,0,3,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(4,1,'Black','back','#2F366C',NULL,0,4,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(5,1,'Brown','brown','#87554B',NULL,0,5,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(6,2,'S','s',NULL,NULL,1,1,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(7,2,'M','m',NULL,NULL,0,2,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(8,2,'L','l',NULL,NULL,0,3,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(9,2,'XL','xl',NULL,NULL,0,4,'published','2022-11-10 21:04:36','2022-11-10 21:04:36'),(10,2,'XXL','xxl',NULL,NULL,0,5,'published','2022-11-10 21:04:36','2022-11-10 21:04:36');
/*!40000 ALTER TABLE `ec_product_attributes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_attributes_translations`
--

DROP TABLE IF EXISTS `ec_product_attributes_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_attributes_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_attributes_id` int NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_attributes_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_attributes_translations`
--

LOCK TABLES `ec_product_attributes_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_attributes_translations` DISABLE KEYS */;
INSERT INTO `ec_product_attributes_translations` VALUES ('vi',1,'Xanh lá cây'),('vi',2,'Xanh da trời'),('vi',3,'Đỏ'),('vi',4,'Đen'),('vi',5,'Nâu'),('vi',6,'S'),('vi',7,'M'),('vi',8,'L'),('vi',9,'XL'),('vi',10,'XXL');
/*!40000 ALTER TABLE `ec_product_attributes_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories`
--

DROP TABLE IF EXISTS `ec_product_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`),
  KEY `ec_product_categories_parent_id_status_index` (`parent_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories`
--

LOCK TABLES `ec_product_categories` WRITE;
/*!40000 ALTER TABLE `ec_product_categories` DISABLE KEYS */;
INSERT INTO `ec_product_categories` VALUES (1,'Hot Promotions',0,NULL,'published',0,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(2,'Electronics',0,NULL,'published',1,'product-categories/1.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(3,'Consumer Electronic',2,NULL,'published',0,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(4,'Home Audio & Theaters',3,NULL,'published',0,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(5,'TV & Videos',3,NULL,'published',1,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(6,'Camera, Photos & Videos',3,NULL,'published',2,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(7,'Cellphones & Accessories',3,NULL,'published',3,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(8,'Headphones',3,NULL,'published',4,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(9,'Videos games',3,NULL,'published',5,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(10,'Wireless Speakers',3,NULL,'published',6,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(11,'Office Electronic',3,NULL,'published',7,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(12,'Accessories & Parts',2,NULL,'published',1,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(13,'Digital Cables',12,NULL,'published',0,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(14,'Audio & Video Cables',12,NULL,'published',1,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(15,'Batteries',12,NULL,'published',2,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(16,'Clothing',0,NULL,'published',2,'product-categories/2.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(17,'Computers',0,NULL,'published',3,'product-categories/3.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(18,'Computer & Technologies',17,NULL,'published',0,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(19,'Computer & Tablets',18,NULL,'published',0,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(20,'Laptop',18,NULL,'published',1,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(21,'Monitors',18,NULL,'published',2,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(22,'Computer Components',18,NULL,'published',3,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(23,'Networking',17,NULL,'published',1,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(24,'Drive & Storages',23,NULL,'published',0,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(25,'Gaming Laptop',23,NULL,'published',1,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(26,'Security & Protection',23,NULL,'published',2,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(27,'Accessories',23,NULL,'published',3,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(28,'Home & Kitchen',0,NULL,'published',4,'product-categories/4.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(29,'Health & Beauty',0,NULL,'published',5,'product-categories/5.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(30,'Jewelry & Watch',0,NULL,'published',6,'product-categories/6.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(31,'Technology Toys',0,NULL,'published',7,'product-categories/7.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(32,'Phones',0,NULL,'published',8,'product-categories/8.jpg',1,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(33,'Babies & Moms',0,NULL,'published',9,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(34,'Sport & Outdoor',0,NULL,'published',10,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(35,'Books & Office',0,NULL,'published',11,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(36,'Cars & Motorcycles',0,NULL,'published',12,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31'),(37,'Home Improvements',0,NULL,'published',13,NULL,0,'2022-11-10 21:04:31','2022-11-10 21:04:31');
/*!40000 ALTER TABLE `ec_product_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_categories_translations`
--

DROP TABLE IF EXISTS `ec_product_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_categories_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_product_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_categories_translations`
--

LOCK TABLES `ec_product_categories_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_categories_translations` DISABLE KEYS */;
INSERT INTO `ec_product_categories_translations` VALUES ('vi',1,'Khuyến mãi hấp dẫn',NULL),('vi',2,'Điện tử',NULL),('vi',3,'Điện tử tiêu dùng',NULL),('vi',4,'Thiết bị nghe nhìn',NULL),('vi',5,'TV & Videos',NULL),('vi',6,'Camera, Photos & Videos',NULL),('vi',7,'Điện thoại di động & Phụ kiện',NULL),('vi',8,'Tai nghe',NULL),('vi',9,'Trò chơi video',NULL),('vi',10,'Loa không dây',NULL),('vi',11,'Điện tử văn phòng',NULL),('vi',12,'Phụ kiện & Phụ tùng',NULL),('vi',13,'Digital Cables',NULL),('vi',14,'Audio & Video Cables',NULL),('vi',15,'Pin',NULL),('vi',16,'Quần áo',NULL),('vi',17,'Máy tính',NULL),('vi',18,'Máy tính & Công nghệ',NULL),('vi',19,'Máy tính & Máy tính bảng',NULL),('vi',20,'Máy tính xách tay',NULL),('vi',21,'Màn hình',NULL),('vi',22,'Linh kiện Máy tính',NULL),('vi',23,'Mạng máy tính',NULL),('vi',24,'Thiết bị lưu trữ',NULL),('vi',25,'Máy tính xách tay chơi game',NULL),('vi',26,'Thiết bị bảo mật',NULL),('vi',27,'Phụ kiện',NULL),('vi',28,'Đồ dùng làm bếp',NULL),('vi',29,'Sức khỏe & làm đẹp',NULL),('vi',30,'Trang sức & Đồng hồ',NULL),('vi',31,'Đồ chơi công nghệ',NULL),('vi',32,'Điện thoại',NULL),('vi',33,'Mẹ và bé',NULL),('vi',34,'Thể thao & ngoài trời',NULL),('vi',35,'Sách & Văn phòng',NULL),('vi',36,'Ô tô & Xe máy',NULL),('vi',37,'Cải tiến nhà cửa',NULL);
/*!40000 ALTER TABLE `ec_product_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_category_product`
--

DROP TABLE IF EXISTS `ec_product_category_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_category_product` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_category_product_category_id_index` (`category_id`),
  KEY `ec_product_category_product_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=91 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_category_product`
--

LOCK TABLES `ec_product_category_product` WRITE;
/*!40000 ALTER TABLE `ec_product_category_product` DISABLE KEYS */;
INSERT INTO `ec_product_category_product` VALUES (1,10,1),(2,4,1),(3,13,1),(4,15,1),(5,34,2),(6,12,2),(7,33,2),(8,27,2),(9,21,3),(10,22,3),(11,19,3),(12,23,3),(13,28,4),(14,16,4),(15,14,4),(16,29,4),(17,20,5),(18,34,5),(19,36,5),(20,35,5),(21,35,6),(22,20,6),(23,34,6),(24,29,6),(25,33,7),(26,36,7),(27,21,7),(28,18,7),(29,27,8),(30,33,8),(31,3,8),(32,19,8),(33,26,9),(34,2,9),(35,12,9),(36,18,9),(37,16,10),(38,17,10),(39,21,10),(40,33,10),(41,29,11),(42,28,11),(43,4,11),(44,32,11),(45,8,12),(46,5,12),(47,29,12),(48,36,12),(49,23,13),(50,3,13),(51,27,13),(52,18,14),(53,19,14),(54,28,14),(55,24,14),(56,16,15),(57,5,15),(58,21,15),(59,33,15),(60,13,16),(61,8,16),(62,33,16),(63,16,17),(64,25,17),(65,24,17),(66,21,17),(67,21,18),(68,18,18),(69,16,18),(70,15,18),(71,10,19),(72,33,19),(73,18,19),(74,16,19),(75,31,20),(76,9,20),(77,12,20),(78,28,20),(79,5,21),(80,31,21),(81,13,21),(82,33,21),(83,23,22),(84,29,22),(85,7,22),(86,26,22),(87,28,23),(88,29,23),(89,15,23),(90,20,23);
/*!40000 ALTER TABLE `ec_product_category_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collection_products`
--

DROP TABLE IF EXISTS `ec_product_collection_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collection_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_collection_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_collection_products_product_collection_id_index` (`product_collection_id`),
  KEY `ec_product_collection_products_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collection_products`
--

LOCK TABLES `ec_product_collection_products` WRITE;
/*!40000 ALTER TABLE `ec_product_collection_products` DISABLE KEYS */;
INSERT INTO `ec_product_collection_products` VALUES (1,3,1),(2,2,2),(3,2,3),(4,2,4),(5,2,5),(6,3,6),(7,1,7),(8,3,8),(9,3,9),(10,2,10),(11,2,11),(12,1,12),(13,3,13),(14,1,14),(15,1,15),(16,1,16),(17,1,17),(18,1,18),(19,1,19),(20,1,20),(21,2,21),(22,3,22),(23,2,23);
/*!40000 ALTER TABLE `ec_product_collection_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections`
--

DROP TABLE IF EXISTS `ec_product_collections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections`
--

LOCK TABLES `ec_product_collections` WRITE;
/*!40000 ALTER TABLE `ec_product_collections` DISABLE KEYS */;
INSERT INTO `ec_product_collections` VALUES (1,'New Arrival','new-arrival',NULL,NULL,'published','2022-11-10 21:04:31','2022-11-10 21:04:31',0),(2,'Best Sellers','best-sellers',NULL,NULL,'published','2022-11-10 21:04:31','2022-11-10 21:04:31',0),(3,'Special Offer','special-offer',NULL,NULL,'published','2022-11-10 21:04:31','2022-11-10 21:04:31',0);
/*!40000 ALTER TABLE `ec_product_collections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_collections_translations`
--

DROP TABLE IF EXISTS `ec_product_collections_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_collections_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_collections_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_collections_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_collections_translations`
--

LOCK TABLES `ec_product_collections_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_collections_translations` DISABLE KEYS */;
INSERT INTO `ec_product_collections_translations` VALUES ('vi',1,'Hàng mới về',NULL),('vi',2,'Bán chạy nhất',NULL),('vi',3,'Khuyến mãi đặc biệt',NULL);
/*!40000 ALTER TABLE `ec_product_collections_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_cross_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_cross_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_cross_sale_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `from_product_id` int unsigned NOT NULL,
  `to_product_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_cross_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_cross_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_cross_sale_relations`
--

LOCK TABLES `ec_product_cross_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` DISABLE KEYS */;
INSERT INTO `ec_product_cross_sale_relations` VALUES (1,1,3),(2,1,14),(3,1,20),(4,1,11),(5,1,6),(6,1,2),(7,2,13),(8,2,15),(9,2,16),(10,2,6),(11,2,12),(12,2,1),(13,3,14),(14,3,4),(15,3,12),(16,3,13),(17,3,18),(18,3,5),(19,4,5),(20,4,15),(21,4,14),(22,4,16),(23,4,13),(24,4,20),(25,5,6),(26,5,2),(27,5,15),(28,5,20),(29,5,7),(30,5,11),(31,6,9),(32,6,20),(33,6,12),(34,6,3),(35,6,4),(36,6,15),(37,6,11),(38,7,2),(39,7,9),(40,7,16),(41,7,18),(42,7,6),(43,7,12),(44,8,5),(45,8,15),(46,8,1),(47,8,13),(48,8,12),(49,9,6),(50,9,2),(51,9,14),(52,9,18),(53,9,15),(54,9,8),(55,10,18),(56,10,15),(57,10,8),(58,10,1),(59,10,16),(60,10,3),(61,11,13),(62,11,14),(63,11,20),(64,11,10),(65,11,18),(66,11,6),(67,12,10),(68,12,3),(69,12,20),(70,12,2),(71,12,16),(72,12,7),(73,13,11),(74,13,16),(75,13,4),(76,13,20),(77,13,1),(78,13,3),(79,13,6),(80,14,3),(81,14,12),(82,14,7),(83,14,13),(84,14,5),(85,14,10),(86,14,4),(87,15,5),(88,15,7),(89,15,6),(90,15,11),(91,15,4),(92,16,8),(93,16,19),(94,16,20),(95,16,14),(96,16,1),(97,16,18),(98,17,13),(99,17,6),(100,17,11),(101,17,8),(102,17,7),(103,17,2),(104,18,17),(105,18,10),(106,18,19),(107,18,3),(108,18,15),(109,18,1),(110,19,10),(111,19,5),(112,19,8),(113,19,15),(114,19,2),(115,19,12),(116,20,4),(117,20,3),(118,20,1),(119,20,18),(120,20,11),(121,21,16),(122,21,9),(123,21,15),(124,21,1),(125,21,14),(126,21,8),(127,22,8),(128,22,15),(129,22,9),(130,22,6),(131,23,18),(132,23,5),(133,23,12),(134,23,8),(135,23,16);
/*!40000 ALTER TABLE `ec_product_cross_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_files`
--

DROP TABLE IF EXISTS `ec_product_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int DEFAULT NULL,
  `url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `extras` mediumtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_files_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_files`
--

LOCK TABLES `ec_product_files` WRITE;
/*!40000 ALTER TABLE `ec_product_files` DISABLE KEYS */;
INSERT INTO `ec_product_files` VALUES (1,24,'product-files/1.jpg','{\"filename\":\"1.jpg\",\"url\":\"product-files\\/1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(2,25,'product-files/1.jpg','{\"filename\":\"1.jpg\",\"url\":\"product-files\\/1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(3,35,'product-files/5.jpg','{\"filename\":\"5.jpg\",\"url\":\"product-files\\/5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(4,35,'product-files/5-1.jpg','{\"filename\":\"5-1.jpg\",\"url\":\"product-files\\/5-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5-1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(5,35,'product-files/5-2.jpg','{\"filename\":\"5-2.jpg\",\"url\":\"product-files\\/5-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5-2\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(6,35,'product-files/5-3.jpg','{\"filename\":\"5-3.jpg\",\"url\":\"product-files\\/5-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5-3\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(7,36,'product-files/5.jpg','{\"filename\":\"5.jpg\",\"url\":\"product-files\\/5.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(8,36,'product-files/5-1.jpg','{\"filename\":\"5-1.jpg\",\"url\":\"product-files\\/5-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5-1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(9,36,'product-files/5-2.jpg','{\"filename\":\"5-2.jpg\",\"url\":\"product-files\\/5-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5-2\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(10,36,'product-files/5-3.jpg','{\"filename\":\"5-3.jpg\",\"url\":\"product-files\\/5-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"5-3\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(11,46,'product-files/9.jpg','{\"filename\":\"9.jpg\",\"url\":\"product-files\\/9.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"9\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(12,46,'product-files/9-1.jpg','{\"filename\":\"9-1.jpg\",\"url\":\"product-files\\/9-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"9-1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(13,46,'product-files/9-2.jpg','{\"filename\":\"9-2.jpg\",\"url\":\"product-files\\/9-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"9-2\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(14,55,'product-files/13.jpg','{\"filename\":\"13.jpg\",\"url\":\"product-files\\/13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"13\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(15,55,'product-files/13-1.jpg','{\"filename\":\"13-1.jpg\",\"url\":\"product-files\\/13-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"13-1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(16,56,'product-files/13.jpg','{\"filename\":\"13.jpg\",\"url\":\"product-files\\/13.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"13\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(17,56,'product-files/13-1.jpg','{\"filename\":\"13-1.jpg\",\"url\":\"product-files\\/13-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"13-1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(18,63,'product-files/17.jpg','{\"filename\":\"17.jpg\",\"url\":\"product-files\\/17.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"17\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(19,63,'product-files/17-1.jpg','{\"filename\":\"17-1.jpg\",\"url\":\"product-files\\/17-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"17-1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(20,63,'product-files/17-2.jpg','{\"filename\":\"17-2.jpg\",\"url\":\"product-files\\/17-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"17-2\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(21,63,'product-files/17-3.jpg','{\"filename\":\"17-3.jpg\",\"url\":\"product-files\\/17-3.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"17-3\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(22,68,'product-files/21.jpg','{\"filename\":\"21.jpg\",\"url\":\"product-files\\/21.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"21\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(23,68,'product-files/21-1.jpg','{\"filename\":\"21-1.jpg\",\"url\":\"product-files\\/21-1.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"21-1\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36'),(24,68,'product-files/21-2.jpg','{\"filename\":\"21-2.jpg\",\"url\":\"product-files\\/21-2.jpg\",\"mime_type\":\"image\\/jpeg\",\"size\":2165,\"modified\":\"2022-11-11 04:04:36\",\"name\":\"21-2\",\"extension\":\"jpg\"}','2022-11-10 21:04:36','2022-11-10 21:04:36');
/*!40000 ALTER TABLE `ec_product_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_label_products`
--

DROP TABLE IF EXISTS `ec_product_label_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_label_products` (
  `product_label_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  PRIMARY KEY (`product_label_id`,`product_id`),
  KEY `ec_product_label_products_product_label_id_index` (`product_label_id`),
  KEY `ec_product_label_products_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_label_products`
--

LOCK TABLES `ec_product_label_products` WRITE;
/*!40000 ALTER TABLE `ec_product_label_products` DISABLE KEYS */;
INSERT INTO `ec_product_label_products` VALUES (1,9),(2,6),(2,18),(3,3),(3,12),(3,15),(3,21);
/*!40000 ALTER TABLE `ec_product_label_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels`
--

DROP TABLE IF EXISTS `ec_product_labels`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels`
--

LOCK TABLES `ec_product_labels` WRITE;
/*!40000 ALTER TABLE `ec_product_labels` DISABLE KEYS */;
INSERT INTO `ec_product_labels` VALUES (1,'Hot','#ec2434','published','2022-11-10 21:04:31','2022-11-10 21:04:31'),(2,'New','#00c9a7','published','2022-11-10 21:04:31','2022-11-10 21:04:31'),(3,'Sale','#fe9931','published','2022-11-10 21:04:31','2022-11-10 21:04:31');
/*!40000 ALTER TABLE `ec_product_labels` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_labels_translations`
--

DROP TABLE IF EXISTS `ec_product_labels_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_labels_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_labels_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_labels_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_labels_translations`
--

LOCK TABLES `ec_product_labels_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_labels_translations` DISABLE KEYS */;
INSERT INTO `ec_product_labels_translations` VALUES ('vi',1,'Nổi bật',NULL),('vi',2,'Mới',NULL),('vi',3,'Giảm giá',NULL);
/*!40000 ALTER TABLE `ec_product_labels_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_related_relations`
--

DROP TABLE IF EXISTS `ec_product_related_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_related_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `from_product_id` int unsigned NOT NULL,
  `to_product_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_related_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_related_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_related_relations`
--

LOCK TABLES `ec_product_related_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_related_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_related_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tag_product`
--

DROP TABLE IF EXISTS `ec_product_tag_product`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tag_product` (
  `product_id` int unsigned NOT NULL,
  `tag_id` int unsigned NOT NULL,
  PRIMARY KEY (`product_id`,`tag_id`),
  KEY `ec_product_tag_product_product_id_index` (`product_id`),
  KEY `ec_product_tag_product_tag_id_index` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tag_product`
--

LOCK TABLES `ec_product_tag_product` WRITE;
/*!40000 ALTER TABLE `ec_product_tag_product` DISABLE KEYS */;
INSERT INTO `ec_product_tag_product` VALUES (1,1),(1,3),(1,6),(2,3),(2,4),(2,5),(3,2),(3,3),(4,3),(4,4),(5,2),(5,5),(5,6),(6,4),(6,6),(7,3),(7,4),(7,6),(8,1),(8,3),(9,2),(9,3),(9,6),(10,3),(10,6),(11,2),(11,4),(11,6),(12,1),(12,3),(13,4),(13,5),(14,2),(14,3),(14,6),(15,3),(15,4),(15,6),(16,1),(16,6),(17,2),(17,3),(17,5),(18,3),(18,5),(18,6),(19,1),(19,4),(19,5),(20,2),(20,3),(21,3),(21,4),(21,6),(22,2),(22,5),(22,6),(23,3),(23,6);
/*!40000 ALTER TABLE `ec_product_tag_product` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags`
--

DROP TABLE IF EXISTS `ec_product_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags`
--

LOCK TABLES `ec_product_tags` WRITE;
/*!40000 ALTER TABLE `ec_product_tags` DISABLE KEYS */;
INSERT INTO `ec_product_tags` VALUES (1,'Electronic',NULL,'published','2022-11-10 21:04:37','2022-11-10 21:04:37'),(2,'Mobile',NULL,'published','2022-11-10 21:04:37','2022-11-10 21:04:37'),(3,'Iphone',NULL,'published','2022-11-10 21:04:37','2022-11-10 21:04:37'),(4,'Printer',NULL,'published','2022-11-10 21:04:37','2022-11-10 21:04:37'),(5,'Office',NULL,'published','2022-11-10 21:04:37','2022-11-10 21:04:37'),(6,'IT',NULL,'published','2022-11-10 21:04:37','2022-11-10 21:04:37');
/*!40000 ALTER TABLE `ec_product_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_tags_translations`
--

DROP TABLE IF EXISTS `ec_product_tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_product_tags_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ec_product_tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_tags_translations`
--

LOCK TABLES `ec_product_tags_translations` WRITE;
/*!40000 ALTER TABLE `ec_product_tags_translations` DISABLE KEYS */;
INSERT INTO `ec_product_tags_translations` VALUES ('vi',1,'Electronic'),('vi',2,'Mobile'),('vi',3,'Iphone'),('vi',4,'Printer'),('vi',5,'Office'),('vi',6,'IT');
/*!40000 ALTER TABLE `ec_product_tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_up_sale_relations`
--

DROP TABLE IF EXISTS `ec_product_up_sale_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_up_sale_relations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `from_product_id` int unsigned NOT NULL,
  `to_product_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_up_sale_relations_from_product_id_index` (`from_product_id`),
  KEY `ec_product_up_sale_relations_to_product_id_index` (`to_product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_up_sale_relations`
--

LOCK TABLES `ec_product_up_sale_relations` WRITE;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_product_up_sale_relations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variation_items`
--

DROP TABLE IF EXISTS `ec_product_variation_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variation_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_id` int unsigned NOT NULL,
  `variation_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_product_variation_items_attribute_id_variation_id_index` (`attribute_id`,`variation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variation_items`
--

LOCK TABLES `ec_product_variation_items` WRITE;
/*!40000 ALTER TABLE `ec_product_variation_items` DISABLE KEYS */;
INSERT INTO `ec_product_variation_items` VALUES (19,1,10),(25,1,13),(31,1,16),(41,1,21),(47,1,24),(51,1,26),(61,1,31),(97,1,49),(3,2,2),(5,2,3),(11,2,6),(13,2,7),(17,2,9),(29,2,15),(53,2,27),(55,2,28),(63,2,32),(85,2,43),(87,2,44),(89,2,45),(93,2,47),(99,2,50),(7,3,4),(23,3,12),(27,3,14),(35,3,18),(45,3,23),(57,3,29),(69,3,35),(81,3,41),(1,4,1),(15,4,8),(33,4,17),(39,4,20),(59,4,30),(67,4,34),(71,4,36),(73,4,37),(77,4,39),(83,4,42),(9,5,5),(21,5,11),(37,5,19),(43,5,22),(49,5,25),(65,5,33),(75,5,38),(79,5,40),(91,5,46),(95,5,48),(12,6,6),(34,6,17),(44,6,22),(54,6,27),(60,6,30),(64,6,32),(88,6,44),(4,7,2),(6,7,3),(26,7,13),(36,7,18),(50,7,25),(68,7,34),(74,7,37),(84,7,42),(86,7,43),(94,7,47),(96,7,48),(8,8,4),(10,8,5),(14,8,7),(20,8,10),(24,8,12),(28,8,14),(30,8,15),(38,8,19),(42,8,21),(46,8,23),(62,8,31),(70,8,35),(72,8,36),(76,8,38),(82,8,41),(16,9,8),(18,9,9),(22,9,11),(40,9,20),(58,9,29),(100,9,50),(2,10,1),(32,10,16),(48,10,24),(52,10,26),(56,10,28),(66,10,33),(78,10,39),(80,10,40),(90,10,45),(92,10,46),(98,10,49);
/*!40000 ALTER TABLE `ec_product_variation_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_variations`
--

DROP TABLE IF EXISTS `ec_product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_variations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int unsigned DEFAULT NULL,
  `configurable_product_id` int unsigned NOT NULL,
  `is_default` tinyint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_product_variations_product_id_configurable_product_id_index` (`product_id`,`configurable_product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_variations`
--

LOCK TABLES `ec_product_variations` WRITE;
/*!40000 ALTER TABLE `ec_product_variations` DISABLE KEYS */;
INSERT INTO `ec_product_variations` VALUES (1,24,1,1),(2,25,1,0),(3,26,2,1),(4,27,2,0),(5,28,2,0),(6,29,3,1),(7,30,3,0),(8,31,4,1),(9,32,4,0),(10,33,4,0),(11,34,4,0),(12,35,5,1),(13,36,5,0),(14,37,6,1),(15,38,7,1),(16,39,7,0),(17,40,7,0),(18,41,7,0),(19,42,8,1),(20,43,8,0),(21,44,8,0),(22,45,8,0),(23,46,9,1),(24,47,10,1),(25,48,10,0),(26,49,10,0),(27,50,10,0),(28,51,11,1),(29,52,11,0),(30,53,12,1),(31,54,12,0),(32,55,13,1),(33,56,13,0),(34,57,14,1),(35,58,14,0),(36,59,15,1),(37,60,15,0),(38,61,16,1),(39,62,16,0),(40,63,17,1),(41,64,18,1),(42,65,19,1),(43,66,19,0),(44,67,20,1),(45,68,21,1),(46,69,22,1),(47,70,23,1),(48,71,23,0),(49,72,23,0),(50,73,23,0);
/*!40000 ALTER TABLE `ec_product_variations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_product_with_attribute_set`
--

DROP TABLE IF EXISTS `ec_product_with_attribute_set`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_product_with_attribute_set` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `attribute_set_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_product_with_attribute_set`
--

LOCK TABLES `ec_product_with_attribute_set` WRITE;
/*!40000 ALTER TABLE `ec_product_with_attribute_set` DISABLE KEYS */;
INSERT INTO `ec_product_with_attribute_set` VALUES (1,1,1,0),(2,2,1,0),(3,1,2,0),(4,2,2,0),(5,1,3,0),(6,2,3,0),(7,1,4,0),(8,2,4,0),(9,1,5,0),(10,2,5,0),(11,1,6,0),(12,2,6,0),(13,1,7,0),(14,2,7,0),(15,1,8,0),(16,2,8,0),(17,1,9,0),(18,2,9,0),(19,1,10,0),(20,2,10,0),(21,1,11,0),(22,2,11,0),(23,1,12,0),(24,2,12,0),(25,1,13,0),(26,2,13,0),(27,1,14,0),(28,2,14,0),(29,1,15,0),(30,2,15,0),(31,1,16,0),(32,2,16,0),(33,1,17,0),(34,2,17,0),(35,1,18,0),(36,2,18,0),(37,1,19,0),(38,2,19,0),(39,1,20,0),(40,2,20,0),(41,1,21,0),(42,2,21,0),(43,1,22,0),(44,2,22,0),(45,1,23,0),(46,2,23,0);
/*!40000 ALTER TABLE `ec_product_with_attribute_set` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products`
--

DROP TABLE IF EXISTS `ec_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `images` text COLLATE utf8mb4_unicode_ci,
  `sku` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `quantity` int unsigned DEFAULT NULL,
  `allow_checkout_when_out_of_stock` tinyint unsigned NOT NULL DEFAULT '0',
  `with_storehouse_management` tinyint unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `brand_id` int unsigned DEFAULT NULL,
  `is_variation` tinyint NOT NULL DEFAULT '0',
  `sale_type` tinyint NOT NULL DEFAULT '0',
  `price` double unsigned DEFAULT NULL,
  `sale_price` double unsigned DEFAULT NULL,
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `length` double(8,2) DEFAULT NULL,
  `wide` double(8,2) DEFAULT NULL,
  `height` double(8,2) DEFAULT NULL,
  `weight` double(8,2) DEFAULT NULL,
  `tax_id` int unsigned DEFAULT NULL,
  `views` bigint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `stock_status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'in_stock',
  `created_by_id` int DEFAULT '0',
  `created_by_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'physical',
  `store_id` int unsigned DEFAULT NULL,
  `approved_by` int DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `ec_products_brand_id_status_is_variation_created_at_index` (`brand_id`,`status`,`is_variation`,`created_at`),
  KEY `ec_products_sale_type_index` (`sale_type`),
  KEY `ec_products_start_date_index` (`start_date`),
  KEY `ec_products_end_date_index` (`end_date`),
  KEY `ec_products_sale_price_index` (`sale_price`),
  KEY `ec_products_is_variation_index` (`is_variation`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products`
--

LOCK TABLES `ec_products` WRITE;
/*!40000 ALTER TABLE `ec_products` DISABLE KEYS */;
INSERT INTO `ec_products` VALUES (1,'Dual Camera 20MP (Digital)','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/1.jpg\"]','SW-185-A0',0,16,0,1,1,6,0,0,80.25,NULL,NULL,NULL,11.00,18.00,10.00,760.00,1,70686,'2022-11-10 21:04:35','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',3,0),(2,'Smart Watches','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/2.jpg\",\"products\\/2-1.jpg\",\"products\\/2-2.jpg\",\"products\\/2-3.jpg\"]','SW-159-A0',0,19,0,1,1,2,0,0,40.5,NULL,NULL,NULL,15.00,15.00,16.00,551.00,1,165514,'2022-11-10 21:04:35','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',4,0),(3,'Beat Headphone','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/3.jpg\"]','SW-127-A0',0,11,0,1,1,1,0,0,20,NULL,NULL,NULL,16.00,12.00,13.00,512.00,1,112930,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',2,0),(4,'Red & Black Headphone','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/4.jpg\",\"products\\/4-1.jpg\",\"products\\/4-2.jpg\",\"products\\/4-3.jpg\"]','SW-100-A0',0,19,0,1,1,2,0,0,548,389.08,NULL,NULL,13.00,17.00,18.00,871.00,1,41987,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',1,0),(5,'Smart Watch External (Digital)','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/5.jpg\",\"products\\/5-1.jpg\",\"products\\/5-2.jpg\",\"products\\/5-3.jpg\"]','SW-107-A0',0,12,0,1,1,2,0,0,859,NULL,NULL,NULL,16.00,14.00,20.00,622.00,1,37167,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',6,0),(6,'Nikon HD camera','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/6.jpg\"]','SW-126-A0',0,10,0,1,1,5,0,0,427,NULL,NULL,NULL,15.00,19.00,15.00,677.00,1,53984,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',2,0),(7,'Audio Equipment','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/7.jpg\"]','SW-143-A0',0,12,0,1,1,4,0,0,536,NULL,NULL,NULL,14.00,15.00,11.00,899.00,1,77354,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',6,0),(8,'Smart Televisions','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/8.jpg\",\"products\\/8-1.jpg\",\"products\\/8-2.jpg\",\"products\\/8-3.jpg\"]','SW-116-A0',0,12,0,1,1,4,0,0,1194,895.5,NULL,NULL,17.00,12.00,18.00,787.00,1,102792,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',3,0),(9,'Samsung Smart Phone (Digital)','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/9.jpg\",\"products\\/9-1.jpg\",\"products\\/9-2.jpg\"]','SW-129-A0',0,16,0,1,1,4,0,0,526,NULL,NULL,NULL,16.00,10.00,13.00,535.00,1,70774,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',1,0),(10,'Herschel Leather Duffle Bag In Brown Color','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/10.jpg\",\"products\\/10-1.jpg\",\"products\\/10-2.jpg\"]','SW-139-A0',0,14,0,1,0,6,0,0,1160,NULL,NULL,NULL,11.00,14.00,19.00,586.00,1,78824,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',6,0),(11,'Xbox One Wireless Controller Black Color','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/11.jpg\",\"products\\/11-1.jpg\",\"products\\/11-2.jpg\",\"products\\/11-3.jpg\"]','SW-192-A0',0,17,0,1,0,6,0,0,1253,NULL,NULL,NULL,10.00,17.00,10.00,579.00,1,178912,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',5,0),(12,'EPSION Plaster Printer','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/12.jpg\",\"products\\/12-1.jpg\",\"products\\/12-2.jpg\",\"products\\/12-3.jpg\"]','SW-197-A0',0,14,0,1,0,3,0,0,559,441.61,NULL,NULL,19.00,20.00,19.00,555.00,1,23101,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',6,0),(13,'Sound Intone I65 Earphone White Version (Digital)','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/13.jpg\",\"products\\/13-1.jpg\"]','SW-130-A0',0,13,0,1,0,4,0,0,535,NULL,NULL,NULL,17.00,15.00,18.00,515.00,1,43707,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',1,0),(14,'B&O Play Mini Bluetooth Speaker','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/14.jpg\"]','SW-165-A0',0,17,0,1,0,3,0,0,584,NULL,NULL,NULL,19.00,16.00,17.00,694.00,1,150079,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',3,0),(15,'Apple MacBook Air Retina 13.3-Inch Laptop','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/15.jpg\",\"products\\/15-1.jpg\"]','SW-175-A0',0,19,0,1,0,6,0,0,553,NULL,NULL,NULL,16.00,19.00,20.00,605.00,1,162807,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',6,0),(16,'Apple MacBook Air Retina 12-Inch Laptop','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/16.jpg\"]','SW-184-A0',0,17,0,1,0,6,0,0,537,418.86,NULL,NULL,20.00,16.00,19.00,679.00,1,45017,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',3,0),(17,'Samsung Gear VR Virtual Reality Headset (Digital)','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/17.jpg\",\"products\\/17-1.jpg\",\"products\\/17-2.jpg\",\"products\\/17-3.jpg\"]','SW-107-A0',0,19,0,1,0,2,0,0,557,NULL,NULL,NULL,10.00,15.00,20.00,872.00,1,67657,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',4,0),(18,'Aveeno Moisturizing Body Shower 450ml','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/18.jpg\",\"products\\/18-1.jpg\",\"products\\/18-2.jpg\",\"products\\/18-3.jpg\"]','SW-127-A0',0,20,0,1,0,6,0,0,956,NULL,NULL,NULL,17.00,18.00,10.00,752.00,1,38679,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',2,0),(19,'NYX Beauty Couton Pallete Makeup 12','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/19.jpg\",\"products\\/19-1.jpg\",\"products\\/19-2.jpg\",\"products\\/19-3.jpg\"]','SW-144-A0',0,10,0,1,0,4,0,0,1242,NULL,NULL,NULL,19.00,12.00,20.00,645.00,1,124560,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',1,0),(20,'NYX Beauty Couton Pallete Makeup 12','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/20.jpg\",\"products\\/20-1.jpg\",\"products\\/20-2.jpg\",\"products\\/20-3.jpg\"]','SW-196-A0',0,19,0,1,0,5,0,0,903,713.37,NULL,NULL,13.00,13.00,13.00,527.00,1,163378,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',1,0),(21,'MVMTH Classical Leather Watch In Black (Digital)','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/21.jpg\",\"products\\/21-1.jpg\",\"products\\/21-2.jpg\"]','SW-142-A0',0,17,0,1,0,5,0,0,893,NULL,NULL,NULL,10.00,16.00,20.00,722.00,1,136022,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',3,0),(22,'Baxter Care Hair Kit For Bearded Mens','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/22.jpg\",\"products\\/22-1.jpg\",\"products\\/22-2.jpg\",\"products\\/22-3.jpg\"]','SW-147-A0',0,10,0,1,0,5,0,0,400,NULL,NULL,NULL,18.00,14.00,18.00,691.00,1,60853,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',6,0),(23,'Ciate Palemore Lipstick Bold Red Color','<ul><li> Unrestrained and portable active stereo speaker</li>\n            <li> Free from the confines of wires and chords</li>\n            <li> 20 hours of portable capabilities</li>\n            <li> Double-ended Coil Cord with 3.5mm Stereo Plugs Included</li>\n            <li> 3/4″ Dome Tweeters: 2X and 4″ Woofer: 1X</li></ul>','<p>Short Hooded Coat features a straight body, large pockets with button flaps, ventilation air holes, and a string detail along the hemline. The style is completed with a drawstring hood, featuring Rains&rsquo; signature built-in cap. Made from waterproof, matte PU, this lightweight unisex rain jacket is an ode to nostalgia through its classic silhouette and utilitarian design details.</p>\n                                <p>- Casual unisex fit</p>\n\n                                <p>- 64% polyester, 36% polyurethane</p>\n\n                                <p>- Water column pressure: 4000 mm</p>\n\n                                <p>- Model is 187cm tall and wearing a size S / M</p>\n\n                                <p>- Unisex fit</p>\n\n                                <p>- Drawstring hood with built-in cap</p>\n\n                                <p>- Front placket with snap buttons</p>\n\n                                <p>- Ventilation under armpit</p>\n\n                                <p>- Adjustable cuffs</p>\n\n                                <p>- Double welted front pockets</p>\n\n                                <p>- Adjustable elastic string at hempen</p>\n\n                                <p>- Ultrasonically welded seams</p>\n\n                                <p>This is a unisex item, please check our clothing &amp; footwear sizing guide for specific Rains jacket sizing information. RAINS comes from the rainy nation of Denmark at the edge of the European continent, close to the ocean and with prevailing westerly winds; all factors that contribute to an average of 121 rain days each year. Arising from these rainy weather conditions comes the attitude that a quick rain shower may be beautiful, as well as moody- but first and foremost requires the right outfit. Rains focus on the whole experience of going outside on rainy days, issuing an invitation to explore even in the most mercurial weather.</p>','published','[\"products\\/23.jpg\",\"products\\/23-1.jpg\",\"products\\/23-2.jpg\",\"products\\/23-3.jpg\"]','SW-176-A0',0,20,0,1,0,4,0,0,766,NULL,NULL,NULL,16.00,16.00,17.00,723.00,1,15237,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',4,0),(24,'Dual Camera 20MP (Digital)',NULL,NULL,'published','[\"products\\/1.jpg\"]','SW-185-A0',0,16,0,1,0,6,1,0,80.25,NULL,NULL,NULL,11.00,18.00,10.00,760.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(25,'Dual Camera 20MP (Digital)',NULL,NULL,'published','[\"products\\/1.jpg\"]','SW-185-A0-A1',0,16,0,1,0,6,1,0,80.25,NULL,NULL,NULL,11.00,18.00,10.00,760.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(26,'Smart Watches',NULL,NULL,'published','[\"products\\/2.jpg\"]','SW-159-A0',0,19,0,1,0,2,1,0,40.5,NULL,NULL,NULL,15.00,15.00,16.00,551.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(27,'Smart Watches',NULL,NULL,'published','[\"products\\/2-1.jpg\"]','SW-159-A0-A1',0,19,0,1,0,2,1,0,40.5,NULL,NULL,NULL,15.00,15.00,16.00,551.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(28,'Smart Watches',NULL,NULL,'published','[\"products\\/2-2.jpg\"]','SW-159-A0-A2',0,19,0,1,0,2,1,0,40.5,NULL,NULL,NULL,15.00,15.00,16.00,551.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(29,'Beat Headphone',NULL,NULL,'published','[\"products\\/3.jpg\"]','SW-127-A0',0,11,0,1,0,1,1,0,20,NULL,NULL,NULL,16.00,12.00,13.00,512.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(30,'Beat Headphone',NULL,NULL,'published','[\"products\\/3.jpg\"]','SW-127-A0-A1',0,11,0,1,0,1,1,0,20,NULL,NULL,NULL,16.00,12.00,13.00,512.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(31,'Red & Black Headphone',NULL,NULL,'published','[\"products\\/4.jpg\"]','SW-100-A0',0,19,0,1,0,2,1,0,548,389.08,NULL,NULL,13.00,17.00,18.00,871.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(32,'Red & Black Headphone',NULL,NULL,'published','[\"products\\/4-1.jpg\"]','SW-100-A0-A1',0,19,0,1,0,2,1,0,548,460.32,NULL,NULL,13.00,17.00,18.00,871.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(33,'Red & Black Headphone',NULL,NULL,'published','[\"products\\/4-2.jpg\"]','SW-100-A0-A2',0,19,0,1,0,2,1,0,548,482.24,NULL,NULL,13.00,17.00,18.00,871.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(34,'Red & Black Headphone',NULL,NULL,'published','[\"products\\/4-3.jpg\"]','SW-100-A0-A3',0,19,0,1,0,2,1,0,548,465.8,NULL,NULL,13.00,17.00,18.00,871.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(35,'Smart Watch External (Digital)',NULL,NULL,'published','[\"products\\/5.jpg\"]','SW-107-A0',0,12,0,1,0,2,1,0,859,NULL,NULL,NULL,16.00,14.00,20.00,622.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(36,'Smart Watch External (Digital)',NULL,NULL,'published','[\"products\\/5-1.jpg\"]','SW-107-A0-A1',0,12,0,1,0,2,1,0,859,NULL,NULL,NULL,16.00,14.00,20.00,622.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(37,'Nikon HD camera',NULL,NULL,'published','[\"products\\/6.jpg\"]','SW-126-A0',0,10,0,1,0,5,1,0,427,NULL,NULL,NULL,15.00,19.00,15.00,677.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(38,'Audio Equipment',NULL,NULL,'published','[\"products\\/7.jpg\"]','SW-143-A0',0,12,0,1,0,4,1,0,536,NULL,NULL,NULL,14.00,15.00,11.00,899.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(39,'Audio Equipment',NULL,NULL,'published','[\"products\\/7.jpg\"]','SW-143-A0-A1',0,12,0,1,0,4,1,0,536,NULL,NULL,NULL,14.00,15.00,11.00,899.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(40,'Audio Equipment',NULL,NULL,'published','[\"products\\/7.jpg\"]','SW-143-A0-A2',0,12,0,1,0,4,1,0,536,NULL,NULL,NULL,14.00,15.00,11.00,899.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(41,'Audio Equipment',NULL,NULL,'published','[\"products\\/7.jpg\"]','SW-143-A0-A3',0,12,0,1,0,4,1,0,536,NULL,NULL,NULL,14.00,15.00,11.00,899.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(42,'Smart Televisions',NULL,NULL,'published','[\"products\\/8.jpg\"]','SW-116-A0',0,12,0,1,0,4,1,0,1194,895.5,NULL,NULL,17.00,12.00,18.00,787.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(43,'Smart Televisions',NULL,NULL,'published','[\"products\\/8-1.jpg\"]','SW-116-A0-A1',0,12,0,1,0,4,1,0,1194,943.26,NULL,NULL,17.00,12.00,18.00,787.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(44,'Smart Televisions',NULL,NULL,'published','[\"products\\/8-2.jpg\"]','SW-116-A0-A2',0,12,0,1,0,4,1,0,1194,883.56,NULL,NULL,17.00,12.00,18.00,787.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(45,'Smart Televisions',NULL,NULL,'published','[\"products\\/8-3.jpg\"]','SW-116-A0-A3',0,12,0,1,0,4,1,0,1194,871.62,NULL,NULL,17.00,12.00,18.00,787.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(46,'Samsung Smart Phone (Digital)',NULL,NULL,'published','[\"products\\/9.jpg\"]','SW-129-A0',0,16,0,1,0,4,1,0,526,NULL,NULL,NULL,16.00,10.00,13.00,535.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(47,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL,'published','[\"products\\/10.jpg\"]','SW-139-A0',0,14,0,1,0,6,1,0,1160,NULL,NULL,NULL,11.00,14.00,19.00,586.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(48,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL,'published','[\"products\\/10-1.jpg\"]','SW-139-A0-A1',0,14,0,1,0,6,1,0,1160,NULL,NULL,NULL,11.00,14.00,19.00,586.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(49,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL,'published','[\"products\\/10-2.jpg\"]','SW-139-A0-A2',0,14,0,1,0,6,1,0,1160,NULL,NULL,NULL,11.00,14.00,19.00,586.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(50,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL,'published','[\"products\\/10.jpg\"]','SW-139-A0-A3',0,14,0,1,0,6,1,0,1160,NULL,NULL,NULL,11.00,14.00,19.00,586.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(51,'Xbox One Wireless Controller Black Color',NULL,NULL,'published','[\"products\\/11.jpg\"]','SW-192-A0',0,17,0,1,0,6,1,0,1253,NULL,NULL,NULL,10.00,17.00,10.00,579.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(52,'Xbox One Wireless Controller Black Color',NULL,NULL,'published','[\"products\\/11-1.jpg\"]','SW-192-A0-A1',0,17,0,1,0,6,1,0,1253,NULL,NULL,NULL,10.00,17.00,10.00,579.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(53,'EPSION Plaster Printer',NULL,NULL,'published','[\"products\\/12.jpg\"]','SW-197-A0',0,14,0,1,0,3,1,0,559,441.61,NULL,NULL,19.00,20.00,19.00,555.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(54,'EPSION Plaster Printer',NULL,NULL,'published','[\"products\\/12-1.jpg\"]','SW-197-A0-A1',0,14,0,1,0,3,1,0,559,503.1,NULL,NULL,19.00,20.00,19.00,555.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(55,'Sound Intone I65 Earphone White Version (Digital)',NULL,NULL,'published','[\"products\\/13.jpg\"]','SW-130-A0',0,13,0,1,0,4,1,0,535,NULL,NULL,NULL,17.00,15.00,18.00,515.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(56,'Sound Intone I65 Earphone White Version (Digital)',NULL,NULL,'published','[\"products\\/13-1.jpg\"]','SW-130-A0-A1',0,13,0,1,0,4,1,0,535,NULL,NULL,NULL,17.00,15.00,18.00,515.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(57,'B&O Play Mini Bluetooth Speaker',NULL,NULL,'published','[\"products\\/14.jpg\"]','SW-165-A0',0,17,0,1,0,3,1,0,584,NULL,NULL,NULL,19.00,16.00,17.00,694.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(58,'B&O Play Mini Bluetooth Speaker',NULL,NULL,'published','[\"products\\/14.jpg\"]','SW-165-A0-A1',0,17,0,1,0,3,1,0,584,NULL,NULL,NULL,19.00,16.00,17.00,694.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(59,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL,'published','[\"products\\/15.jpg\"]','SW-175-A0',0,19,0,1,0,6,1,0,553,NULL,NULL,NULL,16.00,19.00,20.00,605.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(60,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL,'published','[\"products\\/15-1.jpg\"]','SW-175-A0-A1',0,19,0,1,0,6,1,0,553,NULL,NULL,NULL,16.00,19.00,20.00,605.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(61,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,'published','[\"products\\/16.jpg\"]','SW-184-A0',0,17,0,1,0,6,1,0,537,418.86,NULL,NULL,20.00,16.00,19.00,679.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(62,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL,'published','[\"products\\/16.jpg\"]','SW-184-A0-A1',0,17,0,1,0,6,1,0,537,381.27,NULL,NULL,20.00,16.00,19.00,679.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(63,'Samsung Gear VR Virtual Reality Headset (Digital)',NULL,NULL,'published','[\"products\\/17.jpg\"]','SW-107-A0',0,19,0,1,0,2,1,0,557,NULL,NULL,NULL,10.00,15.00,20.00,872.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(64,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL,'published','[\"products\\/18.jpg\"]','SW-127-A0',0,20,0,1,0,6,1,0,956,NULL,NULL,NULL,17.00,18.00,10.00,752.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(65,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,'published','[\"products\\/19.jpg\"]','SW-144-A0',0,10,0,1,0,4,1,0,1242,NULL,NULL,NULL,19.00,12.00,20.00,645.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(66,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,'published','[\"products\\/19-1.jpg\"]','SW-144-A0-A1',0,10,0,1,0,4,1,0,1242,NULL,NULL,NULL,19.00,12.00,20.00,645.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(67,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL,'published','[\"products\\/20.jpg\"]','SW-196-A0',0,19,0,1,0,5,1,0,903,713.37,NULL,NULL,13.00,13.00,13.00,527.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(68,'MVMTH Classical Leather Watch In Black (Digital)',NULL,NULL,'published','[\"products\\/21.jpg\"]','SW-142-A0',0,17,0,1,0,5,1,0,893,NULL,NULL,NULL,10.00,16.00,20.00,722.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'digital',NULL,0),(69,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL,'published','[\"products\\/22.jpg\"]','SW-147-A0',0,10,0,1,0,5,1,0,400,NULL,NULL,NULL,18.00,14.00,18.00,691.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(70,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,'published','[\"products\\/23.jpg\"]','SW-176-A0',0,20,0,1,0,4,1,0,766,NULL,NULL,NULL,16.00,16.00,17.00,723.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(71,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,'published','[\"products\\/23-1.jpg\"]','SW-176-A0-A1',0,20,0,1,0,4,1,0,766,NULL,NULL,NULL,16.00,16.00,17.00,723.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(72,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,'published','[\"products\\/23-2.jpg\"]','SW-176-A0-A2',0,20,0,1,0,4,1,0,766,NULL,NULL,NULL,16.00,16.00,17.00,723.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0),(73,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL,'published','[\"products\\/23-3.jpg\"]','SW-176-A0-A3',0,20,0,1,0,4,1,0,766,NULL,NULL,NULL,16.00,16.00,17.00,723.00,NULL,0,'2022-11-10 21:04:36','2022-11-10 21:04:42','in_stock',0,'Botble\\ACL\\Models\\User',NULL,'physical',NULL,0);
/*!40000 ALTER TABLE `ec_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_products_translations`
--

DROP TABLE IF EXISTS `ec_products_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_products_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ec_products_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`ec_products_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_products_translations`
--

LOCK TABLES `ec_products_translations` WRITE;
/*!40000 ALTER TABLE `ec_products_translations` DISABLE KEYS */;
INSERT INTO `ec_products_translations` VALUES ('vi',1,'Dual Camera 20MP',NULL,NULL),('vi',2,'Smart Watches',NULL,NULL),('vi',3,'Beat Headphone',NULL,NULL),('vi',4,'Red & Black Headphone',NULL,NULL),('vi',5,'Smart Watch External',NULL,NULL),('vi',6,'Nikon HD camera',NULL,NULL),('vi',7,'Audio Equipment',NULL,NULL),('vi',8,'Smart Televisions',NULL,NULL),('vi',9,'Samsung Smart Phone',NULL,NULL),('vi',10,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL),('vi',11,'Xbox One Wireless Controller Black Color',NULL,NULL),('vi',12,'EPSION Plaster Printer',NULL,NULL),('vi',13,'Sound Intone I65 Earphone White Version',NULL,NULL),('vi',14,'B&O Play Mini Bluetooth Speaker',NULL,NULL),('vi',15,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL),('vi',16,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL),('vi',17,'Samsung Gear VR Virtual Reality Headset',NULL,NULL),('vi',18,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL),('vi',19,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL),('vi',20,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL),('vi',21,'MVMTH Classical Leather Watch In Black',NULL,NULL),('vi',22,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL),('vi',23,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL),('vi',24,'Dual Camera 20MP',NULL,NULL),('vi',25,'Dual Camera 20MP',NULL,NULL),('vi',26,'Smart Watches',NULL,NULL),('vi',27,'Smart Watches',NULL,NULL),('vi',28,'Smart Watches',NULL,NULL),('vi',29,'Beat Headphone',NULL,NULL),('vi',30,'Beat Headphone',NULL,NULL),('vi',31,'Red & Black Headphone',NULL,NULL),('vi',32,'Red & Black Headphone',NULL,NULL),('vi',33,'Red & Black Headphone',NULL,NULL),('vi',34,'Red & Black Headphone',NULL,NULL),('vi',35,'Smart Watch External',NULL,NULL),('vi',36,'Smart Watch External',NULL,NULL),('vi',37,'Nikon HD camera',NULL,NULL),('vi',38,'Audio Equipment',NULL,NULL),('vi',39,'Audio Equipment',NULL,NULL),('vi',40,'Audio Equipment',NULL,NULL),('vi',41,'Audio Equipment',NULL,NULL),('vi',42,'Smart Televisions',NULL,NULL),('vi',43,'Smart Televisions',NULL,NULL),('vi',44,'Smart Televisions',NULL,NULL),('vi',45,'Smart Televisions',NULL,NULL),('vi',46,'Samsung Smart Phone',NULL,NULL),('vi',47,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL),('vi',48,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL),('vi',49,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL),('vi',50,'Herschel Leather Duffle Bag In Brown Color',NULL,NULL),('vi',51,'Xbox One Wireless Controller Black Color',NULL,NULL),('vi',52,'Xbox One Wireless Controller Black Color',NULL,NULL),('vi',53,'EPSION Plaster Printer',NULL,NULL),('vi',54,'EPSION Plaster Printer',NULL,NULL),('vi',55,'Sound Intone I65 Earphone White Version',NULL,NULL),('vi',56,'Sound Intone I65 Earphone White Version',NULL,NULL),('vi',57,'B&O Play Mini Bluetooth Speaker',NULL,NULL),('vi',58,'B&O Play Mini Bluetooth Speaker',NULL,NULL),('vi',59,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL),('vi',60,'Apple MacBook Air Retina 13.3-Inch Laptop',NULL,NULL),('vi',61,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL),('vi',62,'Apple MacBook Air Retina 12-Inch Laptop',NULL,NULL),('vi',63,'Samsung Gear VR Virtual Reality Headset',NULL,NULL),('vi',64,'Aveeno Moisturizing Body Shower 450ml',NULL,NULL),('vi',65,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL),('vi',66,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL),('vi',67,'NYX Beauty Couton Pallete Makeup 12',NULL,NULL),('vi',68,'MVMTH Classical Leather Watch In Black',NULL,NULL),('vi',69,'Baxter Care Hair Kit For Bearded Mens',NULL,NULL),('vi',70,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL),('vi',71,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL),('vi',72,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL),('vi',73,'Ciate Palemore Lipstick Bold Red Color',NULL,NULL);
/*!40000 ALTER TABLE `ec_products_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_reviews`
--

DROP TABLE IF EXISTS `ec_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `star` double(8,2) NOT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  KEY `ec_reviews_product_id_customer_id_status_created_at_index` (`product_id`,`customer_id`,`status`,`created_at`),
  KEY `ec_reviews_product_id_customer_id_status_index` (`product_id`,`customer_id`,`status`)
) ENGINE=InnoDB AUTO_INCREMENT=101 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_reviews`
--

LOCK TABLES `ec_reviews` WRITE;
/*!40000 ALTER TABLE `ec_reviews` DISABLE KEYS */;
INSERT INTO `ec_reviews` VALUES (1,7,5,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/14.jpg\"]'),(2,5,21,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\"]'),(3,6,1,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/6.jpg\"]'),(4,2,5,5.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/6.jpg\",\"products\\/23.jpg\"]'),(5,3,5,2.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/6.jpg\"]'),(6,9,23,4.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/7.jpg\"]'),(7,8,20,5.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/14.jpg\"]'),(8,8,17,1.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/18.jpg\"]'),(9,1,16,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/5.jpg\",\"products\\/14.jpg\"]'),(10,5,2,3.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/7.jpg\"]'),(11,3,6,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/6.jpg\"]'),(12,6,12,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\"]'),(13,9,17,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\"]'),(14,10,2,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/6.jpg\",\"products\\/14.jpg\"]'),(15,10,17,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/6.jpg\"]'),(16,4,17,5.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\"]'),(17,10,16,3.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/14.jpg\"]'),(18,5,23,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\"]'),(19,2,7,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/5.jpg\",\"products\\/10.jpg\"]'),(20,3,16,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/7.jpg\"]'),(21,4,17,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/7.jpg\"]'),(22,3,2,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\"]'),(23,5,7,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/7.jpg\",\"products\\/8.jpg\"]'),(24,7,20,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(25,4,4,3.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/5.jpg\"]'),(26,4,17,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/6.jpg\"]'),(27,9,22,4.00,'Best ecommerce CMS online store!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/7.jpg\"]'),(28,5,6,5.00,'We have received brilliant service support and will be expanding the features with the developer. Nice product!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/5.jpg\"]'),(29,2,21,5.00,'Good app, good backup service and support. Good documentation.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/6.jpg\",\"products\\/11.jpg\"]'),(30,2,22,2.00,'Those guys now what they are doing, the release such a good product that it\'s a pleasure to work with ! Even when I was stuck on the project, I created a ticket and the next day it was replied by the team. GOOD JOB guys. I love working with them :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/5.jpg\"]'),(31,8,15,4.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/5.jpg\",\"products\\/12.jpg\"]'),(32,6,13,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\",\"products\\/13.jpg\"]'),(33,1,13,3.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\"]'),(34,4,21,4.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(35,10,16,1.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\"]'),(36,9,13,4.00,'Good app, good backup service and support. Good documentation.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\",\"products\\/18.jpg\"]'),(37,2,23,5.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\",\"products\\/17.jpg\"]'),(38,6,8,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\"]'),(39,4,17,5.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/5.jpg\"]'),(40,5,3,5.00,'Clean & perfect source code','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\",\"products\\/21.jpg\"]'),(41,8,22,3.00,'The best store template! Excellent coding! Very good support! Thank you so much for all the help, I really appreciated.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/6.jpg\"]'),(42,8,6,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/5.jpg\",\"products\\/11.jpg\"]'),(43,5,2,1.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/7.jpg\"]'),(44,2,8,2.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(45,3,2,5.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/7.jpg\",\"products\\/13.jpg\"]'),(46,7,21,5.00,'The code is good, in general, if you like it, can you give it 5 stars?','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\"]'),(47,8,23,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/6.jpg\",\"products\\/12.jpg\"]'),(48,1,14,1.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/21.jpg\"]'),(49,7,8,5.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/7.jpg\",\"products\\/17.jpg\"]'),(50,2,7,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(51,1,19,1.00,'Best ecommerce CMS online store!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\"]'),(52,6,13,2.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\"]'),(53,3,4,5.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\"]'),(54,10,10,4.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(55,2,14,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/7.jpg\"]'),(56,6,14,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\"]'),(57,4,12,2.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/8.jpg\"]'),(58,6,12,4.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/7.jpg\"]'),(59,4,23,2.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\",\"products\\/16.jpg\"]'),(60,6,16,5.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\"]'),(61,6,21,3.00,'It\'s not my first experience here on Codecanyon and I can honestly tell you all that Botble puts a LOT of effort into the support. They answer so fast, they helped me tons of times. REALLY by far THE BEST EXPERIENCE on Codecanyon. Those guys at Botble are so good that they deserve 5 stars. I recommend them, I trust them and I can\'t wait to see what they will sell in a near future. Thank you Botble :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(62,7,6,1.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\"]'),(63,8,15,5.00,'Solution is too robust for our purpose so we didn\'t use it at the end. But I appreciate customer support during initial configuration.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/7.jpg\"]'),(64,5,8,4.00,'Clean & perfect source code','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\"]'),(65,2,2,3.00,'Perfect +++++++++ i love it really also i get to fast ticket answers... Thanks Lot BOTBLE Teams','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/7.jpg\"]'),(66,9,23,3.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/6.jpg\"]'),(67,3,10,3.00,'The best ecommerce CMS! Excellent coding! best support service! Thank you so much..... I really like your hard work.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/17.jpg\"]'),(68,2,13,1.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\"]'),(69,4,21,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/6.jpg\"]'),(70,6,5,2.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/7.jpg\",\"products\\/20.jpg\"]'),(71,1,7,4.00,'As a developer I reviewed this script. This is really awesome ecommerce script. I have convinced when I noticed that it\'s built on fully WordPress concept.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\"]'),(72,1,7,5.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/7.jpg\"]'),(73,8,5,1.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/6.jpg\"]'),(74,10,23,1.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/15.jpg\"]'),(75,3,18,5.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\"]'),(76,7,11,2.00,'Very enthusiastic support! Excellent code is written. It\'s a true pleasure working with.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/19.jpg\"]'),(77,10,16,4.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/14.jpg\"]'),(78,5,16,2.00,'These guys are amazing! Responses immediately, amazing support and help... I immediately feel at ease after Purchasing..','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/5.jpg\",\"products\\/22.jpg\"]'),(79,8,22,5.00,'Great E-commerce system. And much more : Wonderful Customer Support.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/5.jpg\"]'),(80,6,7,2.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/8.jpg\"]'),(81,5,4,3.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\"]'),(82,7,1,4.00,'Amazing code, amazing support. Overall, im really confident in Botble and im happy I made the right choice! Thank you so much guys for coding this masterpiece','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/5.jpg\"]'),(83,4,7,4.00,'Ok good product. I have some issues in customizations. But its not correct to blame the developer. The product is good. Good luck for your business.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\"]'),(84,4,6,2.00,'Second or third time that I buy a Botble product, happy with the products and support. You guys do a good job :)','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(85,2,6,5.00,'Clean & perfect source code','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/5.jpg\"]'),(86,7,23,4.00,'Clean & perfect source code','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(87,2,13,1.00,'Good app, good backup service and support. Good documentation.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/6.jpg\"]'),(88,2,19,2.00,'I Love this Script. I also found how to add other fees. Now I just wait the BIG update for the Marketplace with the Bulk Import. Just do not forget to make it to be Multi-language for us the Botble Fans.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\"]'),(89,7,13,4.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/5.jpg\",\"products\\/20.jpg\"]'),(90,6,8,5.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/6.jpg\",\"products\\/9.jpg\"]'),(91,5,11,2.00,'This web app is really good in design, code quality & features. Besides, the customer support provided by the Botble team was really fast & helpful. You guys are awesome!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/7.jpg\"]'),(92,10,21,1.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/6.jpg\"]'),(93,7,13,2.00,'For me the best eCommerce script on Envato at this moment: modern, clean code, a lot of great features. The customer support is great too: I always get an answer within hours!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\"]'),(94,10,4,4.00,'The script is the best of its class, fast, easy to implement and work with , and the most important thing is the great support team , Recommend with no doubt.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/5.jpg\"]'),(95,1,16,3.00,'Good app, good backup service and support. Good documentation.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\",\"products\\/17.jpg\"]'),(96,5,21,1.00,'Great system, great support, good job Botble. I\'m looking forward to more great functional plugins.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/1.jpg\",\"products\\/7.jpg\"]'),(97,6,6,2.00,'This script is well coded and is super fast. The support is pretty quick. Very patient and helpful team. I strongly recommend it and they deserve more than 5 stars.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/5.jpg\",\"products\\/13.jpg\"]'),(98,4,13,4.00,'Cool template. Excellent code quality. The support responds very quickly, which is very rare on themeforest and codecanyon.net, I buy a lot of templates, and everyone will have a response from technical support for two or three days. Thanks to tech support. I recommend to buy.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/4.jpg\",\"products\\/6.jpg\",\"products\\/23.jpg\"]'),(99,10,11,3.00,'Best ecommerce CMS online store!','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/3.jpg\"]'),(100,7,7,1.00,'Customer Support are grade (A*), however the code is a way too over engineered for it\'s purpose.','published','2022-11-10 21:04:37','2022-11-10 21:04:37','[\"products\\/2.jpg\",\"products\\/6.jpg\"]');
/*!40000 ALTER TABLE `ec_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipment_histories`
--

DROP TABLE IF EXISTS `ec_shipment_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipment_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `shipment_id` int unsigned NOT NULL,
  `order_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipment_histories`
--

LOCK TABLES `ec_shipment_histories` WRITE;
/*!40000 ALTER TABLE `ec_shipment_histories` DISABLE KEYS */;
INSERT INTO `ec_shipment_histories` VALUES (1,'create_from_order','Shipping was created from order %order_id%',0,1,1,'2022-10-28 13:04:42','2022-10-28 13:04:42'),(2,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,1,1,'2022-11-09 05:04:42','2022-11-10 21:04:42'),(3,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,1,1,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(4,'create_from_order','Shipping was created from order %order_id%',0,2,2,'2022-11-04 05:04:42','2022-11-04 05:04:42'),(5,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,2,2,'2022-11-09 05:04:42','2022-11-10 21:04:42'),(6,'create_from_order','Shipping was created from order %order_id%',0,3,3,'2022-10-26 01:04:42','2022-10-26 01:04:42'),(7,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,3,3,'2022-11-09 07:04:42','2022-11-10 21:04:42'),(8,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,3,3,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(9,'create_from_order','Shipping was created from order %order_id%',0,4,4,'2022-10-29 05:04:42','2022-10-29 05:04:42'),(10,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,4,4,'2022-11-09 07:04:42','2022-11-10 21:04:42'),(11,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,4,4,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(12,'create_from_order','Shipping was created from order %order_id%',0,5,5,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(13,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,5,5,'2022-11-09 09:04:42','2022-11-10 21:04:42'),(14,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,5,5,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(15,'create_from_order','Shipping was created from order %order_id%',0,6,6,'2022-11-01 21:04:42','2022-11-01 21:04:42'),(16,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,6,6,'2022-11-09 09:04:42','2022-11-10 21:04:42'),(17,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,6,6,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(18,'create_from_order','Shipping was created from order %order_id%',0,7,7,'2022-10-30 13:04:42','2022-10-30 13:04:42'),(19,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,7,7,'2022-11-09 11:04:42','2022-11-10 21:04:42'),(20,'create_from_order','Shipping was created from order %order_id%',0,8,8,'2022-10-31 23:04:42','2022-10-31 23:04:42'),(21,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,8,8,'2022-11-09 11:04:42','2022-11-10 21:04:42'),(22,'create_from_order','Shipping was created from order %order_id%',0,9,9,'2022-11-01 13:04:42','2022-11-01 13:04:42'),(23,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,9,9,'2022-11-09 13:04:42','2022-11-10 21:04:42'),(24,'create_from_order','Shipping was created from order %order_id%',0,10,10,'2022-11-01 13:04:42','2022-11-01 13:04:42'),(25,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,10,10,'2022-11-09 13:04:42','2022-11-10 21:04:42'),(26,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,10,10,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(27,'create_from_order','Shipping was created from order %order_id%',0,11,11,'2022-11-09 15:04:42','2022-11-09 15:04:42'),(28,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,11,11,'2022-11-09 15:04:42','2022-11-10 21:04:42'),(29,'create_from_order','Shipping was created from order %order_id%',0,12,12,'2022-11-09 15:04:42','2022-11-09 15:04:42'),(30,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,12,12,'2022-11-09 15:04:42','2022-11-10 21:04:42'),(31,'create_from_order','Shipping was created from order %order_id%',0,13,13,'2022-11-02 17:04:42','2022-11-02 17:04:42'),(32,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,13,13,'2022-11-09 17:04:42','2022-11-10 21:04:42'),(33,'create_from_order','Shipping was created from order %order_id%',0,14,14,'2022-11-05 01:04:42','2022-11-05 01:04:42'),(34,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,14,14,'2022-11-09 17:04:42','2022-11-10 21:04:42'),(35,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,14,14,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(36,'create_from_order','Shipping was created from order %order_id%',0,15,15,'2022-11-05 11:04:42','2022-11-05 11:04:42'),(37,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,15,15,'2022-11-09 19:04:42','2022-11-10 21:04:42'),(38,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,15,15,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(39,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,15,15,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(40,'create_from_order','Shipping was created from order %order_id%',0,16,16,'2022-11-02 05:04:42','2022-11-02 05:04:42'),(41,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,16,16,'2022-11-09 19:04:42','2022-11-10 21:04:42'),(42,'create_from_order','Shipping was created from order %order_id%',0,17,17,'2022-11-04 21:04:42','2022-11-04 21:04:42'),(43,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,17,17,'2022-11-09 21:04:42','2022-11-10 21:04:42'),(44,'update_cod_status','Updated COD status to Completed . Updated by: %user_name%',0,17,17,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(45,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,17,17,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(46,'create_from_order','Shipping was created from order %order_id%',0,18,18,'2022-10-31 21:04:42','2022-10-31 21:04:42'),(47,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,18,18,'2022-11-09 21:04:42','2022-11-10 21:04:42'),(48,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,18,18,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(49,'create_from_order','Shipping was created from order %order_id%',0,19,19,'2022-11-07 05:04:42','2022-11-07 05:04:42'),(50,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,19,19,'2022-11-09 23:04:42','2022-11-10 21:04:42'),(51,'create_from_order','Shipping was created from order %order_id%',0,20,20,'2022-11-04 11:04:42','2022-11-04 11:04:42'),(52,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,20,20,'2022-11-09 23:04:42','2022-11-10 21:04:42'),(53,'create_from_order','Shipping was created from order %order_id%',0,21,21,'2022-11-03 09:04:42','2022-11-03 09:04:42'),(54,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,21,21,'2022-11-10 01:04:42','2022-11-10 21:04:42'),(55,'create_from_order','Shipping was created from order %order_id%',0,22,22,'2022-11-03 09:04:42','2022-11-03 09:04:42'),(56,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,22,22,'2022-11-10 01:04:42','2022-11-10 21:04:42'),(57,'create_from_order','Shipping was created from order %order_id%',0,23,23,'2022-11-10 03:04:42','2022-11-10 03:04:42'),(58,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,23,23,'2022-11-10 03:04:42','2022-11-10 21:04:42'),(59,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,23,23,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(60,'create_from_order','Shipping was created from order %order_id%',0,24,24,'2022-11-08 15:04:42','2022-11-08 15:04:42'),(61,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,24,24,'2022-11-10 03:04:42','2022-11-10 21:04:42'),(62,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,24,24,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(63,'create_from_order','Shipping was created from order %order_id%',0,25,25,'2022-11-08 15:04:42','2022-11-08 15:04:42'),(64,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,25,25,'2022-11-10 03:04:42','2022-11-10 21:04:42'),(65,'create_from_order','Shipping was created from order %order_id%',0,26,26,'2022-11-08 05:04:42','2022-11-08 05:04:42'),(66,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,26,26,'2022-11-10 05:04:42','2022-11-10 21:04:42'),(67,'create_from_order','Shipping was created from order %order_id%',0,27,27,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(68,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,27,27,'2022-11-10 05:04:42','2022-11-10 21:04:42'),(69,'create_from_order','Shipping was created from order %order_id%',0,28,28,'2022-11-05 15:04:42','2022-11-05 15:04:42'),(70,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,28,28,'2022-11-10 07:04:42','2022-11-10 21:04:42'),(71,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,28,28,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(72,'create_from_order','Shipping was created from order %order_id%',0,29,29,'2022-11-09 17:04:42','2022-11-09 17:04:42'),(73,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,29,29,'2022-11-10 07:04:42','2022-11-10 21:04:42'),(74,'create_from_order','Shipping was created from order %order_id%',0,30,30,'2022-11-06 05:04:42','2022-11-06 05:04:42'),(75,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,30,30,'2022-11-10 07:04:42','2022-11-10 21:04:42'),(76,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,30,30,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(77,'create_from_order','Shipping was created from order %order_id%',0,31,31,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(78,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,31,31,'2022-11-10 09:04:42','2022-11-10 21:04:42'),(79,'create_from_order','Shipping was created from order %order_id%',0,32,32,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(80,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,32,32,'2022-11-10 09:04:42','2022-11-10 21:04:42'),(81,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,32,32,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(82,'create_from_order','Shipping was created from order %order_id%',0,33,33,'2022-11-06 17:04:42','2022-11-06 17:04:42'),(83,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,33,33,'2022-11-10 11:04:42','2022-11-10 21:04:42'),(84,'create_from_order','Shipping was created from order %order_id%',0,34,34,'2022-11-10 11:04:42','2022-11-10 11:04:42'),(85,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,34,34,'2022-11-10 11:04:42','2022-11-10 21:04:42'),(86,'create_from_order','Shipping was created from order %order_id%',0,35,35,'2022-11-07 21:04:42','2022-11-07 21:04:42'),(87,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,35,35,'2022-11-10 13:04:42','2022-11-10 21:04:42'),(88,'create_from_order','Shipping was created from order %order_id%',0,36,36,'2022-11-10 05:04:42','2022-11-10 05:04:42'),(89,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,36,36,'2022-11-10 13:04:42','2022-11-10 21:04:42'),(90,'create_from_order','Shipping was created from order %order_id%',0,37,37,'2022-11-09 09:04:42','2022-11-09 09:04:42'),(91,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,37,37,'2022-11-10 15:04:42','2022-11-10 21:04:42'),(92,'create_from_order','Shipping was created from order %order_id%',0,38,38,'2022-11-08 21:04:42','2022-11-08 21:04:42'),(93,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,38,38,'2022-11-10 15:04:42','2022-11-10 21:04:42'),(94,'create_from_order','Shipping was created from order %order_id%',0,39,39,'2022-11-10 13:04:42','2022-11-10 13:04:42'),(95,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,39,39,'2022-11-10 17:04:42','2022-11-10 21:04:42'),(96,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,39,39,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(97,'create_from_order','Shipping was created from order %order_id%',0,40,40,'2022-11-10 05:04:42','2022-11-10 05:04:42'),(98,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,40,40,'2022-11-10 17:04:42','2022-11-10 21:04:42'),(99,'update_status','Changed status of shipping to: Delivered. Updated by: %user_name%',0,40,40,'2022-11-10 21:04:42','2022-11-10 21:04:42'),(100,'create_from_order','Shipping was created from order %order_id%',0,41,41,'2022-11-10 17:04:42','2022-11-10 17:04:42'),(101,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,41,41,'2022-11-10 17:04:42','2022-11-10 21:04:42'),(102,'create_from_order','Shipping was created from order %order_id%',0,42,42,'2022-11-10 13:04:42','2022-11-10 13:04:42'),(103,'update_status','Changed status of shipping to: Approved. Updated by: %user_name%',0,42,42,'2022-11-10 19:04:43','2022-11-10 21:04:43');
/*!40000 ALTER TABLE `ec_shipment_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipments`
--

DROP TABLE IF EXISTS `ec_shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` int unsigned NOT NULL,
  `user_id` int unsigned DEFAULT NULL,
  `weight` double(8,2) DEFAULT '0.00',
  `shipment_id` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cod_amount` decimal(15,2) DEFAULT '0.00',
  `cod_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `cross_checking_status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `price` decimal(15,2) DEFAULT '0.00',
  `store_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `tracking_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tracking_link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_date_shipped` datetime DEFAULT NULL,
  `date_shipped` datetime DEFAULT NULL,
  `label_url` text COLLATE utf8mb4_unicode_ci,
  `transaction` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipments`
--

LOCK TABLES `ec_shipments` WRITE;
/*!40000 ALTER TABLE `ec_shipments` DISABLE KEYS */;
INSERT INTO `ec_shipments` VALUES (1,1,NULL,2613.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0014264032','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-16 04:04:42','2022-11-11 04:04:42',NULL,NULL),(2,2,NULL,2858.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0049590150','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-16 04:04:42',NULL,NULL,NULL),(3,3,NULL,551.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0038494178','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-19 04:04:42','2022-11-11 04:04:42',NULL,NULL),(4,4,NULL,1024.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0078759982','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-16 04:04:42','2022-11-11 04:04:42',NULL,NULL),(5,5,NULL,1737.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0087788292','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-18 04:04:42','2022-11-11 04:04:42',NULL,NULL),(6,6,NULL,2169.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0033775191','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-17 04:04:42','2022-11-11 04:04:42',NULL,NULL),(7,7,NULL,1536.00,NULL,'','approved',62.00,'pending','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0084860236','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-13 04:04:42',NULL,NULL,NULL),(8,8,NULL,535.00,NULL,'','approved',578.60,'pending','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0015547922','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-13 04:04:42',NULL,NULL,NULL),(9,9,NULL,535.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD007713837','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-13 04:04:42',NULL,NULL,NULL),(10,10,NULL,2868.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0081753772','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-18 04:04:42','2022-11-11 04:04:42',NULL,NULL),(11,11,NULL,677.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0020861915','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-21 04:04:42',NULL,NULL,NULL),(12,12,NULL,2361.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0082633512','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-19 04:04:42',NULL,NULL,NULL),(13,13,NULL,2100.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0095548941','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-16 04:04:42',NULL,NULL,NULL),(14,14,NULL,1444.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0089952640','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-19 04:04:42','2022-11-11 04:04:42',NULL,NULL),(15,15,NULL,3083.00,NULL,'','delivered',4683.70,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0069113902','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-18 04:04:42','2022-11-11 04:04:42',NULL,NULL),(16,16,NULL,586.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0017163722','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-15 04:04:42',NULL,NULL,NULL),(17,17,NULL,2521.00,NULL,'','delivered',3519.90,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0068963163','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-21 04:04:42','2022-11-11 04:04:42',NULL,NULL),(18,18,NULL,1290.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0099016428','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-15 04:04:42','2022-11-11 04:04:42',NULL,NULL),(19,19,NULL,787.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0017263334','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-17 04:04:42',NULL,NULL,NULL),(20,20,NULL,605.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0057702038','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-20 04:04:42',NULL,NULL,NULL),(21,21,NULL,2082.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0025526534','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-19 04:04:42',NULL,NULL,NULL),(22,22,NULL,2169.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0086805983','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-18 04:04:42',NULL,NULL,NULL),(23,23,NULL,2403.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0071125186','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-19 04:04:42','2022-11-11 04:04:42',NULL,NULL),(24,24,NULL,2037.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0043010945','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-12 04:04:42','2022-11-11 04:04:42',NULL,NULL),(25,25,NULL,645.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0086731966','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-14 04:04:42',NULL,NULL,NULL),(26,26,NULL,579.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0036282450','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-13 04:04:42',NULL,NULL,NULL),(27,27,NULL,1290.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0059202463','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-14 04:04:42',NULL,NULL,NULL),(28,28,NULL,2118.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0078516504','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-18 04:04:42','2022-11-11 04:04:42',NULL,NULL),(29,29,NULL,1653.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0072325226','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-14 04:04:42',NULL,NULL,NULL),(30,30,NULL,1605.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0022448945','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-19 04:04:42','2022-11-11 04:04:42',NULL,NULL),(31,31,NULL,1653.00,NULL,'','approved',125.55,'pending','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0045156726','FastShipping','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-15 04:04:42',NULL,NULL,NULL),(32,32,NULL,1796.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0077321357','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-16 04:04:42','2022-11-11 04:04:42',NULL,NULL),(33,33,NULL,694.00,NULL,'','approved',642.40,'pending','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0080410251','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-20 04:04:42',NULL,NULL,NULL),(34,34,NULL,1290.00,NULL,'','approved',2608.20,'pending','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0015628452','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-19 04:04:42',NULL,NULL,NULL),(35,35,NULL,1102.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0091017539','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-12 04:04:42',NULL,NULL,NULL),(36,36,NULL,2361.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0052887324','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-14 04:04:42',NULL,NULL,NULL),(37,37,NULL,2420.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0049116065','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-18 04:04:42',NULL,NULL,NULL),(38,38,NULL,2361.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0031481423','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-16 04:04:42',NULL,NULL,NULL),(39,39,NULL,899.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0029251284','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-16 04:04:42','2022-11-11 04:04:42',NULL,NULL),(40,40,NULL,1574.00,NULL,'','delivered',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0014011727','GHN','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-20 04:04:42','2022-11-11 04:04:42',NULL,NULL),(41,41,NULL,535.00,NULL,'','approved',0.00,'completed','pending',0.00,0,'2022-11-10 21:04:42','2022-11-10 21:04:42','JJD0029868708','AliExpress','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-15 04:04:42',NULL,NULL,NULL),(42,42,NULL,3907.00,NULL,'','approved',2822.90,'pending','pending',0.00,0,'2022-11-10 21:04:43','2022-11-10 21:04:43','JJD001157999','DHL','https://mydhl.express.dhl/us/en/tracking.html#/track-by-reference','2022-11-15 04:04:43',NULL,NULL,NULL);
/*!40000 ALTER TABLE `ec_shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping`
--

DROP TABLE IF EXISTS `ec_shipping`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping`
--

LOCK TABLES `ec_shipping` WRITE;
/*!40000 ALTER TABLE `ec_shipping` DISABLE KEYS */;
INSERT INTO `ec_shipping` VALUES (1,'All',NULL,'2022-11-10 21:04:37','2022-11-10 21:04:37');
/*!40000 ALTER TABLE `ec_shipping` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rule_items`
--

DROP TABLE IF EXISTS `ec_shipping_rule_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rule_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `shipping_rule_id` int unsigned NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `adjustment_price` decimal(15,2) DEFAULT '0.00',
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rule_items`
--

LOCK TABLES `ec_shipping_rule_items` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rule_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_shipping_rule_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_shipping_rules`
--

DROP TABLE IF EXISTS `ec_shipping_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_shipping_rules` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_id` int unsigned NOT NULL,
  `type` enum('base_on_price','base_on_weight') COLLATE utf8mb4_unicode_ci DEFAULT 'base_on_price',
  `from` decimal(15,2) DEFAULT '0.00',
  `to` decimal(15,2) DEFAULT '0.00',
  `price` decimal(15,2) DEFAULT '0.00',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_shipping_rules`
--

LOCK TABLES `ec_shipping_rules` WRITE;
/*!40000 ALTER TABLE `ec_shipping_rules` DISABLE KEYS */;
INSERT INTO `ec_shipping_rules` VALUES (1,'Delivery',1,'base_on_price',0.00,NULL,0.00,'2022-11-10 21:04:37','2022-11-10 21:04:37');
/*!40000 ALTER TABLE `ec_shipping_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_store_locators`
--

DROP TABLE IF EXISTS `ec_store_locators`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_store_locators` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) DEFAULT '0',
  `is_shipping_location` tinyint(1) DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_store_locators`
--

LOCK TABLES `ec_store_locators` WRITE;
/*!40000 ALTER TABLE `ec_store_locators` DISABLE KEYS */;
INSERT INTO `ec_store_locators` VALUES (1,'Martfury','sales@botble.com','1800979769','502 New Street','AU','Brighton VIC','Brighton VIC',1,1,'2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `ec_store_locators` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_taxes`
--

DROP TABLE IF EXISTS `ec_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` double(8,6) DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_taxes`
--

LOCK TABLES `ec_taxes` WRITE;
/*!40000 ALTER TABLE `ec_taxes` DISABLE KEYS */;
INSERT INTO `ec_taxes` VALUES (1,'VAT',10.000000,1,'published','2022-11-10 21:04:37','2022-11-10 21:04:37'),(2,'None',0.000000,2,'published','2022-11-10 21:04:37','2022-11-10 21:04:37');
/*!40000 ALTER TABLE `ec_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ec_wish_lists`
--

DROP TABLE IF EXISTS `ec_wish_lists`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ec_wish_lists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int unsigned NOT NULL,
  `product_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ec_wish_lists_product_id_customer_id_index` (`product_id`,`customer_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ec_wish_lists`
--

LOCK TABLES `ec_wish_lists` WRITE;
/*!40000 ALTER TABLE `ec_wish_lists` DISABLE KEYS */;
/*!40000 ALTER TABLE `ec_wish_lists` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'SHIPPING',0,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(2,'PAYMENT',1,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(3,'ORDER & RETURNS',2,'published','2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` int NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
INSERT INTO `faq_categories_translations` VALUES ('vi',1,'VẬN CHUYỂN'),('vi',2,'THANH TOÁN'),('vi',3,'ĐƠN HÀNG & HOÀN TRẢ');
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` int unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'What Shipping Methods Are Available?','Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.',1,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(2,'Do You Ship Internationally?','Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.',1,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(3,'How Long Will It Take To Get My Package?','Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.',1,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(4,'What Payment Methods Are Accepted?','Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.',2,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(5,'Is Buying On-Line Safe?','Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.',2,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(6,'How do I place an Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level. Raw denim polaroid paleo farm-to-table, put a bird on it lo-fi tattooed Wes Anderson Pinterest letterpress. Fingerstache McSweeney’s pour-over, letterpress Schlitz photo booth master cleanse bespoke hashtag chillwave gentrify.',3,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(7,'How Can I Cancel Or Change My Order?','Plaid letterpress leggings craft beer meh ethical Pinterest. Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth.',3,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(8,'Do I need an account to place an order?','Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY. Cray ugh 3 wolf moon fap, fashion axe irony butcher cornhole typewriter chambray VHS banjo street art.',3,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(9,'How Do I Track My Order?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Future seitan normcore. Master cleanse American Apparel gentrify flexitarian beard slow-carb next level.',3,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(10,'How Can I Return a Product?','Kale chips Truffaut Williamsburg, hashtag fixie Pinterest raw denim c hambray drinking vinegar Carles street art Bushwick gastropub. Wolf Tumblr paleo church-key. Plaid food truck Echo Park YOLO bitters hella, direct trade Thundercats leggings quinoa before they sold out. You probably haven’t heard of them wayfarers authentic umami drinking vinegar Pinterest Cosby sweater, fingerstache fap High Life.',3,'published','2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` int NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
INSERT INTO `faqs_translations` VALUES ('vi',1,'Có những phương thức vận chuyển nào?','Ex Portland Pitchfork irure ria mép. Eutra fap trước khi họ bán hết theo đúng nghĩa đen. Aliquip ugh quyền xe đạp thực sự mlkshk, rượu bia thủ công mực seitan. '),('vi',2,'Bạn có giao hàng quốc tế không?','Áo hoodie túi tote Tofu mixtape. Quần đùi jean đánh chữ Wolf quinoa, túi messenger hữu cơ freegan cray. '),('vi',3,'Mất bao lâu để nhận được gói hàng của tôi?','Bữa nửa buổi ăn sáng bằng bụng heo quay từ máy đánh chữ VHS, cà phê có nguồn gốc đơn Paleo, Wes Anderson. Khoan Pitchfork linh hoạt, theo nghĩa đen là đổ qua fap theo nghĩa đen. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray bền vững slow-carb raw denim Church-key fap chillwave Etsy. +1 bộ dụng cụ đánh máy, đậu phụ Banksy Vice của American Apparel. '),('vi',4,'Phương thức thanh toán nào được chấp nhận?','Fashion Axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Quầy ảnh Voluptate fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur ria mép. Twee chia gian hàng chụp ảnh xe bán đồ ăn sẵn, bữa tiệc trên mái áo hoodie swag keytar PBR DIY. '),('vi',5,'Mua trực tuyến có an toàn không?','Bữa tiệc nghệ thuật đích thực freegan semiotics jean shorts chia credit. Tiệc trên mái nhà Neutra Austin Brooklyn, Thundercats swag synth gian hàng ảnh 8-bit. Xà cạp letterpress kẻ sọc thủ công bia meh đạo đức Pinterest. '),('vi',6,'Làm cách nào để đặt hàng?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb Odd Định mức seitan trong tương lai. Master làm sạch American Apparel nhẹ nhàng làm sạch râu linh hoạt chậm carb cấp độ tiếp theo. Vải thô denim polaroid nhạt từ trang trại đến bàn, đặt một con chim trên đó hình xăm lo-fi Wes Anderson Pinterest letterpress. Bậc thầy gian hàng ảnh Schlitz của Fingerstache McSweeney đang làm sạch thẻ bắt đầu bằng hashtag theo yêu cầu riêng, chillwave gentrify. '),('vi',7,'Làm cách nào để tôi có thể hủy hoặc thay đổi đơn hàng của mình?','Xà cạp letterpress kẻ sọc thủ công bia meh đạo đức Pinterest. Bữa tiệc nghệ thuật đích thực freegan semiotics jean shorts chia tín. Tiệc trên mái nhà Neutra Austin ở Brooklyn, synth Thundercats có gian hàng ảnh 8-bit. '),('vi',8,'Tôi có cần tài khoản để đặt hàng không?','Thundercats làm lung lay gian hàng ảnh 8-bit. Xà cạp letterpress kẻ sọc thủ công bia meh đạo đức Pinterest. Twee chia ảnh gian hàng xe bán thức ăn làm sẵn, bữa tiệc trên mái áo hoodie swag keytar PBR DIY. Cray ugh 3 wolf moon fap, rìu thời trang mỉa mai người bán thịt máy đánh chữ chambray VHS banjo nghệ thuật đường phố. '),('vi',9,'Làm cách nào để theo dõi đơn hàng của tôi?','Keytar cray slow-carb, Godard banh mi salvia pour-over. Slow-carb @Odd Định mức seitan trong tương lai. Bậc thầy làm sạch American Apparel nhẹ nhàng làm sạch râu linh hoạt theo kiểu chậm carb cấp độ tiếp theo. '),('vi',10,'Làm cách nào để trả lại sản phẩm?','Kale chips Truffaut Williamsburg, fixie hashtag Pinterest raw denim c hambray uống giấm Carles street art Bushwick gastropub. Chìa khóa nhà thờ Wolf Tumblr. Xe tải thực phẩm kẻ sọc Echo Park YOLO cắn hella, giao dịch trực tiếp Thundercats legging quinoa trước khi bán hết. Có thể bạn chưa từng nghe nói về họ những người truyền bá vị umami đích thực uống giấm Pinterest Áo len Cosby, fingerstache fap High Life. ');
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` int unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` text COLLATE utf8mb4_unicode_ci,
  `lang_meta_origin` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` int unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','0d4733d4f7d05867cf0353038a3ae27a',1,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(2,'vi','0d4733d4f7d05867cf0353038a3ae27a',2,'Botble\\SimpleSlider\\Models\\SimpleSlider'),(3,'en_US','3c00d43c4caaa987de61b8badeae441b',1,'Botble\\Menu\\Models\\MenuLocation'),(4,'en_US','5be938af891df431db6a207a90110b3c',1,'Botble\\Menu\\Models\\Menu'),(5,'en_US','114022c9fc97a1fdee6c1ce3e8cfae47',2,'Botble\\Menu\\Models\\Menu'),(6,'en_US','48b9b166ade72f011dce9b872eb3fc54',3,'Botble\\Menu\\Models\\Menu'),(7,'en_US','0f689c40b4bab40c7329026911d03e4b',4,'Botble\\Menu\\Models\\Menu'),(8,'vi','fe53ebb46bb9294c66d8db4166b97b19',2,'Botble\\Menu\\Models\\MenuLocation'),(9,'vi','5be938af891df431db6a207a90110b3c',5,'Botble\\Menu\\Models\\Menu'),(10,'vi','114022c9fc97a1fdee6c1ce3e8cfae47',6,'Botble\\Menu\\Models\\Menu'),(11,'vi','48b9b166ade72f011dce9b872eb3fc54',7,'Botble\\Menu\\Models\\Menu'),(12,'vi','0f689c40b4bab40c7329026911d03e4b',8,'Botble\\Menu\\Models\\Menu');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` int unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0),(2,'Tiếng Việt','vi','vi','vn',0,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `folder_id` int unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (1,0,'1',1,'image/jpeg',916,'brands/1.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(2,0,'2',1,'image/jpeg',916,'brands/2.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(3,0,'3',1,'image/jpeg',916,'brands/3.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(4,0,'4',1,'image/jpeg',916,'brands/4.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(5,0,'5',1,'image/jpeg',916,'brands/5.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(6,0,'6',1,'image/jpeg',916,'brands/6.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(7,0,'7',1,'image/jpeg',916,'brands/7.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(8,0,'1',2,'image/jpeg',2165,'product-categories/1.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(9,0,'2',2,'image/jpeg',2165,'product-categories/2.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(10,0,'3',2,'image/jpeg',2165,'product-categories/3.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(11,0,'4',2,'image/jpeg',2165,'product-categories/4.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(12,0,'5',2,'image/jpeg',2165,'product-categories/5.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(13,0,'6',2,'image/jpeg',2165,'product-categories/6.jpg','[]','2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(14,0,'7',2,'image/jpeg',2165,'product-categories/7.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(15,0,'8',2,'image/jpeg',2165,'product-categories/8.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(16,0,'1',3,'image/jpeg',2165,'products/1.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(17,0,'10-1',3,'image/jpeg',2165,'products/10-1.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(18,0,'10-2',3,'image/jpeg',2165,'products/10-2.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(19,0,'10',3,'image/jpeg',2165,'products/10.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(20,0,'11-1',3,'image/jpeg',2165,'products/11-1.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(21,0,'11-2',3,'image/jpeg',2165,'products/11-2.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(22,0,'11-3',3,'image/jpeg',2165,'products/11-3.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(23,0,'11',3,'image/jpeg',2165,'products/11.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(24,0,'12-1',3,'image/jpeg',2165,'products/12-1.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(25,0,'12-2',3,'image/jpeg',2165,'products/12-2.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(26,0,'12-3',3,'image/jpeg',2165,'products/12-3.jpg','[]','2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(27,0,'12',3,'image/jpeg',2165,'products/12.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(28,0,'13-1',3,'image/jpeg',2165,'products/13-1.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(29,0,'13',3,'image/jpeg',2165,'products/13.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(30,0,'14',3,'image/jpeg',2165,'products/14.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(31,0,'15-1',3,'image/jpeg',2165,'products/15-1.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(32,0,'15',3,'image/jpeg',2165,'products/15.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(33,0,'16',3,'image/jpeg',2165,'products/16.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(34,0,'17-1',3,'image/jpeg',2165,'products/17-1.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(35,0,'17-2',3,'image/jpeg',2165,'products/17-2.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(36,0,'17-3',3,'image/jpeg',2165,'products/17-3.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(37,0,'17',3,'image/jpeg',2165,'products/17.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(38,0,'18-1',3,'image/jpeg',2165,'products/18-1.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(39,0,'18-2',3,'image/jpeg',2165,'products/18-2.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(40,0,'18-3',3,'image/jpeg',2165,'products/18-3.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(41,0,'18',3,'image/jpeg',2165,'products/18.jpg','[]','2022-11-10 21:04:32','2022-11-10 21:04:32',NULL),(42,0,'19-1',3,'image/jpeg',2165,'products/19-1.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(43,0,'19-2',3,'image/jpeg',2165,'products/19-2.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(44,0,'19-3',3,'image/jpeg',2165,'products/19-3.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(45,0,'19',3,'image/jpeg',2165,'products/19.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(46,0,'2-1',3,'image/jpeg',2165,'products/2-1.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(47,0,'2-2',3,'image/jpeg',2165,'products/2-2.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(48,0,'2-3',3,'image/jpeg',2165,'products/2-3.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(49,0,'2',3,'image/jpeg',2165,'products/2.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(50,0,'20-1',3,'image/jpeg',2165,'products/20-1.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(51,0,'20-2',3,'image/jpeg',2165,'products/20-2.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(52,0,'20-3',3,'image/jpeg',2165,'products/20-3.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(53,0,'20',3,'image/jpeg',2165,'products/20.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(54,0,'21-1',3,'image/jpeg',2165,'products/21-1.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(55,0,'21-2',3,'image/jpeg',2165,'products/21-2.jpg','[]','2022-11-10 21:04:33','2022-11-10 21:04:33',NULL),(56,0,'21',3,'image/jpeg',2165,'products/21.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(57,0,'22-1',3,'image/jpeg',2165,'products/22-1.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(58,0,'22-2',3,'image/jpeg',2165,'products/22-2.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(59,0,'22-3',3,'image/jpeg',2165,'products/22-3.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(60,0,'22',3,'image/jpeg',2165,'products/22.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(61,0,'23-1',3,'image/jpeg',2165,'products/23-1.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(62,0,'23-2',3,'image/jpeg',2165,'products/23-2.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(63,0,'23-3',3,'image/jpeg',2165,'products/23-3.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(64,0,'23',3,'image/jpeg',2165,'products/23.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(65,0,'3',3,'image/jpeg',2165,'products/3.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(66,0,'4-1',3,'image/jpeg',2165,'products/4-1.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(67,0,'4-2',3,'image/jpeg',2165,'products/4-2.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(68,0,'4-3',3,'image/jpeg',2165,'products/4-3.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(69,0,'4',3,'image/jpeg',2165,'products/4.jpg','[]','2022-11-10 21:04:34','2022-11-10 21:04:34',NULL),(70,0,'5-1',3,'image/jpeg',2165,'products/5-1.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(71,0,'5-2',3,'image/jpeg',2165,'products/5-2.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(72,0,'5-3',3,'image/jpeg',2165,'products/5-3.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(73,0,'5',3,'image/jpeg',2165,'products/5.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(74,0,'6',3,'image/jpeg',2165,'products/6.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(75,0,'7',3,'image/jpeg',2165,'products/7.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(76,0,'8-1',3,'image/jpeg',2165,'products/8-1.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(77,0,'8-2',3,'image/jpeg',2165,'products/8-2.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(78,0,'8-3',3,'image/jpeg',2165,'products/8-3.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(79,0,'8',3,'image/jpeg',2165,'products/8.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(80,0,'9-1',3,'image/jpeg',2165,'products/9-1.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(81,0,'9-2',3,'image/jpeg',2165,'products/9-2.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(82,0,'9',3,'image/jpeg',2165,'products/9.jpg','[]','2022-11-10 21:04:35','2022-11-10 21:04:35',NULL),(83,0,'1',4,'image/jpeg',2165,'customers/1.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(84,0,'10',4,'image/jpeg',2165,'customers/10.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(85,0,'2',4,'image/jpeg',2165,'customers/2.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(86,0,'3',4,'image/jpeg',2165,'customers/3.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(87,0,'4',4,'image/jpeg',2165,'customers/4.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(88,0,'5',4,'image/jpeg',2165,'customers/5.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(89,0,'6',4,'image/jpeg',2165,'customers/6.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(90,0,'7',4,'image/jpeg',2165,'customers/7.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(91,0,'8',4,'image/jpeg',2165,'customers/8.jpg','[]','2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(92,0,'9',4,'image/jpeg',2165,'customers/9.jpg','[]','2022-11-10 21:04:37','2022-11-10 21:04:37',NULL),(93,0,'1',5,'image/jpeg',2165,'news/1.jpg','[]','2022-11-10 21:04:37','2022-11-10 21:04:37',NULL),(94,0,'10',5,'image/jpeg',2165,'news/10.jpg','[]','2022-11-10 21:04:37','2022-11-10 21:04:37',NULL),(95,0,'11',5,'image/jpeg',2165,'news/11.jpg','[]','2022-11-10 21:04:37','2022-11-10 21:04:37',NULL),(96,0,'2',5,'image/jpeg',2165,'news/2.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(97,0,'3',5,'image/jpeg',2165,'news/3.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(98,0,'4',5,'image/jpeg',2165,'news/4.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(99,0,'5',5,'image/jpeg',2165,'news/5.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(100,0,'6',5,'image/jpeg',2165,'news/6.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(101,0,'7',5,'image/jpeg',2165,'news/7.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(102,0,'8',5,'image/jpeg',2165,'news/8.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(103,0,'9',5,'image/jpeg',2165,'news/9.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(104,0,'1-lg',6,'image/jpeg',3852,'sliders/1-lg.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(105,0,'1-md',6,'image/jpeg',3852,'sliders/1-md.jpg','[]','2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(106,0,'1-sm',6,'image/jpeg',3852,'sliders/1-sm.jpg','[]','2022-11-10 21:04:39','2022-11-10 21:04:39',NULL),(107,0,'2-lg',6,'image/jpeg',3852,'sliders/2-lg.jpg','[]','2022-11-10 21:04:39','2022-11-10 21:04:39',NULL),(108,0,'2-md',6,'image/jpeg',3852,'sliders/2-md.jpg','[]','2022-11-10 21:04:39','2022-11-10 21:04:39',NULL),(109,0,'2-sm',6,'image/jpeg',3852,'sliders/2-sm.jpg','[]','2022-11-10 21:04:39','2022-11-10 21:04:39',NULL),(110,0,'3-lg',6,'image/jpeg',3852,'sliders/3-lg.jpg','[]','2022-11-10 21:04:39','2022-11-10 21:04:39',NULL),(111,0,'3-md',6,'image/jpeg',3852,'sliders/3-md.jpg','[]','2022-11-10 21:04:39','2022-11-10 21:04:39',NULL),(112,0,'3-sm',6,'image/jpeg',3852,'sliders/3-sm.jpg','[]','2022-11-10 21:04:39','2022-11-10 21:04:39',NULL),(113,0,'1',7,'image/jpeg',1463,'promotion/1.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(114,0,'2',7,'image/jpeg',1463,'promotion/2.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(115,0,'3',7,'image/jpeg',2049,'promotion/3.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(116,0,'4',7,'image/jpeg',2049,'promotion/4.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(117,0,'5',7,'image/jpeg',2049,'promotion/5.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(118,0,'6',7,'image/jpeg',2049,'promotion/6.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(119,0,'7',7,'image/jpeg',2049,'promotion/7.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(120,0,'8',7,'image/jpeg',2049,'promotion/8.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(121,0,'9',7,'image/jpeg',2049,'promotion/9.jpg','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(122,0,'app',8,'image/png',1849,'general/app.png','[]','2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(123,0,'coming-soon',8,'image/jpeg',19900,'general/coming-soon.jpg','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(124,0,'favicon',8,'image/png',1925,'general/favicon.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(125,0,'logo-dark',8,'image/png',784,'general/logo-dark.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(126,0,'logo-light',8,'image/png',783,'general/logo-light.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(127,0,'logo',8,'image/png',793,'general/logo.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(128,0,'newsletter',8,'image/jpeg',3316,'general/newsletter.jpg','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(129,0,'payment-method-1',8,'image/jpeg',813,'general/payment-method-1.jpg','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(130,0,'payment-method-2',8,'image/jpeg',878,'general/payment-method-2.jpg','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(131,0,'payment-method-3',8,'image/jpeg',816,'general/payment-method-3.jpg','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(132,0,'payment-method-4',8,'image/jpeg',638,'general/payment-method-4.jpg','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(133,0,'payment-method-5',8,'image/jpeg',659,'general/payment-method-5.jpg','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(134,0,'1',9,'image/png',3482,'stores/1.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(135,0,'10',9,'image/png',1675,'stores/10.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(136,0,'11',9,'image/png',1857,'stores/11.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(137,0,'12',9,'image/png',2046,'stores/12.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(138,0,'13',9,'image/png',1597,'stores/13.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(139,0,'14',9,'image/png',1649,'stores/14.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(140,0,'15',9,'image/png',2120,'stores/15.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(141,0,'16',9,'image/png',2556,'stores/16.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(142,0,'17',9,'image/png',2631,'stores/17.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(143,0,'2',9,'image/png',3369,'stores/2.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(144,0,'3',9,'image/png',3044,'stores/3.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(145,0,'4',9,'image/png',3096,'stores/4.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(146,0,'5',9,'image/png',3607,'stores/5.png','[]','2022-11-10 21:04:41','2022-11-10 21:04:41',NULL),(147,0,'6',9,'image/png',3778,'stores/6.png','[]','2022-11-10 21:04:42','2022-11-10 21:04:42',NULL),(148,0,'7',9,'image/png',1566,'stores/7.png','[]','2022-11-10 21:04:42','2022-11-10 21:04:42',NULL),(149,0,'8',9,'image/png',1773,'stores/8.png','[]','2022-11-10 21:04:42','2022-11-10 21:04:42',NULL),(150,0,'9',9,'image/png',1671,'stores/9.png','[]','2022-11-10 21:04:42','2022-11-10 21:04:42',NULL);
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'brands','brands',0,'2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(2,0,'product-categories','product-categories',0,'2022-11-10 21:04:30','2022-11-10 21:04:30',NULL),(3,0,'products','products',0,'2022-11-10 21:04:31','2022-11-10 21:04:31',NULL),(4,0,'customers','customers',0,'2022-11-10 21:04:36','2022-11-10 21:04:36',NULL),(5,0,'news','news',0,'2022-11-10 21:04:37','2022-11-10 21:04:37',NULL),(6,0,'sliders','sliders',0,'2022-11-10 21:04:38','2022-11-10 21:04:38',NULL),(7,0,'promotion','promotion',0,'2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(8,0,'general','general',0,'2022-11-10 21:04:40','2022-11-10 21:04:40',NULL),(9,0,'stores','stores',0,'2022-11-10 21:04:41','2022-11-10 21:04:41',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int unsigned NOT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2022-11-10 21:04:40','2022-11-10 21:04:40'),(2,5,'main-menu','2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int unsigned NOT NULL,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `reference_id` int unsigned DEFAULT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(2,1,0,NULL,NULL,'#',NULL,0,'Pages',NULL,'_self',1,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(3,1,2,2,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'About us',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(4,1,2,3,'Botble\\Page\\Models\\Page','/terms-of-use',NULL,0,'Terms Of Use',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(5,1,2,4,'Botble\\Page\\Models\\Page','/terms-conditions',NULL,0,'Terms & Conditions',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(6,1,2,5,'Botble\\Page\\Models\\Page','/refund-policy',NULL,0,'Refund Policy',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(7,1,2,12,'Botble\\Page\\Models\\Page','/coming-soon',NULL,0,'Coming soon',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(8,1,0,NULL,NULL,'/products',NULL,0,'Shop',NULL,'_self',1,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(9,1,8,NULL,NULL,'/products',NULL,0,'All products',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(10,1,8,15,'Botble\\Ecommerce\\Models\\ProductCategory','/product-categories/batteries',NULL,0,'Products Of Category',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(11,1,8,NULL,NULL,'/products/beat-headphone',NULL,0,'Product Single',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(12,1,0,NULL,NULL,'/stores',NULL,0,'Stores',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(13,1,0,6,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Blog',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(14,1,0,7,'Botble\\Page\\Models\\Page','/faqs',NULL,0,'FAQs',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(15,1,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(16,2,0,3,'Botble\\Page\\Models\\Page','/terms-of-use',NULL,0,'Terms Of Use',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(17,2,0,4,'Botble\\Page\\Models\\Page','/terms-conditions',NULL,0,'Terms & Conditions',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(18,2,0,5,'Botble\\Page\\Models\\Page','/refund-policy',NULL,0,'Refund Policy',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(19,2,0,7,'Botble\\Page\\Models\\Page','/faqs',NULL,0,'FAQs',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(20,2,0,NULL,NULL,'/nothing',NULL,0,'404 Page',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(21,3,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'About us',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(22,3,0,10,'Botble\\Page\\Models\\Page','/affiliate',NULL,0,'Affiliate',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(23,3,0,11,'Botble\\Page\\Models\\Page','/career',NULL,0,'Career',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(24,3,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Contact us',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(25,4,0,6,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our blog',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(26,4,0,NULL,NULL,'/cart',NULL,0,'Cart',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(27,4,0,NULL,NULL,'/customer/overview',NULL,0,'My account',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(28,4,0,NULL,NULL,'/products',NULL,0,'Shop',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(29,5,0,NULL,NULL,'/',NULL,0,'Trang chủ',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(30,5,0,NULL,NULL,'#',NULL,0,'Trang',NULL,'_self',1,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(31,5,30,2,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'Về chúng tôi',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(32,5,30,3,'Botble\\Page\\Models\\Page','/terms-of-use',NULL,0,'Điều khoản sử dụng',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(33,5,30,4,'Botble\\Page\\Models\\Page','/terms-conditions',NULL,0,'Điều khoản và quy định',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(34,5,30,5,'Botble\\Page\\Models\\Page','/refund-policy',NULL,0,'Chính sách hoàn hàng',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(35,5,30,12,'Botble\\Page\\Models\\Page','/coming-soon',NULL,0,'Sắp ra mắt',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(36,5,0,NULL,NULL,'/products',NULL,0,'Sản phẩm',NULL,'_self',1,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(37,5,36,NULL,NULL,'/products',NULL,0,'Tất cả sản phẩm',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(38,5,36,15,'Botble\\Ecommerce\\Models\\ProductCategory','/product-categories/batteries',NULL,0,'Danh mục sản phẩm',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(39,5,36,NULL,NULL,'/products/beat-headphone',NULL,0,'Sản phẩm chi tiết',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(40,5,0,NULL,NULL,'/stores',NULL,0,'Cửa hàng',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(41,5,0,6,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Tin tức',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(42,5,0,7,'Botble\\Page\\Models\\Page','/faqs',NULL,0,'FAQs',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(43,5,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Liên hệ',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(44,6,0,3,'Botble\\Page\\Models\\Page','/terms-of-use',NULL,0,'Điều khoản sử dụng',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(45,6,0,4,'Botble\\Page\\Models\\Page','/terms-conditions',NULL,0,'Điều khoản và quy định',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(46,6,0,5,'Botble\\Page\\Models\\Page','/refund-policy',NULL,0,'Chính sách hoàn hàng',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(47,6,0,6,'Botble\\Page\\Models\\Page','/blog',NULL,0,'FAQs',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(48,6,0,NULL,NULL,'/nothing',NULL,0,'404 Page',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(49,7,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'Về chúng tôi',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(50,7,0,10,'Botble\\Page\\Models\\Page','/affiliate',NULL,0,'Tiếp thị liên kết',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(51,7,0,11,'Botble\\Page\\Models\\Page','/career',NULL,0,'Tuyển dụng',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(52,7,0,8,'Botble\\Page\\Models\\Page','/contact',NULL,0,'Liên hệ',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(53,8,0,6,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Tin tức',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(54,8,0,NULL,NULL,'/cart',NULL,0,'Giỏ hàng',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(55,8,0,NULL,NULL,'/customer/overview',NULL,0,'Tài khoản',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40'),(56,8,0,NULL,NULL,'/products',NULL,0,'Sản phẩm',NULL,'_self',0,'2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(2,'Quick links','quick-links','published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(3,'Company','company','published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(4,'Business','business','published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(5,'Menu chính','menu-chinh','published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(6,'Liên kết nhanh','lien-ket-nhanh','published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(7,'Công ty','cong-ty','published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(8,'Doanh nghiệp','doanh-nghiep','published','2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` int unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'icon','[\"icon-star\"]',1,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(2,'icon','[\"icon-laundry\"]',2,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(3,'icon','[\"icon-shirt\"]',16,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(4,'icon','[\"icon-desktop\"]',17,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(5,'icon','[\"icon-lampshade\"]',28,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(6,'icon','[\"icon-heart-pulse\"]',29,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(7,'icon','[\"icon-diamond2\"]',30,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(8,'icon','[\"icon-desktop\"]',31,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(9,'icon','[\"icon-smartphone\"]',32,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(10,'icon','[\"icon-baby-bottle\"]',33,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(11,'icon','[\"icon-baseball\"]',34,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(12,'icon','[\"icon-book2\"]',35,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(13,'icon','[\"icon-car-siren\"]',36,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(14,'icon','[\"icon-wrench\"]',37,'Botble\\Ecommerce\\Models\\ProductCategory','2022-11-10 21:04:31','2022-11-10 21:04:31'),(15,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',1,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:35','2022-11-10 21:04:35'),(16,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',2,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(17,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',3,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(18,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',4,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(19,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',5,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(20,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',6,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(21,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',7,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(22,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',8,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(23,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',9,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(24,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',10,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(25,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',11,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(26,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',12,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(27,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',13,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(28,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',14,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(29,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',15,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(30,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',16,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(31,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',17,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(32,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',18,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(33,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',19,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(34,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',20,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(35,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',21,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(36,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',22,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(37,'faq_schema_config','[[[{\"key\":\"question\",\"value\":\"What Shipping Methods Are Available?\"},{\"key\":\"answer\",\"value\":\"Ex Portland Pitchfork irure mustache. Eutra fap before they sold out literally. Aliquip ugh bicycle rights actually mlkshk, seitan squid craft beer tempor.\"}],[{\"key\":\"question\",\"value\":\"Do You Ship Internationally?\"},{\"key\":\"answer\",\"value\":\"Hoodie tote bag mixtape tofu. Typewriter jean shorts wolf quinoa, messenger bag organic freegan cray.\"}],[{\"key\":\"question\",\"value\":\"How Long Will It Take To Get My Package?\"},{\"key\":\"answer\",\"value\":\"Swag slow-carb quinoa VHS typewriter pork belly brunch, paleo single-origin coffee Wes Anderson. Flexitarian Pitchfork forage, literally paleo fap pour-over. Wes Anderson Pinterest YOLO fanny pack meggings, deep v XOXO chambray sustainable slow-carb raw denim church-key fap chillwave Etsy. +1 typewriter kitsch, American Apparel tofu Banksy Vice.\"}],[{\"key\":\"question\",\"value\":\"What Payment Methods Are Accepted?\"},{\"key\":\"answer\",\"value\":\"Fashion axe DIY jean shorts, swag kale chips meh polaroid kogi butcher Wes Anderson chambray next level semiotics gentrify yr. Voluptate photo booth fugiat Vice. Austin sed Williamsburg, ea labore raw denim voluptate cred proident mixtape excepteur mustache. Twee chia photo booth readymade food truck, hoodie roof party swag keytar PBR DIY.\"}],[{\"key\":\"question\",\"value\":\"Is Buying On-Line Safe?\"},{\"key\":\"answer\",\"value\":\"Art party authentic freegan semiotics jean shorts chia cred. Neutra Austin roof party Brooklyn, synth Thundercats swag 8-bit photo booth. Plaid letterpress leggings craft beer meh ethical Pinterest.\"}]]]',23,'Botble\\Ecommerce\\Models\\Product','2022-11-10 21:04:36','2022-11-10 21:04:36'),(38,'tablet_image','[\"sliders\\/1-md.jpg\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(39,'mobile_image','[\"sliders\\/1-sm.jpg\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(40,'tablet_image','[\"sliders\\/2-md.jpg\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(41,'mobile_image','[\"sliders\\/2-sm.jpg\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(42,'tablet_image','[\"sliders\\/3-md.jpg\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(43,'mobile_image','[\"sliders\\/3-sm.jpg\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(44,'tablet_image','[\"sliders\\/1-md.jpg\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(45,'mobile_image','[\"sliders\\/1-sm.jpg\"]',4,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(46,'tablet_image','[\"sliders\\/2-md.jpg\"]',5,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(47,'mobile_image','[\"sliders\\/2-sm.jpg\"]',5,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(48,'tablet_image','[\"sliders\\/3-md.jpg\"]',6,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39'),(49,'mobile_image','[\"sliders\\/3-sm.jpg\"]',6,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2022-11-10 21:04:39','2022-11-10 21:04:39');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_resets_table',1),(5,'2016_06_10_230148_create_acl_tables',1),(6,'2016_06_14_230857_create_menus_table',1),(7,'2016_06_28_221418_create_pages_table',1),(8,'2016_10_05_074239_create_setting_table',1),(9,'2016_11_28_032840_create_dashboard_widget_tables',1),(10,'2016_12_16_084601_create_widgets_table',1),(11,'2017_05_09_070343_create_media_tables',1),(12,'2017_11_03_070450_create_slug_table',1),(13,'2019_01_05_053554_create_jobs_table',1),(14,'2019_08_19_000000_create_failed_jobs_table',1),(15,'2019_12_14_000001_create_personal_access_tokens_table',1),(16,'2021_08_02_084121_fix_old_shortcode',1),(17,'2022_04_20_100851_add_index_to_media_table',1),(18,'2022_04_20_101046_add_index_to_menu_table',1),(19,'2022_07_10_034813_move_lang_folder_to_root',1),(20,'2022_08_04_051940_add_missing_column_expires_at',1),(21,'2022_10_14_024629_drop_column_is_featured',1),(22,'2020_11_18_150916_ads_create_ads_table',2),(23,'2021_12_02_035301_add_ads_translations_table',2),(24,'2015_06_29_025744_create_audit_history',3),(25,'2015_06_18_033822_create_blog_table',4),(26,'2021_02_16_092633_remove_default_value_for_author_type',4),(27,'2021_12_03_030600_create_blog_translations',4),(28,'2022_04_19_113923_add_index_to_table_posts',4),(29,'2016_06_17_091537_create_contacts_table',5),(30,'2020_03_05_041139_create_ecommerce_tables',6),(31,'2021_01_01_044147_ecommerce_create_flash_sale_table',6),(32,'2021_01_17_082713_add_column_is_featured_to_product_collections_table',6),(33,'2021_01_18_024333_add_zip_code_into_table_customer_addresses',6),(34,'2021_02_18_073505_update_table_ec_reviews',6),(35,'2021_03_10_024419_add_column_confirmed_at_to_table_ec_customers',6),(36,'2021_03_10_025153_change_column_tax_amount',6),(37,'2021_03_20_033103_add_column_availability_to_table_ec_products',6),(38,'2021_04_28_074008_ecommerce_create_product_label_table',6),(39,'2021_05_31_173037_ecommerce_create_ec_products_translations',6),(40,'2021_06_28_153141_correct_slugs_data',6),(41,'2021_08_17_105016_remove_column_currency_id_in_some_tables',6),(42,'2021_08_30_142128_add_images_column_to_ec_reviews_table',6),(43,'2021_09_01_115151_remove_unused_fields_in_ec_products',6),(44,'2021_10_04_030050_add_column_created_by_to_table_ec_products',6),(45,'2021_10_05_122616_add_status_column_to_ec_customers_table',6),(46,'2021_11_03_025806_nullable_phone_number_in_ec_customer_addresses',6),(47,'2021_11_23_071403_correct_languages_for_product_variations',6),(48,'2021_11_28_031808_add_product_tags_translations',6),(49,'2021_12_01_031123_add_featured_image_to_ec_products',6),(50,'2022_01_01_033107_update_table_ec_shipments',6),(51,'2022_02_16_042457_improve_product_attribute_sets',6),(52,'2022_03_22_075758_correct_product_name',6),(53,'2022_04_19_113334_add_index_to_ec_products',6),(54,'2022_04_28_144405_remove_unused_table',6),(55,'2022_05_05_115015_create_ec_customer_recently_viewed_products_table',6),(56,'2022_05_18_143720_add_index_to_table_ec_product_categories',6),(57,'2022_06_16_095633_add_index_to_some_tables',6),(58,'2022_06_30_035148_create_order_referrals_table',6),(59,'2022_07_24_153815_add_completed_at_to_ec_orders_table',6),(60,'2022_08_14_032836_create_ec_order_returns_table',6),(61,'2022_08_14_033554_create_ec_order_return_items_table',6),(62,'2022_08_15_040324_add_billing_address',6),(63,'2022_08_30_091114_support_digital_products_table',6),(64,'2022_09_13_095744_create_options_table',6),(65,'2022_09_13_104347_create_option_value_table',6),(66,'2022_10_05_163518_alter_table_ec_order_product',6),(67,'2022_10_12_041517_create_invoices_table',6),(68,'2022_10_12_142226_update_orders_table',6),(69,'2022_10_13_024916_update_table_order_returns',6),(70,'2022_10_21_030830_update_columns_in_ec_shipments_table',6),(71,'2018_07_09_221238_create_faq_table',7),(72,'2021_12_03_082134_create_faq_translations',7),(73,'2016_10_03_032336_create_languages_table',8),(74,'2021_10_25_021023_fix-priority-load-for-language-advanced',9),(75,'2021_12_03_075608_create_page_translations',9),(76,'2019_11_18_061011_create_country_table',10),(77,'2021_12_03_084118_create_location_translations',10),(78,'2021_12_03_094518_migrate_old_location_data',10),(79,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',10),(80,'2022_01_16_085908_improve_plugin_location',10),(81,'2022_08_04_052122_delete_location_backup_tables',10),(82,'2022_10_29_065232_increase_states_abbreviation_column',10),(83,'2022_11_06_061847_increase_state_translations_abbreviation_column',10),(84,'2021_07_06_030002_create_marketplace_table',11),(85,'2021_09_04_150137_add_vendor_verified_at_to_ec_customers_table',11),(86,'2021_10_04_033903_add_column_approved_by_into_table_ec_products',11),(87,'2021_10_06_124943_add_transaction_id_column_to_mp_customer_withdrawals_table',11),(88,'2021_10_10_054216_add_columns_to_mp_customer_revenues_table',11),(89,'2021_12_06_031304_update_table_mp_customer_revenues',11),(90,'2022_10_19_152916_add_columns_to_mp_stores_table',11),(91,'2022_10_20_062849_create_mp_category_sale_commissions_table',11),(92,'2022_11_02_071413_add_more_info_for_store',11),(93,'2022_11_02_080444_add_tax_info',11),(94,'2017_10_24_154832_create_newsletter_table',12),(95,'2017_05_18_080441_create_payment_tables',13),(96,'2021_03_27_144913_add_customer_type_into_table_payments',13),(97,'2021_05_24_034720_make_column_currency_nullable',13),(98,'2021_08_09_161302_add_metadata_column_to_payments_table',13),(99,'2021_10_19_020859_update_metadata_field',13),(100,'2022_06_28_151901_activate_paypal_stripe_plugin',13),(101,'2022_07_07_153354_update_charge_id_in_table_payments',13),(102,'2017_07_11_140018_create_simple_slider_table',14),(103,'2016_10_07_193005_create_translations_table',15);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_category_sale_commissions`
--

DROP TABLE IF EXISTS `mp_category_sale_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_category_sale_commissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_category_id` int unsigned NOT NULL,
  `commission_percentage` decimal(8,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `mp_category_sale_commissions_product_category_id_unique` (`product_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_category_sale_commissions`
--

LOCK TABLES `mp_category_sale_commissions` WRITE;
/*!40000 ALTER TABLE `mp_category_sale_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `mp_category_sale_commissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_revenues`
--

DROP TABLE IF EXISTS `mp_customer_revenues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_revenues` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int unsigned DEFAULT NULL,
  `order_id` int unsigned DEFAULT NULL,
  `sub_amount` decimal(15,2) DEFAULT '0.00',
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) DEFAULT '0.00',
  `current_balance` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `type` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_revenues`
--

LOCK TABLES `mp_customer_revenues` WRITE;
/*!40000 ALTER TABLE `mp_customer_revenues` DISABLE KEYS */;
INSERT INTO `mp_customer_revenues` VALUES (1,2,1,1698.80,0.00,1698.80,0.00,'USD',NULL,'2022-11-10 05:04:43','2022-11-10 05:04:43',0,NULL),(2,7,3,44.55,0.00,44.55,0.00,'USD',NULL,'2022-11-10 13:04:43','2022-11-10 13:04:43',0,NULL),(3,9,5,3884.30,0.00,3884.30,0.00,'USD',NULL,'2022-11-10 09:04:43','2022-11-10 09:04:43',0,NULL),(4,7,6,2374.60,0.00,2374.60,44.55,'USD',NULL,'2022-11-07 09:04:43','2022-11-07 09:04:43',0,NULL),(5,10,10,4769.90,0.00,4769.90,0.00,'USD',NULL,'2022-11-08 03:04:43','2022-11-08 03:04:43',0,NULL),(6,6,14,1875.30,0.00,1875.30,0.00,'USD',NULL,'2022-11-07 03:04:43','2022-11-07 03:04:43',0,NULL),(7,2,18,2608.20,0.00,2608.20,1698.80,'USD',NULL,'2022-10-27 15:04:43','2022-10-27 15:04:43',0,NULL),(8,10,23,1733.90,0.00,1733.90,4769.90,'USD',NULL,'2022-11-04 21:04:43','2022-11-04 21:04:43',0,NULL),(9,6,24,1664.70,0.00,1664.70,1875.30,'USD',NULL,'2022-10-27 07:04:43','2022-10-27 07:04:43',0,NULL),(10,6,28,1215.98,0.00,1215.98,3540.00,'USD',NULL,'2022-10-20 03:04:44','2022-10-20 03:04:44',0,NULL),(11,10,32,2437.30,0.00,2437.30,6503.80,'USD',NULL,'2022-11-02 15:04:44','2022-11-02 15:04:44',0,NULL),(12,10,39,589.60,0.00,589.60,8941.10,'USD',NULL,'2022-10-11 21:04:44','2022-10-11 21:04:44',0,NULL),(13,6,40,2507.40,0.00,2507.40,4755.98,'USD',NULL,'2022-11-04 01:04:44','2022-11-04 01:04:44',0,NULL);
/*!40000 ALTER TABLE `mp_customer_revenues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_customer_withdrawals`
--

DROP TABLE IF EXISTS `mp_customer_withdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_customer_withdrawals` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int unsigned DEFAULT NULL,
  `fee` decimal(15,2) unsigned DEFAULT '0.00',
  `amount` decimal(15,2) unsigned DEFAULT '0.00',
  `current_balance` decimal(15,2) unsigned DEFAULT '0.00',
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `images` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `transaction_id` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_customer_withdrawals`
--

LOCK TABLES `mp_customer_withdrawals` WRITE;
/*!40000 ALTER TABLE `mp_customer_withdrawals` DISABLE KEYS */;
INSERT INTO `mp_customer_withdrawals` VALUES (1,2,0.00,1391.00,4307.00,'USD','','{\"name\":\"Isaiah Hagenes\",\"number\":\"+12202699595\",\"full_name\":\"Prof. Don Pollich I\",\"description\":\"Braeden Schamberger\"}',NULL,0,'processing',NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44',NULL),(2,2,0.00,601.00,2916.00,'USD','','{\"name\":\"Isaiah Hagenes\",\"number\":\"+12202699595\",\"full_name\":\"Prof. Don Pollich I\",\"description\":\"Braeden Schamberger\"}',NULL,0,'completed',NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44',NULL),(3,2,0.00,374.00,2315.00,'USD','','{\"name\":\"Isaiah Hagenes\",\"number\":\"+12202699595\",\"full_name\":\"Prof. Don Pollich I\",\"description\":\"Braeden Schamberger\"}',NULL,0,'processing',NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44',NULL),(4,6,0.00,2286.00,7263.38,'USD','','{\"name\":\"Miss Bernice Muller V\",\"number\":\"+15202592531\",\"full_name\":\"Prof. Monserrate Rogahn III\",\"description\":\"Jazmyne Lubowitz DVM\"}',NULL,0,'processing',NULL,'2022-11-10 21:04:44','2022-11-10 21:04:44',NULL),(5,6,0.00,1138.00,4977.38,'USD','','{\"name\":\"Miss Bernice Muller V\",\"number\":\"+15202592531\",\"full_name\":\"Prof. Monserrate Rogahn III\",\"description\":\"Jazmyne Lubowitz DVM\"}',NULL,0,'pending',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(6,7,0.00,179.00,2419.15,'USD','','{\"name\":\"Brigitte Hirthe II\",\"number\":\"+17013809047\",\"full_name\":\"Mrs. Sienna Christiansen I\",\"description\":\"Nikita Labadie\"}',NULL,0,'completed',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(7,7,0.00,526.00,2240.15,'USD','','{\"name\":\"Brigitte Hirthe II\",\"number\":\"+17013809047\",\"full_name\":\"Mrs. Sienna Christiansen I\",\"description\":\"Nikita Labadie\"}',NULL,0,'pending',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(8,7,0.00,174.00,1714.15,'USD','','{\"name\":\"Brigitte Hirthe II\",\"number\":\"+17013809047\",\"full_name\":\"Mrs. Sienna Christiansen I\",\"description\":\"Nikita Labadie\"}',NULL,0,'completed',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(9,9,0.00,1210.00,3884.30,'USD','','{\"name\":\"Triston Greenfelder\",\"number\":\"+13344152343\",\"full_name\":\"Casey Lemke II\",\"description\":\"Maribel Corkery II\"}',NULL,0,'processing',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(10,9,0.00,691.00,2674.30,'USD','','{\"name\":\"Triston Greenfelder\",\"number\":\"+13344152343\",\"full_name\":\"Casey Lemke II\",\"description\":\"Maribel Corkery II\"}',NULL,0,'processing',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(11,9,0.00,432.00,1983.30,'USD','','{\"name\":\"Triston Greenfelder\",\"number\":\"+13344152343\",\"full_name\":\"Casey Lemke II\",\"description\":\"Maribel Corkery II\"}',NULL,0,'completed',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(12,10,0.00,2316.00,9530.70,'USD','','{\"name\":\"Mr. Rex Yost Jr.\",\"number\":\"+15519742548\",\"full_name\":\"Prof. Dock Tromp II\",\"description\":\"Hailee Erdman DDS\"}',NULL,0,'pending',NULL,'2022-11-10 21:04:45','2022-11-10 21:04:45',NULL),(13,10,0.00,1073.00,7214.70,'USD','','{\"name\":\"Mr. Rex Yost Jr.\",\"number\":\"+15519742548\",\"full_name\":\"Prof. Dock Tromp II\",\"description\":\"Hailee Erdman DDS\"}',NULL,0,'pending',NULL,'2022-11-10 21:04:46','2022-11-10 21:04:46',NULL),(14,10,0.00,1090.00,6141.70,'USD','','{\"name\":\"Mr. Rex Yost Jr.\",\"number\":\"+15519742548\",\"full_name\":\"Prof. Dock Tromp II\",\"description\":\"Hailee Erdman DDS\"}',NULL,0,'pending',NULL,'2022-11-10 21:04:46','2022-11-10 21:04:46',NULL),(15,10,0.00,1198.00,5051.70,'USD','','{\"name\":\"Mr. Rex Yost Jr.\",\"number\":\"+15519742548\",\"full_name\":\"Prof. Dock Tromp II\",\"description\":\"Hailee Erdman DDS\"}',NULL,0,'processing',NULL,'2022-11-10 21:04:46','2022-11-10 21:04:46',NULL);
/*!40000 ALTER TABLE `mp_customer_withdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_stores`
--

DROP TABLE IF EXISTS `mp_stores`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` int unsigned DEFAULT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `vendor_verified_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `zip_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_stores`
--

LOCK TABLES `mp_stores` WRITE;
/*!40000 ALTER TABLE `mp_stores` DISABLE KEYS */;
INSERT INTO `mp_stores` VALUES (1,'GoPro','okuneva.kallie@example.net','+12409825833','258 Candelario Mews Suite 032','SM','Montana','North Burnice',2,'stores/1.png','Molestiae cumque soluta minima corrupti vel.','Repudiandae et dolores eaque voluptatem omnis. Est eveniet ipsa animi provident consequatur rerum. Qui facilis qui sapiente vero voluptates quo.','published',NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42',NULL,NULL),(2,'Global Office','haskell87@example.com','+13528723934','105 Hintz Harbor','NC','Wisconsin','Port Noe',5,'stores/2.png','Ut omnis corporis est nobis et aut odit.','Impedit ratione occaecati qui aut. Possimus ut fugit repellat ut voluptatem aliquid ut. Quisquam id accusamus commodi eaque minus voluptas et.','published',NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42',NULL,NULL),(3,'Young Shop','lrogahn@example.com','+14804881497','89306 Emily Road','CR','Kansas','Herzogside',6,'stores/3.png','Dignissimos nulla laborum accusamus.','Aperiam reiciendis tenetur amet eum accusantium aut eos corrupti. Rerum sunt doloremque ut omnis. Aut dignissimos et id sed. Sit aut quo eaque eos.','published',NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42',NULL,NULL),(4,'Global Store','devan.rice@example.org','+19373396572','67660 Kip Shores Suite 499','AX','Oklahoma','West Bart',7,'stores/4.png','Et velit dolores unde natus quae fuga sit et.','Minus et hic quaerat mollitia. Doloribus harum et et. Tenetur iusto vel ut nesciunt. Ut quod debitis ab saepe ipsum ipsam maxime.','published',NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42',NULL,NULL),(5,'Robert’s Store','kblanda@example.net','+13168983155','52604 Chaya Drive','GG','Vermont','Lake Deon',9,'stores/5.png','Et temporibus debitis laboriosam.','Ipsum dolorem sequi quos eaque porro. Et quis debitis et vel et et dolor.','published',NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42',NULL,NULL),(6,'Stouffer','sohara@example.org','+16315060565','424 Kristopher Fall','SN','Pennsylvania','McDermottside',10,'stores/6.png','Atque et quo blanditiis qui deserunt.','Dignissimos dolor ut reprehenderit qui. Natus explicabo natus temporibus ut sit voluptatem. Molestiae tempora consequuntur voluptas iusto officia.','published',NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42',NULL,NULL);
/*!40000 ALTER TABLE `mp_stores` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mp_vendor_info`
--

DROP TABLE IF EXISTS `mp_vendor_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `mp_vendor_info` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int unsigned NOT NULL DEFAULT '0',
  `balance` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_fee` decimal(15,2) NOT NULL DEFAULT '0.00',
  `total_revenue` decimal(15,2) NOT NULL DEFAULT '0.00',
  `signature` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bank_info` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `payout_payment_method` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT 'bank_transfer',
  `tax_info` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mp_vendor_info`
--

LOCK TABLES `mp_vendor_info` WRITE;
/*!40000 ALTER TABLE `mp_vendor_info` DISABLE KEYS */;
INSERT INTO `mp_vendor_info` VALUES (1,2,1941.00,0.00,4307.00,'$2y$10$DgFt0uVNStdVlxggZL4J6OpcxGzlJBUReOzybzNRHVSN3eBZ2A71a','{\"name\":\"Isaiah Hagenes\",\"number\":\"+12202699595\",\"full_name\":\"Prof. Don Pollich I\",\"description\":\"Braeden Schamberger\"}','2022-11-10 21:04:42','2022-11-10 21:04:44','bank_transfer',NULL),(2,5,0.00,0.00,0.00,'$2y$10$ivAEZbTXTyp4LfS7k3PLhulxLoPrFHXG.lzXsWH5h5IqcGK/m1xsi','{\"name\":\"Heidi Douglas MD\",\"number\":\"+18603044572\",\"full_name\":\"Braeden Marks\",\"description\":\"Foster Emmerich\"}','2022-11-10 21:04:42','2022-11-10 21:04:42','bank_transfer',NULL),(3,6,3839.38,0.00,7263.38,'$2y$10$E9UJLGa8uF0OOFrzDLHPgu2MT6j83z0niXXXe0QITO/4pGFT8bEYq','{\"name\":\"Miss Bernice Muller V\",\"number\":\"+15202592531\",\"full_name\":\"Prof. Monserrate Rogahn III\",\"description\":\"Jazmyne Lubowitz DVM\"}','2022-11-10 21:04:42','2022-11-10 21:04:45','bank_transfer',NULL),(4,7,1540.15,0.00,2419.15,'$2y$10$2OnFDarPLCU6AkfGNP7JMu9P8RW7DFb7v8/GbRV2aRVSeteA.Zboq','{\"name\":\"Brigitte Hirthe II\",\"number\":\"+17013809047\",\"full_name\":\"Mrs. Sienna Christiansen I\",\"description\":\"Nikita Labadie\"}','2022-11-10 21:04:42','2022-11-10 21:04:45','bank_transfer',NULL),(5,9,1551.30,0.00,3884.30,'$2y$10$ePT8zmh31ICFVgd.RTH4C.olEIn03b5brtovavAyrA27L07u/MjoK','{\"name\":\"Triston Greenfelder\",\"number\":\"+13344152343\",\"full_name\":\"Casey Lemke II\",\"description\":\"Maribel Corkery II\"}','2022-11-10 21:04:42','2022-11-10 21:04:45','bank_transfer',NULL),(6,10,3853.70,0.00,9530.70,'$2y$10$JDCtEnlq28C2vcEEnt3UGOZtZN7wiPGuSW3RJTu.fadaLE7Ir4u/a','{\"name\":\"Mr. Rex Yost Jr.\",\"number\":\"+15519742548\",\"full_name\":\"Prof. Dock Tromp II\",\"description\":\"Hailee Erdman DDS\"}','2022-11-10 21:04:42','2022-11-10 21:04:46','bank_transfer',NULL);
/*!40000 ALTER TABLE `mp_vendor_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` int NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','<div>[simple-slider key=\"home-slider\" ads_1=\"VC2C8Q1UGCBG\" ads_2=\"NBDWRXTSVZ8N\"][/simple-slider]</div><div>[site-features icon1=\"icon-rocket\" title1=\"Free Delivery\" subtitle1=\"For all orders over $99\" icon2=\"icon-sync\" title2=\"90 Days Return\" subtitle2=\"If goods have problems\" icon3=\"icon-credit-card\" title3=\"Secure Payment\" subtitle3=\"100% secure payment\" icon4=\"icon-bubbles\" title4=\"24/7 Support\" subtitle4=\"Dedicated support\" icon5=\"icon-gift\" title5=\"Gift Service\" subtitle5=\"Support gift service\"][/site-features]</div><div>[flash-sale title=\"Deal of the day\" flash_sale_id=\"1\"][/flash-sale]</div><div>[featured-product-categories title=\"Top Categories\"][/featured-product-categories]</div><div>[theme-ads key_1=\"IZ6WU8KUALYD\" key_2=\"ILSFJVYFGCPZ\" key_3=\"ZDOZUZZIU7FT\"][/theme-ads]</div><div>[featured-products title=\"Featured products\"][/featured-products]</div><div>[theme-ads key_1=\"Q9YDUIC9HSWS\" key_2=\"IZ6WU8KUALYE\"][/theme-ads]</div><div>[product-collections title=\"Exclusive Products\"][/product-collections]</div><div>[product-category-products category_id=\"18\"][/product-category-products]</div><div>[download-app title=\"Download Martfury App Now!\" subtitle=\"Shopping fastly and easily more with our app. Get a link to download the app on your phone.\" screenshot=\"general/app.png\" android_app_url=\"https://www.appstore.com\" ios_app_url=\"https://play.google.com/store\"][/download-app]</div><div>[product-category-products category_id=\"23\"][/product-category-products]</div><div>[newsletter-form title=\"Join Our Newsletter Now\" subtitle=\"Subscribe to get information about products and coupons\"][/newsletter-form]</div>',1,NULL,'homepage',NULL,'published','2022-11-10 21:04:39','2022-11-10 21:04:39'),(2,'About us','<p>Alice panted as she went on to her ear, and whispered \'She\'s under sentence of execution.\' \'What for?\' said the Hatter with a little hot tea upon its forehead (the position in dancing.\' Alice said; \'there\'s a large rabbit-hole under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you haven\'t found it advisable--\"\' \'Found WHAT?\' said the Gryphon. \'The reason is,\' said the Cat, \'a dog\'s not mad. You grant that?\' \'I suppose they are the jurors.\' She said the White Rabbit was no more of it had.</p><p>I hadn\'t mentioned Dinah!\' she said this, she came upon a Gryphon, lying fast asleep in the sky. Alice went timidly up to Alice, and her eyes to see that queer little toss of her head to keep back the wandering hair that curled all over with fright. \'Oh, I beg your pardon!\' cried Alice again, for this time the Queen to-day?\' \'I should like it put the Dormouse turned out, and, by the English, who wanted leaders, and had just succeeded in curving it down \'important,\' and some \'unimportant.\'.</p><p>Alice said very politely, feeling quite pleased to have the experiment tried. \'Very true,\' said the Duchess, as she could for sneezing. There was no longer to be patted on the door of which was immediately suppressed by the Hatter, \'you wouldn\'t talk about wasting IT. It\'s HIM.\' \'I don\'t see any wine,\' she remarked. \'It tells the day and night! You see the Queen. \'Their heads are gone, if it makes me grow smaller, I suppose.\' So she was about a thousand times as large as the rest of my own.</p><p>LITTLE BUSY BEE,\" but it had struck her foot! She was moving them about as much as she was saying, and the Dormouse sulkily remarked, \'If you can\'t help it,\' she thought, \'it\'s sure to do THAT in a deep voice, \'are done with blacking, I believe.\' \'Boots and shoes under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you were down here till I\'m somebody else\"--but, oh dear!\' cried Alice in a minute, trying to put everything upon Bill! I wouldn\'t say anything about it, you may nurse it a.</p>',1,NULL,'default',NULL,'published','2022-11-10 21:04:39','2022-11-10 21:04:39'),(3,'Terms Of Use','<p>Majesty must cross-examine THIS witness.\' \'Well, if I shall be punished for it to make out that she wasn\'t a bit hurt, and she had found her way into that lovely garden. I think I may as well say,\' added the Dormouse, and repeated her question. \'Why did they draw?\' said Alice, always ready to talk to.\' \'How are you getting on now, my dear?\' it continued, turning to the general conclusion, that wherever you go on? It\'s by far the most curious thing I ever heard!\' \'Yes, I think I can say.\' This.</p><p>The Duchess took her choice, and was going on, as she listened, or seemed to Alice with one finger for the garden!\' and she hastily dried her eyes filled with tears running down his brush, and had just begun \'Well, of all this time, and was immediately suppressed by the White Rabbit, \'and that\'s the queerest thing about it.\' \'She\'s in prison,\' the Queen was in such long curly brown hair! And it\'ll fetch things when you have just been picked up.\' \'What\'s in it?\' said the Duchess: \'flamingoes.</p><p>Hatter, it woke up again with a shiver. \'I beg your pardon,\' said Alice in a tone of great surprise. \'Of course not,\' said the Gryphon, half to itself, \'Oh dear! Oh dear! I shall see it quite plainly through the wood. \'It\'s the stupidest tea-party I ever saw one that size? Why, it fills the whole she thought at first was moderate. But the snail replied \"Too far, too far!\" and gave a little pattering of feet in a low voice, \'Your Majesty must cross-examine THIS witness.\' \'Well, if I chose,\' the.</p><p>Oh dear! I\'d nearly forgotten to ask.\' \'It turned into a butterfly, I should think you\'ll feel it a very fine day!\' said a timid voice at her with large eyes full of smoke from one end to the general conclusion, that wherever you go to law: I will just explain to you how it was an old conger-eel, that used to do:-- \'How doth the little creature down, and was suppressed. \'Come, that finished the guinea-pigs!\' thought Alice. The poor little thing sat down again in a very respectful tone, but.</p>',1,NULL,'default',NULL,'published','2022-11-10 21:04:39','2022-11-10 21:04:39'),(4,'Terms & Conditions','<p>Alice, \'but I haven\'t had a head could be NO mistake about it: it was a large rabbit-hole under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you haven\'t found it made no mark; but he would not give all else for two reasons. First, because I\'m on the bank--the birds with draggled feathers, the animals with their heads!\' and the game was in confusion, getting the Dormouse indignantly. However, he consented to go through next walking about at the bottom of a globe of goldfish she had never.</p><p>Canterbury, found it advisable--\"\' \'Found WHAT?\' said the Mock Turtle. \'Certainly not!\' said Alice doubtfully: \'it means--to--make--anything--prettier.\' \'Well, then,\' the Cat in a hoarse growl, \'the world would go round a deal faster than it does.\' \'Which would NOT be an advantage,\' said Alice, who had got to do,\' said Alice sharply, for she had never left off quarrelling with the name of the door with his nose, and broke off a little irritated at the March Hare. Alice was more than Alice.</p><p>March Hare. \'I didn\'t mean it!\' pleaded poor Alice in a furious passion, and went on without attending to her; \'but those serpents! There\'s no pleasing them!\' Alice was a paper label, with the next verse.\' \'But about his toes?\' the Mock Turtle to sing you a song?\' \'Oh, a song, please, if the Mock Turtle. \'Certainly not!\' said Alice desperately: \'he\'s perfectly idiotic!\' And she kept fanning herself all the right distance--but then I wonder what you\'re doing!\' cried Alice, quite forgetting her.</p><p>Has lasted the rest of the guinea-pigs cheered, and was immediately suppressed by the hand, it hurried off, without waiting for turns, quarrelling all the rest were quite dry again, the cook was leaning over the jury-box with the bread-knife.\' The March Hare took the hookah out of sight, they were mine before. If I or she fell past it. \'Well!\' thought Alice \'without pictures or conversations in it, \'and what is the same as the door began sneezing all at once. The Dormouse had closed its eyes.</p>',1,NULL,'default',NULL,'published','2022-11-10 21:04:39','2022-11-10 21:04:39'),(5,'Refund Policy','<p>Alice. \'Nothing WHATEVER?\' persisted the King. \'Nearly two miles high,\' added the Queen. \'I haven\'t the slightest idea,\' said the Hatter; \'so I can\'t put it to be ashamed of yourself,\' said Alice, very much at this, she was now about two feet high, and her eyes immediately met those of a tree. By the use of a book,\' thought Alice to herself, (not in a ring, and begged the Mouse heard this, it turned round and round Alice, every now and then, and holding it to her in the morning, just time to.</p><p>Cheshire cat,\' said the Mouse. \'--I proceed. \"Edwin and Morcar, the earls of Mercia and Northumbria, declared for him: and even Stigand, the patriotic archbishop of Canterbury, found it very nice, (it had, in fact, I didn\'t know how to spell \'stupid,\' and that you had been found and handed back to my boy, I beat him when he finds out who I am! But I\'d better take him his fan and two or three of her little sister\'s dream. The long grass rustled at her with large round eyes, and feebly.</p><p>Alice, thinking it was only the pepper that had a pencil that squeaked. This of course, to begin with.\' \'A barrowful will do, to begin with.\' \'A barrowful of WHAT?\' thought Alice; \'but when you throw them, and considered a little, and then said, \'It was the same thing,\' said the King. \'Nothing whatever,\' said Alice. \'Anything you like,\' said the Queen. \'It proves nothing of tumbling down stairs! How brave they\'ll all think me for his housemaid,\' she said to Alice, that she hardly knew what she.</p><p>SIT down,\' the King said to herself, \'Now, what am I to get very tired of swimming about here, O Mouse!\' (Alice thought this must ever be A secret, kept from all the same, shedding gallons of tears, but said nothing. \'Perhaps it doesn\'t matter much,\' thought Alice, \'or perhaps they won\'t walk the way I want to see how he did with the glass table as before, \'It\'s all his fancy, that: they never executes nobody, you know. Come on!\' \'Everybody says \"come on!\" here,\' thought Alice, \'and if it had.</p>',1,NULL,'default',NULL,'published','2022-11-10 21:04:39','2022-11-10 21:04:39'),(6,'Blog','<p>---</p>',1,NULL,'blog-sidebar',NULL,'published','2022-11-10 21:04:39','2022-11-10 21:04:39'),(7,'FAQs','<div>[faq title=\"Frequently Asked Questions\"][/faq]</div>',1,NULL,'default',NULL,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(8,'Contact','<div>[google-map]502 New Street, Brighton VIC, Australia[/google-map]</div><div>[contact-info-boxes title=\"Contact Us For Any Questions\"][/contact-info-boxes]</div><div>[contact-form][/contact-form]</div>',1,NULL,'full-width',NULL,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(9,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this Website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,'default',NULL,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(10,'Affiliate','<p>I know?\' said Alice, as she swam lazily about in the middle. Alice kept her eyes filled with tears again as she stood looking at it again: but he now hastily began again, using the ink, that was lying under the door; so either way I\'ll get into her eyes--and still as she was small enough to look through into the air, and came flying down upon her: she gave a little shriek, and went on so long that they could not think of anything else. CHAPTER V. Advice from a bottle marked \'poison,\' so Alice.</p><p>Dodo suddenly called out \'The Queen! The Queen!\' and the Queen\'s shrill cries to the other: the only difficulty was, that she was ever to get out again. The rabbit-hole went straight on like a steam-engine when she was playing against herself, for she was trying to fix on one, the cook till his eyes were nearly out of the window, I only knew how to get very tired of sitting by her sister was reading, but it makes rather a hard word, I will just explain to you to death.\"\' \'You are old,\' said.</p><p>Alice to find quite a crowd of little Alice herself, and fanned herself with one eye, How the Owl and the little door: but, alas! the little golden key in the pool rippling to the other: he came trotting along in a helpless sort of thing that would be wasting our breath.\" \"I\'ll be judge, I\'ll be jury,\" Said cunning old Fury: \"I\'ll try the thing Mock Turtle yet?\' \'No,\' said the Mouse only growled in reply. \'Idiot!\' said the March Hare: she thought to herself \'It\'s the oldest rule in the wood,\'.</p><p>ARE OLD, FATHER WILLIAM,\"\' said the King. \'Nearly two miles high,\' added the Dormouse. \'Fourteenth of March, I think I can go back and finish your story!\' Alice called after her. \'I\'ve something important to say!\' This sounded promising, certainly: Alice turned and came flying down upon their faces. There was exactly three inches high). \'But I\'m not myself, you see.\' \'I don\'t think they play at all the arches are gone from this morning,\' said Alice loudly. \'The idea of the sea.\' \'I couldn\'t.</p>',1,NULL,'default',NULL,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(11,'Career','<p>It means much the same height as herself; and when she turned the corner, but the Gryphon at the mushroom (she had kept a piece of evidence we\'ve heard yet,\' said the White Rabbit. She was moving them about as curious as it left no mark on the floor: in another moment, when she got used to know. Let me see--how IS it to be trampled under its feet, ran round the court with a T!\' said the Caterpillar. This was quite a long silence after this, and she went on again: \'Twenty-four hours, I THINK.</p><p>Arithmetic--Ambition, Distraction, Uglification, and Derision.\' \'I never thought about it,\' added the March Hare, \'that \"I like what I was sent for.\' \'You ought to speak, but for a rabbit! I suppose you\'ll be asleep again before it\'s done.\' \'Once upon a little bit, and said anxiously to herself, \'if one only knew the right thing to eat some of them attempted to explain it as she passed; it was very hot, she kept on good terms with him, he\'d do almost anything you liked with the next witness.</p><p>Rabbit just under the sea,\' the Gryphon went on again:-- \'I didn\'t mean it!\' pleaded poor Alice. \'But you\'re so easily offended, you know!\' The Mouse looked at each other for some minutes. Alice thought she had read about them in books, and she at once crowded round her, about four feet high. \'Whoever lives there,\' thought Alice, as she could, for the Dormouse,\' thought Alice; \'but a grin without a great hurry. \'You did!\' said the Queen, \'and he shall tell you more than three.\' \'Your hair.</p><p>Alice; \'I must be the use of a water-well,\' said the Dodo, pointing to the game, feeling very curious thing, and she tried to fancy what the name \'W. RABBIT\' engraved upon it. She went in without knocking, and hurried off to trouble myself about you: you must manage the best thing to nurse--and she\'s such a nice little dog near our house I should be like then?\' And she thought at first she would gather about her any more questions about it, so she set to work nibbling at the cook and the other.</p>',1,NULL,'default',NULL,'published','2022-11-10 21:04:40','2022-11-10 21:04:40'),(12,'Coming soon','<p>Condimentum ipsum a adipiscing hac dolor set consectetur urna commodo elit parturient <br/>molestie ut nisl partu convallier ullamcorpe.</p><div>[coming-soon time=\"December 30, 2022 15:37:25\" image=\"general/coming-soon.jpg\"][/coming-soon]</div>',1,NULL,'coming-soon',NULL,'published','2022-11-10 21:04:40','2022-11-10 21:04:40');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
INSERT INTO `pages_translations` VALUES ('vi',1,'Trang chủ',NULL,'<div>[simple-slider key=\"home-slider\" ads_1=\"VC2C8Q1UGCBG\" ads_2=\"NBDWRXTSVZ8N\"][/simple-slider]</div><div>[site-features icon1=\"icon-rocket\" title1=\"Miễn phí vận chuyển\" subtitle1=\"Cho đơn hàng từ 2tr\" icon2=\"icon-sync\" title2=\"Miễn phí hoàn hàng\" subtitle2=\"If goods have problems\" icon3=\"icon-credit-card\" title3=\"Thanh toán bảo mật\" subtitle3=\"100% secure payment\" icon4=\"icon-bubbles\" title4=\"Hỗ trợ 24/7\" subtitle4=\"Dedicated support\" icon5=\"icon-gift\" title5=\"Dịch vụ gói quà\" subtitle5=\"Support gift service\"][/site-features]</div><div>[flash-sale title=\"Khuyến mãi hot\" flash_sale_id=\"1\"][/flash-sale]</div><div>[featured-product-categories title=\"Danh mục nổi bật\"][/featured-product-categories]</div><div>[theme-ads key_1=\"IZ6WU8KUALYD\" key_2=\"ILSFJVYFGCPZ\" key_3=\"ZDOZUZZIU7FT\"][/theme-ads]</div><div>[featured-products title=\"Sản phẩm nổi bật\"][/featured-products]</div><div>[theme-ads key_1=\"Q9YDUIC9HSWS\" key_2=\"IZ6WU8KUALYE\"][/theme-ads]</div><div>[product-collections title=\"Sản phẩm độc quyền\"][/product-collections]</div><div>[product-category-products category_id=\"18\"][/product-category-products]</div><div>[download-app title=\"Tải Martfury App Ngay!\" subtitle=\"Mua sắm nhanh chóng và dễ dàng hơn với ứng dụng của chúng tôi. Nhận liên kết để tải xuống ứng dụng trên điện thoại của bạn.\" screenshot=\"general/app.png\" android_app_url=\"https://www.appstore.com\" ios_app_url=\"https://play.google.com/store\"][/download-app]</div><div>[product-category-products category_id=\"23\"][/product-category-products]</div><div>[newsletter-form title=\"Tham gia bản tin ngay\" subtitle=\"Đăng ký để nhận thông tin về sản phẩm và phiếu giảm giá\"][/newsletter-form]</div>'),('vi',2,'Về chúng tôi',NULL,NULL),('vi',3,'Điều khoản sử dụng',NULL,NULL),('vi',4,'Điều khoản và điều kiện',NULL,NULL),('vi',5,'Điều kiện hoàn hàng',NULL,NULL),('vi',6,'Tin tức',NULL,'<p>---</p>'),('vi',7,'Câu hỏi thường gặp',NULL,'<div>[faq title=\"Các câu hỏi thường gặp\"][/faq]</div>'),('vi',8,'Liên hệ',NULL,'<div>[google-map]502 New Street, Brighton VIC, Australia[/google-map]</div><div>[contact-info-boxes title=\"Liên hệ với chúng tôi nếu bạn có thắc mắc\"][/contact-info-boxes]</div><div>[contact-form][/contact-form]</div>'),('vi',9,'Chính sách cookie',NULL,'<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>'),('vi',10,'Tiếp thị liên kết',NULL,NULL),('vi',11,'Tuyển dụng',NULL,NULL),('vi',12,'Sắp ra mắt',NULL,'<p>Condimentum ipsum a adipiscing hac dolor set consectetur urna commodo elit parturient <br/>molestie ut nisl partu convallier ullamcorpe.</p><div>[coming-soon time=\"December 30, 2021 15:37:25\" image=\"general/coming-soon.jpg\"][/coming-soon]</div>');
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `order_id` int unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` int unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'USD',0,'N6VSMSR8FX','sslcommerz',NULL,1698.80,1,'completed','confirm',8,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(2,'USD',0,'T9BBMJZTMJ','stripe',NULL,2904.30,2,'completed','confirm',8,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(3,'USD',0,'NN61EUGEWL','sslcommerz',NULL,44.55,3,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(4,'USD',0,'N0RDQSNXQV','bank_transfer',NULL,42.00,4,'pending','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(5,'USD',0,'XUH2MNEIJG','sslcommerz',NULL,3884.30,5,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(6,'USD',0,'QGHT5Q70PZ','razorpay',NULL,2374.60,6,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(7,'USD',0,'NREVY96ZPI','cod',NULL,62.00,7,'pending','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(8,'USD',0,'FNHSXOMA21','cod',NULL,578.60,8,'pending','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(9,'USD',0,'OQHWFQEOVW','paypal',NULL,578.60,9,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(10,'USD',0,'B6SEEMQUQS','sslcommerz',NULL,4769.90,10,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(11,'USD',0,'TXKTPTXQSU','stripe',NULL,469.70,11,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(12,'USD',0,'87V4EANT4N','stripe',NULL,3701.40,12,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(13,'USD',0,'O22KKWSVMG','bank_transfer',NULL,2228.10,13,'pending','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(14,'USD',0,'XXYH4IHTAC','stripe',NULL,1875.30,14,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(15,'USD',0,'CVGFQVRAWM','cod',NULL,4683.70,15,'pending','confirm',8,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(16,'USD',0,'R8TYJEWXAT','mollie',NULL,1276.00,16,'completed','confirm',8,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(17,'USD',0,'AEDRVSSIE2','cod',NULL,3519.90,17,'pending','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(18,'USD',0,'TEHLYGCLMK','sslcommerz',NULL,2608.20,18,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(19,'USD',0,'7MUOBUQUKA','stripe',NULL,1313.40,19,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(20,'USD',0,'TUT0WSXORZ','paystack',NULL,608.30,20,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(21,'USD',0,'ZN74JYSF6C','bank_transfer',NULL,1810.40,21,'pending','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(22,'USD',0,'NHV8SUBIYU','sslcommerz',NULL,2374.60,22,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(23,'USD',0,'QZCS9ELEOI','paypal',NULL,1733.90,23,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(24,'USD',0,'4DVQQHOJ5Y','sslcommerz',NULL,1664.70,24,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(25,'USD',0,'BFPYNJ3TDO','razorpay',NULL,1366.20,25,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(26,'USD',0,'9XASPCSDCK','bank_transfer',NULL,1378.30,26,'pending','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(27,'USD',0,'Q7SQEMRHVF','mollie',NULL,2608.20,27,'completed','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(28,'USD',0,'ZMVGO4YZVR','sslcommerz',NULL,1215.98,28,'completed','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(29,'USD',0,'8IHKRYAQRO','bank_transfer',NULL,125.55,29,'pending','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(30,'USD',0,'Q7MOIHGFYK','bank_transfer',NULL,1630.60,30,'pending','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(31,'USD',0,'QENXII89IZ','cod',NULL,125.55,31,'pending','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(32,'USD',0,'2ZJJK6OH4K','paypal',NULL,2437.30,32,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(33,'USD',0,'OCB7IRZX5Q','cod',NULL,642.40,33,'pending','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(34,'USD',0,'MJABN7FFAV','cod',NULL,2608.20,34,'pending','confirm',4,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(35,'USD',0,'AFLYJF0JE8','bank_transfer',NULL,85.05,35,'pending','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(36,'USD',0,'2ASZ0018EG','sslcommerz',NULL,3701.40,36,'completed','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(37,'USD',0,'GGWN7BT3OI','stripe',NULL,2070.50,37,'completed','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(38,'USD',0,'YDXPPZHLIU','razorpay',NULL,3701.40,38,'completed','confirm',3,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(39,'USD',0,'RWLWQKOVWQ','paypal',NULL,589.60,39,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(40,'USD',0,'P5OA6WAVDK','razorpay',NULL,2507.40,40,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(41,'USD',0,'RSMGDU8TCR','paystack',NULL,578.60,41,'completed','confirm',1,NULL,NULL,'2022-11-10 21:04:42','2022-11-10 21:04:42','Botble\\Ecommerce\\Models\\Customer',NULL),(42,'USD',0,'TEASZARUKF','cod',NULL,2822.90,42,'pending','confirm',1,NULL,NULL,'2022-11-10 21:04:43','2022-11-10 21:04:43','Botble\\Ecommerce\\Models\\Customer',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int unsigned NOT NULL,
  `post_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (1,1,1),(2,4,1),(3,2,2),(4,4,2),(5,2,3),(6,3,3),(7,2,4),(8,4,4),(9,2,5),(10,4,5),(11,2,6),(12,3,6),(13,2,7),(14,4,7),(15,1,8),(16,4,8),(17,2,9),(18,3,9),(19,1,10),(20,4,10),(21,1,11),(22,4,11);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` int unsigned NOT NULL,
  `post_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (1,1,1),(2,2,1),(3,3,1),(4,4,1),(5,5,1),(6,1,2),(7,2,2),(8,3,2),(9,4,2),(10,5,2),(11,1,3),(12,2,3),(13,3,3),(14,4,3),(15,5,3),(16,1,4),(17,2,4),(18,3,4),(19,4,4),(20,5,4),(21,1,5),(22,2,5),(23,3,5),(24,4,5),(25,5,5),(26,1,6),(27,2,6),(28,3,6),(29,4,6),(30,5,6),(31,1,7),(32,2,7),(33,3,7),(34,4,7),(35,5,7),(36,1,8),(37,2,8),(38,3,8),(39,4,8),(40,5,8),(41,1,9),(42,2,9),(43,3,9),(44,4,9),(45,5,9),(46,1,10),(47,2,10),(48,3,10),(49,4,10),(50,5,10),(51,1,11),(52,2,11),(53,3,11),(54,4,11),(55,5,11);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` int NOT NULL,
  `author_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `author_id` (`author_id`),
  KEY `author_type` (`author_type`),
  KEY `created_at` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'4 Expert Tips On How To Choose The Right Men’s Wallet','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/1.jpg',1377,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(2,'Sexy Clutches: How to Buy & Wear a Designer Clutch Bag','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/2.jpg',1363,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(3,'The Top 2020 Handbag Trends to Know','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/3.jpg',858,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(4,'How to Match the Color of Your Handbag With an Outfit','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/4.jpg',526,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(5,'How to Care for Leather Bags','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/5.jpg',2042,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(6,'We\'re Crushing Hard on Summer\'s 10 Biggest Bag Trends','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/6.jpg',2211,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(7,'Essential Qualities of Highly Successful Music','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/7.jpg',801,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(8,'9 Things I Love About Shaving My Head','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/8.jpg',635,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(9,'Why Teamwork Really Makes The Dream Work','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/9.jpg',276,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(10,'The World Caters to Average People','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',1,'news/10.jpg',120,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38'),(11,'The litigants on the screen are not actors','You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n','published',1,'Botble\\ACL\\Models\\User',0,'news/11.jpg',981,NULL,'2022-11-10 21:04:38','2022-11-10 21:04:38');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
INSERT INTO `posts_translations` VALUES ('vi',1,'4 Lời khuyên của Chuyên gia về Cách Chọn Ví Nam Phù hợp','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',2,'Sexy Clutches: Cách Mua & Đeo Túi Clutch Thiết kế','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',3,'Xu hướng túi xách hàng đầu năm 2020 cần biết','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',4,'Cách Phối Màu Túi Xách Của Bạn Với Trang Phục','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',5,'Cách Chăm sóc Túi Da','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',6,'Chúng tôi đang nghiền ngẫm 10 xu hướng túi lớn nhất của mùa hè','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',7,'Những phẩm chất cần thiết của âm nhạc thành công cao','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',8,'9 điều tôi thích khi cạo đầu','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',9,'Tại sao làm việc theo nhóm thực sự biến giấc mơ thành công','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',10,'Thế giới phục vụ cho những người trung bình','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n'),('vi',11,'Các đương sự trên màn hình không phải là diễn viên','Bạn nên chú ý hơn khi chọn ví. Có rất nhiều trong số chúng trên thị trường với các mẫu mã và phong cách khác nhau. Khi bạn lựa chọn cẩn thận, bạn sẽ có thể mua một chiếc ví phù hợp với nhu cầu của bạn. Chưa kể nó sẽ giúp nâng tầm phong cách của bạn một cách đáng kể.','<p>I have seen many people underestimating the power of their wallets. To them, they are just a functional item they use to carry. As a result, they often end up with the wallets which are not really suitable for them.</p>\n\n<p>You should pay more attention when you choose your wallets. There are a lot of them on the market with the different designs and styles. When you choose carefully, you would be able to buy a wallet that is catered to your needs. Not to mention that it will help to enhance your style significantly.</p>\n\n<p style=\"text-align:center\"><img alt=\"f4\" src=\"/storage/news/1.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<p><strong><em>For all of the reason above, here are 7 expert tips to help you pick up the right men&rsquo;s wallet for you:</em></strong></p>\n\n<h4><strong>Number 1: Choose A Neat Wallet</strong></h4>\n\n<p>The wallet is an essential accessory that you should go simple. Simplicity is the best in this case. A simple and neat wallet with the plain color and even&nbsp;<strong>minimalist style</strong>&nbsp;is versatile. It can be used for both formal and casual events. In addition, that wallet will go well with most of the clothes in your wardrobe.</p>\n\n<p>Keep in mind that a wallet will tell other people about your personality and your fashion sense as much as other clothes you put on. Hence, don&rsquo;t go cheesy on your wallet or else people will think that you have a funny and particular style.</p>\n\n<p style=\"text-align:center\"><img alt=\"f5\" src=\"/storage/news/2.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n<hr />\n<h4><strong>Number 2: Choose The Right Size For Your Wallet</strong></h4>\n\n<p>You should avoid having an over-sized wallet. Don&rsquo;t think that you need to buy a big wallet because you have a lot to carry with you. In addition, a fat wallet is very ugly. It will make it harder for you to slide the wallet into your trousers&rsquo; pocket. In addition, it will create a bulge and ruin your look.</p>\n\n<p>Before you go on to buy a new wallet, clean out your wallet and place all of the items from your wallet on a table. Throw away things that you would never need any more such as the old bills or the expired gift cards. Remember to check your wallet on a frequent basis to get rid of all of the old stuff that you don&rsquo;t need anymore.</p>\n\n<p style=\"text-align:center\"><img alt=\"f1\" src=\"/storage/news/3.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 3: Don&rsquo;t Limit Your Options Of Materials</strong></h4>\n\n<p>The types and designs of wallets are not the only things that you should consider when you go out searching for your best wallet. You have more than 1 option of material rather than leather to choose from as well.</p>\n\n<p>You can experiment with other available options such as cotton, polyester and canvas. They all have their own pros and cons. As a result, they will be suitable for different needs and requirements. You should think about them all in order to choose the material which you would like the most.</p>\n\n<p style=\"text-align:center\"><img alt=\"f6\" height=\"375\" src=\"/storage/news/4.jpg\" /></p>\n\n<p><br />\n&nbsp;</p>\n\n<hr />\n<h4><strong>Number 4: Consider A Wallet As A Long Term Investment</strong></h4>\n\n<p>Your wallet is indeed an investment that you should consider spending a decent amount of time and effort on it. Another factor that you need to consider is how much you want to spend on your wallet. The price ranges of wallets on the market vary a great deal. You can find a wallet which is as cheap as about 5 to 7 dollars. On the other hand, you should expect to pay around 250 to 300 dollars for a high-quality wallet.</p>\n\n<p>In case you need a wallet to use for a long time, it is a good idea that you should invest a decent amount of money on a wallet. A high quality wallet from a reputational brand with the premium quality such as cowhide leather will last for a long time. In addition, it is an accessory to show off your fashion sense and your social status.</p>\n\n<p style=\"text-align:center\"><img alt=\"f2\" height=\"400\" src=\"/storage/news/5.jpg\" /></p>\n\n<p>&nbsp;</p>\n');
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` int unsigned NOT NULL,
  `updated_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"ecommerce\",\"faq\",\"location\",\"marketplace\",\"newsletter\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"translation\",\"mollie\"]',NULL,'2022-11-10 21:04:30'),(4,'language_hide_default','1',NULL,NULL),(5,'language_switcher_display','dropdown',NULL,NULL),(6,'language_display','all',NULL,NULL),(7,'language_hide_languages','[]',NULL,NULL),(8,'simple_slider_using_assets','0',NULL,NULL),(9,'media_random_hash','511d5f165ff4ac799077280f7a7c0df6',NULL,NULL),(10,'permalink-botble-blog-models-post','blog',NULL,NULL),(11,'permalink-botble-blog-models-category','blog',NULL,NULL),(12,'payment_cod_status','1',NULL,NULL),(13,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,NULL),(14,'payment_bank_transfer_status','1',NULL,NULL),(15,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,NULL),(16,'plugins_ecommerce_customer_new_order_status','0',NULL,NULL),(17,'plugins_ecommerce_admin_new_order_status','0',NULL,NULL),(18,'ecommerce_load_countries_states_cities_from_location_plugin','0',NULL,NULL),(19,'payment_stripe_payment_type','stripe_checkout',NULL,NULL),(20,'ecommerce_is_enabled_support_digital_products','1',NULL,NULL),(21,'ecommerce_store_name','Martfury',NULL,NULL),(22,'ecommerce_store_phone','1800979769',NULL,NULL),(23,'ecommerce_store_address','502 New Street',NULL,NULL),(24,'ecommerce_store_state','Brighton VIC',NULL,NULL),(25,'ecommerce_store_city','Brighton VIC',NULL,NULL),(26,'ecommerce_store_country','AU',NULL,NULL),(27,'theme','martfury',NULL,NULL),(28,'admin_logo','general/logo-light.png',NULL,NULL),(29,'theme-martfury-site_title','Martfury - Laravel Ecommerce system',NULL,NULL),(30,'theme-martfury-copyright','© 2022 Martfury. All Rights Reserved.',NULL,NULL),(31,'theme-martfury-favicon','general/favicon.png',NULL,NULL),(32,'theme-martfury-logo','general/logo.png',NULL,NULL),(33,'theme-martfury-welcome_message','Welcome to Martfury Online Shopping Store!',NULL,NULL),(34,'theme-martfury-address','502 New Street, Brighton VIC, Australia',NULL,NULL),(35,'theme-martfury-hotline','1800 97 97 69',NULL,NULL),(36,'theme-martfury-email','contact@martfury.co',NULL,NULL),(37,'theme-martfury-payment_methods','[\"general\\/payment-method-1.jpg\",\"general\\/payment-method-2.jpg\",\"general\\/payment-method-3.jpg\",\"general\\/payment-method-4.jpg\",\"general\\/payment-method-5.jpg\"]',NULL,NULL),(38,'theme-martfury-newsletter_image','general/newsletter.jpg',NULL,NULL),(39,'theme-martfury-homepage_id','1',NULL,NULL),(40,'theme-martfury-blog_page_id','6',NULL,NULL),(41,'theme-martfury-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,NULL),(42,'theme-martfury-cookie_consent_learn_more_url','https://martfury.test/cookie-policy',NULL,NULL),(43,'theme-martfury-cookie_consent_learn_more_text','Cookie Policy',NULL,NULL),(44,'theme-martfury-number_of_products_per_page','42',NULL,NULL),(45,'theme-martfury-product_feature_1_title','Shipping worldwide',NULL,NULL),(46,'theme-martfury-product_feature_1_icon','icon-network',NULL,NULL),(47,'theme-martfury-product_feature_2_title','Free 7-day return if eligible, so easy',NULL,NULL),(48,'theme-martfury-product_feature_2_icon','icon-3d-rotate',NULL,NULL),(49,'theme-martfury-product_feature_3_title','Supplier give bills for this product.',NULL,NULL),(50,'theme-martfury-product_feature_3_icon','icon-receipt',NULL,NULL),(51,'theme-martfury-product_feature_4_title','Pay online or when receiving goods',NULL,NULL),(52,'theme-martfury-product_feature_4_icon','icon-credit-card',NULL,NULL),(53,'theme-martfury-contact_info_box_1_title','Contact Directly',NULL,NULL),(54,'theme-martfury-contact_info_box_1_subtitle','contact@martfury.com',NULL,NULL),(55,'theme-martfury-contact_info_box_1_details','(+004) 912-3548-07',NULL,NULL),(56,'theme-martfury-contact_info_box_2_title','Headquarters',NULL,NULL),(57,'theme-martfury-contact_info_box_2_subtitle','17 Queen St, Southbank, Melbourne 10560, Australia',NULL,NULL),(58,'theme-martfury-contact_info_box_2_details','',NULL,NULL),(59,'theme-martfury-contact_info_box_3_title','Work With Us',NULL,NULL),(60,'theme-martfury-contact_info_box_3_subtitle','Send your CV to our email:',NULL,NULL),(61,'theme-martfury-contact_info_box_3_details','career@martfury.com',NULL,NULL),(62,'theme-martfury-contact_info_box_4_title','Customer Service',NULL,NULL),(63,'theme-martfury-contact_info_box_4_subtitle','customercare@martfury.com',NULL,NULL),(64,'theme-martfury-contact_info_box_4_details','(800) 843-2446',NULL,NULL),(65,'theme-martfury-contact_info_box_5_title','Media Relations',NULL,NULL),(66,'theme-martfury-contact_info_box_5_subtitle','media@martfury.com',NULL,NULL),(67,'theme-martfury-contact_info_box_5_details','(801) 947-3564',NULL,NULL),(68,'theme-martfury-contact_info_box_6_title','Vendor Support',NULL,NULL),(69,'theme-martfury-contact_info_box_6_subtitle','vendorsupport@martfury.com',NULL,NULL),(70,'theme-martfury-contact_info_box_6_details','(801) 947-3100',NULL,NULL),(71,'theme-martfury-number_of_cross_sale_product','7',NULL,NULL),(72,'theme-martfury-logo_in_the_checkout_page','general/logo-dark.png',NULL,NULL),(73,'theme-martfury-logo_in_invoices','general/logo-dark.png',NULL,NULL),(74,'theme-martfury-logo_vendor_dashboard','general/logo-dark.png',NULL,NULL),(75,'theme-martfury-social-name-1','Facebook','2022-11-10 21:04:41','2022-11-10 21:04:41'),(76,'theme-martfury-social-url-1','https://www.facebook.com/','2022-11-10 21:04:41','2022-11-10 21:04:41'),(77,'theme-martfury-social-icon-1','fa-facebook','2022-11-10 21:04:41','2022-11-10 21:04:41'),(78,'theme-martfury-social-color-1','#3b5999','2022-11-10 21:04:41','2022-11-10 21:04:41'),(79,'theme-martfury-social-name-2','Twitter','2022-11-10 21:04:41','2022-11-10 21:04:41'),(80,'theme-martfury-social-url-2','https://www.twitter.com/','2022-11-10 21:04:41','2022-11-10 21:04:41'),(81,'theme-martfury-social-icon-2','fa-twitter','2022-11-10 21:04:41','2022-11-10 21:04:41'),(82,'theme-martfury-social-color-2','#55ACF9','2022-11-10 21:04:41','2022-11-10 21:04:41'),(83,'theme-martfury-social-name-3','Instagram','2022-11-10 21:04:41','2022-11-10 21:04:41'),(84,'theme-martfury-social-url-3','https://www.instagram.com/','2022-11-10 21:04:41','2022-11-10 21:04:41'),(85,'theme-martfury-social-icon-3','fa-instagram','2022-11-10 21:04:41','2022-11-10 21:04:41'),(86,'theme-martfury-social-color-3','#E1306C','2022-11-10 21:04:41','2022-11-10 21:04:41'),(87,'theme-martfury-social-name-4','Youtube','2022-11-10 21:04:41','2022-11-10 21:04:41'),(88,'theme-martfury-social-url-4','https://www.youtube.com/','2022-11-10 21:04:41','2022-11-10 21:04:41'),(89,'theme-martfury-social-icon-4','fa-youtube','2022-11-10 21:04:41','2022-11-10 21:04:41'),(90,'theme-martfury-social-color-4','#FF0000','2022-11-10 21:04:41','2022-11-10 21:04:41'),(91,'theme-martfury-vi-copyright','© 2022 Martfury. Tất cả quyền đã được bảo hộ.',NULL,NULL),(92,'theme-martfury-vi-welcome_message','Chào mừng đến với Martfury - Cửa Hàng Mua Sắm Online!',NULL,NULL),(93,'theme-martfury-vi-homepage_id','1',NULL,NULL),(94,'theme-martfury-vi-blog_page_id','6',NULL,NULL),(95,'theme-martfury-vi-cookie_consent_message','Trải nghiệm của bạn trên trang web này sẽ được cải thiện bằng cách cho phép cookie ',NULL,NULL),(96,'theme-martfury-vi-cookie_consent_learn_more_url','https://martfury.test/cookie-policy',NULL,NULL),(97,'theme-martfury-vi-cookie_consent_learn_more_text','Chính sách cookie',NULL,NULL),(98,'theme-martfury-vi-product_feature_1_title','Vận chuyển toàn cầu',NULL,NULL),(99,'theme-martfury-vi-product_feature_2_title','Miễn phí hoàn hàng 7 ngày',NULL,NULL),(100,'theme-martfury-vi-product_feature_3_title','Nhà cung cấp sẽ cấp hóa đơn cho sản phẩm này',NULL,NULL),(101,'theme-martfury-vi-product_feature_4_title','Thanh toán online hoặc trực tiếp',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` int unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Slider 1','sliders/1-lg.jpg','/products',NULL,1,'2022-11-10 21:04:39','2022-11-10 21:04:39'),(2,1,'Slider 2','sliders/2-lg.jpg','/products',NULL,2,'2022-11-10 21:04:39','2022-11-10 21:04:39'),(3,1,'Slider 3','sliders/3-lg.jpg','/products',NULL,3,'2022-11-10 21:04:39','2022-11-10 21:04:39'),(4,2,'Slider 1','sliders/1-lg.jpg','/products',NULL,1,'2022-11-10 21:04:39','2022-11-10 21:04:39'),(5,2,'Slider 2','sliders/2-lg.jpg','/products',NULL,2,'2022-11-10 21:04:39','2022-11-10 21:04:39'),(6,2,'Slider 3','sliders/3-lg.jpg','/products',NULL,3,'2022-11-10 21:04:39','2022-11-10 21:04:39');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2022-11-10 21:04:39','2022-11-10 21:04:39'),(2,'Slider trang chủ','slider-trang-chu','Slider chính trên trang chủ','published','2022-11-10 21:04:39','2022-11-10 21:04:39');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` int unsigned NOT NULL,
  `reference_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=112 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'fashion-live',1,'Botble\\Ecommerce\\Models\\Brand','brands','2022-11-10 21:04:30','2022-11-10 21:04:30'),(2,'hand-crafted',2,'Botble\\Ecommerce\\Models\\Brand','brands','2022-11-10 21:04:30','2022-11-10 21:04:30'),(3,'mestonix',3,'Botble\\Ecommerce\\Models\\Brand','brands','2022-11-10 21:04:30','2022-11-10 21:04:30'),(4,'sunshine',4,'Botble\\Ecommerce\\Models\\Brand','brands','2022-11-10 21:04:30','2022-11-10 21:04:30'),(5,'pure',5,'Botble\\Ecommerce\\Models\\Brand','brands','2022-11-10 21:04:30','2022-11-10 21:04:30'),(6,'anfold',6,'Botble\\Ecommerce\\Models\\Brand','brands','2022-11-10 21:04:30','2022-11-10 21:04:30'),(7,'automotive',7,'Botble\\Ecommerce\\Models\\Brand','brands','2022-11-10 21:04:30','2022-11-10 21:04:30'),(8,'hot-promotions',1,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(9,'electronics',2,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(10,'consumer-electronic',3,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(11,'home-audio-theaters',4,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(12,'tv-videos',5,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(13,'camera-photos-videos',6,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(14,'cellphones-accessories',7,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(15,'headphones',8,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(16,'videos-games',9,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(17,'wireless-speakers',10,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(18,'office-electronic',11,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(19,'accessories-parts',12,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(20,'digital-cables',13,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(21,'audio-video-cables',14,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(22,'batteries',15,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(23,'clothing',16,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(24,'computers',17,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(25,'computer-technologies',18,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(26,'computer-tablets',19,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(27,'laptop',20,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(28,'monitors',21,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(29,'computer-components',22,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(30,'networking',23,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(31,'drive-storages',24,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(32,'gaming-laptop',25,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(33,'security-protection',26,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(34,'accessories',27,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(35,'home-kitchen',28,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(36,'health-beauty',29,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(37,'jewelry-watch',30,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(38,'technology-toys',31,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(39,'phones',32,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(40,'babies-moms',33,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(41,'sport-outdoor',34,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(42,'books-office',35,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(43,'cars-motorcycles',36,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(44,'home-improvements',37,'Botble\\Ecommerce\\Models\\ProductCategory','product-categories','2022-11-10 21:04:31','2022-11-10 21:04:31'),(45,'dual-camera-20mp',1,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:35','2022-11-10 21:04:35'),(46,'smart-watches',2,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(47,'beat-headphone',3,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(48,'red-black-headphone',4,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(49,'smart-watch-external',5,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(50,'nikon-hd-camera',6,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(51,'audio-equipment',7,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(52,'smart-televisions',8,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(53,'samsung-smart-phone',9,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(54,'herschel-leather-duffle-bag-in-brown-color',10,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(55,'xbox-one-wireless-controller-black-color',11,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(56,'epsion-plaster-printer',12,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(57,'sound-intone-i65-earphone-white-version',13,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(58,'bo-play-mini-bluetooth-speaker',14,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(59,'apple-macbook-air-retina-133-inch-laptop',15,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(60,'apple-macbook-air-retina-12-inch-laptop',16,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(61,'samsung-gear-vr-virtual-reality-headset',17,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(62,'aveeno-moisturizing-body-shower-450ml',18,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(63,'nyx-beauty-couton-pallete-makeup-12',19,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(64,'nyx-beauty-couton-pallete-makeup-12',20,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(65,'mvmth-classical-leather-watch-in-black',21,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(66,'baxter-care-hair-kit-for-bearded-mens',22,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(67,'ciate-palemore-lipstick-bold-red-color',23,'Botble\\Ecommerce\\Models\\Product','products','2022-11-10 21:04:36','2022-11-10 21:04:36'),(68,'electronic',1,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2022-11-10 21:04:37','2022-11-10 21:04:37'),(69,'mobile',2,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2022-11-10 21:04:37','2022-11-10 21:04:37'),(70,'iphone',3,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2022-11-10 21:04:37','2022-11-10 21:04:37'),(71,'printer',4,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2022-11-10 21:04:37','2022-11-10 21:04:37'),(72,'office',5,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2022-11-10 21:04:37','2022-11-10 21:04:37'),(73,'it',6,'Botble\\Ecommerce\\Models\\ProductTag','product-tags','2022-11-10 21:04:37','2022-11-10 21:04:37'),(74,'ecommerce',1,'Botble\\Blog\\Models\\Category','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(75,'fashion',2,'Botble\\Blog\\Models\\Category','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(76,'electronic',3,'Botble\\Blog\\Models\\Category','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(77,'commercial',4,'Botble\\Blog\\Models\\Category','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(78,'general',1,'Botble\\Blog\\Models\\Tag','tag','2022-11-10 21:04:38','2022-11-10 21:04:38'),(79,'design',2,'Botble\\Blog\\Models\\Tag','tag','2022-11-10 21:04:38','2022-11-10 21:04:38'),(80,'fashion',3,'Botble\\Blog\\Models\\Tag','tag','2022-11-10 21:04:38','2022-11-10 21:04:38'),(81,'branding',4,'Botble\\Blog\\Models\\Tag','tag','2022-11-10 21:04:38','2022-11-10 21:04:38'),(82,'modern',5,'Botble\\Blog\\Models\\Tag','tag','2022-11-10 21:04:38','2022-11-10 21:04:38'),(83,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',1,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(84,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',2,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(85,'the-top-2020-handbag-trends-to-know',3,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(86,'how-to-match-the-color-of-your-handbag-with-an-outfit',4,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(87,'how-to-care-for-leather-bags',5,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(88,'were-crushing-hard-on-summers-10-biggest-bag-trends',6,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(89,'essential-qualities-of-highly-successful-music',7,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(90,'9-things-i-love-about-shaving-my-head',8,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(91,'why-teamwork-really-makes-the-dream-work',9,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(92,'the-world-caters-to-average-people',10,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(93,'the-litigants-on-the-screen-are-not-actors',11,'Botble\\Blog\\Models\\Post','blog','2022-11-10 21:04:38','2022-11-10 21:04:40'),(94,'home',1,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:39','2022-11-10 21:04:39'),(95,'about-us',2,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:39','2022-11-10 21:04:39'),(96,'terms-of-use',3,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:39','2022-11-10 21:04:39'),(97,'terms-conditions',4,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:39','2022-11-10 21:04:39'),(98,'refund-policy',5,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:39','2022-11-10 21:04:39'),(99,'blog',6,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:40','2022-11-10 21:04:40'),(100,'faqs',7,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:40','2022-11-10 21:04:40'),(101,'contact',8,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:40','2022-11-10 21:04:40'),(102,'cookie-policy',9,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:40','2022-11-10 21:04:40'),(103,'affiliate',10,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:40','2022-11-10 21:04:40'),(104,'career',11,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:40','2022-11-10 21:04:40'),(105,'coming-soon',12,'Botble\\Page\\Models\\Page','','2022-11-10 21:04:40','2022-11-10 21:04:40'),(106,'gopro',1,'Botble\\Marketplace\\Models\\Store','stores','2022-11-10 21:04:42','2022-11-10 21:04:42'),(107,'global-office',2,'Botble\\Marketplace\\Models\\Store','stores','2022-11-10 21:04:42','2022-11-10 21:04:42'),(108,'young-shop',3,'Botble\\Marketplace\\Models\\Store','stores','2022-11-10 21:04:42','2022-11-10 21:04:42'),(109,'global-store',4,'Botble\\Marketplace\\Models\\Store','stores','2022-11-10 21:04:42','2022-11-10 21:04:42'),(110,'roberts-store',5,'Botble\\Marketplace\\Models\\Store','stores','2022-11-10 21:04:42','2022-11-10 21:04:42'),(111,'stouffer',6,'Botble\\Marketplace\\Models\\Store','stores','2022-11-10 21:04:42','2022-11-10 21:04:42');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abbreviation` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` int NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` int NOT NULL,
  `author_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'General',1,'Botble\\ACL\\Models\\User','','published','2022-11-10 21:04:38','2022-11-10 21:04:38'),(2,'Design',1,'Botble\\ACL\\Models\\User','','published','2022-11-10 21:04:38','2022-11-10 21:04:38'),(3,'Fashion',1,'Botble\\ACL\\Models\\User','','published','2022-11-10 21:04:38','2022-11-10 21:04:38'),(4,'Branding',1,'Botble\\ACL\\Models\\User','','published','2022-11-10 21:04:38','2022-11-10 21:04:38'),(5,'Modern',1,'Botble\\ACL\\Models\\User','','published','2022-11-10 21:04:38','2022-11-10 21:04:38');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` int NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
INSERT INTO `tags_translations` VALUES ('vi',1,'Chung',NULL),('vi',2,'Thiết kế',NULL),('vi',3,'Thời trang',NULL),('vi',4,'Thương hiệu',NULL),('vi',5,'Hiện đại',NULL);
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `translations`
--

DROP TABLE IF EXISTS `translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `translations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `status` int NOT NULL DEFAULT '0',
  `locale` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5067 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `translations`
--

LOCK TABLES `translations` WRITE;
/*!40000 ALTER TABLE `translations` DISABLE KEYS */;
INSERT INTO `translations` VALUES (1,1,'en','auth','failed','These credentials do not match our records.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(2,1,'en','auth','password','The provided password is incorrect.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(3,1,'en','auth','throttle','Too many login attempts. Please try again in :seconds seconds.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(4,1,'en','pagination','previous','&laquo; Previous','2022-11-10 21:04:46','2022-11-10 21:04:46'),(5,1,'en','pagination','next','Next &raquo;','2022-11-10 21:04:46','2022-11-10 21:04:46'),(6,1,'en','passwords','reset','Your password has been reset!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(7,1,'en','passwords','sent','We have emailed your password reset link!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(8,1,'en','passwords','throttled','Please wait before retrying.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(9,1,'en','passwords','token','This password reset token is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(10,1,'en','passwords','user','We can\'t find a user with that email address.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(11,1,'en','validation','accepted','The :attribute must be accepted.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(12,1,'en','validation','accepted_if','The :attribute must be accepted when :other is :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(13,1,'en','validation','active_url','The :attribute is not a valid URL.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(14,1,'en','validation','after','The :attribute must be a date after :date.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(15,1,'en','validation','after_or_equal','The :attribute must be a date after or equal to :date.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(16,1,'en','validation','alpha','The :attribute must only contain letters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(17,1,'en','validation','alpha_dash','The :attribute must only contain letters, numbers, dashes and underscores.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(18,1,'en','validation','alpha_num','The :attribute must only contain letters and numbers.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(19,1,'en','validation','array','The :attribute must be an array.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(20,1,'en','validation','before','The :attribute must be a date before :date.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(21,1,'en','validation','before_or_equal','The :attribute must be a date before or equal to :date.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(22,1,'en','validation','between.array','The :attribute must have between :min and :max items.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(23,1,'en','validation','between.file','The :attribute must be between :min and :max kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(24,1,'en','validation','between.numeric','The :attribute must be between :min and :max.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(25,1,'en','validation','between.string','The :attribute must be between :min and :max characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(26,1,'en','validation','boolean','The :attribute field must be true or false.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(27,1,'en','validation','confirmed','The :attribute confirmation does not match.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(28,1,'en','validation','current_password','The password is incorrect.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(29,1,'en','validation','date','The :attribute is not a valid date.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(30,1,'en','validation','date_equals','The :attribute must be a date equal to :date.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(31,1,'en','validation','date_format','The :attribute does not match the format :format.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(32,1,'en','validation','declined','The :attribute must be declined.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(33,1,'en','validation','declined_if','The :attribute must be declined when :other is :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(34,1,'en','validation','different','The :attribute and :other must be different.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(35,1,'en','validation','digits','The :attribute must be :digits digits.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(36,1,'en','validation','digits_between','The :attribute must be between :min and :max digits.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(37,1,'en','validation','dimensions','The :attribute has invalid image dimensions.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(38,1,'en','validation','distinct','The :attribute field has a duplicate value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(39,1,'en','validation','doesnt_end_with','The :attribute may not end with one of the following: :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(40,1,'en','validation','doesnt_start_with','The :attribute may not start with one of the following: :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(41,1,'en','validation','email','The :attribute must be a valid email address.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(42,1,'en','validation','ends_with','The :attribute must end with one of the following: :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(43,1,'en','validation','enum','The selected :attribute is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(44,1,'en','validation','exists','The selected :attribute is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(45,1,'en','validation','file','The :attribute must be a file.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(46,1,'en','validation','filled','The :attribute field must have a value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(47,1,'en','validation','gt.array','The :attribute must have more than :value items.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(48,1,'en','validation','gt.file','The :attribute must be greater than :value kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(49,1,'en','validation','gt.numeric','The :attribute must be greater than :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(50,1,'en','validation','gt.string','The :attribute must be greater than :value characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(51,1,'en','validation','gte.array','The :attribute must have :value items or more.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(52,1,'en','validation','gte.file','The :attribute must be greater than or equal to :value kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(53,1,'en','validation','gte.numeric','The :attribute must be greater than or equal to :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(54,1,'en','validation','gte.string','The :attribute must be greater than or equal to :value characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(55,1,'en','validation','image','The :attribute must be an image.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(56,1,'en','validation','in','The selected :attribute is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(57,1,'en','validation','in_array','The :attribute field does not exist in :other.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(58,1,'en','validation','integer','The :attribute must be an integer.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(59,1,'en','validation','ip','The :attribute must be a valid IP address.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(60,1,'en','validation','ipv4','The :attribute must be a valid IPv4 address.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(61,1,'en','validation','ipv6','The :attribute must be a valid IPv6 address.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(62,1,'en','validation','json','The :attribute must be a valid JSON string.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(63,1,'en','validation','lowercase','The :attribute must be lowercase.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(64,1,'en','validation','lt.array','The :attribute must have less than :value items.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(65,1,'en','validation','lt.file','The :attribute must be less than :value kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(66,1,'en','validation','lt.numeric','The :attribute must be less than :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(67,1,'en','validation','lt.string','The :attribute must be less than :value characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(68,1,'en','validation','lte.array','The :attribute must not have more than :value items.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(69,1,'en','validation','lte.file','The :attribute must be less than or equal to :value kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(70,1,'en','validation','lte.numeric','The :attribute must be less than or equal to :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(71,1,'en','validation','lte.string','The :attribute must be less than or equal to :value characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(72,1,'en','validation','mac_address','The :attribute must be a valid MAC address.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(73,1,'en','validation','max.array','The :attribute must not have more than :max items.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(74,1,'en','validation','max.file','The :attribute must not be greater than :max kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(75,1,'en','validation','max.numeric','The :attribute must not be greater than :max.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(76,1,'en','validation','max.string','The :attribute must not be greater than :max characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(77,1,'en','validation','max_digits','The :attribute must not have more than :max digits.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(78,1,'en','validation','mimes','The :attribute must be a file of type: :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(79,1,'en','validation','mimetypes','The :attribute must be a file of type: :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(80,1,'en','validation','min.array','The :attribute must have at least :min items.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(81,1,'en','validation','min.file','The :attribute must be at least :min kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(82,1,'en','validation','min.numeric','The :attribute must be at least :min.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(83,1,'en','validation','min.string','The :attribute must be at least :min characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(84,1,'en','validation','min_digits','The :attribute must have at least :min digits.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(85,1,'en','validation','multiple_of','The :attribute must be a multiple of :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(86,1,'en','validation','not_in','The selected :attribute is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(87,1,'en','validation','not_regex','The :attribute format is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(88,1,'en','validation','numeric','The :attribute must be a number.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(89,1,'en','validation','password.letters','The :attribute must contain at least one letter.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(90,1,'en','validation','password.mixed','The :attribute must contain at least one uppercase and one lowercase letter.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(91,1,'en','validation','password.numbers','The :attribute must contain at least one number.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(92,1,'en','validation','password.symbols','The :attribute must contain at least one symbol.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(93,1,'en','validation','password.uncompromised','The given :attribute has appeared in a data leak. Please choose a different :attribute.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(94,1,'en','validation','present','The :attribute field must be present.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(95,1,'en','validation','prohibited','The :attribute field is prohibited.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(96,1,'en','validation','prohibited_if','The :attribute field is prohibited when :other is :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(97,1,'en','validation','prohibited_unless','The :attribute field is prohibited unless :other is in :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(98,1,'en','validation','prohibits','The :attribute field prohibits :other from being present.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(99,1,'en','validation','regex','The :attribute format is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(100,1,'en','validation','required','The :attribute field is required.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(101,1,'en','validation','required_array_keys','The :attribute field must contain entries for: :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(102,1,'en','validation','required_if','The :attribute field is required when :other is :value.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(103,1,'en','validation','required_if_accepted','The :attribute field is required when :other is accepted.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(104,1,'en','validation','required_unless','The :attribute field is required unless :other is in :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(105,1,'en','validation','required_with','The :attribute field is required when :values is present.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(106,1,'en','validation','required_with_all','The :attribute field is required when :values are present.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(107,1,'en','validation','required_without','The :attribute field is required when :values is not present.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(108,1,'en','validation','required_without_all','The :attribute field is required when none of :values are present.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(109,1,'en','validation','same','The :attribute and :other must match.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(110,1,'en','validation','size.array','The :attribute must contain :size items.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(111,1,'en','validation','size.file','The :attribute must be :size kilobytes.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(112,1,'en','validation','size.numeric','The :attribute must be :size.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(113,1,'en','validation','size.string','The :attribute must be :size characters.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(114,1,'en','validation','starts_with','The :attribute must start with one of the following: :values.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(115,1,'en','validation','string','The :attribute must be a string.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(116,1,'en','validation','timezone','The :attribute must be a valid timezone.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(117,1,'en','validation','unique','The :attribute has already been taken.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(118,1,'en','validation','uploaded','The :attribute failed to upload.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(119,1,'en','validation','url','The :attribute must be a valid URL.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(120,1,'en','validation','uuid','The :attribute must be a valid UUID.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(121,1,'en','validation','custom.attribute-name.rule-name','custom-message','2022-11-10 21:04:46','2022-11-10 21:04:46'),(122,1,'en','core/acl/api','api_clients','API Clients','2022-11-10 21:04:46','2022-11-10 21:04:46'),(123,1,'en','core/acl/api','create_new_client','Create new client','2022-11-10 21:04:46','2022-11-10 21:04:46'),(124,1,'en','core/acl/api','create_new_client_success','Create new client successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(125,1,'en','core/acl/api','edit_client','Edit client \":name\"','2022-11-10 21:04:46','2022-11-10 21:04:46'),(126,1,'en','core/acl/api','edit_client_success','Updated client successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(127,1,'en','core/acl/api','delete_success','Deleted client successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(128,1,'en','core/acl/api','confirm_delete_title','Confirm delete client \":name\"','2022-11-10 21:04:46','2022-11-10 21:04:46'),(129,1,'en','core/acl/api','confirm_delete_description','Do you really want to delete client \":name\"?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(130,1,'en','core/acl/api','cancel_delete','No','2022-11-10 21:04:46','2022-11-10 21:04:46'),(131,1,'en','core/acl/api','continue_delete','Yes, let\'s delete it!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(132,1,'en','core/acl/api','name','Name','2022-11-10 21:04:46','2022-11-10 21:04:46'),(133,1,'en','core/acl/api','cancel','Cancel','2022-11-10 21:04:46','2022-11-10 21:04:46'),(134,1,'en','core/acl/api','save','Save','2022-11-10 21:04:46','2022-11-10 21:04:46'),(135,1,'en','core/acl/api','edit','Edit','2022-11-10 21:04:46','2022-11-10 21:04:46'),(136,1,'en','core/acl/api','delete','Delete','2022-11-10 21:04:46','2022-11-10 21:04:46'),(137,1,'en','core/acl/api','client_id','Client ID','2022-11-10 21:04:46','2022-11-10 21:04:46'),(138,1,'en','core/acl/api','secret','Secret','2022-11-10 21:04:46','2022-11-10 21:04:46'),(139,1,'en','core/acl/auth','login.username','Email/Username','2022-11-10 21:04:46','2022-11-10 21:04:46'),(140,1,'en','core/acl/auth','login.email','Email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(141,1,'en','core/acl/auth','login.password','Password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(142,1,'en','core/acl/auth','login.title','User Login','2022-11-10 21:04:46','2022-11-10 21:04:46'),(143,1,'en','core/acl/auth','login.remember','Remember me?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(144,1,'en','core/acl/auth','login.login','Sign in','2022-11-10 21:04:46','2022-11-10 21:04:46'),(145,1,'en','core/acl/auth','login.placeholder.username','Please enter your username','2022-11-10 21:04:46','2022-11-10 21:04:46'),(146,1,'en','core/acl/auth','login.placeholder.email','Please enter your email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(147,1,'en','core/acl/auth','login.success','Login successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(148,1,'en','core/acl/auth','login.fail','Wrong username or password.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(149,1,'en','core/acl/auth','login.not_active','Your account has not been activated yet!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(150,1,'en','core/acl/auth','login.banned','This account is banned.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(151,1,'en','core/acl/auth','login.logout_success','Logout successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(152,1,'en','core/acl/auth','login.dont_have_account','You don\'t have account on this system, please contact administrator for more information!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(153,1,'en','core/acl/auth','forgot_password.title','Forgot Password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(154,1,'en','core/acl/auth','forgot_password.message','<p>Have you forgotten your password?</p><p>Please enter your email account. System will send a email with active link to reset your password.</p>','2022-11-10 21:04:46','2022-11-10 21:04:46'),(155,1,'en','core/acl/auth','forgot_password.submit','Submit','2022-11-10 21:04:46','2022-11-10 21:04:46'),(156,1,'en','core/acl/auth','reset.new_password','New password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(157,1,'en','core/acl/auth','reset.password_confirmation','Confirm new password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(158,1,'en','core/acl/auth','reset.email','Email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(159,1,'en','core/acl/auth','reset.title','Reset your password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(160,1,'en','core/acl/auth','reset.update','Update','2022-11-10 21:04:46','2022-11-10 21:04:46'),(161,1,'en','core/acl/auth','reset.wrong_token','This link is invalid or expired. Please try using reset form again.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(162,1,'en','core/acl/auth','reset.user_not_found','This username is not exist.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(163,1,'en','core/acl/auth','reset.success','Reset password successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(164,1,'en','core/acl/auth','reset.fail','Token is invalid, the reset password link has been expired!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(165,1,'en','core/acl/auth','reset.reset.title','Email reset password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(166,1,'en','core/acl/auth','reset.send.success','A email was sent to your email account. Please check and complete this action.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(167,1,'en','core/acl/auth','reset.send.fail','Can not send email in this time. Please try again later.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(168,1,'en','core/acl/auth','reset.new-password','New password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(169,1,'en','core/acl/auth','email.reminder.title','Email reset password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(170,1,'en','core/acl/auth','password_confirmation','Password confirm','2022-11-10 21:04:46','2022-11-10 21:04:46'),(171,1,'en','core/acl/auth','failed','Failed','2022-11-10 21:04:46','2022-11-10 21:04:46'),(172,1,'en','core/acl/auth','throttle','Throttle','2022-11-10 21:04:46','2022-11-10 21:04:46'),(173,1,'en','core/acl/auth','not_member','Not a member yet?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(174,1,'en','core/acl/auth','register_now','Register now','2022-11-10 21:04:46','2022-11-10 21:04:46'),(175,1,'en','core/acl/auth','lost_your_password','Lost your password?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(176,1,'en','core/acl/auth','login_title','Admin','2022-11-10 21:04:46','2022-11-10 21:04:46'),(177,1,'en','core/acl/auth','login_via_social','Login with social networks','2022-11-10 21:04:46','2022-11-10 21:04:46'),(178,1,'en','core/acl/auth','back_to_login','Back to login page','2022-11-10 21:04:46','2022-11-10 21:04:46'),(179,1,'en','core/acl/auth','sign_in_below','Sign In Below','2022-11-10 21:04:46','2022-11-10 21:04:46'),(180,1,'en','core/acl/auth','languages','Languages','2022-11-10 21:04:46','2022-11-10 21:04:46'),(181,1,'en','core/acl/auth','reset_password','Reset Password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(182,1,'en','core/acl/auth','settings.email.title','ACL','2022-11-10 21:04:46','2022-11-10 21:04:46'),(183,1,'en','core/acl/auth','settings.email.description','ACL email configuration','2022-11-10 21:04:46','2022-11-10 21:04:46'),(184,1,'en','core/acl/permissions','notices.role_in_use','Cannot delete this role, it is still in use!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(185,1,'en','core/acl/permissions','notices.role_delete_belong_user','You are not able to delete this role; it belongs to someone else!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(186,1,'en','core/acl/permissions','notices.role_edit_belong_user','You are not able to edit this role; it belongs to someone else!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(187,1,'en','core/acl/permissions','notices.delete_global_role','You are not allowed to delete global roles!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(188,1,'en','core/acl/permissions','notices.delete_success','The selected role was deleted successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(189,1,'en','core/acl/permissions','notices.modified_success','The selected role was modified successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(190,1,'en','core/acl/permissions','notices.create_success','The new role was successfully created','2022-11-10 21:04:46','2022-11-10 21:04:46'),(191,1,'en','core/acl/permissions','notices.duplicated_success','The selected role was duplicated successfully','2022-11-10 21:04:46','2022-11-10 21:04:46'),(192,1,'en','core/acl/permissions','notices.no_select','Please select at least one record to take this action!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(193,1,'en','core/acl/permissions','notices.not_found','Role not found','2022-11-10 21:04:46','2022-11-10 21:04:46'),(194,1,'en','core/acl/permissions','name','Name','2022-11-10 21:04:46','2022-11-10 21:04:46'),(195,1,'en','core/acl/permissions','current_role','Current Role','2022-11-10 21:04:46','2022-11-10 21:04:46'),(196,1,'en','core/acl/permissions','no_role_assigned','No role assigned','2022-11-10 21:04:46','2022-11-10 21:04:46'),(197,1,'en','core/acl/permissions','role_assigned','Assigned Role','2022-11-10 21:04:46','2022-11-10 21:04:46'),(198,1,'en','core/acl/permissions','create_role','Create New Role','2022-11-10 21:04:46','2022-11-10 21:04:46'),(199,1,'en','core/acl/permissions','role_name','Name','2022-11-10 21:04:46','2022-11-10 21:04:46'),(200,1,'en','core/acl/permissions','role_description','Description','2022-11-10 21:04:46','2022-11-10 21:04:46'),(201,1,'en','core/acl/permissions','permission_flags','Permission Flags','2022-11-10 21:04:46','2022-11-10 21:04:46'),(202,1,'en','core/acl/permissions','cancel','Cancel','2022-11-10 21:04:46','2022-11-10 21:04:46'),(203,1,'en','core/acl/permissions','reset','Reset','2022-11-10 21:04:46','2022-11-10 21:04:46'),(204,1,'en','core/acl/permissions','save','Save','2022-11-10 21:04:46','2022-11-10 21:04:46'),(205,1,'en','core/acl/permissions','global_role_msg','This is a global role and cannot be modified.  You can use the Duplicate button to make a copy of this role that you can then modify.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(206,1,'en','core/acl/permissions','details','Details','2022-11-10 21:04:46','2022-11-10 21:04:46'),(207,1,'en','core/acl/permissions','duplicate','Duplicate','2022-11-10 21:04:46','2022-11-10 21:04:46'),(208,1,'en','core/acl/permissions','all','All Permissions','2022-11-10 21:04:46','2022-11-10 21:04:46'),(209,1,'en','core/acl/permissions','list_role','List Roles','2022-11-10 21:04:46','2022-11-10 21:04:46'),(210,1,'en','core/acl/permissions','created_on','Created On','2022-11-10 21:04:46','2022-11-10 21:04:46'),(211,1,'en','core/acl/permissions','created_by','Created By','2022-11-10 21:04:46','2022-11-10 21:04:46'),(212,1,'en','core/acl/permissions','actions','Actions','2022-11-10 21:04:46','2022-11-10 21:04:46'),(213,1,'en','core/acl/permissions','role_in_use','Cannot delete this role, it is still in use!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(214,1,'en','core/acl/permissions','role_delete_belong_user','You are not able to delete this role; it belongs to someone else!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(215,1,'en','core/acl/permissions','delete_global_role','Can not delete global role','2022-11-10 21:04:46','2022-11-10 21:04:46'),(216,1,'en','core/acl/permissions','delete_success','Delete role successfully','2022-11-10 21:04:46','2022-11-10 21:04:46'),(217,1,'en','core/acl/permissions','no_select','Please select at least one role to take this action!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(218,1,'en','core/acl/permissions','not_found','No role found!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(219,1,'en','core/acl/permissions','role_edit_belong_user','You are not able to edit this role; it belongs to someone else!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(220,1,'en','core/acl/permissions','modified_success','Modified successfully','2022-11-10 21:04:46','2022-11-10 21:04:46'),(221,1,'en','core/acl/permissions','create_success','Create successfully','2022-11-10 21:04:46','2022-11-10 21:04:46'),(222,1,'en','core/acl/permissions','duplicated_success','Duplicated successfully','2022-11-10 21:04:46','2022-11-10 21:04:46'),(223,1,'en','core/acl/permissions','options','Options','2022-11-10 21:04:46','2022-11-10 21:04:46'),(224,1,'en','core/acl/permissions','access_denied_message','You are not allowed to do this action','2022-11-10 21:04:46','2022-11-10 21:04:46'),(225,1,'en','core/acl/permissions','roles','Roles','2022-11-10 21:04:46','2022-11-10 21:04:46'),(226,1,'en','core/acl/permissions','role_permission','Roles and Permissions','2022-11-10 21:04:46','2022-11-10 21:04:46'),(227,1,'en','core/acl/permissions','user_management','User Management','2022-11-10 21:04:46','2022-11-10 21:04:46'),(228,1,'en','core/acl/permissions','super_user_management','Super User Management','2022-11-10 21:04:46','2022-11-10 21:04:46'),(229,1,'en','core/acl/permissions','action_unauthorized','This action is unauthorized.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(230,1,'en','core/acl/reminders','password','Passwords must be at least six characters and match the confirmation.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(231,1,'en','core/acl/reminders','user','We can\'t find a user with that e-mail address.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(232,1,'en','core/acl/reminders','token','This password reset token is invalid.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(233,1,'en','core/acl/reminders','sent','Password reminder sent!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(234,1,'en','core/acl/reminders','reset','Password has been reset!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(235,1,'en','core/acl/users','delete_user_logged_in','Can\'t delete this user. This user is logged on!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(236,1,'en','core/acl/users','no_select','Please select at least one record to take this action!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(237,1,'en','core/acl/users','lock_user_logged_in','Can\'t lock this user. This user is logged on!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(238,1,'en','core/acl/users','update_success','Update status successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(239,1,'en','core/acl/users','save_setting_failed','Something went wrong when save your setting','2022-11-10 21:04:46','2022-11-10 21:04:46'),(240,1,'en','core/acl/users','not_found','User not found','2022-11-10 21:04:46','2022-11-10 21:04:46'),(241,1,'en','core/acl/users','email_exist','That email address already belongs to an existing account','2022-11-10 21:04:46','2022-11-10 21:04:46'),(242,1,'en','core/acl/users','username_exist','That username address already belongs to an existing account','2022-11-10 21:04:46','2022-11-10 21:04:46'),(243,1,'en','core/acl/users','update_profile_success','Your profile changes were successfully saved','2022-11-10 21:04:46','2022-11-10 21:04:46'),(244,1,'en','core/acl/users','password_update_success','Password successfully changed','2022-11-10 21:04:46','2022-11-10 21:04:46'),(245,1,'en','core/acl/users','current_password_not_valid','Current password is not valid','2022-11-10 21:04:46','2022-11-10 21:04:46'),(246,1,'en','core/acl/users','user_exist_in','User is already a member','2022-11-10 21:04:46','2022-11-10 21:04:46'),(247,1,'en','core/acl/users','email','Email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(248,1,'en','core/acl/users','role','Role','2022-11-10 21:04:46','2022-11-10 21:04:46'),(249,1,'en','core/acl/users','username','Username','2022-11-10 21:04:46','2022-11-10 21:04:46'),(250,1,'en','core/acl/users','last_name','Last Name','2022-11-10 21:04:46','2022-11-10 21:04:46'),(251,1,'en','core/acl/users','first_name','First Name','2022-11-10 21:04:46','2022-11-10 21:04:46'),(252,1,'en','core/acl/users','message','Message','2022-11-10 21:04:46','2022-11-10 21:04:46'),(253,1,'en','core/acl/users','cancel_btn','Cancel','2022-11-10 21:04:46','2022-11-10 21:04:46'),(254,1,'en','core/acl/users','change_password','Change password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(255,1,'en','core/acl/users','current_password','Current password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(256,1,'en','core/acl/users','new_password','New Password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(257,1,'en','core/acl/users','confirm_new_password','Confirm New Password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(258,1,'en','core/acl/users','password','Password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(259,1,'en','core/acl/users','save','Save','2022-11-10 21:04:46','2022-11-10 21:04:46'),(260,1,'en','core/acl/users','cannot_delete','User could not be deleted','2022-11-10 21:04:46','2022-11-10 21:04:46'),(261,1,'en','core/acl/users','deleted','User deleted','2022-11-10 21:04:46','2022-11-10 21:04:46'),(262,1,'en','core/acl/users','last_login','Last Login','2022-11-10 21:04:46','2022-11-10 21:04:46'),(263,1,'en','core/acl/users','error_update_profile_image','Error when update profile image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(264,1,'en','core/acl/users','email_reminder_template','<h3>Hello :name</h3><p>The system has received a request to restore the password for your account, to complete this task please click the link below.</p><p><a href=\":link\">Reset password now</a></p><p>If not you ask recover password, please ignore this email.</p><p>This email is valid for 60 minutes after receiving the email.</p>','2022-11-10 21:04:46','2022-11-10 21:04:46'),(265,1,'en','core/acl/users','change_profile_image','Change Profile Image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(266,1,'en','core/acl/users','new_image','New Image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(267,1,'en','core/acl/users','loading','Loading','2022-11-10 21:04:46','2022-11-10 21:04:46'),(268,1,'en','core/acl/users','close','Close','2022-11-10 21:04:46','2022-11-10 21:04:46'),(269,1,'en','core/acl/users','update','Update','2022-11-10 21:04:46','2022-11-10 21:04:46'),(270,1,'en','core/acl/users','read_image_failed','Failed to read the image file','2022-11-10 21:04:46','2022-11-10 21:04:46'),(271,1,'en','core/acl/users','users','Users','2022-11-10 21:04:46','2022-11-10 21:04:46'),(272,1,'en','core/acl/users','update_avatar_success','Update profile image successfully!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(273,1,'en','core/acl/users','info.title','User profile','2022-11-10 21:04:46','2022-11-10 21:04:46'),(274,1,'en','core/acl/users','info.first_name','First Name','2022-11-10 21:04:46','2022-11-10 21:04:46'),(275,1,'en','core/acl/users','info.last_name','Last Name','2022-11-10 21:04:46','2022-11-10 21:04:46'),(276,1,'en','core/acl/users','total_users','Total users','2022-11-10 21:04:46','2022-11-10 21:04:46'),(277,1,'en','core/acl/users','statuses.activated','Activated','2022-11-10 21:04:46','2022-11-10 21:04:46'),(278,1,'en','core/acl/users','statuses.deactivated','Deactivated','2022-11-10 21:04:46','2022-11-10 21:04:46'),(279,1,'en','core/acl/users','make_super','Make super','2022-11-10 21:04:46','2022-11-10 21:04:46'),(280,1,'en','core/acl/users','remove_super','Remove super','2022-11-10 21:04:46','2022-11-10 21:04:46'),(281,1,'en','core/acl/users','is_super','Is super?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(282,1,'en','core/acl/users','email_placeholder','Ex: example@gmail.com','2022-11-10 21:04:46','2022-11-10 21:04:46'),(283,1,'en','core/acl/users','password_confirmation','Re-type password','2022-11-10 21:04:46','2022-11-10 21:04:46'),(284,1,'en','core/acl/users','select_role','Select role','2022-11-10 21:04:46','2022-11-10 21:04:46'),(285,1,'en','core/acl/users','create_new_user','Create a new user','2022-11-10 21:04:46','2022-11-10 21:04:46'),(286,1,'en','core/acl/users','cannot_delete_super_user','Permission denied. Cannot delete a super user!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(287,1,'en','core/acl/users','assigned_role','Assigned Role','2022-11-10 21:04:46','2022-11-10 21:04:46'),(288,1,'en','core/acl/users','no_role_assigned','No role assigned','2022-11-10 21:04:46','2022-11-10 21:04:46'),(289,1,'en','core/acl/users','view_user_profile','View user\'s profile','2022-11-10 21:04:46','2022-11-10 21:04:46'),(290,1,'vi','core/acl/auth','login.username','Email/Tên truy cập','2022-11-10 21:04:46','2022-11-10 21:04:46'),(291,1,'vi','core/acl/auth','login.password','Mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(292,1,'vi','core/acl/auth','login.title','Đăng nhập vào quản trị','2022-11-10 21:04:46','2022-11-10 21:04:46'),(293,1,'vi','core/acl/auth','login.remember','Nhớ mật khẩu?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(294,1,'vi','core/acl/auth','login.login','Đăng nhập','2022-11-10 21:04:46','2022-11-10 21:04:46'),(295,1,'vi','core/acl/auth','login.placeholder.username','Vui lòng nhập tên truy cập','2022-11-10 21:04:46','2022-11-10 21:04:46'),(296,1,'vi','core/acl/auth','login.placeholder.email','Vui lòng nhập email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(297,1,'vi','core/acl/auth','login.success','Đăng nhập thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(298,1,'vi','core/acl/auth','login.fail','Sai tên truy cập hoặc mật khẩu.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(299,1,'vi','core/acl/auth','login.not_active','Tài khoản của bạn chưa được kích hoạt!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(300,1,'vi','core/acl/auth','login.banned','Tài khoản này đã bị khóa.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(301,1,'vi','core/acl/auth','login.logout_success','Đăng xuất thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(302,1,'vi','core/acl/auth','login.dont_have_account','Bạn không có tài khoản trong hệ thống, vui lòng liên hệ quản trị viên!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(303,1,'vi','core/acl/auth','login.email','Email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(304,1,'vi','core/acl/auth','forgot_password.title','Quên mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(305,1,'vi','core/acl/auth','forgot_password.message','<p>Quên mật khẩu?</p><p>Vui lòng nhập email đăng nhập tài khoản của bạn để hệ thống gửi liên kết khôi phục mật khẩu.</p>','2022-11-10 21:04:46','2022-11-10 21:04:46'),(306,1,'vi','core/acl/auth','forgot_password.submit','Hoàn tất','2022-11-10 21:04:46','2022-11-10 21:04:46'),(307,1,'vi','core/acl/auth','reset.new_password','Mật khẩu mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(308,1,'vi','core/acl/auth','reset.title','Khôi phục mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(309,1,'vi','core/acl/auth','reset.update','Cập nhật','2022-11-10 21:04:46','2022-11-10 21:04:46'),(310,1,'vi','core/acl/auth','reset.wrong_token','Liên kết này không chính xác hoặc đã hết hiệu lực, vui lòng yêu cầu khôi phục mật khẩu lại!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(311,1,'vi','core/acl/auth','reset.user_not_found','Tên đăng nhập không tồn tại.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(312,1,'vi','core/acl/auth','reset.success','Khôi phục mật khẩu thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(313,1,'vi','core/acl/auth','reset.fail','Token không hợp lệ hoặc liên kết khôi phục mật khẩu đã hết thời gian hiệu lực!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(314,1,'vi','core/acl/auth','reset.reset.title','Email khôi phục mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(315,1,'vi','core/acl/auth','reset.send.success','Một email khôi phục mật khẩu đã được gửi tới email của bạn, vui lòng kiểm tra và hoàn tất yêu cầu.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(316,1,'vi','core/acl/auth','reset.send.fail','Không thể gửi email trong lúc này. Vui lòng thực hiện lại sau.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(317,1,'vi','core/acl/auth','reset.new-password','Mật khẩu mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(318,1,'vi','core/acl/auth','reset.email','Email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(319,1,'vi','core/acl/auth','reset.password_confirmation','Xác nhận mật khẩu mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(320,1,'vi','core/acl/auth','email.reminder.title','Email khôi phục mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(321,1,'vi','core/acl/auth','failed','Không thành công','2022-11-10 21:04:46','2022-11-10 21:04:46'),(322,1,'vi','core/acl/auth','throttle','Throttle','2022-11-10 21:04:46','2022-11-10 21:04:46'),(323,1,'vi','core/acl/auth','back_to_login','Quay lại trang đăng nhập','2022-11-10 21:04:46','2022-11-10 21:04:46'),(324,1,'vi','core/acl/auth','login_title','Đăng nhập vào quản trị','2022-11-10 21:04:46','2022-11-10 21:04:46'),(325,1,'vi','core/acl/auth','login_via_social','Đăng nhập thông qua mạng xã hội','2022-11-10 21:04:46','2022-11-10 21:04:46'),(326,1,'vi','core/acl/auth','lost_your_password','Quên mật khẩu?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(327,1,'vi','core/acl/auth','not_member','Chưa là thành viên?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(328,1,'vi','core/acl/auth','register_now','Đăng ký ngay','2022-11-10 21:04:46','2022-11-10 21:04:46'),(329,1,'vi','core/acl/auth','languages','Ngôn ngữ','2022-11-10 21:04:46','2022-11-10 21:04:46'),(330,1,'vi','core/acl/auth','password_confirmation','Xác nhận mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(331,1,'vi','core/acl/auth','reset_password','Khôi phục mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(332,1,'vi','core/acl/auth','sign_in_below','Đăng nhập','2022-11-10 21:04:46','2022-11-10 21:04:46'),(333,1,'vi','core/acl/permissions','notices.role_in_use','Không thể xóa quyền người dùng này vì nó đang được sử dụng!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(334,1,'vi','core/acl/permissions','notices.role_delete_belong_user','Không thể xóa quyền hạn này vì nó thuộc về người khác!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(335,1,'vi','core/acl/permissions','notices.role_edit_belong_user','Bạn không được phép sửa quyền này vì nó thuộc về người khác','2022-11-10 21:04:46','2022-11-10 21:04:46'),(336,1,'vi','core/acl/permissions','notices.delete_global_role','Bạn không thể xóa quyền người dùng hệ thống!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(337,1,'vi','core/acl/permissions','notices.delete_success','Quyền người dùng đã được xóa!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(338,1,'vi','core/acl/permissions','notices.modified_success','Quyền người dùng đã được cập nhật thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(339,1,'vi','core/acl/permissions','notices.create_success','Quyền người dùng mới đã được tạo thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(340,1,'vi','core/acl/permissions','notices.duplicated_success','Quyền người dùng đã được sao chép thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(341,1,'vi','core/acl/permissions','notices.no_select','Hãy chọn ít nhất một quyền người dùng để thực hiện hành động này!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(342,1,'vi','core/acl/permissions','notices.not_found','Không tìm thấy quyền người dùng này','2022-11-10 21:04:46','2022-11-10 21:04:46'),(343,1,'vi','core/acl/permissions','name','Tên','2022-11-10 21:04:46','2022-11-10 21:04:46'),(344,1,'vi','core/acl/permissions','current_role','Quyền hiện tại','2022-11-10 21:04:46','2022-11-10 21:04:46'),(345,1,'vi','core/acl/permissions','no_role_assigned','Không có quyền hạn nào','2022-11-10 21:04:46','2022-11-10 21:04:46'),(346,1,'vi','core/acl/permissions','role_assigned','Quyền đã được gán','2022-11-10 21:04:46','2022-11-10 21:04:46'),(347,1,'vi','core/acl/permissions','create_role','Tạo quyền mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(348,1,'vi','core/acl/permissions','role_name','Tên','2022-11-10 21:04:46','2022-11-10 21:04:46'),(349,1,'vi','core/acl/permissions','role_description','Mô tả','2022-11-10 21:04:46','2022-11-10 21:04:46'),(350,1,'vi','core/acl/permissions','permission_flags','Cờ đánh dấu quyền hạn','2022-11-10 21:04:46','2022-11-10 21:04:46'),(351,1,'vi','core/acl/permissions','cancel','Hủy bỏ','2022-11-10 21:04:46','2022-11-10 21:04:46'),(352,1,'vi','core/acl/permissions','reset','Làm lại','2022-11-10 21:04:46','2022-11-10 21:04:46'),(353,1,'vi','core/acl/permissions','save','Lưu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(354,1,'vi','core/acl/permissions','global_role_msg','Đây là một phân quyền toàn cục và không thể thay đổi.  Bạn có thể sử dụng nút \"Nhân bản\" để tạo một bản sao chép cho phân quyền này và chỉnh sửa.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(355,1,'vi','core/acl/permissions','details','Chi tiết','2022-11-10 21:04:46','2022-11-10 21:04:46'),(356,1,'vi','core/acl/permissions','duplicate','Nhân bản','2022-11-10 21:04:46','2022-11-10 21:04:46'),(357,1,'vi','core/acl/permissions','all','Tất cả phân quyền','2022-11-10 21:04:46','2022-11-10 21:04:46'),(358,1,'vi','core/acl/permissions','list_role','Danh sách quyền','2022-11-10 21:04:46','2022-11-10 21:04:46'),(359,1,'vi','core/acl/permissions','created_on','Ngày tạo','2022-11-10 21:04:46','2022-11-10 21:04:46'),(360,1,'vi','core/acl/permissions','created_by','Được tạo bởi','2022-11-10 21:04:46','2022-11-10 21:04:46'),(361,1,'vi','core/acl/permissions','actions','Tác vụ','2022-11-10 21:04:46','2022-11-10 21:04:46'),(362,1,'vi','core/acl/permissions','create_success','Tạo thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(363,1,'vi','core/acl/permissions','delete_global_role','Không thể xóa quyền hệ thống','2022-11-10 21:04:46','2022-11-10 21:04:46'),(364,1,'vi','core/acl/permissions','delete_success','Xóa quyền thành công','2022-11-10 21:04:46','2022-11-10 21:04:46'),(365,1,'vi','core/acl/permissions','duplicated_success','Nhân bản thành công','2022-11-10 21:04:46','2022-11-10 21:04:46'),(366,1,'vi','core/acl/permissions','modified_success','Sửa thành công','2022-11-10 21:04:46','2022-11-10 21:04:46'),(367,1,'vi','core/acl/permissions','no_select','Hãy chọn ít nhất một quyền để thực hiện hành động này!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(368,1,'vi','core/acl/permissions','not_found','Không tìm thấy quyền thành viên nào!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(369,1,'vi','core/acl/permissions','options','Tùy chọn','2022-11-10 21:04:46','2022-11-10 21:04:46'),(370,1,'vi','core/acl/permissions','role_delete_belong_user','Không thể xóa quyền hạn này vì nó thuộc về người khác!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(371,1,'vi','core/acl/permissions','role_edit_belong_user','Bạn không được phép sửa quyền này vì nó thuộc về người khác','2022-11-10 21:04:46','2022-11-10 21:04:46'),(372,1,'vi','core/acl/permissions','role_in_use','Không thể xóa quyền người dùng này vì nó đang được sử dụng!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(373,1,'vi','core/acl/permissions','access_denied_message','Bạn không có quyền sử dụng chức năng này!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(374,1,'vi','core/acl/permissions','roles','Quyền','2022-11-10 21:04:46','2022-11-10 21:04:46'),(375,1,'vi','core/acl/permissions','role_permission','Nhóm và phân quyền','2022-11-10 21:04:46','2022-11-10 21:04:46'),(376,1,'vi','core/acl/permissions','user_management','Quản lý người dùng hệ thống','2022-11-10 21:04:46','2022-11-10 21:04:46'),(377,1,'vi','core/acl/permissions','super_user_management','Quản lý người dùng cấp cao','2022-11-10 21:04:46','2022-11-10 21:04:46'),(378,1,'vi','core/acl/permissions','action_unauthorized','Hành động này không được phép','2022-11-10 21:04:46','2022-11-10 21:04:46'),(379,1,'vi','core/acl/reminders','password','Mật khẩu phải ít nhất 6 kí tự và trùng khớp với mật khẩu xác nhận.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(380,1,'vi','core/acl/reminders','user','Hệ thống không thể tìm thấy tài khoản với email này.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(381,1,'vi','core/acl/reminders','token','Mã khôi phục mật khẩu này không hợp lệ.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(382,1,'vi','core/acl/reminders','sent','Liên kết khôi phục mật khẩu đã được gửi!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(383,1,'vi','core/acl/reminders','reset','Mật khẩu đã được thay đổi!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(384,1,'vi','core/acl/users','delete_user_logged_in','Không thể xóa người dùng đang đăng nhập hệ thống!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(385,1,'vi','core/acl/users','no_select','Hãy chọn ít nhất một trường để thực hiện hành động này!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(386,1,'vi','core/acl/users','lock_user_logged_in','Không thể khóa người dùng đang đăng nhập hệ thống!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(387,1,'vi','core/acl/users','update_success','Cập nhật trạng thái thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(388,1,'vi','core/acl/users','save_setting_failed','Có lỗi xảy ra trong quá trình lưu cài đặt của người dùng','2022-11-10 21:04:46','2022-11-10 21:04:46'),(389,1,'vi','core/acl/users','not_found','Không tìm thấy người dùng','2022-11-10 21:04:46','2022-11-10 21:04:46'),(390,1,'vi','core/acl/users','email_exist','Email này đã được sử dụng bởi người dùng khác trong hệ thống','2022-11-10 21:04:46','2022-11-10 21:04:46'),(391,1,'vi','core/acl/users','username_exist','Tên đăng nhập này đã được sử dụng bởi người dùng khác trong hệ thống','2022-11-10 21:04:46','2022-11-10 21:04:46'),(392,1,'vi','core/acl/users','update_profile_success','Thông tin tài khoản của bạn đã được cập nhật thành công','2022-11-10 21:04:46','2022-11-10 21:04:46'),(393,1,'vi','core/acl/users','password_update_success','Cập nhật mật khẩu thành công','2022-11-10 21:04:46','2022-11-10 21:04:46'),(394,1,'vi','core/acl/users','current_password_not_valid','Mật khẩu hiện tại không chính xác','2022-11-10 21:04:46','2022-11-10 21:04:46'),(395,1,'vi','core/acl/users','user_exist_in','Người dùng đã là thành viên','2022-11-10 21:04:46','2022-11-10 21:04:46'),(396,1,'vi','core/acl/users','email','Email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(397,1,'vi','core/acl/users','username','Tên đăng nhập','2022-11-10 21:04:46','2022-11-10 21:04:46'),(398,1,'vi','core/acl/users','role','Phân quyền','2022-11-10 21:04:46','2022-11-10 21:04:46'),(399,1,'vi','core/acl/users','first_name','Họ','2022-11-10 21:04:46','2022-11-10 21:04:46'),(400,1,'vi','core/acl/users','last_name','Tên','2022-11-10 21:04:46','2022-11-10 21:04:46'),(401,1,'vi','core/acl/users','message','Thông điệp','2022-11-10 21:04:46','2022-11-10 21:04:46'),(402,1,'vi','core/acl/users','cancel_btn','Hủy bỏ','2022-11-10 21:04:46','2022-11-10 21:04:46'),(403,1,'vi','core/acl/users','password','Mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(404,1,'vi','core/acl/users','new_password','Mật khẩu mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(405,1,'vi','core/acl/users','save','Lưu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(406,1,'vi','core/acl/users','confirm_new_password','Xác nhận mật khẩu mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(407,1,'vi','core/acl/users','deleted','Xóa thành viên thành công','2022-11-10 21:04:46','2022-11-10 21:04:46'),(408,1,'vi','core/acl/users','cannot_delete','Không thể xóa thành viên','2022-11-10 21:04:46','2022-11-10 21:04:46'),(409,1,'vi','core/acl/users','last_login','Lần cuối đăng nhập','2022-11-10 21:04:46','2022-11-10 21:04:46'),(410,1,'vi','core/acl/users','error_update_profile_image','Có lỗi trong quá trình đổi ảnh đại diện','2022-11-10 21:04:46','2022-11-10 21:04:46'),(411,1,'vi','core/acl/users','email_reminder_template','<h3>Xin chào :name</h3><p>Hệ thống vừa nhận được yêu cầu khôi phục mật khẩu cho tài khoản của bạn, để hoàn tất tác vụ này vui lòng click vào đường link bên dưới.</p><p><a href=\":link\">Khôi phục mật khẩu</a></p><p>Nếu không phải bạn yêu cầu khôi phục mật khẩu, vui lòng bỏ qua email này.</p><p>Email này có giá trị trong vòng 60 phút kể từ lúc nhận được email.</p>','2022-11-10 21:04:46','2022-11-10 21:04:46'),(412,1,'vi','core/acl/users','change_profile_image','Thay đổi ảnh đại diện','2022-11-10 21:04:46','2022-11-10 21:04:46'),(413,1,'vi','core/acl/users','new_image','Ảnh mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(414,1,'vi','core/acl/users','loading','Đang tải','2022-11-10 21:04:46','2022-11-10 21:04:46'),(415,1,'vi','core/acl/users','close','Đóng','2022-11-10 21:04:46','2022-11-10 21:04:46'),(416,1,'vi','core/acl/users','update','Cập nhật','2022-11-10 21:04:46','2022-11-10 21:04:46'),(417,1,'vi','core/acl/users','read_image_failed','Không đọc được nội dung của hình ảnh','2022-11-10 21:04:46','2022-11-10 21:04:46'),(418,1,'vi','core/acl/users','update_avatar_success','Cập nhật ảnh đại diện thành công!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(419,1,'vi','core/acl/users','users','Quản trị viên','2022-11-10 21:04:46','2022-11-10 21:04:46'),(420,1,'vi','core/acl/users','info.title','Thông tin người dùng','2022-11-10 21:04:46','2022-11-10 21:04:46'),(421,1,'vi','core/acl/users','info.first_name','Họ','2022-11-10 21:04:46','2022-11-10 21:04:46'),(422,1,'vi','core/acl/users','info.last_name','Tên','2022-11-10 21:04:46','2022-11-10 21:04:46'),(423,1,'vi','core/acl/users','statuses.activated','Đang hoạt động','2022-11-10 21:04:46','2022-11-10 21:04:46'),(424,1,'vi','core/acl/users','statuses.deactivated','Đã khoá','2022-11-10 21:04:46','2022-11-10 21:04:46'),(425,1,'vi','core/acl/users','change_password','Thay đổi mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(426,1,'vi','core/acl/users','current_password','Mật khẩu hiện tại','2022-11-10 21:04:46','2022-11-10 21:04:46'),(427,1,'vi','core/acl/users','make_super','Thiết lập quyền cao nhất','2022-11-10 21:04:46','2022-11-10 21:04:46'),(428,1,'vi','core/acl/users','remove_super','Loại bỏ quyền cao nhất','2022-11-10 21:04:46','2022-11-10 21:04:46'),(429,1,'vi','core/acl/users','is_super','Quyền cao nhất?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(430,1,'vi','core/acl/users','email_placeholder','Ex: example@gmail.com','2022-11-10 21:04:46','2022-11-10 21:04:46'),(431,1,'vi','core/acl/users','password_confirmation','Nhập lại mật khẩu','2022-11-10 21:04:46','2022-11-10 21:04:46'),(432,1,'vi','core/acl/users','select_role','Chọn nhóm','2022-11-10 21:04:46','2022-11-10 21:04:46'),(433,1,'vi','core/acl/users','create_new_user','Tạo tài khoản quản trị viên mới','2022-11-10 21:04:46','2022-11-10 21:04:46'),(434,1,'vi','core/acl/users','cannot_delete_super_user','Vượt quyền hạn, không thể xoá quản trị viên cấp cao nhất!','2022-11-10 21:04:46','2022-11-10 21:04:46'),(435,1,'vi','core/acl/users','assigned_role','Cấp quyền','2022-11-10 21:04:46','2022-11-10 21:04:46'),(436,1,'vi','core/acl/users','total_users','Tổng số người dùng','2022-11-10 21:04:46','2022-11-10 21:04:46'),(437,1,'vi','core/acl/users','view_user_profile','Xem thông tin người dùng','2022-11-10 21:04:46','2022-11-10 21:04:46'),(438,1,'vi','core/acl/users','no_role_assigned','Chưa có quyền nào','2022-11-10 21:04:46','2022-11-10 21:04:46'),(439,1,'en','core/base/base','yes','Yes','2022-11-10 21:04:46','2022-11-10 21:04:46'),(440,1,'en','core/base/base','no','No','2022-11-10 21:04:46','2022-11-10 21:04:46'),(441,1,'en','core/base/base','is_default','Is default?','2022-11-10 21:04:46','2022-11-10 21:04:46'),(442,1,'en','core/base/base','proc_close_disabled_error','Function proc_close() is disabled. Please contact your hosting provider to enable\n    it. Or you can add to .env: CAN_EXECUTE_COMMAND=false to disable this feature.','2022-11-10 21:04:46','2022-11-10 21:04:46'),(443,1,'en','core/base/base','email_template.header','Email template header','2022-11-10 21:04:46','2022-11-10 21:04:46'),(444,1,'en','core/base/base','email_template.footer','Email template footer','2022-11-10 21:04:46','2022-11-10 21:04:46'),(445,1,'en','core/base/base','email_template.site_title','Site title','2022-11-10 21:04:46','2022-11-10 21:04:46'),(446,1,'en','core/base/base','email_template.site_url','Site URL','2022-11-10 21:04:46','2022-11-10 21:04:46'),(447,1,'en','core/base/base','email_template.site_logo','Site Logo','2022-11-10 21:04:46','2022-11-10 21:04:46'),(448,1,'en','core/base/base','email_template.date_time','Current date time','2022-11-10 21:04:46','2022-11-10 21:04:46'),(449,1,'en','core/base/base','email_template.date_year','Current year','2022-11-10 21:04:46','2022-11-10 21:04:46'),(450,1,'en','core/base/base','email_template.site_admin_email','Site admin email','2022-11-10 21:04:46','2022-11-10 21:04:46'),(451,1,'en','core/base/base','change_image','Change image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(452,1,'en','core/base/base','delete_image','Delete image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(453,1,'en','core/base/base','preview_image','Preview image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(454,1,'en','core/base/base','image','Image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(455,1,'en','core/base/base','using_button','Using button','2022-11-10 21:04:46','2022-11-10 21:04:46'),(456,1,'en','core/base/base','select_image','Select image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(457,1,'en','core/base/base','to_add_more_image','to add more images','2022-11-10 21:04:46','2022-11-10 21:04:46'),(458,1,'en','core/base/base','add_image','Add image','2022-11-10 21:04:46','2022-11-10 21:04:46'),(459,1,'en','core/base/base','tools','Tools','2022-11-10 21:04:46','2022-11-10 21:04:46'),(460,1,'en','core/base/cache','cache_management','Cache management','2022-11-10 21:04:47','2022-11-10 21:04:47'),(461,1,'en','core/base/cache','cache_commands','Clear cache commands','2022-11-10 21:04:47','2022-11-10 21:04:47'),(462,1,'en','core/base/cache','commands.clear_cms_cache.title','Clear all CMS cache','2022-11-10 21:04:47','2022-11-10 21:04:47'),(463,1,'en','core/base/cache','commands.clear_cms_cache.description','Clear CMS caching: database caching, static blocks... Run this command when you don\'t see the changes after updating data.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(464,1,'en','core/base/cache','commands.clear_cms_cache.success_msg','Cache cleaned','2022-11-10 21:04:47','2022-11-10 21:04:47'),(465,1,'en','core/base/cache','commands.refresh_compiled_views.title','Refresh compiled views','2022-11-10 21:04:47','2022-11-10 21:04:47'),(466,1,'en','core/base/cache','commands.refresh_compiled_views.description','Clear compiled views to make views up to date.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(467,1,'en','core/base/cache','commands.refresh_compiled_views.success_msg','Cache view refreshed','2022-11-10 21:04:47','2022-11-10 21:04:47'),(468,1,'en','core/base/cache','commands.clear_config_cache.title','Clear config cache','2022-11-10 21:04:47','2022-11-10 21:04:47'),(469,1,'en','core/base/cache','commands.clear_config_cache.description','You might need to refresh the config caching when you change something on production environment.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(470,1,'en','core/base/cache','commands.clear_config_cache.success_msg','Config cache cleaned','2022-11-10 21:04:47','2022-11-10 21:04:47'),(471,1,'en','core/base/cache','commands.clear_route_cache.title','Clear route cache','2022-11-10 21:04:47','2022-11-10 21:04:47'),(472,1,'en','core/base/cache','commands.clear_route_cache.description','Clear cache routing.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(473,1,'en','core/base/cache','commands.clear_route_cache.success_msg','The route cache has been cleaned','2022-11-10 21:04:47','2022-11-10 21:04:47'),(474,1,'en','core/base/cache','commands.clear_log.title','Clear log','2022-11-10 21:04:47','2022-11-10 21:04:47'),(475,1,'en','core/base/cache','commands.clear_log.description','Clear system log files','2022-11-10 21:04:47','2022-11-10 21:04:47'),(476,1,'en','core/base/cache','commands.clear_log.success_msg','The system log has been cleaned','2022-11-10 21:04:47','2022-11-10 21:04:47'),(477,1,'en','core/base/enums','statuses.draft','Draft','2022-11-10 21:04:47','2022-11-10 21:04:47'),(478,1,'en','core/base/enums','statuses.pending','Pending','2022-11-10 21:04:47','2022-11-10 21:04:47'),(479,1,'en','core/base/enums','statuses.published','Published','2022-11-10 21:04:47','2022-11-10 21:04:47'),(480,1,'en','core/base/errors','401_title','Permission Denied','2022-11-10 21:04:47','2022-11-10 21:04:47'),(481,1,'en','core/base/errors','401_msg','<li>You have not been granted access to the section by the administrator.</li>\n	                <li>You may have the wrong account type.</li>\n	                <li>You are not authorized to view the requested resource.</li>\n	                <li>Your subscription may have expired.</li>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(482,1,'en','core/base/errors','404_title','Page could not be found','2022-11-10 21:04:47','2022-11-10 21:04:47'),(483,1,'en','core/base/errors','404_msg','<li>The page you requested does not exist.</li>\n	                <li>The link you clicked is no longer.</li>\n	                <li>The page may have moved to a new location.</li>\n	                <li>An error may have occurred.</li>\n	                <li>You are not authorized to view the requested resource.</li>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(484,1,'en','core/base/errors','500_title','Page could not be loaded','2022-11-10 21:04:47','2022-11-10 21:04:47'),(485,1,'en','core/base/errors','500_msg','<li>The page you requested does not exist.</li>\n	                <li>The link you clicked is no longer.</li>\n	                <li>The page may have moved to a new location.</li>\n	                <li>An error may have occurred.</li>\n	                <li>You are not authorized to view the requested resource.</li>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(486,1,'en','core/base/errors','reasons','This may have occurred because of several reasons','2022-11-10 21:04:47','2022-11-10 21:04:47'),(487,1,'en','core/base/errors','try_again','Please try again in a few minutes, or alternatively return to the homepage by <a href=\"https://martfury.test/admin\">clicking here</a>.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(488,1,'en','core/base/errors','not_found','Not Found','2022-11-10 21:04:47','2022-11-10 21:04:47'),(489,1,'en','core/base/forms','choose_image','Choose image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(490,1,'en','core/base/forms','actions','Actions','2022-11-10 21:04:47','2022-11-10 21:04:47'),(491,1,'en','core/base/forms','save','Save','2022-11-10 21:04:47','2022-11-10 21:04:47'),(492,1,'en','core/base/forms','save_and_continue','Save & Edit','2022-11-10 21:04:47','2022-11-10 21:04:47'),(493,1,'en','core/base/forms','image','Image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(494,1,'en','core/base/forms','image_placeholder','Insert path of image or click upload button','2022-11-10 21:04:47','2022-11-10 21:04:47'),(495,1,'en','core/base/forms','create','Create','2022-11-10 21:04:47','2022-11-10 21:04:47'),(496,1,'en','core/base/forms','edit','Edit','2022-11-10 21:04:47','2022-11-10 21:04:47'),(497,1,'en','core/base/forms','permalink','Permalink','2022-11-10 21:04:47','2022-11-10 21:04:47'),(498,1,'en','core/base/forms','ok','OK','2022-11-10 21:04:47','2022-11-10 21:04:47'),(499,1,'en','core/base/forms','cancel','Cancel','2022-11-10 21:04:47','2022-11-10 21:04:47'),(500,1,'en','core/base/forms','character_remain','character(s) remain','2022-11-10 21:04:47','2022-11-10 21:04:47'),(501,1,'en','core/base/forms','template','Template','2022-11-10 21:04:47','2022-11-10 21:04:47'),(502,1,'en','core/base/forms','choose_file','Choose file','2022-11-10 21:04:47','2022-11-10 21:04:47'),(503,1,'en','core/base/forms','file','File','2022-11-10 21:04:47','2022-11-10 21:04:47'),(504,1,'en','core/base/forms','content','Content','2022-11-10 21:04:47','2022-11-10 21:04:47'),(505,1,'en','core/base/forms','description','Description','2022-11-10 21:04:47','2022-11-10 21:04:47'),(506,1,'en','core/base/forms','name','Name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(507,1,'en','core/base/forms','slug','Slug','2022-11-10 21:04:47','2022-11-10 21:04:47'),(508,1,'en','core/base/forms','title','Title','2022-11-10 21:04:47','2022-11-10 21:04:47'),(509,1,'en','core/base/forms','value','Value','2022-11-10 21:04:47','2022-11-10 21:04:47'),(510,1,'en','core/base/forms','name_placeholder','Name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(511,1,'en','core/base/forms','alias_placeholder','Alias','2022-11-10 21:04:47','2022-11-10 21:04:47'),(512,1,'en','core/base/forms','description_placeholder','Short description','2022-11-10 21:04:47','2022-11-10 21:04:47'),(513,1,'en','core/base/forms','parent','Parent','2022-11-10 21:04:47','2022-11-10 21:04:47'),(514,1,'en','core/base/forms','icon','Icon','2022-11-10 21:04:47','2022-11-10 21:04:47'),(515,1,'en','core/base/forms','icon_placeholder','Ex: fa fa-home','2022-11-10 21:04:47','2022-11-10 21:04:47'),(516,1,'en','core/base/forms','order_by','Order by','2022-11-10 21:04:47','2022-11-10 21:04:47'),(517,1,'en','core/base/forms','order_by_placeholder','Order by','2022-11-10 21:04:47','2022-11-10 21:04:47'),(518,1,'en','core/base/forms','is_featured','Is featured?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(519,1,'en','core/base/forms','is_default','Is default?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(520,1,'en','core/base/forms','update','Update','2022-11-10 21:04:47','2022-11-10 21:04:47'),(521,1,'en','core/base/forms','publish','Publish','2022-11-10 21:04:47','2022-11-10 21:04:47'),(522,1,'en','core/base/forms','remove_image','Remove image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(523,1,'en','core/base/forms','remove_file','Remove file','2022-11-10 21:04:47','2022-11-10 21:04:47'),(524,1,'en','core/base/forms','order','Order','2022-11-10 21:04:47','2022-11-10 21:04:47'),(525,1,'en','core/base/forms','alias','Alias','2022-11-10 21:04:47','2022-11-10 21:04:47'),(526,1,'en','core/base/forms','basic_information','Basic information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(527,1,'en','core/base/forms','short_code','Shortcode','2022-11-10 21:04:47','2022-11-10 21:04:47'),(528,1,'en','core/base/forms','add_short_code','Add a shortcode','2022-11-10 21:04:47','2022-11-10 21:04:47'),(529,1,'en','core/base/forms','add','Add','2022-11-10 21:04:47','2022-11-10 21:04:47'),(530,1,'en','core/base/forms','link','Link','2022-11-10 21:04:47','2022-11-10 21:04:47'),(531,1,'en','core/base/forms','show_hide_editor','Show/Hide Editor','2022-11-10 21:04:47','2022-11-10 21:04:47'),(532,1,'en','core/base/forms','basic_info_title','Basic information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(533,1,'en','core/base/forms','expand_all','Expand all','2022-11-10 21:04:47','2022-11-10 21:04:47'),(534,1,'en','core/base/forms','collapse_all','Collapse all','2022-11-10 21:04:47','2022-11-10 21:04:47'),(535,1,'en','core/base/forms','view_new_tab','Open in new tab','2022-11-10 21:04:47','2022-11-10 21:04:47'),(536,1,'en','core/base/forms','view_preview_image','View preview image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(537,1,'en','core/base/layouts','platform_admin','Platform Administration','2022-11-10 21:04:47','2022-11-10 21:04:47'),(538,1,'en','core/base/layouts','dashboard','Dashboard','2022-11-10 21:04:47','2022-11-10 21:04:47'),(539,1,'en','core/base/layouts','widgets','Widgets','2022-11-10 21:04:47','2022-11-10 21:04:47'),(540,1,'en','core/base/layouts','plugins','Plugins','2022-11-10 21:04:47','2022-11-10 21:04:47'),(541,1,'en','core/base/layouts','settings','Settings','2022-11-10 21:04:47','2022-11-10 21:04:47'),(542,1,'en','core/base/layouts','setting_general','General','2022-11-10 21:04:47','2022-11-10 21:04:47'),(543,1,'en','core/base/layouts','setting_email','Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(544,1,'en','core/base/layouts','system_information','System information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(545,1,'en','core/base/layouts','theme','Theme','2022-11-10 21:04:47','2022-11-10 21:04:47'),(546,1,'en','core/base/layouts','copyright','Copyright :year &copy; :company. Version: <span>:version</span>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(547,1,'en','core/base/layouts','profile','Profile','2022-11-10 21:04:47','2022-11-10 21:04:47'),(548,1,'en','core/base/layouts','logout','Logout','2022-11-10 21:04:47','2022-11-10 21:04:47'),(549,1,'en','core/base/layouts','no_search_result','No results found, please try with different keywords.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(550,1,'en','core/base/layouts','home','Home','2022-11-10 21:04:47','2022-11-10 21:04:47'),(551,1,'en','core/base/layouts','search','Search','2022-11-10 21:04:47','2022-11-10 21:04:47'),(552,1,'en','core/base/layouts','add_new','Add new','2022-11-10 21:04:47','2022-11-10 21:04:47'),(553,1,'en','core/base/layouts','n_a','N/A','2022-11-10 21:04:47','2022-11-10 21:04:47'),(554,1,'en','core/base/layouts','page_loaded_time','Page loaded in','2022-11-10 21:04:47','2022-11-10 21:04:47'),(555,1,'en','core/base/layouts','view_website','View website','2022-11-10 21:04:47','2022-11-10 21:04:47'),(556,1,'en','core/base/mail','send-fail','Send email failed','2022-11-10 21:04:47','2022-11-10 21:04:47'),(557,1,'en','core/base/notices','create_success_message','Created successfully','2022-11-10 21:04:47','2022-11-10 21:04:47'),(558,1,'en','core/base/notices','update_success_message','Updated successfully','2022-11-10 21:04:47','2022-11-10 21:04:47'),(559,1,'en','core/base/notices','delete_success_message','Deleted successfully','2022-11-10 21:04:47','2022-11-10 21:04:47'),(560,1,'en','core/base/notices','success_header','Success!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(561,1,'en','core/base/notices','error_header','Error!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(562,1,'en','core/base/notices','no_select','Please select at least one record to perform this action!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(563,1,'en','core/base/notices','processing_request','We are processing your request.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(564,1,'en','core/base/notices','error','Error!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(565,1,'en','core/base/notices','success','Success!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(566,1,'en','core/base/notices','info','Info!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(567,1,'en','core/base/notices','enum.validate_message','The :attribute value you have entered is invalid.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(568,1,'en','core/base/system','no_select','Please select at least one record to take this action!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(569,1,'en','core/base/system','cannot_find_user','Unable to find specified user','2022-11-10 21:04:47','2022-11-10 21:04:47'),(570,1,'en','core/base/system','supper_revoked','Super user access revoked','2022-11-10 21:04:47','2022-11-10 21:04:47'),(571,1,'en','core/base/system','cannot_revoke_yourself','Can not revoke supper user access permission yourself!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(572,1,'en','core/base/system','cant_remove_supper','You don\'t has permission to remove this super user','2022-11-10 21:04:47','2022-11-10 21:04:47'),(573,1,'en','core/base/system','cant_find_user_with_email','Unable to find user with specified email address','2022-11-10 21:04:47','2022-11-10 21:04:47'),(574,1,'en','core/base/system','supper_granted','Super user access granted','2022-11-10 21:04:47','2022-11-10 21:04:47'),(575,1,'en','core/base/system','delete_log_success','Delete log file successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(576,1,'en','core/base/system','get_member_success','Member list retrieved successfully','2022-11-10 21:04:47','2022-11-10 21:04:47'),(577,1,'en','core/base/system','error_occur','The following errors occurred','2022-11-10 21:04:47','2022-11-10 21:04:47'),(578,1,'en','core/base/system','user_management','User Management','2022-11-10 21:04:47','2022-11-10 21:04:47'),(579,1,'en','core/base/system','user_management_description','Manage users.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(580,1,'en','core/base/system','role_and_permission','Roles and Permissions','2022-11-10 21:04:47','2022-11-10 21:04:47'),(581,1,'en','core/base/system','role_and_permission_description','Manage the available roles.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(582,1,'en','core/base/system','user.list_super','List Super Users','2022-11-10 21:04:47','2022-11-10 21:04:47'),(583,1,'en','core/base/system','user.email','Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(584,1,'en','core/base/system','user.last_login','Last Login','2022-11-10 21:04:47','2022-11-10 21:04:47'),(585,1,'en','core/base/system','user.username','Username','2022-11-10 21:04:47','2022-11-10 21:04:47'),(586,1,'en','core/base/system','user.add_user','Add Super User','2022-11-10 21:04:47','2022-11-10 21:04:47'),(587,1,'en','core/base/system','user.cancel','Cancel','2022-11-10 21:04:47','2022-11-10 21:04:47'),(588,1,'en','core/base/system','user.create','Create','2022-11-10 21:04:47','2022-11-10 21:04:47'),(589,1,'en','core/base/system','options.features','Feature Access Control','2022-11-10 21:04:47','2022-11-10 21:04:47'),(590,1,'en','core/base/system','options.feature_description','Manage the available.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(591,1,'en','core/base/system','options.manage_super','Super User Management','2022-11-10 21:04:47','2022-11-10 21:04:47'),(592,1,'en','core/base/system','options.manage_super_description','Add/remove super users.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(593,1,'en','core/base/system','options.info','System information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(594,1,'en','core/base/system','options.info_description','All information about current system configuration.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(595,1,'en','core/base/system','info.title','System information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(596,1,'en','core/base/system','info.cache','Cache','2022-11-10 21:04:47','2022-11-10 21:04:47'),(597,1,'en','core/base/system','info.locale','Active locale','2022-11-10 21:04:47','2022-11-10 21:04:47'),(598,1,'en','core/base/system','info.environment','Environment','2022-11-10 21:04:47','2022-11-10 21:04:47'),(599,1,'en','core/base/system','disabled_in_demo_mode','You cannot do it in demo mode!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(600,1,'en','core/base/system','report_description','Please share this information for troubleshooting','2022-11-10 21:04:47','2022-11-10 21:04:47'),(601,1,'en','core/base/system','get_system_report','Get System Report','2022-11-10 21:04:47','2022-11-10 21:04:47'),(602,1,'en','core/base/system','system_environment','System Environment','2022-11-10 21:04:47','2022-11-10 21:04:47'),(603,1,'en','core/base/system','framework_version','Framework Version','2022-11-10 21:04:47','2022-11-10 21:04:47'),(604,1,'en','core/base/system','timezone','Timezone','2022-11-10 21:04:47','2022-11-10 21:04:47'),(605,1,'en','core/base/system','debug_mode','Debug Mode','2022-11-10 21:04:47','2022-11-10 21:04:47'),(606,1,'en','core/base/system','storage_dir_writable','Storage Dir Writable','2022-11-10 21:04:47','2022-11-10 21:04:47'),(607,1,'en','core/base/system','cache_dir_writable','Cache Dir Writable','2022-11-10 21:04:47','2022-11-10 21:04:47'),(608,1,'en','core/base/system','app_size','App Size','2022-11-10 21:04:47','2022-11-10 21:04:47'),(609,1,'en','core/base/system','server_environment','Server Environment','2022-11-10 21:04:47','2022-11-10 21:04:47'),(610,1,'en','core/base/system','php_version','PHP Version','2022-11-10 21:04:47','2022-11-10 21:04:47'),(611,1,'en','core/base/system','php_version_error','PHP must be >= :version','2022-11-10 21:04:47','2022-11-10 21:04:47'),(612,1,'en','core/base/system','server_software','Server Software','2022-11-10 21:04:47','2022-11-10 21:04:47'),(613,1,'en','core/base/system','server_os','Server OS','2022-11-10 21:04:47','2022-11-10 21:04:47'),(614,1,'en','core/base/system','database','Database','2022-11-10 21:04:47','2022-11-10 21:04:47'),(615,1,'en','core/base/system','ssl_installed','SSL Installed','2022-11-10 21:04:47','2022-11-10 21:04:47'),(616,1,'en','core/base/system','cache_driver','Cache Driver','2022-11-10 21:04:47','2022-11-10 21:04:47'),(617,1,'en','core/base/system','session_driver','Session Driver','2022-11-10 21:04:47','2022-11-10 21:04:47'),(618,1,'en','core/base/system','queue_connection','Queue Connection','2022-11-10 21:04:47','2022-11-10 21:04:47'),(619,1,'en','core/base/system','mbstring_ext','Mbstring Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(620,1,'en','core/base/system','openssl_ext','OpenSSL Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(621,1,'en','core/base/system','pdo_ext','PDO Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(622,1,'en','core/base/system','curl_ext','CURL Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(623,1,'en','core/base/system','exif_ext','Exif Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(624,1,'en','core/base/system','file_info_ext','File info Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(625,1,'en','core/base/system','tokenizer_ext','Tokenizer Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(626,1,'en','core/base/system','extra_stats','Extra Stats','2022-11-10 21:04:47','2022-11-10 21:04:47'),(627,1,'en','core/base/system','installed_packages','Installed packages and their version numbers','2022-11-10 21:04:47','2022-11-10 21:04:47'),(628,1,'en','core/base/system','extra_information','Extra Information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(629,1,'en','core/base/system','copy_report','Copy Report','2022-11-10 21:04:47','2022-11-10 21:04:47'),(630,1,'en','core/base/system','package_name','Package Name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(631,1,'en','core/base/system','dependency_name','Dependency Name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(632,1,'en','core/base/system','version','Version','2022-11-10 21:04:47','2022-11-10 21:04:47'),(633,1,'en','core/base/system','cms_version','CMS Version','2022-11-10 21:04:47','2022-11-10 21:04:47'),(634,1,'en','core/base/system','imagick_or_gd_ext','Imagick/GD Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(635,1,'en','core/base/system','updater','System Updater','2022-11-10 21:04:47','2022-11-10 21:04:47'),(636,1,'en','core/base/system','zip','Zip Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(637,1,'en','core/base/system','memory_limit','Memory limit','2022-11-10 21:04:47','2022-11-10 21:04:47'),(638,1,'en','core/base/system','max_execution_time','Max execution time (s)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(639,1,'en','core/base/system','php_version_warning','You are using an out of date PHP version (:version). Please upgrade PHP version on your server to >= 8.0.2 for better security and performance!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(640,1,'en','core/base/system','upgrade_php_version_required','You are using an unsupported PHP version (:version). You need to upgrade PHP version on your server to greater than or equal to 8.0.2 before upgrading to this version!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(641,1,'en','core/base/tables','id','ID','2022-11-10 21:04:47','2022-11-10 21:04:47'),(642,1,'en','core/base/tables','name','Name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(643,1,'en','core/base/tables','slug','Slug','2022-11-10 21:04:47','2022-11-10 21:04:47'),(644,1,'en','core/base/tables','title','Title','2022-11-10 21:04:47','2022-11-10 21:04:47'),(645,1,'en','core/base/tables','order_by','Order By','2022-11-10 21:04:47','2022-11-10 21:04:47'),(646,1,'en','core/base/tables','order','Order','2022-11-10 21:04:47','2022-11-10 21:04:47'),(647,1,'en','core/base/tables','status','Status','2022-11-10 21:04:47','2022-11-10 21:04:47'),(648,1,'en','core/base/tables','created_at','Created At','2022-11-10 21:04:47','2022-11-10 21:04:47'),(649,1,'en','core/base/tables','updated_at','Updated At','2022-11-10 21:04:47','2022-11-10 21:04:47'),(650,1,'en','core/base/tables','description','Description','2022-11-10 21:04:47','2022-11-10 21:04:47'),(651,1,'en','core/base/tables','operations','Operations','2022-11-10 21:04:47','2022-11-10 21:04:47'),(652,1,'en','core/base/tables','url','URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(653,1,'en','core/base/tables','author','Author','2022-11-10 21:04:47','2022-11-10 21:04:47'),(654,1,'en','core/base/tables','notes','Notes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(655,1,'en','core/base/tables','column','Column','2022-11-10 21:04:47','2022-11-10 21:04:47'),(656,1,'en','core/base/tables','origin','Origin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(657,1,'en','core/base/tables','after_change','After changes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(658,1,'en','core/base/tables','views','Views','2022-11-10 21:04:47','2022-11-10 21:04:47'),(659,1,'en','core/base/tables','browser','Browser','2022-11-10 21:04:47','2022-11-10 21:04:47'),(660,1,'en','core/base/tables','session','Session','2022-11-10 21:04:47','2022-11-10 21:04:47'),(661,1,'en','core/base/tables','activated','activated','2022-11-10 21:04:47','2022-11-10 21:04:47'),(662,1,'en','core/base/tables','deactivated','deactivated','2022-11-10 21:04:47','2022-11-10 21:04:47'),(663,1,'en','core/base/tables','is_featured','Is featured','2022-11-10 21:04:47','2022-11-10 21:04:47'),(664,1,'en','core/base/tables','edit','Edit','2022-11-10 21:04:47','2022-11-10 21:04:47'),(665,1,'en','core/base/tables','delete','Delete','2022-11-10 21:04:47','2022-11-10 21:04:47'),(666,1,'en','core/base/tables','restore','Restore','2022-11-10 21:04:47','2022-11-10 21:04:47'),(667,1,'en','core/base/tables','activate','Activate','2022-11-10 21:04:47','2022-11-10 21:04:47'),(668,1,'en','core/base/tables','deactivate','Deactivate','2022-11-10 21:04:47','2022-11-10 21:04:47'),(669,1,'en','core/base/tables','excel','Excel','2022-11-10 21:04:47','2022-11-10 21:04:47'),(670,1,'en','core/base/tables','export','Export','2022-11-10 21:04:47','2022-11-10 21:04:47'),(671,1,'en','core/base/tables','csv','CSV','2022-11-10 21:04:47','2022-11-10 21:04:47'),(672,1,'en','core/base/tables','pdf','PDF','2022-11-10 21:04:47','2022-11-10 21:04:47'),(673,1,'en','core/base/tables','print','Print','2022-11-10 21:04:47','2022-11-10 21:04:47'),(674,1,'en','core/base/tables','reset','Reset','2022-11-10 21:04:47','2022-11-10 21:04:47'),(675,1,'en','core/base/tables','reload','Reload','2022-11-10 21:04:47','2022-11-10 21:04:47'),(676,1,'en','core/base/tables','display','Display','2022-11-10 21:04:47','2022-11-10 21:04:47'),(677,1,'en','core/base/tables','all','All','2022-11-10 21:04:47','2022-11-10 21:04:47'),(678,1,'en','core/base/tables','add_new','Add New','2022-11-10 21:04:47','2022-11-10 21:04:47'),(679,1,'en','core/base/tables','action','Actions','2022-11-10 21:04:47','2022-11-10 21:04:47'),(680,1,'en','core/base/tables','delete_entry','Delete','2022-11-10 21:04:47','2022-11-10 21:04:47'),(681,1,'en','core/base/tables','view','View Detail','2022-11-10 21:04:47','2022-11-10 21:04:47'),(682,1,'en','core/base/tables','save','Save','2022-11-10 21:04:47','2022-11-10 21:04:47'),(683,1,'en','core/base/tables','show_from','Show from','2022-11-10 21:04:47','2022-11-10 21:04:47'),(684,1,'en','core/base/tables','to','to','2022-11-10 21:04:47','2022-11-10 21:04:47'),(685,1,'en','core/base/tables','in','in','2022-11-10 21:04:47','2022-11-10 21:04:47'),(686,1,'en','core/base/tables','records','records','2022-11-10 21:04:47','2022-11-10 21:04:47'),(687,1,'en','core/base/tables','no_data','No data to display','2022-11-10 21:04:47','2022-11-10 21:04:47'),(688,1,'en','core/base/tables','no_record','No record','2022-11-10 21:04:47','2022-11-10 21:04:47'),(689,1,'en','core/base/tables','confirm_delete','Confirm delete','2022-11-10 21:04:47','2022-11-10 21:04:47'),(690,1,'en','core/base/tables','confirm_delete_msg','Do you really want to delete this record?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(691,1,'en','core/base/tables','confirm_delete_many_msg','Do you really want to delete selected record(s)?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(692,1,'en','core/base/tables','cancel','Cancel','2022-11-10 21:04:47','2022-11-10 21:04:47'),(693,1,'en','core/base/tables','template','Template','2022-11-10 21:04:47','2022-11-10 21:04:47'),(694,1,'en','core/base/tables','email','Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(695,1,'en','core/base/tables','last_login','Last login','2022-11-10 21:04:47','2022-11-10 21:04:47'),(696,1,'en','core/base/tables','shortcode','Shortcode','2022-11-10 21:04:47','2022-11-10 21:04:47'),(697,1,'en','core/base/tables','image','Image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(698,1,'en','core/base/tables','bulk_changes','Bulk changes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(699,1,'en','core/base/tables','submit','Submit','2022-11-10 21:04:47','2022-11-10 21:04:47'),(700,1,'en','core/base/tables','please_select_record','Please select at least one record to perform this action!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(701,1,'en','core/base/tabs','detail','Detail','2022-11-10 21:04:47','2022-11-10 21:04:47'),(702,1,'en','core/base/tabs','file','Files','2022-11-10 21:04:47','2022-11-10 21:04:47'),(703,1,'en','core/base/tabs','record_note','Record Note','2022-11-10 21:04:47','2022-11-10 21:04:47'),(704,1,'en','core/base/tabs','revision','Revision History','2022-11-10 21:04:47','2022-11-10 21:04:47'),(705,1,'vi','core/base/base','yes','Có','2022-11-10 21:04:47','2022-11-10 21:04:47'),(706,1,'vi','core/base/base','no','Không','2022-11-10 21:04:47','2022-11-10 21:04:47'),(707,1,'vi','core/base/base','is_default','Mặc định?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(708,1,'vi','core/base/base','proc_close_disabled_error','Hàm proc_close() đã bị tắt. Vui lòng liên hệ nhà cung cấp hosting để mở hàm này. Hoặc có thể thêm vào .env: CAN_EXECUTE_COMMAND=false để tắt tính năng này.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(709,1,'vi','core/base/base','add_image','Thêm ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(710,1,'vi','core/base/base','change_image','Đổi ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(711,1,'vi','core/base/base','delete_image','Xóa ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(712,1,'vi','core/base/base','email_template.date_time','Ngày giờ hiện tại','2022-11-10 21:04:47','2022-11-10 21:04:47'),(713,1,'vi','core/base/base','email_template.date_year','Năm hiện tại','2022-11-10 21:04:47','2022-11-10 21:04:47'),(714,1,'vi','core/base/base','email_template.footer','Mẫu chân trang email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(715,1,'vi','core/base/base','email_template.header','Mẫu đầu trang email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(716,1,'vi','core/base/base','email_template.site_admin_email','Email quản trị viên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(717,1,'vi','core/base/base','email_template.site_logo','Logo của trang','2022-11-10 21:04:47','2022-11-10 21:04:47'),(718,1,'vi','core/base/base','email_template.site_title','Tiêu đề trang','2022-11-10 21:04:47','2022-11-10 21:04:47'),(719,1,'vi','core/base/base','email_template.site_url','URL trang','2022-11-10 21:04:47','2022-11-10 21:04:47'),(720,1,'vi','core/base/base','image','Hình ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(721,1,'vi','core/base/base','preview_image','Ảnh xem trước','2022-11-10 21:04:47','2022-11-10 21:04:47'),(722,1,'vi','core/base/base','select_image','Chọn ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(723,1,'vi','core/base/base','to_add_more_image','để thêm hình ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(724,1,'vi','core/base/base','using_button','Sử dụng nút','2022-11-10 21:04:47','2022-11-10 21:04:47'),(725,1,'vi','core/base/cache','cache_management','Quản lý bộ nhớ đệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(726,1,'vi','core/base/cache','cache_commands','Các lệnh xoá bộ nhớ đệm cơ bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(727,1,'vi','core/base/cache','commands.clear_cms_cache.title','Xóa tất cả bộ đệm hiện có của ứng dụng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(728,1,'vi','core/base/cache','commands.clear_cms_cache.description','Xóa các bộ nhớ đệm của ứng dụng: cơ sở dữ liệu, nội dung tĩnh... Chạy lệnh này khi bạn thử cập nhật dữ liệu nhưng giao diện không thay đổi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(729,1,'vi','core/base/cache','commands.clear_cms_cache.success_msg','Bộ đệm đã được xóa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(730,1,'vi','core/base/cache','commands.refresh_compiled_views.title','Làm mới bộ đệm giao diện','2022-11-10 21:04:47','2022-11-10 21:04:47'),(731,1,'vi','core/base/cache','commands.refresh_compiled_views.description','Làm mới bộ đệm giao diện giúp phần giao diện luôn mới nhất','2022-11-10 21:04:47','2022-11-10 21:04:47'),(732,1,'vi','core/base/cache','commands.refresh_compiled_views.success_msg','Bộ đệm giao diện đã được làm mới','2022-11-10 21:04:47','2022-11-10 21:04:47'),(733,1,'vi','core/base/cache','commands.clear_config_cache.title','Xóa bộ nhớ đệm của phần cấu hình','2022-11-10 21:04:47','2022-11-10 21:04:47'),(734,1,'vi','core/base/cache','commands.clear_config_cache.description','Bạn cần làm mới bộ đệm cấu hình khi bạn tạo ra sự thay đổi nào đó ở môi trường thành phẩm.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(735,1,'vi','core/base/cache','commands.clear_config_cache.success_msg','Bộ đệm cấu hình đã được xóa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(736,1,'vi','core/base/cache','commands.clear_route_cache.title','Xoá cache đường dẫn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(737,1,'vi','core/base/cache','commands.clear_route_cache.description','Cần thực hiện thao tác này khi thấy không xuất hiện đường dẫn mới.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(738,1,'vi','core/base/cache','commands.clear_route_cache.success_msg','Bộ đệm điều hướng đã bị xóa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(739,1,'vi','core/base/cache','commands.clear_log.description','Xoá lịch sử lỗi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(740,1,'vi','core/base/cache','commands.clear_log.success_msg','Lịch sử lỗi đã được làm sạch','2022-11-10 21:04:47','2022-11-10 21:04:47'),(741,1,'vi','core/base/cache','commands.clear_log.title','Xoá lịch sử lỗi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(742,1,'vi','core/base/enums','statuses.draft','Bản nháp','2022-11-10 21:04:47','2022-11-10 21:04:47'),(743,1,'vi','core/base/enums','statuses.pending','Đang chờ xử lý','2022-11-10 21:04:47','2022-11-10 21:04:47'),(744,1,'vi','core/base/enums','statuses.published','Đã xuất bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(745,1,'vi','core/base/errors','401_title','Bạn không có quyền truy cập trang này','2022-11-10 21:04:47','2022-11-10 21:04:47'),(746,1,'vi','core/base/errors','401_msg','<li>Bạn không được cấp quyền truy cập bởi quản trị viên.</li>\n	                <li>Bạn sử dụng sai loại tài khoản.</li>\n	                <li>Bạn không được cấp quyền để có thể truy cập trang này</li>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(747,1,'vi','core/base/errors','404_title','Không tìm thấy trang yêu cầu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(748,1,'vi','core/base/errors','404_msg','<li>Trang bạn yêu cầu không tồn tại.</li>\n	                <li>Liên kết bạn vừa nhấn không còn được sử dụng.</li>\n	                <li>Trang này có thể đã được chuyển sang vị trí khác.</li>\n	                <li>Có thể có lỗi xảy ra.</li>\n	                <li>Bạn không được cấp quyền để có thể truy cập trang này</li>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(749,1,'vi','core/base/errors','500_title','Không thể tải trang','2022-11-10 21:04:47','2022-11-10 21:04:47'),(750,1,'vi','core/base/errors','500_msg','<li>Trang bạn yêu cầu không tồn tại.</li>\n	                <li>Liên kết bạn vừa nhấn không còn được sử dụng.</li>\n	                <li>Trang này có thể đã được chuyển sang vị trí khác.</li>\n	                <li>Có thể có lỗi xảy ra.</li>\n	                <li>Bạn không được cấp quyền để có thể truy cập trang này</li>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(751,1,'vi','core/base/errors','reasons','Điều này có thể xảy ra vì nhiều lý do.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(752,1,'vi','core/base/errors','try_again','Vui lòng thử lại trong vài phút, hoặc quay trở lại trang chủ bằng cách <a href=\"http://cms.local/admin\"> nhấn vào đây </a>.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(753,1,'vi','core/base/errors','not_found','Không tìm thấy','2022-11-10 21:04:47','2022-11-10 21:04:47'),(754,1,'vi','core/base/forms','choose_image','Chọn ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(755,1,'vi','core/base/forms','actions','Tác vụ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(756,1,'vi','core/base/forms','save','Lưu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(757,1,'vi','core/base/forms','save_and_continue','Lưu & chỉnh sửa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(758,1,'vi','core/base/forms','image','Hình ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(759,1,'vi','core/base/forms','image_placeholder','Chèn đường dẫn hình ảnh hoặc nhấn nút để chọn hình','2022-11-10 21:04:47','2022-11-10 21:04:47'),(760,1,'vi','core/base/forms','create','Tạo mới','2022-11-10 21:04:47','2022-11-10 21:04:47'),(761,1,'vi','core/base/forms','edit','Sửa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(762,1,'vi','core/base/forms','permalink','Đường dẫn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(763,1,'vi','core/base/forms','ok','OK','2022-11-10 21:04:47','2022-11-10 21:04:47'),(764,1,'vi','core/base/forms','cancel','Hủy bỏ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(765,1,'vi','core/base/forms','character_remain','kí tự còn lại','2022-11-10 21:04:47','2022-11-10 21:04:47'),(766,1,'vi','core/base/forms','template','Template','2022-11-10 21:04:47','2022-11-10 21:04:47'),(767,1,'vi','core/base/forms','choose_file','Chọn tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(768,1,'vi','core/base/forms','file','Tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(769,1,'vi','core/base/forms','content','Nội dung','2022-11-10 21:04:47','2022-11-10 21:04:47'),(770,1,'vi','core/base/forms','description','Mô tả','2022-11-10 21:04:47','2022-11-10 21:04:47'),(771,1,'vi','core/base/forms','name','Tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(772,1,'vi','core/base/forms','name_placeholder','Nhập tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(773,1,'vi','core/base/forms','description_placeholder','Mô tả ngắn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(774,1,'vi','core/base/forms','parent','Cha','2022-11-10 21:04:47','2022-11-10 21:04:47'),(775,1,'vi','core/base/forms','icon','Biểu tượng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(776,1,'vi','core/base/forms','order_by','Sắp xếp','2022-11-10 21:04:47','2022-11-10 21:04:47'),(777,1,'vi','core/base/forms','order_by_placeholder','Sắp xếp','2022-11-10 21:04:47','2022-11-10 21:04:47'),(778,1,'vi','core/base/forms','slug','Slug','2022-11-10 21:04:47','2022-11-10 21:04:47'),(779,1,'vi','core/base/forms','is_featured','Nổi bật?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(780,1,'vi','core/base/forms','is_default','Mặc định?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(781,1,'vi','core/base/forms','icon_placeholder','Ví dụ: fa fa-home','2022-11-10 21:04:47','2022-11-10 21:04:47'),(782,1,'vi','core/base/forms','update','Cập nhật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(783,1,'vi','core/base/forms','publish','Xuất bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(784,1,'vi','core/base/forms','remove_image','Xoá ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(785,1,'vi','core/base/forms','add','Thêm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(786,1,'vi','core/base/forms','add_short_code','Thêm shortcode','2022-11-10 21:04:47','2022-11-10 21:04:47'),(787,1,'vi','core/base/forms','alias','Mã thay thế','2022-11-10 21:04:47','2022-11-10 21:04:47'),(788,1,'vi','core/base/forms','alias_placeholder','Mã thay thế','2022-11-10 21:04:47','2022-11-10 21:04:47'),(789,1,'vi','core/base/forms','basic_information','Thông tin cơ bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(790,1,'vi','core/base/forms','link','Liên kết','2022-11-10 21:04:47','2022-11-10 21:04:47'),(791,1,'vi','core/base/forms','order','Thứ tự','2022-11-10 21:04:47','2022-11-10 21:04:47'),(792,1,'vi','core/base/forms','short_code','Shortcode','2022-11-10 21:04:47','2022-11-10 21:04:47'),(793,1,'vi','core/base/forms','title','Tiêu đề','2022-11-10 21:04:47','2022-11-10 21:04:47'),(794,1,'vi','core/base/forms','value','Giá trị','2022-11-10 21:04:47','2022-11-10 21:04:47'),(795,1,'vi','core/base/forms','show_hide_editor','Ẩn/Hiện trình soạn thảo','2022-11-10 21:04:47','2022-11-10 21:04:47'),(796,1,'vi','core/base/forms','basic_info_title','Thông tin cơ bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(797,1,'vi','core/base/forms','remove_file','Xóa tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(798,1,'vi','core/base/layouts','platform_admin','Quản trị hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(799,1,'vi','core/base/layouts','dashboard','Bảng điều khiển','2022-11-10 21:04:47','2022-11-10 21:04:47'),(800,1,'vi','core/base/layouts','widgets','Tiện ích','2022-11-10 21:04:47','2022-11-10 21:04:47'),(801,1,'vi','core/base/layouts','plugins','Tiện ích mở rộng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(802,1,'vi','core/base/layouts','settings','Cài đặt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(803,1,'vi','core/base/layouts','setting_general','Cơ bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(804,1,'vi','core/base/layouts','system_information','Thông tin hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(805,1,'vi','core/base/layouts','theme','Giao diện','2022-11-10 21:04:47','2022-11-10 21:04:47'),(806,1,'vi','core/base/layouts','copyright','Bản quyền :year &copy; :company. Phiên bản: <span>:version</span>','2022-11-10 21:04:47','2022-11-10 21:04:47'),(807,1,'vi','core/base/layouts','profile','Thông tin cá nhân','2022-11-10 21:04:47','2022-11-10 21:04:47'),(808,1,'vi','core/base/layouts','logout','Đăng xuất','2022-11-10 21:04:47','2022-11-10 21:04:47'),(809,1,'vi','core/base/layouts','no_search_result','Không có kết quả tìm kiếm, hãy thử lại với từ khóa khác.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(810,1,'vi','core/base/layouts','home','Trang chủ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(811,1,'vi','core/base/layouts','search','Tìm kiếm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(812,1,'vi','core/base/layouts','add_new','Thêm mới','2022-11-10 21:04:47','2022-11-10 21:04:47'),(813,1,'vi','core/base/layouts','n_a','N/A','2022-11-10 21:04:47','2022-11-10 21:04:47'),(814,1,'vi','core/base/layouts','page_loaded_time','Trang tải xong trong','2022-11-10 21:04:47','2022-11-10 21:04:47'),(815,1,'vi','core/base/layouts','view_website','Xem trang ngoài','2022-11-10 21:04:47','2022-11-10 21:04:47'),(816,1,'vi','core/base/layouts','setting_email','Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(817,1,'vi','core/base/mail','send-fail','Gửi email không thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(818,1,'vi','core/base/notices','create_success_message','Tạo thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(819,1,'vi','core/base/notices','update_success_message','Cập nhật thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(820,1,'vi','core/base/notices','delete_success_message','Xóa thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(821,1,'vi','core/base/notices','success_header','Thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(822,1,'vi','core/base/notices','error_header','Lỗi!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(823,1,'vi','core/base/notices','no_select','Chọn ít nhất 1 trường để thực hiện hành động này!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(824,1,'vi','core/base/notices','processing_request','Hệ thống đang xử lý yêu cầu.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(825,1,'vi','core/base/notices','error','Lỗi!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(826,1,'vi','core/base/notices','success','Thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(827,1,'vi','core/base/notices','info','Thông tin!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(828,1,'vi','core/base/notices','enum.validate_message','Giá trị của :attribute không hợp lệ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(829,1,'vi','core/base/system','no_select','Hãy chọn ít nhất 1 trường để thực hiện hành động này!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(830,1,'vi','core/base/system','cannot_find_user','Không thể tải được thông tin người dùng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(831,1,'vi','core/base/system','supper_revoked','Quyền quản trị viên cao nhất đã được gỡ bỏ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(832,1,'vi','core/base/system','cannot_revoke_yourself','Không thể gỡ bỏ quyền quản trị cấp cao của chính bạn!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(833,1,'vi','core/base/system','cant_remove_supper','Bạn không có quyền xóa quản trị viên cấp cao','2022-11-10 21:04:47','2022-11-10 21:04:47'),(834,1,'vi','core/base/system','cant_find_user_with_email','Không thể tìm thấy người dùng với email này','2022-11-10 21:04:47','2022-11-10 21:04:47'),(835,1,'vi','core/base/system','supper_granted','Quyền quản trị cao nhất đã được gán','2022-11-10 21:04:47','2022-11-10 21:04:47'),(836,1,'vi','core/base/system','delete_log_success','Xóa tập tin log thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(837,1,'vi','core/base/system','get_member_success','Hiển thị danh sách thành viên thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(838,1,'vi','core/base/system','error_occur','Có lỗi dưới đây','2022-11-10 21:04:47','2022-11-10 21:04:47'),(839,1,'vi','core/base/system','role_and_permission','Phân quyền hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(840,1,'vi','core/base/system','role_and_permission_description','Quản lý những phân quyền trong hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(841,1,'vi','core/base/system','user.list_super','Danh sách quản trị viên cấp cao','2022-11-10 21:04:47','2022-11-10 21:04:47'),(842,1,'vi','core/base/system','user.username','Tên đăng nhập','2022-11-10 21:04:47','2022-11-10 21:04:47'),(843,1,'vi','core/base/system','user.email','Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(844,1,'vi','core/base/system','user.last_login','Đăng nhập lần cuối	','2022-11-10 21:04:47','2022-11-10 21:04:47'),(845,1,'vi','core/base/system','user.add_user','Thêm quản trị viên cấp cao','2022-11-10 21:04:47','2022-11-10 21:04:47'),(846,1,'vi','core/base/system','user.cancel','Hủy bỏ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(847,1,'vi','core/base/system','user.create','Thêm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(848,1,'vi','core/base/system','options.features','Kiểm soát truy cập các tính năng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(849,1,'vi','core/base/system','options.feature_description','Bật/tắt các tính năng.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(850,1,'vi','core/base/system','options.manage_super','Quản lý quản trị viên cấp cao','2022-11-10 21:04:47','2022-11-10 21:04:47'),(851,1,'vi','core/base/system','options.manage_super_description','Thêm/xóa quản trị viên cấp cao','2022-11-10 21:04:47','2022-11-10 21:04:47'),(852,1,'vi','core/base/system','options.info','Thông tin hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(853,1,'vi','core/base/system','options.info_description','Những thông tin về cấu hình hiện tại của hệ thống.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(854,1,'vi','core/base/system','info.title','Thông tin hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(855,1,'vi','core/base/system','info.cache','Bộ nhớ đệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(856,1,'vi','core/base/system','info.environment','Môi trường','2022-11-10 21:04:47','2022-11-10 21:04:47'),(857,1,'vi','core/base/system','info.locale','Ngôn ngữ hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(858,1,'vi','core/base/system','user_management','Quản lý thành viên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(859,1,'vi','core/base/system','user_management_description','Quản lý người dùng trong hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(860,1,'vi','core/base/system','app_size','Kích thước ứng dụng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(861,1,'vi','core/base/system','cache_dir_writable','Có thể ghi bộ nhớ đệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(862,1,'vi','core/base/system','cache_driver','Loại lưu trữ bộ nhớ đệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(863,1,'vi','core/base/system','copy_report','Sao chép báo cáo','2022-11-10 21:04:47','2022-11-10 21:04:47'),(864,1,'vi','core/base/system','curl_ext','CURL Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(865,1,'vi','core/base/system','database','Hệ thống dữ liệu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(866,1,'vi','core/base/system','debug_mode','Chế độ sửa lỗi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(867,1,'vi','core/base/system','dependency_name','Tên gói','2022-11-10 21:04:47','2022-11-10 21:04:47'),(868,1,'vi','core/base/system','exif_ext','Exif Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(869,1,'vi','core/base/system','extra_information','Thông tin mở rộng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(870,1,'vi','core/base/system','extra_stats','Thống kê thêm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(871,1,'vi','core/base/system','file_info_ext','File info Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(872,1,'vi','core/base/system','framework_version','Phiên bản framework','2022-11-10 21:04:47','2022-11-10 21:04:47'),(873,1,'vi','core/base/system','get_system_report','Lấy thông tin hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(874,1,'vi','core/base/system','installed_packages','Các gói đã cài đặt và phiên bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(875,1,'vi','core/base/system','mbstring_ext','Mbstring Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(876,1,'vi','core/base/system','openssl_ext','OpenSSL Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(877,1,'vi','core/base/system','package_name','Tên gói','2022-11-10 21:04:47','2022-11-10 21:04:47'),(878,1,'vi','core/base/system','pdo_ext','PDO Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(879,1,'vi','core/base/system','php_version','Phiên bản PHP','2022-11-10 21:04:47','2022-11-10 21:04:47'),(880,1,'vi','core/base/system','report_description','Vui lòng chia sẻ thông tin này nhằm mục đích điều tra nguyên nhân gây lỗi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(881,1,'vi','core/base/system','server_environment','Môi trường máy chủ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(882,1,'vi','core/base/system','server_os','Hệ điều hành của máy chủ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(883,1,'vi','core/base/system','server_software','Phần mềm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(884,1,'vi','core/base/system','session_driver','Loại lưu trữ phiên làm việc','2022-11-10 21:04:47','2022-11-10 21:04:47'),(885,1,'vi','core/base/system','ssl_installed','Đã cài đặt chứng chỉ SSL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(886,1,'vi','core/base/system','storage_dir_writable','Có thể lưu trữ dữ liệu tạm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(887,1,'vi','core/base/system','system_environment','Môi trường hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(888,1,'vi','core/base/system','timezone','Múi giờ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(889,1,'vi','core/base/system','tokenizer_ext','Tokenizer Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(890,1,'vi','core/base/system','version','Phiên bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(891,1,'vi','core/base/system','cms_version','Phiên bản CMS','2022-11-10 21:04:47','2022-11-10 21:04:47'),(892,1,'vi','core/base/system','queue_connection','Queue Connection','2022-11-10 21:04:47','2022-11-10 21:04:47'),(893,1,'vi','core/base/system','disabled_in_demo_mode','Bạn không thể thực hiện hành động này ở chế độ demo!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(894,1,'vi','core/base/system','imagick_or_gd_ext','Imagick/GD Ext','2022-11-10 21:04:47','2022-11-10 21:04:47'),(895,1,'vi','core/base/system','php_version_error','Phiên bản PHP phải >= :version','2022-11-10 21:04:47','2022-11-10 21:04:47'),(896,1,'vi','core/base/system','updater','Nâng cấp hệ thống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(897,1,'vi','core/base/tables','id','ID','2022-11-10 21:04:47','2022-11-10 21:04:47'),(898,1,'vi','core/base/tables','name','Tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(899,1,'vi','core/base/tables','order_by','Thứ tự','2022-11-10 21:04:47','2022-11-10 21:04:47'),(900,1,'vi','core/base/tables','status','Trạng thái','2022-11-10 21:04:47','2022-11-10 21:04:47'),(901,1,'vi','core/base/tables','created_at','Ngày tạo','2022-11-10 21:04:47','2022-11-10 21:04:47'),(902,1,'vi','core/base/tables','updated_at','Ngày cập nhật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(903,1,'vi','core/base/tables','operations','Tác vụ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(904,1,'vi','core/base/tables','url','URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(905,1,'vi','core/base/tables','author','Người tạo','2022-11-10 21:04:47','2022-11-10 21:04:47'),(906,1,'vi','core/base/tables','column','Cột','2022-11-10 21:04:47','2022-11-10 21:04:47'),(907,1,'vi','core/base/tables','origin','Bản cũ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(908,1,'vi','core/base/tables','after_change','Sau khi thay đổi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(909,1,'vi','core/base/tables','notes','Ghi chú','2022-11-10 21:04:47','2022-11-10 21:04:47'),(910,1,'vi','core/base/tables','activated','kích hoạt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(911,1,'vi','core/base/tables','browser','Trình duyệt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(912,1,'vi','core/base/tables','deactivated','hủy kích hoạt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(913,1,'vi','core/base/tables','description','Mô tả','2022-11-10 21:04:47','2022-11-10 21:04:47'),(914,1,'vi','core/base/tables','session','Phiên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(915,1,'vi','core/base/tables','views','Lượt xem','2022-11-10 21:04:47','2022-11-10 21:04:47'),(916,1,'vi','core/base/tables','restore','Khôi phục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(917,1,'vi','core/base/tables','edit','Sửa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(918,1,'vi','core/base/tables','delete','Xóa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(919,1,'vi','core/base/tables','action','Hành động','2022-11-10 21:04:47','2022-11-10 21:04:47'),(920,1,'vi','core/base/tables','activate','Kích hoạt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(921,1,'vi','core/base/tables','add_new','Thêm mới','2022-11-10 21:04:47','2022-11-10 21:04:47'),(922,1,'vi','core/base/tables','all','Tất cả','2022-11-10 21:04:47','2022-11-10 21:04:47'),(923,1,'vi','core/base/tables','cancel','Hủy bỏ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(924,1,'vi','core/base/tables','confirm_delete','Xác nhận xóa','2022-11-10 21:04:47','2022-11-10 21:04:47'),(925,1,'vi','core/base/tables','confirm_delete_msg','Bạn có chắc chắn muốn xóa bản ghi này?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(926,1,'vi','core/base/tables','csv','CSV','2022-11-10 21:04:47','2022-11-10 21:04:47'),(927,1,'vi','core/base/tables','deactivate','Hủy kích hoạt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(928,1,'vi','core/base/tables','delete_entry','Xóa bản ghi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(929,1,'vi','core/base/tables','display','Hiển thị','2022-11-10 21:04:47','2022-11-10 21:04:47'),(930,1,'vi','core/base/tables','excel','Excel','2022-11-10 21:04:47','2022-11-10 21:04:47'),(931,1,'vi','core/base/tables','export','Xuất bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(932,1,'vi','core/base/tables','in','trong tổng số','2022-11-10 21:04:47','2022-11-10 21:04:47'),(933,1,'vi','core/base/tables','no_data','Không có dữ liệu để hiển thị','2022-11-10 21:04:47','2022-11-10 21:04:47'),(934,1,'vi','core/base/tables','no_record','Không có dữ liệu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(935,1,'vi','core/base/tables','pdf','PDF','2022-11-10 21:04:47','2022-11-10 21:04:47'),(936,1,'vi','core/base/tables','print','In','2022-11-10 21:04:47','2022-11-10 21:04:47'),(937,1,'vi','core/base/tables','records','bản ghi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(938,1,'vi','core/base/tables','reload','Tải lại','2022-11-10 21:04:47','2022-11-10 21:04:47'),(939,1,'vi','core/base/tables','reset','Làm mới','2022-11-10 21:04:47','2022-11-10 21:04:47'),(940,1,'vi','core/base/tables','save','Lưu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(941,1,'vi','core/base/tables','show_from','Hiển thị từ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(942,1,'vi','core/base/tables','template','Giao diện','2022-11-10 21:04:47','2022-11-10 21:04:47'),(943,1,'vi','core/base/tables','to','đến','2022-11-10 21:04:47','2022-11-10 21:04:47'),(944,1,'vi','core/base/tables','view','Xem chi tiết','2022-11-10 21:04:47','2022-11-10 21:04:47'),(945,1,'vi','core/base/tables','email','Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(946,1,'vi','core/base/tables','image','Hình ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(947,1,'vi','core/base/tables','is_featured','Nổi bật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(948,1,'vi','core/base/tables','last_login','Lần cuối đăng nhập','2022-11-10 21:04:47','2022-11-10 21:04:47'),(949,1,'vi','core/base/tables','order','Thứ tự','2022-11-10 21:04:47','2022-11-10 21:04:47'),(950,1,'vi','core/base/tables','shortcode','Shortcode','2022-11-10 21:04:47','2022-11-10 21:04:47'),(951,1,'vi','core/base/tables','slug','Slug','2022-11-10 21:04:47','2022-11-10 21:04:47'),(952,1,'vi','core/base/tables','title','Tiêu đề','2022-11-10 21:04:47','2022-11-10 21:04:47'),(953,1,'vi','core/base/tables','bulk_changes','Thay đổi hàng loạt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(954,1,'vi','core/base/tables','confirm_delete_many_msg','Bạn có chắc chắn muốn xóa những bản ghi này?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(955,1,'vi','core/base/tables','submit','Hoàn tất','2022-11-10 21:04:47','2022-11-10 21:04:47'),(956,1,'vi','core/base/tables','please_select_record','Vui lòng chọn ít nhất 1 bản ghi để thực hiện hành động này!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(957,1,'vi','core/base/tabs','detail','Chi tiết','2022-11-10 21:04:47','2022-11-10 21:04:47'),(958,1,'vi','core/base/tabs','file','Tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(959,1,'vi','core/base/tabs','record_note','Ghi chú','2022-11-10 21:04:47','2022-11-10 21:04:47'),(960,1,'vi','core/base/tabs','revision','Lịch sử thay đổi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(961,1,'en','core/dashboard/dashboard','update_position_success','Update widget position successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(962,1,'en','core/dashboard/dashboard','hide_success','Update widget successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(963,1,'en','core/dashboard/dashboard','confirm_hide','Are you sure?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(964,1,'en','core/dashboard/dashboard','hide_message','Do you really want to hide this widget? It will be disappear on Dashboard!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(965,1,'en','core/dashboard/dashboard','confirm_hide_btn','Yes, hide this widget','2022-11-10 21:04:47','2022-11-10 21:04:47'),(966,1,'en','core/dashboard/dashboard','cancel_hide_btn','Cancel','2022-11-10 21:04:47','2022-11-10 21:04:47'),(967,1,'en','core/dashboard/dashboard','collapse_expand','Collapse/Expand','2022-11-10 21:04:47','2022-11-10 21:04:47'),(968,1,'en','core/dashboard/dashboard','hide','Hide','2022-11-10 21:04:47','2022-11-10 21:04:47'),(969,1,'en','core/dashboard/dashboard','reload','Reload','2022-11-10 21:04:47','2022-11-10 21:04:47'),(970,1,'en','core/dashboard/dashboard','save_setting_success','Save widget settings successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(971,1,'en','core/dashboard/dashboard','widget_not_exists','Widget is not exits!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(972,1,'en','core/dashboard/dashboard','manage_widgets','Manage Widgets','2022-11-10 21:04:47','2022-11-10 21:04:47'),(973,1,'en','core/dashboard/dashboard','fullscreen','Full screen','2022-11-10 21:04:47','2022-11-10 21:04:47'),(974,1,'en','core/dashboard/dashboard','title','Dashboard','2022-11-10 21:04:47','2022-11-10 21:04:47'),(975,1,'en','core/dashboard/dashboard','predefined_ranges.today','Today','2022-11-10 21:04:47','2022-11-10 21:04:47'),(976,1,'en','core/dashboard/dashboard','predefined_ranges.yesterday','Yesterday','2022-11-10 21:04:47','2022-11-10 21:04:47'),(977,1,'en','core/dashboard/dashboard','predefined_ranges.this_week','This Week','2022-11-10 21:04:47','2022-11-10 21:04:47'),(978,1,'en','core/dashboard/dashboard','predefined_ranges.last_7_days','Last 7 Days','2022-11-10 21:04:47','2022-11-10 21:04:47'),(979,1,'en','core/dashboard/dashboard','predefined_ranges.this_month','This Month','2022-11-10 21:04:47','2022-11-10 21:04:47'),(980,1,'en','core/dashboard/dashboard','predefined_ranges.last_30_days','Last 30 Days','2022-11-10 21:04:47','2022-11-10 21:04:47'),(981,1,'en','core/dashboard/dashboard','predefined_ranges.this_year','This Year','2022-11-10 21:04:47','2022-11-10 21:04:47'),(982,1,'vi','core/dashboard/dashboard','cancel_hide_btn','Hủy bỏ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(983,1,'vi','core/dashboard/dashboard','collapse_expand','Mở rộng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(984,1,'vi','core/dashboard/dashboard','confirm_hide','Bạn có chắc?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(985,1,'vi','core/dashboard/dashboard','confirm_hide_btn','Vâng, ẩn tiện ích này','2022-11-10 21:04:47','2022-11-10 21:04:47'),(986,1,'vi','core/dashboard/dashboard','hide','Ẩn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(987,1,'vi','core/dashboard/dashboard','hide_message','Bạn có chắc chắn muốn ẩn tiện ích này? Nó sẽ không được hiển thị trên trang chủ nữa!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(988,1,'vi','core/dashboard/dashboard','hide_success','Ẩn tiện ích thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(989,1,'vi','core/dashboard/dashboard','manage_widgets','Quản lý tiện ích','2022-11-10 21:04:47','2022-11-10 21:04:47'),(990,1,'vi','core/dashboard/dashboard','reload','Làm mới','2022-11-10 21:04:47','2022-11-10 21:04:47'),(991,1,'vi','core/dashboard/dashboard','save_setting_success','Lưu tiện ích thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(992,1,'vi','core/dashboard/dashboard','update_position_success','Cập nhật vị trí tiện ích thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(993,1,'vi','core/dashboard/dashboard','widget_not_exists','Tiện ích này không tồn tại!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(994,1,'vi','core/dashboard/dashboard','fullscreen','Toàn màn hình','2022-11-10 21:04:47','2022-11-10 21:04:47'),(995,1,'vi','core/dashboard/dashboard','title','Trang quản trị','2022-11-10 21:04:47','2022-11-10 21:04:47'),(996,1,'en','core/media/media','filter','Filter','2022-11-10 21:04:47','2022-11-10 21:04:47'),(997,1,'en','core/media/media','everything','Everything','2022-11-10 21:04:47','2022-11-10 21:04:47'),(998,1,'en','core/media/media','image','Image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(999,1,'en','core/media/media','video','Video','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1000,1,'en','core/media/media','document','Document','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1001,1,'en','core/media/media','view_in','View in','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1002,1,'en','core/media/media','all_media','All media','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1003,1,'en','core/media/media','trash','Trash','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1004,1,'en','core/media/media','recent','Recent','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1005,1,'en','core/media/media','favorites','Favorites','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1006,1,'en','core/media/media','upload','Upload','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1007,1,'en','core/media/media','create_folder','Create folder','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1008,1,'en','core/media/media','refresh','Refresh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1009,1,'en','core/media/media','empty_trash','Empty trash','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1010,1,'en','core/media/media','search_file_and_folder','Search in current folder','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1011,1,'en','core/media/media','sort','Sort','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1012,1,'en','core/media/media','file_name_asc','File name - ASC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1013,1,'en','core/media/media','file_name_desc','File name - DESC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1014,1,'en','core/media/media','uploaded_date_asc','Uploaded date - ASC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1015,1,'en','core/media/media','uploaded_date_desc','Uploaded date - DESC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1016,1,'en','core/media/media','size_asc','Size - ASC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1017,1,'en','core/media/media','size_desc','Size - DESC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1018,1,'en','core/media/media','actions','Actions','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1019,1,'en','core/media/media','nothing_is_selected','Nothing is selected','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1020,1,'en','core/media/media','insert','Insert','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1021,1,'en','core/media/media','folder_name','Folder name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1022,1,'en','core/media/media','create','Create','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1023,1,'en','core/media/media','rename','Rename','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1024,1,'en','core/media/media','close','Close','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1025,1,'en','core/media/media','save_changes','Save changes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1026,1,'en','core/media/media','move_to_trash','Move items to trash','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1027,1,'en','core/media/media','confirm_trash','Are you sure you want to move these items to trash?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1028,1,'en','core/media/media','confirm','Confirm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1029,1,'en','core/media/media','confirm_delete','Delete item(s)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1030,1,'en','core/media/media','confirm_delete_description','Your request cannot rollback. Are you sure you wanna delete these items?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1031,1,'en','core/media/media','empty_trash_title','Empty trash','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1032,1,'en','core/media/media','empty_trash_description','Your request cannot rollback. Are you sure you wanna remove all items in trash?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1033,1,'en','core/media/media','up_level','Up one level','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1034,1,'en','core/media/media','upload_progress','Upload progress','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1035,1,'en','core/media/media','folder_created','Folder is created successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1036,1,'en','core/media/media','gallery','Media gallery','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1037,1,'en','core/media/media','trash_error','Error when delete selected item(s)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1038,1,'en','core/media/media','trash_success','Moved selected item(s) to trash successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1039,1,'en','core/media/media','restore_error','Error when restore selected item(s)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1040,1,'en','core/media/media','restore_success','Restore selected item(s) successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1041,1,'en','core/media/media','copy_success','Copied selected item(s) successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1042,1,'en','core/media/media','delete_success','Deleted selected item(s) successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1043,1,'en','core/media/media','favorite_success','Favorite selected item(s) successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1044,1,'en','core/media/media','remove_favorite_success','Remove selected item(s) from favorites successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1045,1,'en','core/media/media','rename_error','Error when rename item(s)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1046,1,'en','core/media/media','rename_success','Rename selected item(s) successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1047,1,'en','core/media/media','empty_trash_success','Empty trash successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1048,1,'en','core/media/media','invalid_action','Invalid action!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1049,1,'en','core/media/media','file_not_exists','File is not exists!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1050,1,'en','core/media/media','download_file_error','Error when downloading files!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1051,1,'en','core/media/media','missing_zip_archive_extension','Please enable ZipArchive extension to download file!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1052,1,'en','core/media/media','can_not_download_file','Can not download this file!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1053,1,'en','core/media/media','invalid_request','Invalid request!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1054,1,'en','core/media/media','add_success','Add item successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1055,1,'en','core/media/media','file_too_big','File too big. Max file upload is :size bytes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1056,1,'en','core/media/media','file_too_big_readable_size','File too big. Max file upload is :size.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1057,1,'en','core/media/media','can_not_detect_file_type','File type is not allowed or can not detect file type!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1058,1,'en','core/media/media','upload_failed','The file is NOT uploaded completely. The server allows max upload file size is :size . Please check your file size OR try to upload again in case of having network errors','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1059,1,'en','core/media/media','menu_name','Media','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1060,1,'en','core/media/media','add','Add media','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1061,1,'en','core/media/media','javascript.name','Name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1062,1,'en','core/media/media','javascript.url','URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1063,1,'en','core/media/media','javascript.full_url','Full URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1064,1,'en','core/media/media','javascript.size','Size','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1065,1,'en','core/media/media','javascript.mime_type','Type','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1066,1,'en','core/media/media','javascript.created_at','Uploaded at','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1067,1,'en','core/media/media','javascript.updated_at','Modified at','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1068,1,'en','core/media/media','javascript.nothing_selected','Nothing is selected','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1069,1,'en','core/media/media','javascript.visit_link','Open link','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1070,1,'en','core/media/media','javascript.no_item.all_media.icon','fas fa-cloud-upload-alt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1071,1,'en','core/media/media','javascript.no_item.all_media.title','Drop files and folders here','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1072,1,'en','core/media/media','javascript.no_item.all_media.message','Or use the upload button above','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1073,1,'en','core/media/media','javascript.no_item.trash.icon','fas fa-trash-alt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1074,1,'en','core/media/media','javascript.no_item.trash.title','There is nothing in your trash currently','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1075,1,'en','core/media/media','javascript.no_item.trash.message','Delete files to move them to trash automatically. Delete files from trash to remove them permanently','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1076,1,'en','core/media/media','javascript.no_item.favorites.icon','fas fa-star','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1077,1,'en','core/media/media','javascript.no_item.favorites.title','You have not added anything to your favorites yet','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1078,1,'en','core/media/media','javascript.no_item.favorites.message','Add files to favorites to easily find them later','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1079,1,'en','core/media/media','javascript.no_item.recent.icon','far fa-clock','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1080,1,'en','core/media/media','javascript.no_item.recent.title','You did not opened anything yet','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1081,1,'en','core/media/media','javascript.no_item.recent.message','All recent files that you opened will be appeared here','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1082,1,'en','core/media/media','javascript.no_item.default.icon','fas fa-sync','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1083,1,'en','core/media/media','javascript.no_item.default.title','No items','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1084,1,'en','core/media/media','javascript.no_item.default.message','This directory has no item','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1085,1,'en','core/media/media','javascript.clipboard.success','These file links has been copied to clipboard','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1086,1,'en','core/media/media','javascript.message.error_header','Error','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1087,1,'en','core/media/media','javascript.message.success_header','Success','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1088,1,'en','core/media/media','javascript.download.error','No files selected or cannot download these files','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1089,1,'en','core/media/media','javascript.actions_list.basic.preview','Preview','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1090,1,'en','core/media/media','javascript.actions_list.file.copy_link','Copy link','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1091,1,'en','core/media/media','javascript.actions_list.file.rename','Rename','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1092,1,'en','core/media/media','javascript.actions_list.file.make_copy','Make a copy','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1093,1,'en','core/media/media','javascript.actions_list.user.favorite','Add to favorite','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1094,1,'en','core/media/media','javascript.actions_list.user.remove_favorite','Remove favorite','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1095,1,'en','core/media/media','javascript.actions_list.other.download','Download','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1096,1,'en','core/media/media','javascript.actions_list.other.trash','Move to trash','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1097,1,'en','core/media/media','javascript.actions_list.other.delete','Delete permanently','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1098,1,'en','core/media/media','javascript.actions_list.other.restore','Restore','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1099,1,'en','core/media/media','javascript.change_image','Change image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1100,1,'en','core/media/media','javascript.delete_image','Delete image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1101,1,'en','core/media/media','javascript.choose_image','Choose image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1102,1,'en','core/media/media','javascript.preview_image','Preview image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1103,1,'en','core/media/media','name_invalid','The folder name has invalid character(s).','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1104,1,'en','core/media/media','url_invalid','Please provide a valid URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1105,1,'en','core/media/media','path_invalid','Please provide a valid path','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1106,1,'en','core/media/media','download_link','Download','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1107,1,'en','core/media/media','url','URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1108,1,'en','core/media/media','download_explain','Enter one URL per line.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1109,1,'en','core/media/media','downloading','Downloading...','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1110,1,'vi','core/media/media','filter','Lọc','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1111,1,'vi','core/media/media','everything','Tất cả','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1112,1,'vi','core/media/media','image','Hình ảnh','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1113,1,'vi','core/media/media','video','Phim','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1114,1,'vi','core/media/media','document','Tài liệu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1115,1,'vi','core/media/media','view_in','Chế độ xem','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1116,1,'vi','core/media/media','all_media','Tất cả tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1117,1,'vi','core/media/media','trash','Thùng rác','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1118,1,'vi','core/media/media','recent','Gần đây','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1119,1,'vi','core/media/media','favorites','Được gắn dấu sao','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1120,1,'vi','core/media/media','upload','Tải lên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1121,1,'vi','core/media/media','create_folder','Tạo thư mục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1122,1,'vi','core/media/media','refresh','Làm mới','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1123,1,'vi','core/media/media','empty_trash','Dọn thùng rác','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1124,1,'vi','core/media/media','search_file_and_folder','Tìm kiếm tập tin và thư mục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1125,1,'vi','core/media/media','sort','Sắp xếp','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1126,1,'vi','core/media/media','file_name_asc','Tên tập tin - ASC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1127,1,'vi','core/media/media','file_name_desc','Tên tập tin - DESC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1128,1,'vi','core/media/media','uploaded_date_asc','Ngày tải lên - ASC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1129,1,'vi','core/media/media','uploaded_date_desc','Ngày tải lên - DESC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1130,1,'vi','core/media/media','size_asc','Kích thước - ASC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1131,1,'vi','core/media/media','size_desc','Kích thước - DESC','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1132,1,'vi','core/media/media','actions','Hành động','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1133,1,'vi','core/media/media','nothing_is_selected','Không có tập tin nào được chọn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1134,1,'vi','core/media/media','insert','Chèn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1135,1,'vi','core/media/media','folder_name','Tên thư mục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1136,1,'vi','core/media/media','create','Tạo','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1137,1,'vi','core/media/media','rename','Đổi tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1138,1,'vi','core/media/media','close','Đóng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1139,1,'vi','core/media/media','save_changes','Lưu thay đổi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1140,1,'vi','core/media/media','move_to_trash','Đưa vào thùng rác','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1141,1,'vi','core/media/media','confirm_trash','Bạn có chắc chắn muốn bỏ những tập tin này vào thùng rác?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1142,1,'vi','core/media/media','confirm','Xác nhận','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1143,1,'vi','core/media/media','confirm_delete','Xóa tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1144,1,'vi','core/media/media','confirm_delete_description','Hành động này không thể khôi phục. Bạn có chắc chắn muốn xóa các tập tin này?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1145,1,'vi','core/media/media','empty_trash_title','Dọn sạch thùng rác','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1146,1,'vi','core/media/media','empty_trash_description','Hành động này không thể khôi phục. Bạn có chắc chắn muốn dọn sạch thùng rác?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1147,1,'vi','core/media/media','up_level','Quay lại một cấp','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1148,1,'vi','core/media/media','upload_progress','Tiến trình tải lên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1149,1,'vi','core/media/media','folder_created','Tạo thư mục thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1150,1,'vi','core/media/media','gallery','Thư viện tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1151,1,'vi','core/media/media','trash_error','Có lỗi khi xóa tập tin/thư mục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1152,1,'vi','core/media/media','trash_success','Xóa tập tin/thư mục thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1153,1,'vi','core/media/media','restore_error','Có lỗi trong quá trình khôi phục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1154,1,'vi','core/media/media','restore_success','Khôi phục thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1155,1,'vi','core/media/media','copy_success','Sao chép thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1156,1,'vi','core/media/media','delete_success','Xóa thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1157,1,'vi','core/media/media','favorite_success','Thêm dấu sao thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1158,1,'vi','core/media/media','remove_favorite_success','Bỏ dấu sao thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1159,1,'vi','core/media/media','rename_error','Có lỗi trong quá trình đổi tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1160,1,'vi','core/media/media','rename_success','Đổi tên thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1161,1,'vi','core/media/media','invalid_action','Hành động không hợp lệ!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1162,1,'vi','core/media/media','file_not_exists','Tập tin không tồn tại!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1163,1,'vi','core/media/media','download_file_error','Có lỗi trong quá trình tải xuống tập tin!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1164,1,'vi','core/media/media','missing_zip_archive_extension','Hãy bật ZipArchive extension để tải tập tin!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1165,1,'vi','core/media/media','can_not_download_file','Không thể tải tập tin!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1166,1,'vi','core/media/media','invalid_request','Yêu cầu không hợp lệ!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1167,1,'vi','core/media/media','add_success','Thêm thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1168,1,'vi','core/media/media','file_too_big','Tập tin quá lớn. Giới hạn tải lên là :size bytes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1169,1,'vi','core/media/media','can_not_detect_file_type','Loại tập tin không hợp lệ hoặc không thể xác định loại tập tin!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1170,1,'vi','core/media/media','upload_failed','The file is NOT uploaded completely. The server allows max upload file size is :size . Please check your file size OR try to upload again in case of having network errors','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1171,1,'vi','core/media/media','menu_name','Quản lý tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1172,1,'vi','core/media/media','add','Thêm tập tin','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1173,1,'vi','core/media/media','javascript.name','Tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1174,1,'vi','core/media/media','javascript.url','Đường dẫn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1175,1,'vi','core/media/media','javascript.full_url','Đường dẫn tuyệt đối','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1176,1,'vi','core/media/media','javascript.size','Kích thước','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1177,1,'vi','core/media/media','javascript.mime_type','Loại','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1178,1,'vi','core/media/media','javascript.created_at','Được tải lên lúc','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1179,1,'vi','core/media/media','javascript.updated_at','Được chỉnh sửa lúc','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1180,1,'vi','core/media/media','javascript.nothing_selected','Bạn chưa chọn tập tin nào','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1181,1,'vi','core/media/media','javascript.visit_link','Mở liên kết','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1182,1,'vi','core/media/media','javascript.no_item.all_media.icon','fas fa-cloud-upload-alt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1183,1,'vi','core/media/media','javascript.no_item.all_media.title','Bạn có thể kéo thả tập tin vào đây để tải lên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1184,1,'vi','core/media/media','javascript.no_item.all_media.message','Hoặc có thể bấm nút Tải lên ở phía trên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1185,1,'vi','core/media/media','javascript.no_item.trash.icon','fas fa-trash-alt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1186,1,'vi','core/media/media','javascript.no_item.trash.title','Hiện tại không có tập tin nào trong thùng rác','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1187,1,'vi','core/media/media','javascript.no_item.trash.message','Xóa tập tin sẽ đem tập tin lưu vào thùng rác. Xóa tập tin trong thùng rác sẽ xóa vĩnh viễn.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1188,1,'vi','core/media/media','javascript.no_item.favorites.icon','fas fa-star','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1189,1,'vi','core/media/media','javascript.no_item.favorites.title','Bạn chưa đặt tập tin nào vào mục yêu thích','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1190,1,'vi','core/media/media','javascript.no_item.favorites.message','Thêm tập tin vào mục yêu thích để tìm kiếm chúng dễ dàng sau này.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1191,1,'vi','core/media/media','javascript.no_item.recent.icon','far fa-clock','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1192,1,'vi','core/media/media','javascript.no_item.recent.title','Bạn chưa mở tập tin nào.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1193,1,'vi','core/media/media','javascript.no_item.recent.message','Mục này hiển thị các tập tin bạn đã xem gần đây.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1194,1,'vi','core/media/media','javascript.no_item.default.icon','fas fa-sync','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1195,1,'vi','core/media/media','javascript.no_item.default.title','Thư mục trống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1196,1,'vi','core/media/media','javascript.no_item.default.message','Thư mục này chưa có tập tin nào','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1197,1,'vi','core/media/media','javascript.clipboard.success','Đường dẫn của các tập tin đã được sao chép vào clipboard','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1198,1,'vi','core/media/media','javascript.message.error_header','Lỗi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1199,1,'vi','core/media/media','javascript.message.success_header','Thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1200,1,'vi','core/media/media','javascript.download.error','Bạn chưa chọn tập tin nào hoặc tập tin này không cho phép tải về','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1201,1,'vi','core/media/media','javascript.actions_list.basic.preview','Xem trước','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1202,1,'vi','core/media/media','javascript.actions_list.file.copy_link','Sao chép đường dẫn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1203,1,'vi','core/media/media','javascript.actions_list.file.rename','Đổi tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1204,1,'vi','core/media/media','javascript.actions_list.file.make_copy','Nhân bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1205,1,'vi','core/media/media','javascript.actions_list.user.favorite','Yêu thích','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1206,1,'vi','core/media/media','javascript.actions_list.user.remove_favorite','Xóa khỏi mục yêu thích','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1207,1,'vi','core/media/media','javascript.actions_list.other.download','Tải xuống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1208,1,'vi','core/media/media','javascript.actions_list.other.trash','Chuyển vào thùng rác','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1209,1,'vi','core/media/media','javascript.actions_list.other.delete','Xóa hoàn toàn','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1210,1,'vi','core/media/media','javascript.actions_list.other.restore','Khôi phục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1211,1,'vi','core/media/media','empty_trash_success','Dọn sạch thùng rác thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1212,1,'vi','core/media/media','name_invalid','Tên thư mục chứa ký tự không hợp lệ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1213,1,'vi','core/media/media','path_invalid','Vui lòng cung cấp 1 đường dẫn hợp lệ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1214,1,'vi','core/media/media','url_invalid','Vui lòng cung cấp 1 đường dẫn hợp lệ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1215,1,'vi','core/media/media','download_explain','Mỗi URL trên 1 dòng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1216,1,'vi','core/media/media','download_link','Tải xuống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1217,1,'vi','core/media/media','downloading','Đang tải xuống','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1218,1,'en','core/setting/setting','title','Settings','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1219,1,'en','core/setting/setting','email_setting_title','Email settings','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1220,1,'en','core/setting/setting','general.theme','Theme','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1221,1,'en','core/setting/setting','general.description','Setting site information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1222,1,'en','core/setting/setting','general.title','General','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1223,1,'en','core/setting/setting','general.general_block','General Information','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1224,1,'en','core/setting/setting','general.rich_editor','Rich Editor','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1225,1,'en','core/setting/setting','general.site_title','Site title','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1226,1,'en','core/setting/setting','general.admin_email','Admin Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1227,1,'en','core/setting/setting','general.seo_block','SEO Configuration','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1228,1,'en','core/setting/setting','general.seo_title','SEO Title','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1229,1,'en','core/setting/setting','general.seo_description','SEO Description','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1230,1,'en','core/setting/setting','general.webmaster_tools_block','Google Webmaster Tools','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1231,1,'en','core/setting/setting','general.placeholder.site_title','Site Title (maximum 120 characters)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1232,1,'en','core/setting/setting','general.placeholder.admin_email','Admin Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1233,1,'en','core/setting/setting','general.placeholder.seo_title','SEO Title (maximum 120 characters)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1234,1,'en','core/setting/setting','general.placeholder.seo_description','SEO Description (maximum 120 characters)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1235,1,'en','core/setting/setting','general.placeholder.google_analytics','Google Analytics','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1236,1,'en','core/setting/setting','general.cache_admin_menu','Cache admin menu?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1237,1,'en','core/setting/setting','general.enable_send_error_reporting_via_email','Enable to send error reporting via email?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1238,1,'en','core/setting/setting','general.time_zone','Timezone','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1239,1,'en','core/setting/setting','general.default_admin_theme','Default admin theme','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1240,1,'en','core/setting/setting','general.enable_change_admin_theme','Enable change admin theme?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1241,1,'en','core/setting/setting','general.enable','Enable','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1242,1,'en','core/setting/setting','general.disable','Disable','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1243,1,'en','core/setting/setting','general.enable_cache','Enable cache?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1244,1,'en','core/setting/setting','general.disable_cache_in_the_admin_panel','Disable cache in the admin panel?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1245,1,'en','core/setting/setting','general.cache_time','Cache time (minutes)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1246,1,'en','core/setting/setting','general.enable_cache_site_map','Enable cache site map?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1247,1,'en','core/setting/setting','general.cache_time_site_map','Cache Time Site map (minutes)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1248,1,'en','core/setting/setting','general.admin_logo','Admin logo','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1249,1,'en','core/setting/setting','general.admin_favicon','Admin favicon','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1250,1,'en','core/setting/setting','general.admin_title','Admin title','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1251,1,'en','core/setting/setting','general.admin_title_placeholder','Title show to tab of browser','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1252,1,'en','core/setting/setting','general.cache_block','Cache','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1253,1,'en','core/setting/setting','general.admin_appearance_title','Admin appearance','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1254,1,'en','core/setting/setting','general.admin_appearance_description','Setting admin appearance such as editor, language...','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1255,1,'en','core/setting/setting','general.seo_block_description','Setting site title, site meta description, site keyword for optimize SEO','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1256,1,'en','core/setting/setting','general.webmaster_tools_description','Google Webmaster Tools (GWT) is free software that helps you manage the technical side of your website','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1257,1,'en','core/setting/setting','general.cache_description','Config cache for system for optimize speed','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1258,1,'en','core/setting/setting','general.yes','Yes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1259,1,'en','core/setting/setting','general.no','No','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1260,1,'en','core/setting/setting','general.show_on_front','Your homepage displays','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1261,1,'en','core/setting/setting','general.select','— Select —','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1262,1,'en','core/setting/setting','general.show_site_name','Show site name after page title, separate with \"-\"?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1263,1,'en','core/setting/setting','general.locale','Site language','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1264,1,'en','core/setting/setting','general.locale_direction','Front site language direction','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1265,1,'en','core/setting/setting','general.admin_locale_direction','Admin language direction','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1266,1,'en','core/setting/setting','general.admin_login_screen_backgrounds','Login screen backgrounds (~1366x768)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1267,1,'en','core/setting/setting','general.minutes','minutes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1268,1,'en','core/setting/setting','email.subject','Subject','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1269,1,'en','core/setting/setting','email.content','Content','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1270,1,'en','core/setting/setting','email.title','Setting for email template','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1271,1,'en','core/setting/setting','email.description','Email template using HTML & system variables.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1272,1,'en','core/setting/setting','email.reset_to_default','Reset to default','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1273,1,'en','core/setting/setting','email.back','Back to settings','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1274,1,'en','core/setting/setting','email.reset_success','Reset back to default successfully','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1275,1,'en','core/setting/setting','email.confirm_reset','Confirm reset email template?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1276,1,'en','core/setting/setting','email.confirm_message','Do you really want to reset this email template to default?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1277,1,'en','core/setting/setting','email.continue','Continue','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1278,1,'en','core/setting/setting','email.sender_name','Sender name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1279,1,'en','core/setting/setting','email.sender_name_placeholder','Name','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1280,1,'en','core/setting/setting','email.sender_email','Sender email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1281,1,'en','core/setting/setting','email.mailer','Mailer','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1282,1,'en','core/setting/setting','email.port','Port','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1283,1,'en','core/setting/setting','email.port_placeholder','Ex: 587','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1284,1,'en','core/setting/setting','email.host','Host','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1285,1,'en','core/setting/setting','email.host_placeholder','Ex: smtp.gmail.com','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1286,1,'en','core/setting/setting','email.username','Username','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1287,1,'en','core/setting/setting','email.username_placeholder','Username to login to mail server','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1288,1,'en','core/setting/setting','email.password','Password','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1289,1,'en','core/setting/setting','email.password_placeholder','Password to login to mail server','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1290,1,'en','core/setting/setting','email.encryption','Encryption','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1291,1,'en','core/setting/setting','email.mail_gun_domain','Domain','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1292,1,'en','core/setting/setting','email.mail_gun_domain_placeholder','Domain','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1293,1,'en','core/setting/setting','email.mail_gun_secret','Secret','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1294,1,'en','core/setting/setting','email.mail_gun_secret_placeholder','Secret','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1295,1,'en','core/setting/setting','email.mail_gun_endpoint','Endpoint','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1296,1,'en','core/setting/setting','email.mail_gun_endpoint_placeholder','Endpoint','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1297,1,'en','core/setting/setting','email.log_channel','Log channel','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1298,1,'en','core/setting/setting','email.sendmail_path','Sendmail Path','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1299,1,'en','core/setting/setting','email.encryption_placeholder','Encryption: ssl or tls','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1300,1,'en','core/setting/setting','email.ses_key','Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1301,1,'en','core/setting/setting','email.ses_key_placeholder','Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1302,1,'en','core/setting/setting','email.ses_secret','Secret','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1303,1,'en','core/setting/setting','email.ses_secret_placeholder','Secret','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1304,1,'en','core/setting/setting','email.ses_region','Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1305,1,'en','core/setting/setting','email.ses_region_placeholder','Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1306,1,'en','core/setting/setting','email.postmark_token','Token','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1307,1,'en','core/setting/setting','email.postmark_token_placeholder','Token','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1308,1,'en','core/setting/setting','email.template_title','Email templates','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1309,1,'en','core/setting/setting','email.template_description','Base templates for all emails','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1310,1,'en','core/setting/setting','email.template_header','Email template header','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1311,1,'en','core/setting/setting','email.template_header_description','Template for header of emails','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1312,1,'en','core/setting/setting','email.template_footer','Email template footer','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1313,1,'en','core/setting/setting','email.template_footer_description','Template for footer of emails','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1314,1,'en','core/setting/setting','email.default','Default','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1315,1,'en','core/setting/setting','email.using_queue_to_send_mail','Using queue job to send emails (Must to setup Queue first https://laravel.com/docs/queues#supervisor-configuration)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1316,1,'en','core/setting/setting','media.title','Media','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1317,1,'en','core/setting/setting','media.driver','Driver','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1318,1,'en','core/setting/setting','media.description','Settings for media','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1319,1,'en','core/setting/setting','media.aws_access_key_id','AWS Access Key ID','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1320,1,'en','core/setting/setting','media.aws_secret_key','AWS Secret Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1321,1,'en','core/setting/setting','media.aws_default_region','AWS Default Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1322,1,'en','core/setting/setting','media.aws_bucket','AWS Bucket','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1323,1,'en','core/setting/setting','media.aws_url','AWS URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1324,1,'en','core/setting/setting','media.aws_endpoint','AWS Endpoint (Optional)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1325,1,'en','core/setting/setting','media.do_spaces_access_key_id','DO Spaces Access Key ID','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1326,1,'en','core/setting/setting','media.do_spaces_secret_key','DO Spaces Secret Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1327,1,'en','core/setting/setting','media.do_spaces_default_region','DO Spaces Default Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1328,1,'en','core/setting/setting','media.do_spaces_bucket','DO Spaces Bucket','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1329,1,'en','core/setting/setting','media.do_spaces_endpoint','DO Spaces Endpoint','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1330,1,'en','core/setting/setting','media.do_spaces_cdn_enabled','Is DO Spaces CDN enabled?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1331,1,'en','core/setting/setting','media.media_do_spaces_cdn_custom_domain','Do Spaces CDN custom domain','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1332,1,'en','core/setting/setting','media.media_do_spaces_cdn_custom_domain_placeholder','https://your-custom-domain.com','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1333,1,'en','core/setting/setting','media.wasabi_access_key_id','Wasabi Access Key ID','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1334,1,'en','core/setting/setting','media.wasabi_secret_key','Wasabi Secret Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1335,1,'en','core/setting/setting','media.wasabi_default_region','Wasabi Default Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1336,1,'en','core/setting/setting','media.wasabi_bucket','Wasabi Bucket','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1337,1,'en','core/setting/setting','media.wasabi_root','Wasabi Root','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1338,1,'en','core/setting/setting','media.default_placeholder_image','Default placeholder image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1339,1,'en','core/setting/setting','media.enable_chunk','Enable chunk size upload?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1340,1,'en','core/setting/setting','media.chunk_size','Chunk size (Bytes)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1341,1,'en','core/setting/setting','media.chunk_size_placeholder','Default: 1048576 ~ 1MB','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1342,1,'en','core/setting/setting','media.max_file_size','Chunk max file size (MB)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1343,1,'en','core/setting/setting','media.max_file_size_placeholder','Default: 1048576 ~ 1GB','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1344,1,'en','core/setting/setting','media.enable_watermark','Enable watermark?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1345,1,'en','core/setting/setting','media.watermark_source','Watermark image','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1346,1,'en','core/setting/setting','media.watermark_size','Size of watermark (%)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1347,1,'en','core/setting/setting','media.watermark_size_placeholder','Default: 10 (%)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1348,1,'en','core/setting/setting','media.watermark_opacity','Watermark Opacity (%)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1349,1,'en','core/setting/setting','media.watermark_opacity_placeholder','Default: 70 (%)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1350,1,'en','core/setting/setting','media.watermark_position','Watermark position','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1351,1,'en','core/setting/setting','media.watermark_position_x','Watermark position X','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1352,1,'en','core/setting/setting','media.watermark_position_y','Watermark position Y','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1353,1,'en','core/setting/setting','media.watermark_position_top_left','Top left','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1354,1,'en','core/setting/setting','media.watermark_position_top_right','Top right','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1355,1,'en','core/setting/setting','media.watermark_position_bottom_left','Bottom left','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1356,1,'en','core/setting/setting','media.watermark_position_bottom_right','Bottom right','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1357,1,'en','core/setting/setting','media.watermark_position_center','Center','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1358,1,'en','core/setting/setting','media.turn_off_automatic_url_translation_into_latin','Turn off automatic URL translation into Latin?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1359,1,'en','core/setting/setting','media.bunnycdn_hostname','Hostname','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1360,1,'en','core/setting/setting','media.bunnycdn_zone','Zone Name (The name of your storage zone)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1361,1,'en','core/setting/setting','media.bunnycdn_key','FTP & API Access Password (The storage zone API Access Password)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1362,1,'en','core/setting/setting','media.bunnycdn_region','Region (The storage zone region)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1363,1,'en','core/setting/setting','media.optional','Optional','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1364,1,'en','core/setting/setting','media.sizes','Media thumbnails sizes','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1365,1,'en','core/setting/setting','media.media_sizes_helper','Set width or height to 0 if you just want to crop by width or height. Need to click on \"Generate thumbnails\" to apply changes.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1366,1,'en','core/setting/setting','media.width','Width','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1367,1,'en','core/setting/setting','media.height','Height','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1368,1,'en','core/setting/setting','media.default_size_value','Default: :size','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1369,1,'en','core/setting/setting','media.all','All','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1370,1,'en','core/setting/setting','media.media_folders_can_add_watermark','Add watermark for images in folders:','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1371,1,'en','core/setting/setting','media.max_upload_filesize','Max upload filesize (MB)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1372,1,'en','core/setting/setting','media.max_upload_filesize_placeholder','Default: :size, must less than :size.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1373,1,'en','core/setting/setting','media.max_upload_filesize_helper','Your server allows to upload files maximum :size, you can change this value to limit upload filesize.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1374,1,'en','core/setting/setting','license.purchase_code','Purchase code','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1375,1,'en','core/setting/setting','license.buyer','Buyer','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1376,1,'en','core/setting/setting','field_type_not_exists','This field type does not exist','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1377,1,'en','core/setting/setting','save_settings','Save settings','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1378,1,'en','core/setting/setting','template','Template','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1379,1,'en','core/setting/setting','description','Description','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1380,1,'en','core/setting/setting','enable','Enable','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1381,1,'en','core/setting/setting','send','Send','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1382,1,'en','core/setting/setting','test_email_description','To send test email, please make sure you are updated configuration to send mail!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1383,1,'en','core/setting/setting','test_email_input_placeholder','Enter the email which you want to send test email.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1384,1,'en','core/setting/setting','test_email_modal_title','Send a test email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1385,1,'en','core/setting/setting','test_send_mail','Send test mail','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1386,1,'en','core/setting/setting','test_email_send_success','Send email successfully!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1387,1,'en','core/setting/setting','locale_direction_ltr','Left to Right','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1388,1,'en','core/setting/setting','locale_direction_rtl','Right to Left','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1389,1,'en','core/setting/setting','saving','Saving...','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1390,1,'en','core/setting/setting','emails_warning','You can add up to :count emails','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1391,1,'en','core/setting/setting','email_add_more','Add more','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1392,1,'en','core/setting/setting','generate','Generate','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1393,1,'en','core/setting/setting','generate_thumbnails','Generate thumbnails','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1394,1,'en','core/setting/setting','generate_thumbnails_success','Generate thumbnails successfully. :count files are generated!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1395,1,'en','core/setting/setting','generate_thumbnails_error','We are unable to regenerate thumbnail for these files :count files!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1396,1,'en','core/setting/setting','generate_thumbnails_description','Are you sure you want to re-generate thumbnails for all images? It will take time so please DO NOT leave this page, wait until it is finished.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1397,1,'en','core/setting/setting','enable_chunk_description','Chunk size upload is used to upload large file size.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1398,1,'en','core/setting/setting','watermark_description','WARNING: Watermark is just added to new uploaded images, it won\'t be added to existing images. Disable watermark won\'t remove watermark from existing images.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1399,1,'vi','core/setting/setting','title','Cài đặt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1400,1,'vi','core/setting/setting','general.theme','Giao diện','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1401,1,'vi','core/setting/setting','general.description','Cấu hình những thông tin cài đặt website.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1402,1,'vi','core/setting/setting','general.title','Thông tin chung','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1403,1,'vi','core/setting/setting','general.general_block','Thông tin chung','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1404,1,'vi','core/setting/setting','general.site_title','Tên trang','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1405,1,'vi','core/setting/setting','general.admin_email','Email quản trị viên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1406,1,'vi','core/setting/setting','general.seo_block','Cấu hình SEO','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1407,1,'vi','core/setting/setting','general.seo_title','Tiêu đề SEO','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1408,1,'vi','core/setting/setting','general.seo_description','Mô tả SEO','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1409,1,'vi','core/setting/setting','general.webmaster_tools_block','Google Webmaster Tools','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1410,1,'vi','core/setting/setting','general.placeholder.site_title','Tên trang (tối đa 120 kí tự)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1411,1,'vi','core/setting/setting','general.placeholder.admin_email','Admin Email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1412,1,'vi','core/setting/setting','general.placeholder.google_analytics','Ví dụ: UA-42767940-2','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1413,1,'vi','core/setting/setting','general.placeholder.seo_title','Tiêu đề SEO (tối đa 120 kí tự)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1414,1,'vi','core/setting/setting','general.placeholder.seo_description','Mô tả SEO (tối đa 120 kí tự)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1415,1,'vi','core/setting/setting','general.enable_change_admin_theme','Cho phép thay đổi giao diện quản trị?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1416,1,'vi','core/setting/setting','general.enable','Bật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1417,1,'vi','core/setting/setting','general.disable','Tắt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1418,1,'vi','core/setting/setting','general.enable_cache','Bật bộ nhớ đệm?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1419,1,'vi','core/setting/setting','general.cache_time','Thời gian lưu bộ nhớ đệm (phút)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1420,1,'vi','core/setting/setting','general.cache_time_site_map','Thời gian lưu sơ đồ trang trong bộ nhớ đệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1421,1,'vi','core/setting/setting','general.admin_logo','Logo trang quản trị','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1422,1,'vi','core/setting/setting','general.admin_title','Tiêu đề trang quản trị','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1423,1,'vi','core/setting/setting','general.admin_title_placeholder','Tiêu đề hiển thị trên thẻ trình duyệt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1424,1,'vi','core/setting/setting','general.rich_editor','Bộ soạn thảo văn bản','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1425,1,'vi','core/setting/setting','general.cache_block','Bộ nhớ đệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1426,1,'vi','core/setting/setting','general.yes','Bật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1427,1,'vi','core/setting/setting','general.no','Tắt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1428,1,'vi','core/setting/setting','general.locale','Ngôn ngữ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1429,1,'vi','core/setting/setting','general.admin_appearance_description','Setting admin appearance such as editor, language...','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1430,1,'vi','core/setting/setting','general.admin_appearance_title','Admin appearance','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1431,1,'vi','core/setting/setting','general.admin_login_screen_backgrounds','Login screen backgrounds (~1366x768)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1432,1,'vi','core/setting/setting','general.admin_favicon','Admin favicon','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1433,1,'vi','core/setting/setting','general.cache_admin_menu','Cache admin menu?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1434,1,'vi','core/setting/setting','general.cache_description','Config cache for system for optimize speed','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1435,1,'vi','core/setting/setting','general.default_admin_theme','Default admin theme','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1436,1,'vi','core/setting/setting','general.enable_send_error_reporting_via_email','Enable to send error reporting via email?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1437,1,'vi','core/setting/setting','general.locale_direction','Hướng chữ viết','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1438,1,'vi','core/setting/setting','general.select','-- Lựa chọn --','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1439,1,'vi','core/setting/setting','general.seo_block_description','Setting site title, site meta description, site keyword for optimize SEO','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1440,1,'vi','core/setting/setting','general.show_on_front','Thiết lập trang chủ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1441,1,'vi','core/setting/setting','general.show_site_name','Hiển thị tên trang web sau tiêu đề trang, tách biệt bằng \"-\"?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1442,1,'vi','core/setting/setting','general.time_zone','Múi giờ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1443,1,'vi','core/setting/setting','general.webmaster_tools_description','Công cụ quản trị trang web của Google (GWT) là phần mềm miễn phí giúp bạn quản lý khía cạnh kỹ thuật của trang web của mình','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1444,1,'vi','core/setting/setting','email.subject','Tiêu đề','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1445,1,'vi','core/setting/setting','email.content','Nội dung','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1446,1,'vi','core/setting/setting','email.title','Cấu hình email template','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1447,1,'vi','core/setting/setting','email.description','Cấu trúc file template sử dụng HTML và các biến trong hệ thống.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1448,1,'vi','core/setting/setting','email.reset_to_default','Khôi phục về mặc định','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1449,1,'vi','core/setting/setting','email.back','Trở lại trang cài đặt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1450,1,'vi','core/setting/setting','email.reset_success','Khôi phục mặc định thành công','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1451,1,'vi','core/setting/setting','email.confirm_reset','Xác nhận khôi phục mặc định?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1452,1,'vi','core/setting/setting','email.confirm_message','Bạn có chắc chắn muốn khôi phục về bản mặc định?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1453,1,'vi','core/setting/setting','email.continue','Tiếp tục','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1454,1,'vi','core/setting/setting','email.sender_name','Tên người gửi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1455,1,'vi','core/setting/setting','email.sender_name_placeholder','Tên','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1456,1,'vi','core/setting/setting','email.sender_email','Email của người gửi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1457,1,'vi','core/setting/setting','email.mailer','Loại','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1458,1,'vi','core/setting/setting','email.port','Cổng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1459,1,'vi','core/setting/setting','email.port_placeholder','Ví dụ: 587','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1460,1,'vi','core/setting/setting','email.host','Máy chủ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1461,1,'vi','core/setting/setting','email.host_placeholder','Ví dụ: smtp.gmail.com','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1462,1,'vi','core/setting/setting','email.username','Tên đăng nhập','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1463,1,'vi','core/setting/setting','email.username_placeholder','Tên đăng nhập vào máy chủ mail','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1464,1,'vi','core/setting/setting','email.password','Mật khẩu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1465,1,'vi','core/setting/setting','email.password_placeholder','Mật khẩu đăng nhập vào máy chủ mail','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1466,1,'vi','core/setting/setting','email.encryption','Mã hoá','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1467,1,'vi','core/setting/setting','email.mail_gun_domain','Tên miền','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1468,1,'vi','core/setting/setting','email.mail_gun_domain_placeholder','Tên miền','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1469,1,'vi','core/setting/setting','email.mail_gun_secret','Chuỗi bí mật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1470,1,'vi','core/setting/setting','email.mail_gun_secret_placeholder','Chuỗi bí mật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1471,1,'vi','core/setting/setting','email.template_title','Mẫu giao diện email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1472,1,'vi','core/setting/setting','email.template_description','Giao diện mặc định cho tất cả email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1473,1,'vi','core/setting/setting','email.template_header','Mẫu cho phần trên của email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1474,1,'vi','core/setting/setting','email.template_header_description','Phần trên của tất cả email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1475,1,'vi','core/setting/setting','email.template_footer','Mẫu cho phần dưới của email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1476,1,'vi','core/setting/setting','email.template_footer_description','Phần dưới của tất cả email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1477,1,'vi','core/setting/setting','email.default','Mặc định','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1478,1,'vi','core/setting/setting','email.mail_gun_endpoint','Endpoint','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1479,1,'vi','core/setting/setting','email.mail_gun_endpoint_placeholder','Endpoint','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1480,1,'vi','core/setting/setting','email.postmark_token','Token','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1481,1,'vi','core/setting/setting','email.postmark_token_placeholder','Token','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1482,1,'vi','core/setting/setting','email.encryption_placeholder','Kiểu mã hóa: ssl hoặc tls','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1483,1,'vi','core/setting/setting','email.log_channel','Phương thức log','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1484,1,'vi','core/setting/setting','email.sendmail_path','Sendmail Path','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1485,1,'vi','core/setting/setting','email.ses_key','Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1486,1,'vi','core/setting/setting','email.ses_key_placeholder','Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1487,1,'vi','core/setting/setting','email.ses_region','Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1488,1,'vi','core/setting/setting','email.ses_region_placeholder','Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1489,1,'vi','core/setting/setting','email.ses_secret','Secret','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1490,1,'vi','core/setting/setting','email.ses_secret_placeholder','Secret','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1491,1,'vi','core/setting/setting','email.using_queue_to_send_mail','Sử dụng job queue để gửi email (Trước tiên phải thiết lập Queue https://laravel.com/docs/queues#supervisor-configuration)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1492,1,'vi','core/setting/setting','save_settings','Lưu cài đặt','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1493,1,'vi','core/setting/setting','template','Mẫu','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1494,1,'vi','core/setting/setting','description','Mô tả','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1495,1,'vi','core/setting/setting','enable','Bật','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1496,1,'vi','core/setting/setting','test_send_mail','Gửi thử nghiệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1497,1,'vi','core/setting/setting','email_setting_title','Cấu hình email','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1498,1,'vi','core/setting/setting','field_type_not_exists','Loại field này không được hỗ trợ','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1499,1,'vi','core/setting/setting','test_email_description','Để gửi email thử nghiệm, hãy đảm bảo rằng bạn đã cập nhật cấu hình để gửi thư!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1500,1,'vi','core/setting/setting','test_email_input_placeholder','Nhập email mà bạn muốn gửi email thử nghiệm.','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1501,1,'vi','core/setting/setting','test_email_modal_title','Gửi một email thử nghiệm','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1502,1,'vi','core/setting/setting','test_email_send_success','Gửi email thành công!','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1503,1,'vi','core/setting/setting','send','Gửi','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1504,1,'vi','core/setting/setting','license.buyer','Tên đăng nhập','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1505,1,'vi','core/setting/setting','license.purchase_code','Purchase code','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1506,1,'vi','core/setting/setting','locale_direction_ltr','Trái sang phải','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1507,1,'vi','core/setting/setting','locale_direction_rtl','Phải sang trái','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1508,1,'vi','core/setting/setting','media.aws_access_key_id','AWS Access Key ID','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1509,1,'vi','core/setting/setting','media.aws_bucket','AWS Bucket','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1510,1,'vi','core/setting/setting','media.aws_default_region','AWS Default Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1511,1,'vi','core/setting/setting','media.aws_url','AWS URL','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1512,1,'vi','core/setting/setting','media.aws_secret_key','AWS Secret Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1513,1,'vi','core/setting/setting','media.chunk_size','Chunk size (Bytes)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1514,1,'vi','core/setting/setting','media.chunk_size_placeholder','Mặc định: 1048576 ~ 1MB','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1515,1,'vi','core/setting/setting','media.do_spaces_access_key_id','DO Spaces Access Key ID','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1516,1,'vi','core/setting/setting','media.description','Cài đặt cho media','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1517,1,'vi','core/setting/setting','media.do_spaces_bucket','DO Spaces Bucket','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1518,1,'vi','core/setting/setting','media.do_spaces_cdn_enabled','Bật DO Spaces CDN?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1519,1,'vi','core/setting/setting','media.do_spaces_default_region','DO Spaces Default Region','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1520,1,'vi','core/setting/setting','media.do_spaces_endpoint','DO Spaces Endpoint','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1521,1,'vi','core/setting/setting','media.do_spaces_secret_key','DO Spaces Secret Key','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1522,1,'vi','core/setting/setting','media.driver','Driver','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1523,1,'vi','core/setting/setting','media.enable_chunk','Bật chunk size upload?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1524,1,'vi','core/setting/setting','media.enable_watermark','Bật watermark?','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1525,1,'vi','core/setting/setting','media.max_file_size','Chunk max file size (MB)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1526,1,'vi','core/setting/setting','media.max_file_size_placeholder','Mặc định: 1048576 ~ 1GB','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1527,1,'vi','core/setting/setting','media.media_do_spaces_cdn_custom_domain','Do Spaces CDN custom domain','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1528,1,'vi','core/setting/setting','media.media_do_spaces_cdn_custom_domain_placeholder','https://ten-mien-cua-ban.com','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1529,1,'vi','core/setting/setting','media.title','Media','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1530,1,'vi','core/setting/setting','media.watermark_opacity','Watermark Opacity (%)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1531,1,'vi','core/setting/setting','media.watermark_opacity_placeholder','Mặc định: 70 (%)','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1532,1,'vi','core/setting/setting','media.watermark_position','Vị trí watermark','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1533,1,'vi','core/setting/setting','media.watermark_position_bottom_left','Bên trái dưới cùng','2022-11-10 21:04:47','2022-11-10 21:04:47'),(1534,1,'vi','core/setting/setting','media.watermark_position_bottom_right','Bên phải dưới cùng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1535,1,'vi','core/setting/setting','media.watermark_position_center','Chính giữa','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1536,1,'vi','core/setting/setting','media.watermark_position_top_left','Bên trái trên cùng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1537,1,'vi','core/setting/setting','media.watermark_position_top_right','Bên phải trên cùng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1538,1,'vi','core/setting/setting','media.watermark_position_x','Watermark position X','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1539,1,'vi','core/setting/setting','media.watermark_position_y','Watermark position Y','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1540,1,'vi','core/setting/setting','media.watermark_size','Kích thước của watermark (%)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1541,1,'vi','core/setting/setting','media.watermark_size_placeholder','Mặc định: 10 (%)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1542,1,'vi','core/setting/setting','media.watermark_source','Hình ảnh watermark','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1543,1,'en','core/table/general','operations','Operations','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1544,1,'en','core/table/general','loading_data','Loading data from server','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1545,1,'en','core/table/general','display','Display','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1546,1,'en','core/table/general','all','All','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1547,1,'en','core/table/general','edit_entry','Edit','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1548,1,'en','core/table/general','delete_entry','Delete','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1549,1,'en','core/table/general','show_from','Showing from','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1550,1,'en','core/table/general','to','to','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1551,1,'en','core/table/general','in','in','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1552,1,'en','core/table/general','records','records','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1553,1,'en','core/table/general','no_data','No data to display','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1554,1,'en','core/table/general','no_record','No record','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1555,1,'en','core/table/general','loading','Loading data from server','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1556,1,'en','core/table/general','confirm_delete','Confirm delete','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1557,1,'en','core/table/general','confirm_delete_msg','Do you really want to delete this record?','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1558,1,'en','core/table/general','cancel','Cancel','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1559,1,'en','core/table/general','delete','Delete','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1560,1,'en','core/table/general','close','Close','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1561,1,'en','core/table/general','contains','Contains','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1562,1,'en','core/table/general','is_equal_to','Is equal to','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1563,1,'en','core/table/general','greater_than','Greater than','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1564,1,'en','core/table/general','less_than','Less than','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1565,1,'en','core/table/general','value','Value','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1566,1,'en','core/table/general','select_field','Select field','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1567,1,'en','core/table/general','reset','Reset','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1568,1,'en','core/table/general','add_additional_filter','Add additional filter','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1569,1,'en','core/table/general','apply','Apply','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1570,1,'en','core/table/general','filters','Filters','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1571,1,'en','core/table/general','bulk_change','Bulk changes','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1572,1,'en','core/table/general','select_option','Select option','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1573,1,'en','core/table/general','bulk_actions','Bulk Actions','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1574,1,'en','core/table/general','save_bulk_change_success','Update data for selected record(s) successfully!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1575,1,'en','core/table/general','please_select_record','Please select at least one record to perform this action!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1576,1,'en','core/table/general','filtered','(filtered from _MAX_ total records)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1577,1,'en','core/table/general','search','Search...','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1578,1,'en','core/table/table','operations','Operations','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1579,1,'en','core/table/table','loading_data','Loading data from server','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1580,1,'en','core/table/table','display','Display','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1581,1,'en','core/table/table','all','All','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1582,1,'en','core/table/table','edit_entry','Edit','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1583,1,'en','core/table/table','delete_entry','Delete','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1584,1,'en','core/table/table','show_from','Showing from','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1585,1,'en','core/table/table','to','to','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1586,1,'en','core/table/table','in','in','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1587,1,'en','core/table/table','records','records','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1588,1,'en','core/table/table','no_data','No data to display','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1589,1,'en','core/table/table','no_record','No record','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1590,1,'en','core/table/table','loading','Loading data from server','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1591,1,'en','core/table/table','confirm_delete','Confirm delete','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1592,1,'en','core/table/table','confirm_delete_msg','Do you really want to delete this record?','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1593,1,'en','core/table/table','cancel','Cancel','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1594,1,'en','core/table/table','delete','Delete','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1595,1,'en','core/table/table','close','Close','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1596,1,'en','core/table/table','contains','Contains','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1597,1,'en','core/table/table','is_equal_to','Is equal to','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1598,1,'en','core/table/table','greater_than','Greater than','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1599,1,'en','core/table/table','less_than','Less than','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1600,1,'en','core/table/table','value','Value','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1601,1,'en','core/table/table','select_field','Select field','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1602,1,'en','core/table/table','reset','Reset','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1603,1,'en','core/table/table','add_additional_filter','Add additional filter','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1604,1,'en','core/table/table','apply','Apply','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1605,1,'en','core/table/table','filters','Filters','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1606,1,'en','core/table/table','bulk_change','Bulk changes','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1607,1,'en','core/table/table','select_option','Select option','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1608,1,'en','core/table/table','bulk_actions','Bulk Actions','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1609,1,'en','core/table/table','save_bulk_change_success','Update data for selected record(s) successfully!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1610,1,'en','core/table/table','please_select_record','Please select at least one record to perform this action!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1611,1,'en','core/table/table','filtered','(filtered from _MAX_ total records)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1612,1,'en','core/table/table','search','Search...','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1613,1,'vi','core/table/general','operations','Hành động','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1614,1,'vi','core/table/general','loading_data','Đang tải dữ liệu từ hệ thống','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1615,1,'vi','core/table/general','display','Hiển thị','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1616,1,'vi','core/table/general','all','Tất cả','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1617,1,'vi','core/table/general','edit_entry','Sửa','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1618,1,'vi','core/table/general','delete_entry','Xoá','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1619,1,'vi','core/table/general','show_from','Hiển thị từ','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1620,1,'vi','core/table/general','to','đến','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1621,1,'vi','core/table/general','in','trong tổng số','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1622,1,'vi','core/table/general','records','bản ghi','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1623,1,'vi','core/table/general','no_data','Không có dữ liệu để hiển thị','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1624,1,'vi','core/table/general','no_record','không có bản ghi nào','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1625,1,'vi','core/table/general','loading','Đang tải dữ liệu từ hệ thống','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1626,1,'vi','core/table/general','confirm_delete','Xác nhận xoá','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1627,1,'vi','core/table/general','confirm_delete_msg','Bạn có chắc chắn muốn xoá bản ghi này?','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1628,1,'vi','core/table/general','cancel','Huỷ bỏ','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1629,1,'vi','core/table/general','delete','Xoá','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1630,1,'vi','core/table/general','close','Đóng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1631,1,'vi','core/table/general','is_equal_to','Bằng với','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1632,1,'vi','core/table/general','greater_than','Lớn hơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1633,1,'vi','core/table/general','less_than','Nhỏ hơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1634,1,'vi','core/table/general','value','Giá trị','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1635,1,'vi','core/table/general','select_field','Chọn trường','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1636,1,'vi','core/table/general','reset','Làm mới','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1637,1,'vi','core/table/general','add_additional_filter','Thêm bộ lọc','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1638,1,'vi','core/table/general','apply','Áp dụng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1639,1,'vi','core/table/general','select_option','Lựa chọn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1640,1,'vi','core/table/general','filters','Lọc dữ liệu','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1641,1,'vi','core/table/general','bulk_change','Thay đổi hàng loạt','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1642,1,'vi','core/table/general','bulk_actions','Hành động','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1643,1,'vi','core/table/general','contains','Bao gồm','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1644,1,'vi','core/table/general','filtered','(đã được lọc từ _MAX_ bản ghi)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1645,1,'vi','core/table/table','operations','Hành động','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1646,1,'vi','core/table/table','loading_data','Đang tải dữ liệu từ hệ thống','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1647,1,'vi','core/table/table','display','Hiển thị','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1648,1,'vi','core/table/table','all','Tất cả','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1649,1,'vi','core/table/table','edit_entry','Sửa','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1650,1,'vi','core/table/table','delete_entry','Xoá','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1651,1,'vi','core/table/table','show_from','Hiển thị từ','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1652,1,'vi','core/table/table','to','đến','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1653,1,'vi','core/table/table','in','trong tổng số','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1654,1,'vi','core/table/table','records','bản ghi','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1655,1,'vi','core/table/table','no_data','Không có dữ liệu để hiển thị','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1656,1,'vi','core/table/table','no_record','không có bản ghi nào','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1657,1,'vi','core/table/table','loading','Đang tải dữ liệu từ hệ thống','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1658,1,'vi','core/table/table','confirm_delete','Xác nhận xoá','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1659,1,'vi','core/table/table','confirm_delete_msg','Bạn có chắc chắn muốn xoá bản ghi này?','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1660,1,'vi','core/table/table','cancel','Huỷ bỏ','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1661,1,'vi','core/table/table','delete','Xoá','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1662,1,'vi','core/table/table','close','Đóng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1663,1,'vi','core/table/table','is_equal_to','Bằng với','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1664,1,'vi','core/table/table','greater_than','Lớn hơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1665,1,'vi','core/table/table','less_than','Nhỏ hơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1666,1,'vi','core/table/table','value','Giá trị','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1667,1,'vi','core/table/table','select_field','Chọn trường','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1668,1,'vi','core/table/table','reset','Làm mới','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1669,1,'vi','core/table/table','add_additional_filter','Thêm bộ lọc','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1670,1,'vi','core/table/table','apply','Áp dụng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1671,1,'vi','core/table/table','select_option','Lựa chọn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1672,1,'vi','core/table/table','filters','Lọc dữ liệu','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1673,1,'vi','core/table/table','bulk_change','Thay đổi hàng loạt','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1674,1,'vi','core/table/table','bulk_actions','Hành động','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1675,1,'vi','core/table/table','contains','Bao gồm','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1676,1,'vi','core/table/table','filtered','(đã được lọc từ _MAX_ bản ghi)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1677,1,'vi','core/table/table','please_select_record','Vui lòng chọn ít nhất 1 bản ghi để thực hiện hành động này!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1678,1,'vi','core/table/table','save_bulk_change_success','Cập nhật dữ liệu cho các bản ghi thành công!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1679,1,'vi','core/table/table','search','Tìm kiếm...','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1680,1,'en','packages/api/api','settings','API Settings','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1681,1,'en','packages/api/api','save_settings','Save settings','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1682,1,'en','packages/api/api','setting_title','API settings','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1683,1,'en','packages/api/api','setting_description','Settings for API','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1684,1,'en','packages/api/api','api_enabled','API enabled?','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1685,1,'en','packages/get-started/get-started','welcome_title','Welcome to your admin dashboard!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1686,1,'en','packages/get-started/get-started','welcome_description','In a few short steps, you can have your new dashboard up and running!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1687,1,'en','packages/get-started/get-started','get_started','Get Started!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1688,1,'en','packages/get-started/get-started','customize_branding_title','Customize branding','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1689,1,'en','packages/get-started/get-started','customize_branding_description','Customize your site with colors, logo and subdomain to match your business unique branding and identity.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1690,1,'en','packages/get-started/get-started','colors','Colors','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1691,1,'en','packages/get-started/get-started','fonts','Fonts','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1692,1,'en','packages/get-started/get-started','primary_color','Primary color','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1693,1,'en','packages/get-started/get-started','primary_font','Primary font','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1694,1,'en','packages/get-started/get-started','setup_wizard_button',':link to finish Quick setup Wizard!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1695,1,'en','packages/get-started/get-started','click_here','Click here','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1696,1,'en','packages/get-started/get-started','site_title','Site title','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1697,1,'en','packages/get-started/get-started','identify','Identify','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1698,1,'en','packages/get-started/get-started','logo','Logo','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1699,1,'en','packages/get-started/get-started','admin_logo','Admin logo','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1700,1,'en','packages/get-started/get-started','favicon','Favicon','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1701,1,'en','packages/get-started/get-started','admin_favicon','Admin favicon','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1702,1,'en','packages/get-started/get-started','next_step','Next step','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1703,1,'en','packages/get-started/get-started','site_ready_title','Your site is ready!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1704,1,'en','packages/get-started/get-started','site_ready_description','Welcome to your new site! Your website has been created and populated with sample data. You are in the admin area of your site where you can set up everything else needed to complete your site.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1705,1,'en','packages/get-started/get-started','finish','Finish','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1706,1,'en','packages/get-started/get-started','exit_wizard_title','Are you sure you want to exit the Quick Setup Wizard?','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1707,1,'en','packages/get-started/get-started','exit_wizard_confirm','Yes, I\'ll finish it later','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1708,1,'en','packages/get-started/get-started','exit_wizard_cancel','No, take me back to the wizard','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1709,1,'en','packages/get-started/get-started','change_default_account_info_title','Change default account info','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1710,1,'en','packages/get-started/get-started','change_default_account_info_description','The default account is using a weak password. You need to change it to a complex password for better security.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1711,1,'en','packages/get-started/get-started','username','Username','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1712,1,'en','packages/get-started/get-started','email','Email','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1713,1,'en','packages/get-started/get-started','password','Password','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1714,1,'en','packages/get-started/get-started','password_confirmation','Password confirmation','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1715,1,'en','packages/installer/installer','title','Installer','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1716,1,'en','packages/installer/installer','next','Next Step','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1717,1,'en','packages/installer/installer','back','Previous','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1718,1,'en','packages/installer/installer','finish','Install','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1719,1,'en','packages/installer/installer','forms.errorTitle','The following errors occurred:','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1720,1,'en','packages/installer/installer','welcome.templateTitle','Welcome','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1721,1,'en','packages/installer/installer','welcome.title','Welcome','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1722,1,'en','packages/installer/installer','welcome.message','Before getting started, we need some information on the database. You will need to know the following items before proceeding.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1723,1,'en','packages/installer/installer','welcome.next','Let\'s go','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1724,1,'en','packages/installer/installer','requirements.templateTitle','Step 1 | Server Requirements','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1725,1,'en','packages/installer/installer','requirements.title','Server Requirements','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1726,1,'en','packages/installer/installer','requirements.next','Check Permissions','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1727,1,'en','packages/installer/installer','permissions.templateTitle','Step 2 | Permissions','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1728,1,'en','packages/installer/installer','permissions.title','Permissions','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1729,1,'en','packages/installer/installer','permissions.next','Configure Environment','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1730,1,'en','packages/installer/installer','environment.wizard.templateTitle','Environment Settings','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1731,1,'en','packages/installer/installer','environment.wizard.title','Environment Settings','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1732,1,'en','packages/installer/installer','environment.wizard.form.name_required','An environment name is required.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1733,1,'en','packages/installer/installer','environment.wizard.form.app_name_label','Site title','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1734,1,'en','packages/installer/installer','environment.wizard.form.app_name_placeholder','Site title','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1735,1,'en','packages/installer/installer','environment.wizard.form.app_url_label','URL','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1736,1,'en','packages/installer/installer','environment.wizard.form.app_url_placeholder','URL','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1737,1,'en','packages/installer/installer','environment.wizard.form.db_connection_label','Database Connection','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1738,1,'en','packages/installer/installer','environment.wizard.form.db_connection_label_mysql','MySQL','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1739,1,'en','packages/installer/installer','environment.wizard.form.db_connection_label_sqlite','SQLite','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1740,1,'en','packages/installer/installer','environment.wizard.form.db_connection_label_pgsql','PostgreSQL','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1741,1,'en','packages/installer/installer','environment.wizard.form.db_host_label','Database host','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1742,1,'en','packages/installer/installer','environment.wizard.form.db_host_placeholder','Database host','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1743,1,'en','packages/installer/installer','environment.wizard.form.db_port_label','Database port','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1744,1,'en','packages/installer/installer','environment.wizard.form.db_port_placeholder','Database port','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1745,1,'en','packages/installer/installer','environment.wizard.form.db_name_label','Database name','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1746,1,'en','packages/installer/installer','environment.wizard.form.db_name_placeholder','Database name','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1747,1,'en','packages/installer/installer','environment.wizard.form.db_username_label','Database username','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1748,1,'en','packages/installer/installer','environment.wizard.form.db_username_placeholder','Database username','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1749,1,'en','packages/installer/installer','environment.wizard.form.db_password_label','Database password','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1750,1,'en','packages/installer/installer','environment.wizard.form.db_password_placeholder','Database password','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1751,1,'en','packages/installer/installer','environment.wizard.form.buttons.install','Install','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1752,1,'en','packages/installer/installer','environment.success','Your .env file settings have been saved.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1753,1,'en','packages/installer/installer','environment.errors','Unable to save the .env file, Please create it manually.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1754,1,'en','packages/installer/installer','install','Install','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1755,1,'en','packages/installer/installer','final.title','Installation Finished','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1756,1,'en','packages/installer/installer','final.templateTitle','Installation Finished','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1757,1,'en','packages/installer/installer','final.finished','Application has been successfully installed.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1758,1,'en','packages/installer/installer','final.exit','Click here to exit','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1759,1,'en','packages/installer/installer','create_account','Create account','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1760,1,'en','packages/installer/installer','first_name','First name','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1761,1,'en','packages/installer/installer','last_name','Last name','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1762,1,'en','packages/installer/installer','username','Username','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1763,1,'en','packages/installer/installer','email','Email','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1764,1,'en','packages/installer/installer','password','Password','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1765,1,'en','packages/installer/installer','password_confirmation','Password confirmation','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1766,1,'en','packages/installer/installer','create','Create','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1767,1,'en','packages/installer/installer','install_success','Installed successfully!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1768,1,'en','packages/menu/menu','name','Menus','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1769,1,'en','packages/menu/menu','key_name','Menu name (key: :key)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1770,1,'en','packages/menu/menu','basic_info','Basic information','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1771,1,'en','packages/menu/menu','add_to_menu','Add to menu','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1772,1,'en','packages/menu/menu','custom_link','Custom link','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1773,1,'en','packages/menu/menu','add_link','Add link','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1774,1,'en','packages/menu/menu','structure','Menu structure','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1775,1,'en','packages/menu/menu','remove','Remove','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1776,1,'en','packages/menu/menu','cancel','Cancel','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1777,1,'en','packages/menu/menu','title','Title','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1778,1,'en','packages/menu/menu','icon','Icon','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1779,1,'en','packages/menu/menu','url','URL','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1780,1,'en','packages/menu/menu','target','Target','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1781,1,'en','packages/menu/menu','css_class','CSS class','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1782,1,'en','packages/menu/menu','self_open_link','Open link directly','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1783,1,'en','packages/menu/menu','blank_open_link','Open link in new tab','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1784,1,'en','packages/menu/menu','create','Create menu','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1785,1,'en','packages/menu/menu','edit','Edit menu','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1786,1,'en','packages/menu/menu','menu_settings','Menu settings','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1787,1,'en','packages/menu/menu','display_location','Display location','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1788,1,'en','packages/menu/menu','title_placeholder','Title','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1789,1,'en','packages/menu/menu','icon_placeholder','Icon','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1790,1,'en','packages/menu/menu','url_placeholder','URL','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1791,1,'en','packages/menu/menu','css_class_placeholder','CSS class','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1792,1,'en','packages/menu/menu','menu_id','Menu ID','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1793,1,'vi','packages/menu/menu','name','Trình đơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1794,1,'vi','packages/menu/menu','cancel','Hủy bỏ','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1795,1,'vi','packages/menu/menu','add_link','Thêm liên kết','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1796,1,'vi','packages/menu/menu','add_to_menu','Thêm vào trình đơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1797,1,'vi','packages/menu/menu','basic_info','Thông tin cơ bản','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1798,1,'vi','packages/menu/menu','blank_open_link','Mở liên kết trong tab mới','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1799,1,'vi','packages/menu/menu','css_class','CSS class','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1800,1,'vi','packages/menu/menu','custom_link','Liên kết tùy chọn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1801,1,'vi','packages/menu/menu','icon','Biểu tượng','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1802,1,'vi','packages/menu/menu','key_name','Tên menu (key::key)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1803,1,'vi','packages/menu/menu','remove','Xóa','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1804,1,'vi','packages/menu/menu','self_open_link','Mở liên kết trong tab hiện tại','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1805,1,'vi','packages/menu/menu','structure','Cấu trúc trình đơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1806,1,'vi','packages/menu/menu','target','Target','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1807,1,'vi','packages/menu/menu','title','Tiêu đề','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1808,1,'vi','packages/menu/menu','url','URL','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1809,1,'vi','packages/menu/menu','create','Tạo trình đơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1810,1,'vi','packages/menu/menu','edit','Sửa trình đơn','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1811,1,'vi','packages/menu/menu','display_location','Vị trí hiển thị','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1812,1,'vi','packages/menu/menu','menu_settings','Cấu hình menu','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1813,1,'en','packages/optimize/optimize','settings.title','Optimize page speed','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1814,1,'en','packages/optimize/optimize','settings.description','Minify HTML output, inline CSS, remove comments...','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1815,1,'en','packages/optimize/optimize','settings.enable','Enable optimize page speed?','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1816,1,'en','packages/optimize/optimize','collapse_white_space','Collapse white space','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1817,1,'en','packages/optimize/optimize','collapse_white_space_description','This filter reduces bytes transmitted in an HTML file by removing unnecessary whitespace.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1818,1,'en','packages/optimize/optimize','elide_attributes','Elide attributes','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1819,1,'en','packages/optimize/optimize','elide_attributes_description','This filter reduces the transfer size of HTML files by removing attributes from tags when the specified value is equal to the default value for that attribute. This can save a modest number of bytes, and may make the document more compressible by canonicalizing the affected tags.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1820,1,'en','packages/optimize/optimize','inline_css','Inline CSS','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1821,1,'en','packages/optimize/optimize','inline_css_description','This filter transforms the inline \"style\" attribute of tags into classes by moving the CSS to the header.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1822,1,'en','packages/optimize/optimize','insert_dns_prefetch','Insert DNS prefetch','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1823,1,'en','packages/optimize/optimize','insert_dns_prefetch_description','This filter injects tags in the HEAD to enable the browser to do DNS prefetching.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1824,1,'en','packages/optimize/optimize','remove_comments','Remove comments','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1825,1,'en','packages/optimize/optimize','remove_comments_description','This filter eliminates HTML, JS and CSS comments. The filter reduces the transfer size of HTML files by removing the comments. Depending on the HTML file, this filter can significantly reduce the number of bytes transmitted on the network.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1826,1,'en','packages/optimize/optimize','trim_urls','Trim URLs','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1827,1,'en','packages/optimize/optimize','trim_urls_description','This filter trims URLs by resolving them by making them relative to the base URL for the page.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1828,1,'en','packages/optimize/optimize','remove_quotes','Remove quotes','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1829,1,'en','packages/optimize/optimize','remove_quotes_description','This filter eliminates unnecessary quotation marks from HTML attributes. While required by the various HTML specifications, browsers permit their omission when the value of an attribute is composed of a certain subset of characters (alphanumerics and some punctuation characters).','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1830,1,'en','packages/optimize/optimize','defer_javascript','Defer javascript','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1831,1,'en','packages/optimize/optimize','defer_javascript_description','Defers the execution of javascript in the HTML. If necessary cancel deferring in some script, use data-pagespeed-no-defer as script attribute to cancel deferring.','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1832,1,'en','packages/page/pages','create','Create new page','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1833,1,'en','packages/page/pages','edit','Edit page','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1834,1,'en','packages/page/pages','form.name','Name','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1835,1,'en','packages/page/pages','form.name_placeholder','Page\'s name (Maximum 120 characters)','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1836,1,'en','packages/page/pages','form.content','Content','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1837,1,'en','packages/page/pages','form.note','Note content','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1838,1,'en','packages/page/pages','notices.no_select','Please select at least one record to take this action!','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1839,1,'en','packages/page/pages','notices.update_success_message','Update successfully','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1840,1,'en','packages/page/pages','cannot_delete','Page could not be deleted','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1841,1,'en','packages/page/pages','deleted','Page deleted','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1842,1,'en','packages/page/pages','pages','Pages','2022-11-10 21:04:48','2022-11-10 21:04:48'),(1843,1,'en','packages/page/pages','menu','Pages','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1844,1,'en','packages/page/pages','menu_name','Pages','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1845,1,'en','packages/page/pages','edit_this_page','Edit this page','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1846,1,'en','packages/page/pages','total_pages','Total pages','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1847,1,'en','packages/page/pages','settings.show_on_front','Your homepage displays','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1848,1,'en','packages/page/pages','settings.select','— Select —','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1849,1,'en','packages/page/pages','front_page','Front Page','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1850,1,'vi','packages/page/pages','create','Thêm trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1851,1,'vi','packages/page/pages','edit','Sửa trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1852,1,'vi','packages/page/pages','form.name','Tiêu đề trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1853,1,'vi','packages/page/pages','form.note','Nội dung ghi chú','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1854,1,'vi','packages/page/pages','form.name_placeholder','Tên trang (tối đa 120 kí tự)','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1855,1,'vi','packages/page/pages','form.content','Nội dung','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1856,1,'vi','packages/page/pages','notices.no_select','Chọn ít nhất 1 trang để thực hiện hành động này!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1857,1,'vi','packages/page/pages','notices.update_success_message','Cập nhật thành công','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1858,1,'vi','packages/page/pages','deleted','Xóa trang thành công','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1859,1,'vi','packages/page/pages','cannot_delete','Không thể xóa trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1860,1,'vi','packages/page/pages','menu','Trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1861,1,'vi','packages/page/pages','menu_name','Trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1862,1,'vi','packages/page/pages','edit_this_page','Sửa trang này','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1863,1,'vi','packages/page/pages','pages','Trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1864,1,'vi','packages/page/pages','front_page','Trang chủ','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1865,1,'vi','packages/page/pages','settings.select','-- Lựa chọn --','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1866,1,'vi','packages/page/pages','settings.show_on_front','Lựa chọn trang chủ','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1867,1,'vi','packages/page/pages','total_pages','Tổng số trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1868,1,'en','packages/plugin-management/plugin','enabled','Enabled','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1869,1,'en','packages/plugin-management/plugin','deactivated','Deactivated','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1870,1,'en','packages/plugin-management/plugin','activated','Activated','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1871,1,'en','packages/plugin-management/plugin','activate','Activate','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1872,1,'en','packages/plugin-management/plugin','deactivate','Deactivate','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1873,1,'en','packages/plugin-management/plugin','author','By','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1874,1,'en','packages/plugin-management/plugin','update_plugin_status_success','Update plugin successfully','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1875,1,'en','packages/plugin-management/plugin','plugins','Plugins','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1876,1,'en','packages/plugin-management/plugin','missing_required_plugins','Please activate plugin(s): :plugins before activate this plugin!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1877,1,'en','packages/plugin-management/plugin','remove','Remove','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1878,1,'en','packages/plugin-management/plugin','remove_plugin_success','Remove plugin successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1879,1,'en','packages/plugin-management/plugin','remove_plugin','Remove plugin','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1880,1,'en','packages/plugin-management/plugin','remove_plugin_confirm_message','Do you really want to remove this plugin?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1881,1,'en','packages/plugin-management/plugin','remove_plugin_confirm_yes','Yes, remove it!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1882,1,'en','packages/plugin-management/plugin','total_plugins','Total plugins','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1883,1,'en','packages/plugin-management/plugin','invalid_plugin','This plugin is not a valid plugin, please check it again!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1884,1,'en','packages/plugin-management/plugin','version','Version','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1885,1,'en','packages/plugin-management/plugin','invalid_json','Invalid plugin.json!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1886,1,'en','packages/plugin-management/plugin','activate_success','Activate plugin successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1887,1,'en','packages/plugin-management/plugin','activated_already','This plugin is activated already!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1888,1,'en','packages/plugin-management/plugin','plugin_not_exist','This plugin is not exists.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1889,1,'en','packages/plugin-management/plugin','missing_json_file','Missing file plugin.json!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1890,1,'en','packages/plugin-management/plugin','plugin_invalid','Plugin is valid!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1891,1,'en','packages/plugin-management/plugin','published_assets_success','Publish assets for plugin :name successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1892,1,'en','packages/plugin-management/plugin','plugin_removed','Plugin has been removed!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1893,1,'en','packages/plugin-management/plugin','deactivated_success','Deactivate plugin successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1894,1,'en','packages/plugin-management/plugin','deactivated_already','This plugin is deactivated already!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1895,1,'en','packages/plugin-management/plugin','folder_is_not_writeable','Cannot write files! Folder :name is not writable. Please chmod to make it writable!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1896,1,'en','packages/plugin-management/plugin','plugin_is_not_ready','Plugin :name is not ready to use','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1897,1,'vi','packages/plugin-management/plugin','activate','Kích hoạt','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1898,1,'vi','packages/plugin-management/plugin','author','Tác giả','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1899,1,'vi','packages/plugin-management/plugin','version','Phiên bản','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1900,1,'vi','packages/plugin-management/plugin','activated','Đã kích hoạt','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1901,1,'vi','packages/plugin-management/plugin','deactivate','Hủy kích hoạt','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1902,1,'vi','packages/plugin-management/plugin','deactivated','Đã vô hiệu','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1903,1,'vi','packages/plugin-management/plugin','enabled','Kích hoạt','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1904,1,'vi','packages/plugin-management/plugin','invalid_plugin','Gói mở rộng không hợp lệ','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1905,1,'vi','packages/plugin-management/plugin','update_plugin_status_success','Cập nhật trạng thái gói mở rộng thành công','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1906,1,'vi','packages/plugin-management/plugin','missing_required_plugins','Vui lòng kích hoạt các gói mở rộng :plugins trước khi kích hoạt gói này','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1907,1,'vi','packages/plugin-management/plugin','plugins','Gói mở rộng','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1908,1,'vi','packages/plugin-management/plugin','remove','Xoá','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1909,1,'vi','packages/plugin-management/plugin','remove_plugin_success','Xoá thành công!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1910,1,'vi','packages/plugin-management/plugin','remove_plugin','Xoá gói mở rộng','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1911,1,'vi','packages/plugin-management/plugin','remove_plugin_confirm_message','Bạn có chắc chắn muốn xoá plugin này?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1912,1,'vi','packages/plugin-management/plugin','remove_plugin_confirm_yes','Có, xoá!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1913,1,'vi','packages/plugin-management/plugin','total_plugins','Tất cả plugins','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1914,1,'vi','packages/plugin-management/plugin','activate_success','Kích hoạt thành công!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1915,1,'vi','packages/plugin-management/plugin','activated_already','Gói mở rộng này đã được kích hoạt rồi!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1916,1,'vi','packages/plugin-management/plugin','deactivated_already','Gói mở rộng này đã được hủy kích hoạt rồi!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1917,1,'vi','packages/plugin-management/plugin','deactivated_success','Hủy kích hoạt thành công!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1918,1,'vi','packages/plugin-management/plugin','invalid_json','Sai cấu hình plugin.json!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1919,1,'vi','packages/plugin-management/plugin','missing_json_file','Thiếu tập tin cấu hình plugin.json!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1920,1,'vi','packages/plugin-management/plugin','plugin_invalid','Gói mở rộng không hợp lệ!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1921,1,'vi','packages/plugin-management/plugin','plugin_not_exist','Gói mở rộng không tồn tại','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1922,1,'vi','packages/plugin-management/plugin','plugin_removed','Gói mở rộng đã bị xóa!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1923,1,'vi','packages/plugin-management/plugin','published_assets_success','Xuất bản assets cho gói mở rộng thành công!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1924,1,'en','packages/seo-helper/seo-helper','meta_box_header','Search Engine Optimize','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1925,1,'en','packages/seo-helper/seo-helper','edit_seo_meta','Edit SEO meta','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1926,1,'en','packages/seo-helper/seo-helper','default_description','Setup meta title & description to make your site easy to discovered on search engines such as Google','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1927,1,'en','packages/seo-helper/seo-helper','seo_title','SEO Title','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1928,1,'en','packages/seo-helper/seo-helper','seo_description','SEO description','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1929,1,'vi','packages/seo-helper/seo-helper','meta_box_header','Tối ưu hoá bộ máy tìm kiếm (SEO)','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1930,1,'vi','packages/seo-helper/seo-helper','edit_seo_meta','Chỉnh sửa SEO','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1931,1,'vi','packages/seo-helper/seo-helper','default_description','Thiết lập các thẻ mô tả giúp người dùng dễ dàng tìm thấy trên công cụ tìm kiếm như Google.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1932,1,'vi','packages/seo-helper/seo-helper','seo_title','Tiêu đề trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1933,1,'vi','packages/seo-helper/seo-helper','seo_description','Mô tả trang','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1934,1,'en','packages/slug/slug','permalink_settings','Permalink','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1935,1,'en','packages/slug/slug','settings.title','Permalink settings','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1936,1,'en','packages/slug/slug','settings.description','Manage permalink for all modules.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1937,1,'en','packages/slug/slug','settings.preview','Preview','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1938,1,'en','packages/slug/slug','settings.turn_off_automatic_url_translation_into_latin','Turn off automatic URL translation into Latin?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1939,1,'en','packages/slug/slug','preview','Preview','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1940,1,'en','packages/slug/slug','prefix_for','Prefix for :name','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1941,1,'vi','packages/slug/slug','permalink_settings','Liên kết cố định','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1942,1,'vi','packages/slug/slug','preview','Xem trước','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1943,1,'vi','packages/slug/slug','settings.description','Quản lý liên kết cố định cho các module.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1944,1,'vi','packages/slug/slug','settings.preview','Xem trước','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1945,1,'vi','packages/slug/slug','settings.title','Cài đặt liên kết cố định','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1946,1,'en','packages/theme/theme','name','Themes','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1947,1,'en','packages/theme/theme','theme','Theme','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1948,1,'en','packages/theme/theme','author','Author','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1949,1,'en','packages/theme/theme','version','Version','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1950,1,'en','packages/theme/theme','description','Description','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1951,1,'en','packages/theme/theme','active_success','Activate theme :name successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1952,1,'en','packages/theme/theme','active','Active','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1953,1,'en','packages/theme/theme','activated','Activated','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1954,1,'en','packages/theme/theme','appearance','Appearance','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1955,1,'en','packages/theme/theme','theme_options','Theme options','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1956,1,'en','packages/theme/theme','save_changes','Save Changes','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1957,1,'en','packages/theme/theme','developer_mode','Developer Mode Enabled','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1958,1,'en','packages/theme/theme','custom_css','Custom CSS','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1959,1,'en','packages/theme/theme','custom_js','Custom JS','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1960,1,'en','packages/theme/theme','custom_header_js','Header JS','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1961,1,'en','packages/theme/theme','custom_header_js_placeholder','JS in header of page, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1962,1,'en','packages/theme/theme','custom_body_js','Body JS','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1963,1,'en','packages/theme/theme','custom_body_js_placeholder','JS in body of page, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1964,1,'en','packages/theme/theme','custom_footer_js','Footer JS','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1965,1,'en','packages/theme/theme','custom_footer_js_placeholder','JS in footer of page, wrap it inside &#x3C;script&#x3E;&#x3C;/script&#x3E;','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1966,1,'en','packages/theme/theme','custom_html','Custom HTML','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1967,1,'en','packages/theme/theme','custom_header_html','Header HTML','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1968,1,'en','packages/theme/theme','custom_header_html_placeholder','HTML in header of page, no special tags: script, style, iframe...','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1969,1,'en','packages/theme/theme','custom_body_html','Body HTML','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1970,1,'en','packages/theme/theme','custom_body_html_placeholder','HTML in body of page, no special tags: script, style, iframe...','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1971,1,'en','packages/theme/theme','custom_footer_html','Footer HTML','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1972,1,'en','packages/theme/theme','custom_footer_html_placeholder','HTML in footer of page, no special tags: script, style, iframe...','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1973,1,'en','packages/theme/theme','remove_theme_success','Remove theme successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1974,1,'en','packages/theme/theme','theme_is_not_existed','This theme is not existed!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1975,1,'en','packages/theme/theme','remove','Remove','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1976,1,'en','packages/theme/theme','remove_theme','Remove theme','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1977,1,'en','packages/theme/theme','remove_theme_confirm_message','Do you really want to remove this theme?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1978,1,'en','packages/theme/theme','remove_theme_confirm_yes','Yes, remove it!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1979,1,'en','packages/theme/theme','total_themes','Total themes','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1980,1,'en','packages/theme/theme','show_admin_bar','Show admin bar (When admin logged in, still show admin bar in website)?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1981,1,'en','packages/theme/theme','settings.title','Theme','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1982,1,'en','packages/theme/theme','settings.description','Setting for theme','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1983,1,'en','packages/theme/theme','settings.redirect_404_to_homepage','Redirect all not found requests to homepage?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1984,1,'en','packages/theme/theme','add_new','Add new','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1985,1,'en','packages/theme/theme','theme_activated_already','Theme \":name\" is activated already!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1986,1,'en','packages/theme/theme','missing_json_file','Missing file theme.json!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1987,1,'en','packages/theme/theme','theme_invalid','Theme is valid!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1988,1,'en','packages/theme/theme','published_assets_success','Publish assets for :themes successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1989,1,'en','packages/theme/theme','cannot_remove_theme','Cannot remove activated theme, please activate another theme before removing \":name\"!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1990,1,'en','packages/theme/theme','theme_deleted','Theme \":name\" has been destroyed.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1991,1,'en','packages/theme/theme','removed_assets','Remove assets of a theme :name successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1992,1,'en','packages/theme/theme','update_custom_css_success','Update custom CSS successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1993,1,'en','packages/theme/theme','update_custom_js_success','Update custom JS successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1994,1,'en','packages/theme/theme','update_custom_html_success','Update custom HTML successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1995,1,'en','packages/theme/theme','go_to_dashboard','Go to dashboard','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1996,1,'en','packages/theme/theme','custom_css_placeholder','Using Ctrl + Space to autocomplete.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1997,1,'en','packages/theme/theme','theme_option_general','General','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1998,1,'en','packages/theme/theme','theme_option_general_description','General settings','2022-11-10 21:04:49','2022-11-10 21:04:49'),(1999,1,'en','packages/theme/theme','theme_option_seo_open_graph_image','SEO default Open Graph image','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2000,1,'en','packages/theme/theme','theme_option_logo','Logo','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2001,1,'en','packages/theme/theme','theme_option_favicon','Favicon','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2002,1,'en','packages/theme/theme','folder_is_not_writeable','Cannot write files! Folder :name is not writable. Please chmod to make it writable!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2003,1,'vi','packages/theme/theme','name','Giao diện','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2004,1,'vi','packages/theme/theme','activated','Đã kích hoạt','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2005,1,'vi','packages/theme/theme','active','Kích hoạt','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2006,1,'vi','packages/theme/theme','active_success','Kích hoạt giao diện thành công!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2007,1,'vi','packages/theme/theme','author','Tác giả','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2008,1,'vi','packages/theme/theme','description','Mô tả','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2009,1,'vi','packages/theme/theme','appearance','Hiển thị','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2010,1,'vi','packages/theme/theme','theme','Giao diện','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2011,1,'vi','packages/theme/theme','theme_options','Tuỳ chọn giao diện','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2012,1,'vi','packages/theme/theme','version','Phiên bản','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2013,1,'vi','packages/theme/theme','save_changes','Lưu thay đổi','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2014,1,'vi','packages/theme/theme','developer_mode','Đang kích hoạt chế độ thử nghiệm','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2015,1,'vi','packages/theme/theme','custom_css','Tuỳ chỉnh CSS','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2016,1,'vi','packages/theme/theme','remove','Xóa','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2017,1,'vi','packages/theme/theme','remove_theme','Xóa giao diện','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2018,1,'vi','packages/theme/theme','remove_theme_confirm_message','Bạn có chắc chắn muốn xóa giao diện này?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2019,1,'vi','packages/theme/theme','remove_theme_confirm_yes','Vâng, xác nhận xóa!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2020,1,'vi','packages/theme/theme','remove_theme_success','Xóa giao diện thành công!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2021,1,'vi','packages/theme/theme','settings.description','Cài đặt giao diện','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2022,1,'vi','packages/theme/theme','settings.title','Giao diện','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2023,1,'vi','packages/theme/theme','show_admin_bar','Hiển thị admin bar (khi admin đã đăng nhập, vẫn hiển thị admin bar trên website)?','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2024,1,'vi','packages/theme/theme','total_themes','Tổng số giao diện','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2025,1,'vi','packages/theme/theme','add_new','Thêm mới','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2026,1,'en','packages/widget/global','name','Widgets','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2027,1,'en','packages/widget/global','create','New widget','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2028,1,'en','packages/widget/global','edit','Edit widget','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2029,1,'en','packages/widget/global','delete','Delete','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2030,1,'en','packages/widget/global','available','Available Widgets','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2031,1,'en','packages/widget/global','instruction','To activate a widget drag it to a sidebar or click on it. To deactivate a widget and delete its settings, drag it back.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2032,1,'en','packages/widget/global','number_tag_display','Number tags will be display','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2033,1,'en','packages/widget/global','number_post_display','Number posts will be display','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2034,1,'en','packages/widget/global','select_menu','Select Menu','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2035,1,'en','packages/widget/global','widget_text','Text','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2036,1,'en','packages/widget/global','widget_text_description','Arbitrary text or HTML.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2037,1,'en','packages/widget/global','widget_recent_post','Recent Posts','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2038,1,'en','packages/widget/global','widget_recent_post_description','Recent posts widget.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2039,1,'en','packages/widget/global','widget_custom_menu','Custom Menu','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2040,1,'en','packages/widget/global','widget_custom_menu_description','Add a custom menu to your widget area.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2041,1,'en','packages/widget/global','widget_tag','Tags','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2042,1,'en','packages/widget/global','widget_tag_description','Popular tags','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2043,1,'en','packages/widget/global','save_success','Save widget successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2044,1,'en','packages/widget/global','delete_success','Delete widget successfully!','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2045,1,'en','packages/widget/widget','name','Widgets','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2046,1,'en','packages/widget/widget','create','New widget','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2047,1,'en','packages/widget/widget','edit','Edit widget','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2048,1,'en','packages/widget/widget','delete','Delete','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2049,1,'en','packages/widget/widget','available','Available Widgets','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2050,1,'en','packages/widget/widget','instruction','To activate a widget drag it to a sidebar or click on it. To deactivate a widget and delete its settings, drag it back.','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2051,1,'en','packages/widget/widget','number_tag_display','Number tags will be display','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2052,1,'en','packages/widget/widget','number_post_display','Number posts will be display','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2053,1,'en','packages/widget/widget','select_menu','Select Menu','2022-11-10 21:04:49','2022-11-10 21:04:49'),(2054,1,'en','packages/widget/widget','widget_text','Text','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2055,1,'en','packages/widget/widget','widget_text_description','Arbitrary text or HTML.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2056,1,'en','packages/widget/widget','widget_recent_post','Recent Posts','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2057,1,'en','packages/widget/widget','widget_recent_post_description','Recent posts widget.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2058,1,'en','packages/widget/widget','widget_custom_menu','Custom Menu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2059,1,'en','packages/widget/widget','widget_custom_menu_description','Add a custom menu to your widget area.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2060,1,'en','packages/widget/widget','widget_tag','Tags','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2061,1,'en','packages/widget/widget','widget_tag_description','Popular tags','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2062,1,'en','packages/widget/widget','save_success','Save widget successfully!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2063,1,'en','packages/widget/widget','delete_success','Delete widget successfully!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2064,1,'en','packages/widget/widget','primary_sidebar_name','Primary sidebar','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2065,1,'en','packages/widget/widget','primary_sidebar_description','Primary sidebar section','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2066,1,'vi','packages/widget/global','name','Widgets','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2067,1,'vi','packages/widget/global','create','New widget','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2068,1,'vi','packages/widget/global','edit','Edit widget','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2069,1,'vi','packages/widget/global','available','Tiện ích có sẵn','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2070,1,'vi','packages/widget/global','delete','Xóa','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2071,1,'vi','packages/widget/global','instruction','Để kích hoạt tiện ích, hãy kéo nó vào sidebar hoặc nhấn vào nó. Để hủy kích hoạt tiện ích và xóa các thiết lập của tiện ích, kéo nó quay trở lại.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2072,1,'vi','packages/widget/global','number_post_display','Số bài viết sẽ hiển thị','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2073,1,'vi','packages/widget/global','number_tag_display','Số thẻ sẽ hiển thị','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2074,1,'vi','packages/widget/global','select_menu','Lựa chọn trình đơn','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2075,1,'vi','packages/widget/global','widget_custom_menu','Menu tùy chỉnh','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2076,1,'vi','packages/widget/global','widget_custom_menu_description','Thêm menu tùy chỉnh vào khu vực tiện ích của bạn','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2077,1,'vi','packages/widget/global','widget_recent_post','Bài viết gần đây','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2078,1,'vi','packages/widget/global','widget_recent_post_description','Tiện ích bài viết gần đây','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2079,1,'vi','packages/widget/global','widget_tag','Thẻ','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2080,1,'vi','packages/widget/global','widget_tag_description','Thẻ phổ biến, sử dụng nhiều','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2081,1,'vi','packages/widget/global','widget_text','Văn bản','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2082,1,'vi','packages/widget/global','widget_text_description','Văn bản tùy ý hoặc HTML.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2083,1,'vi','packages/widget/global','delete_success','Xoá tiện ích thành công','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2084,1,'vi','packages/widget/global','save_success','Lưu tiện ích thành công!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2085,1,'vi','packages/widget/widget','name','Widgets','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2086,1,'vi','packages/widget/widget','create','New widget','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2087,1,'vi','packages/widget/widget','edit','Edit widget','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2088,1,'vi','packages/widget/widget','available','Tiện ích có sẵn','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2089,1,'vi','packages/widget/widget','delete','Xóa','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2090,1,'vi','packages/widget/widget','instruction','Để kích hoạt tiện ích, hãy kéo nó vào sidebar hoặc nhấn vào nó. Để hủy kích hoạt tiện ích và xóa các thiết lập của tiện ích, kéo nó quay trở lại.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2091,1,'vi','packages/widget/widget','number_post_display','Số bài viết sẽ hiển thị','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2092,1,'vi','packages/widget/widget','number_tag_display','Số thẻ sẽ hiển thị','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2093,1,'vi','packages/widget/widget','select_menu','Lựa chọn trình đơn','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2094,1,'vi','packages/widget/widget','widget_custom_menu','Menu tùy chỉnh','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2095,1,'vi','packages/widget/widget','widget_custom_menu_description','Thêm menu tùy chỉnh vào khu vực tiện ích của bạn','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2096,1,'vi','packages/widget/widget','widget_recent_post','Bài viết gần đây','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2097,1,'vi','packages/widget/widget','widget_recent_post_description','Tiện ích bài viết gần đây','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2098,1,'vi','packages/widget/widget','widget_tag','Thẻ','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2099,1,'vi','packages/widget/widget','widget_tag_description','Thẻ phổ biến, sử dụng nhiều','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2100,1,'vi','packages/widget/widget','widget_text','Văn bản','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2101,1,'vi','packages/widget/widget','widget_text_description','Văn bản tùy ý hoặc HTML.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2102,1,'vi','packages/widget/widget','delete_success','Xoá tiện ích thành công','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2103,1,'vi','packages/widget/widget','save_success','Lưu tiện ích thành công!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2104,1,'en','plugins/ads/ads','name','Ads','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2105,1,'en','plugins/ads/ads','create','New ads','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2106,1,'en','plugins/ads/ads','edit','Edit ads','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2107,1,'en','plugins/ads/ads','location','Location','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2108,1,'en','plugins/ads/ads','url','URL','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2109,1,'en','plugins/ads/ads','expired_at','Expired at','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2110,1,'en','plugins/ads/ads','key','Key','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2111,1,'en','plugins/ads/ads','shortcode','Shortcode','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2112,1,'en','plugins/ads/ads','clicked','Clicked','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2113,1,'en','plugins/ads/ads','not_set','Not set','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2114,1,'en','plugins/ads/ads','adblock_warning','If you are using Adblock browser extension, you need to disable this extension on your site first. It may block your ads if it is enabled on your site! <br /> Tips: Image name SHOULD NOT contain some ads keywords (ad, promotion...)','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2115,1,'en','plugins/ads/ads','select_ad','Select Ad','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2116,1,'en','plugins/analytics/analytics','sessions','Sessions','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2117,1,'en','plugins/analytics/analytics','visitors','Visitors','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2118,1,'en','plugins/analytics/analytics','pageviews','Pageviews','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2119,1,'en','plugins/analytics/analytics','bounce_rate','Bounce Rate','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2120,1,'en','plugins/analytics/analytics','page_session','Pages/Session','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2121,1,'en','plugins/analytics/analytics','avg_duration','Avg. Duration','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2122,1,'en','plugins/analytics/analytics','percent_new_session','Percent new session','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2123,1,'en','plugins/analytics/analytics','new_users','New visitors','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2124,1,'en','plugins/analytics/analytics','visits','visits','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2125,1,'en','plugins/analytics/analytics','views','views','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2126,1,'en','plugins/analytics/analytics','view_id_not_specified','You must provide a valid view id. The document here: <a href=\"https://docs.botble.com/cms/master/plugin-analytics\" target=\"_blank\">https://docs.botble.com/cms/master/plugin-analytics</a>','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2127,1,'en','plugins/analytics/analytics','credential_is_not_valid','Analytics credentials is not valid. The document here: <a href=\"https://docs.botble.com/cms/master/plugin-analytics\" target=\"_blank\">https://docs.botble.com/cms/master/plugin-analytics</a>','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2128,1,'en','plugins/analytics/analytics','start_date_can_not_before_end_date','Start date :start_date cannot be after end date :end_date','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2129,1,'en','plugins/analytics/analytics','wrong_configuration','To view analytics you\'ll need to get a google analytics client id and add it to your settings. <br /> You also need JSON credential data. <br /> The document here: <a href=\"https://docs.botble.com/cms/master/plugin-analytics\" target=\"_blank\">https://docs.botble.com/cms/master/plugin-analytics</a>','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2130,1,'en','plugins/analytics/analytics','settings.title','Google Analytics','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2131,1,'en','plugins/analytics/analytics','settings.description','Config Credentials for Google Analytics','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2132,1,'en','plugins/analytics/analytics','settings.tracking_code','Tracking ID','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2133,1,'en','plugins/analytics/analytics','settings.tracking_code_placeholder','Example: GA-12586526-8','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2134,1,'en','plugins/analytics/analytics','settings.view_id','View ID','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2135,1,'en','plugins/analytics/analytics','settings.view_id_description','Google Analytics View ID','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2136,1,'en','plugins/analytics/analytics','settings.json_credential','Service Account Credentials','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2137,1,'en','plugins/analytics/analytics','settings.json_credential_description','Service Account Credentials','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2138,1,'en','plugins/analytics/analytics','widget_analytics_page','Top Most Visit Pages','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2139,1,'en','plugins/analytics/analytics','widget_analytics_browser','Top Browsers','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2140,1,'en','plugins/analytics/analytics','widget_analytics_referrer','Top Referrers','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2141,1,'en','plugins/analytics/analytics','widget_analytics_general','Site Analytics','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2142,1,'vi','plugins/analytics/analytics','avg_duration','Trung bình','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2143,1,'vi','plugins/analytics/analytics','bounce_rate','Tỉ lệ thoát','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2144,1,'vi','plugins/analytics/analytics','page_session','Trang/Phiên','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2145,1,'vi','plugins/analytics/analytics','pageviews','Lượt xem','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2146,1,'vi','plugins/analytics/analytics','sessions','Phiên','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2147,1,'vi','plugins/analytics/analytics','views','lượt xem','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2148,1,'vi','plugins/analytics/analytics','visitors','Người truy cập','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2149,1,'vi','plugins/analytics/analytics','visits','lượt ghé thăm','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2150,1,'vi','plugins/analytics/analytics','credential_is_not_valid','Thông tin cài đặt không hợp lệ. Tài liệu hướng dẫn tại đây: <a href=\"https://docs.botble.com/cms/master/plugin-analytics\" target=\"_blank\">https://docs.botble.com/cms/master/plugin-analytics</a>','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2151,1,'vi','plugins/analytics/analytics','new_users','Lượt khách mới','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2152,1,'vi','plugins/analytics/analytics','percent_new_session','Tỉ lệ khách mới','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2153,1,'vi','plugins/analytics/analytics','start_date_can_not_before_end_date','Ngày bắt đầu :start_date không thể sau ngày kết thúc :end_date','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2154,1,'vi','plugins/analytics/analytics','view_id_not_specified','Bạn phải cung cấp View ID hợp lê. Tài liệu hướng dẫn tại đây: <a href=\"https://docs.botble.com/cms/master/plugin-analytics\" target=\"_blank\">https://docs.botble.com/cms/master/plugin-analytics</a>','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2155,1,'vi','plugins/analytics/analytics','wrong_configuration','Để xem dữ liệu thống kê Google Analytics, bạn cần lấy thông tin Client ID và thêm nó vào trong phần cài đặt. Bạn cũng cần thông tin xác thực dạng JSON. Tài liệu hướng dẫn tại đây: <a href=\"https://docs.botble.com/cms/master/plugin-analytics\" target=\"_blank\">https://docs.botble.com/cms/master/plugin-analytics</a>','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2156,1,'vi','plugins/analytics/analytics','settings.title','Google Analytics','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2157,1,'vi','plugins/analytics/analytics','settings.description','Config Credentials for Google Analytics','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2158,1,'vi','plugins/analytics/analytics','settings.tracking_code','Tracking Code','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2159,1,'vi','plugins/analytics/analytics','settings.tracking_code_placeholder','Example: GA-12586526-8','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2160,1,'vi','plugins/analytics/analytics','settings.view_id','View ID','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2161,1,'vi','plugins/analytics/analytics','settings.view_id_description','Google Analytics View ID','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2162,1,'vi','plugins/analytics/analytics','settings.json_credential','Service Account Credentials','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2163,1,'vi','plugins/analytics/analytics','settings.json_credential_description','Service Account Credentials','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2164,1,'vi','plugins/analytics/analytics','widget_analytics_browser','Trình duyệt truy cập nhiều','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2165,1,'vi','plugins/analytics/analytics','widget_analytics_general','Thống kê truy cập','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2166,1,'vi','plugins/analytics/analytics','widget_analytics_page','Trang được xem nhiều nhất','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2167,1,'vi','plugins/analytics/analytics','widget_analytics_referrer','Trang giới thiệu nhiều','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2168,1,'en','plugins/audit-log/history','name','Activities Logs','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2169,1,'en','plugins/audit-log/history','created','created','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2170,1,'en','plugins/audit-log/history','updated','updated','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2171,1,'en','plugins/audit-log/history','deleted','deleted','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2172,1,'en','plugins/audit-log/history','logged in','logged in','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2173,1,'en','plugins/audit-log/history','logged out','logged out','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2174,1,'en','plugins/audit-log/history','changed password','changed password','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2175,1,'en','plugins/audit-log/history','updated profile','updated profile','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2176,1,'en','plugins/audit-log/history','attached','attached','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2177,1,'en','plugins/audit-log/history','shared','shared','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2178,1,'en','plugins/audit-log/history','to the system','to the system','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2179,1,'en','plugins/audit-log/history','of the system','of the system','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2180,1,'en','plugins/audit-log/history','menu','menu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2181,1,'en','plugins/audit-log/history','post','post','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2182,1,'en','plugins/audit-log/history','page','page','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2183,1,'en','plugins/audit-log/history','category','category','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2184,1,'en','plugins/audit-log/history','tag','tag','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2185,1,'en','plugins/audit-log/history','user','user','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2186,1,'en','plugins/audit-log/history','contact','contact','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2187,1,'en','plugins/audit-log/history','backup','backup','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2188,1,'en','plugins/audit-log/history','custom-field','custom field','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2189,1,'en','plugins/audit-log/history','widget_audit_logs','Activities Logs','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2190,1,'en','plugins/audit-log/history','action','Action','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2191,1,'en','plugins/audit-log/history','user_agent','User Agent','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2192,1,'en','plugins/audit-log/history','system','System','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2193,1,'en','plugins/audit-log/history','delete_all','Delete all records','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2194,1,'vi','plugins/audit-log/history','name','Lịch sử hoạt động','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2195,1,'vi','plugins/audit-log/history','created',' đã tạo','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2196,1,'vi','plugins/audit-log/history','updated',' đã cập nhật','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2197,1,'vi','plugins/audit-log/history','deleted',' đã xóa','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2198,1,'vi','plugins/audit-log/history','attached','đính kèm','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2199,1,'vi','plugins/audit-log/history','backup','sao lưu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2200,1,'vi','plugins/audit-log/history','category','danh mục','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2201,1,'vi','plugins/audit-log/history','changed password','thay đổi mật khẩu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2202,1,'vi','plugins/audit-log/history','contact','liên hệ','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2203,1,'vi','plugins/audit-log/history','custom-field','khung mở rộng','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2204,1,'vi','plugins/audit-log/history','logged in','đăng nhập','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2205,1,'vi','plugins/audit-log/history','logged out','đăng xuất','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2206,1,'vi','plugins/audit-log/history','menu','trình đơn','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2207,1,'vi','plugins/audit-log/history','of the system','khỏi hệ thống','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2208,1,'vi','plugins/audit-log/history','page','trang','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2209,1,'vi','plugins/audit-log/history','post','bài viết','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2210,1,'vi','plugins/audit-log/history','shared','đã chia sẻ','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2211,1,'vi','plugins/audit-log/history','tag','thẻ','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2212,1,'vi','plugins/audit-log/history','to the system','vào hệ thống','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2213,1,'vi','plugins/audit-log/history','updated profile','cập nhật tài khoản','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2214,1,'vi','plugins/audit-log/history','user','thành viên','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2215,1,'vi','plugins/audit-log/history','widget_audit_logs','Lịch sử hoạt động','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2216,1,'vi','plugins/audit-log/history','system','Hệ thống','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2217,1,'vi','plugins/audit-log/history','action','Hành động','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2218,1,'vi','plugins/audit-log/history','delete_all','Xóa tất cả bản ghi','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2219,1,'vi','plugins/audit-log/history','user_agent','User Agent','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2220,1,'en','plugins/backup/backup','name','Backup','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2221,1,'en','plugins/backup/backup','backup_description','Backup database and uploads folder.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2222,1,'en','plugins/backup/backup','create_backup_success','Created backup successfully!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2223,1,'en','plugins/backup/backup','delete_backup_success','Delete backup successfully!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2224,1,'en','plugins/backup/backup','restore_backup_success','Restore backup successfully!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2225,1,'en','plugins/backup/backup','generate_btn','Generate backup','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2226,1,'en','plugins/backup/backup','create','Create a backup','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2227,1,'en','plugins/backup/backup','restore','Restore a backup','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2228,1,'en','plugins/backup/backup','create_btn','Create','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2229,1,'en','plugins/backup/backup','restore_btn','Restore','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2230,1,'en','plugins/backup/backup','restore_confirm_msg','Do you really want to restore this revision?','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2231,1,'en','plugins/backup/backup','download_uploads_folder','Download backup of uploads folder','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2232,1,'en','plugins/backup/backup','download_database','Download backup of database','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2233,1,'en','plugins/backup/backup','restore_tooltip','Restore this backup','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2234,1,'en','plugins/backup/backup','demo_alert','Hi guest, if you see demo site is destroyed, please help me <a href=\":link\">go here</a> and restore demo site to the latest revision! Thank you so much!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2235,1,'en','plugins/backup/backup','menu_name','Backups','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2236,1,'en','plugins/backup/backup','size','Size','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2237,1,'en','plugins/backup/backup','no_backups','There is no backup now!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2238,1,'en','plugins/backup/backup','proc_open_disabled_error','Function <strong>proc_open()</strong> has been disabled so the system cannot backup the database. Please contact your hosting provider to enable it.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2239,1,'en','plugins/backup/backup','database_backup_not_existed','Backup database is not existed!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2240,1,'en','plugins/backup/backup','uploads_folder_backup_not_existed','Backup uploads folder is not existed!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2241,1,'en','plugins/backup/backup','important_message1','This is a simple backup feature, it is a solution for you if your site has < 1GB data and can be used for quickly backup your site.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2242,1,'en','plugins/backup/backup','important_message2','If you have more than 1GB images/files in local storage, you should use backup feature of your hosting or VPS.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2243,1,'en','plugins/backup/backup','important_message3','To backup your database, function <strong>proc_open()</strong> or <strong>system()</strong> must be enabled. Contact your hosting provider to enable it if it is disabled.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2244,1,'en','plugins/backup/backup','important_message4','It is not a full backup, it is just back up uploaded files and your database.','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2245,1,'en','plugins/backup/backup','cannot_restore_database','Cannot restore database. The database backup is missing!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2246,1,'vi','plugins/backup/backup','backup_description','Sao lưu cơ sở dữ liệu và thư mục /uploads','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2247,1,'vi','plugins/backup/backup','create','Tạo bản sao lưu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2248,1,'vi','plugins/backup/backup','create_backup_success','Tạo bản sao lưu thành công!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2249,1,'vi','plugins/backup/backup','create_btn','Tạo','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2250,1,'vi','plugins/backup/backup','delete_backup_success','Xóa bản sao lưu thành công!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2251,1,'vi','plugins/backup/backup','generate_btn','Tạo sao lưu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2252,1,'vi','plugins/backup/backup','name','Sao lưu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2253,1,'vi','plugins/backup/backup','restore','Khôi phục bản sao lưu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2254,1,'vi','plugins/backup/backup','restore_backup_success','Khôi phục bản sao lưu thành công','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2255,1,'vi','plugins/backup/backup','restore_btn','Khôi phục','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2256,1,'vi','plugins/backup/backup','restore_confirm_msg','Bạn có chắc chắn muốn khôi phục hệ thống về thời điểm tạo bản sao lưu này?','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2257,1,'vi','plugins/backup/backup','restore_tooltip','Khôi phục bản sao lưu này','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2258,1,'vi','plugins/backup/backup','download_database','Tải về bản sao lưu CSDL','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2259,1,'vi','plugins/backup/backup','download_uploads_folder','Tải về bản sao lưu thư mục uploads','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2260,1,'vi','plugins/backup/backup','menu_name','Sao lưu','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2261,1,'vi','plugins/backup/backup','demo_alert','Chào khách, nếu bạn thấy trang demo bị phá hoại, hãy tới <a href=\":link\">trang sao lưu</a> và khôi phục bản sao lưu cuối cùng. Cảm ơn bạn nhiều!','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2262,1,'en','plugins/blog/base','menu_name','Blog','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2263,1,'en','plugins/blog/base','blog_page','Blog Page','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2264,1,'en','plugins/blog/base','select','-- Select --','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2265,1,'en','plugins/blog/base','blog_page_id','Blog page','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2266,1,'en','plugins/blog/base','number_posts_per_page','Number posts per page','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2267,1,'en','plugins/blog/base','write_some_tags','Write some tags','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2268,1,'en','plugins/blog/base','short_code_name','Blog posts','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2269,1,'en','plugins/blog/base','short_code_description','Add blog posts','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2270,1,'en','plugins/blog/base','number_posts_per_page_in_category','Number of posts per page in a category','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2271,1,'en','plugins/blog/base','number_posts_per_page_in_tag','Number of posts per page in a tag','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2272,1,'en','plugins/blog/base','settings.title','Blog','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2273,1,'en','plugins/blog/base','settings.description','Settings for Blog','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2274,1,'en','plugins/blog/base','settings.enable_blog_post_schema','Enable Blog Post Schema?','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2275,1,'en','plugins/blog/base','settings.enable_blog_post_schema_description','Learn more: https://schema.org/Article','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2276,1,'en','plugins/blog/base','settings.schema_type','Schema type','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2277,1,'en','plugins/blog/categories','create','Create new category','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2278,1,'en','plugins/blog/categories','edit','Edit category','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2279,1,'en','plugins/blog/categories','menu','Categories','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2280,1,'en','plugins/blog/categories','edit_this_category','Edit this category','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2281,1,'en','plugins/blog/categories','menu_name','Categories','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2282,1,'en','plugins/blog/categories','none','None','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2283,1,'en','plugins/blog/categories','total_posts','Total posts: :total','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2284,1,'en','plugins/blog/member','dob','Born :date','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2285,1,'en','plugins/blog/member','draft_posts','Draft Posts','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2286,1,'en','plugins/blog/member','pending_posts','Pending Posts','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2287,1,'en','plugins/blog/member','published_posts','Published Posts','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2288,1,'en','plugins/blog/member','posts','Posts','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2289,1,'en','plugins/blog/member','write_post','Write a post','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2290,1,'en','plugins/blog/posts','create','Create new post','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2291,1,'en','plugins/blog/posts','edit','Edit post','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2292,1,'en','plugins/blog/posts','form.name','Name','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2293,1,'en','plugins/blog/posts','form.name_placeholder','Post\'s name (Maximum :c characters)','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2294,1,'en','plugins/blog/posts','form.description','Description','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2295,1,'en','plugins/blog/posts','form.description_placeholder','Short description for post (Maximum :c characters)','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2296,1,'en','plugins/blog/posts','form.categories','Categories','2022-11-10 21:04:50','2022-11-10 21:04:50'),(2297,1,'en','plugins/blog/posts','form.tags','Tags','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2298,1,'en','plugins/blog/posts','form.tags_placeholder','Tags','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2299,1,'en','plugins/blog/posts','form.content','Content','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2300,1,'en','plugins/blog/posts','form.is_featured','Is featured?','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2301,1,'en','plugins/blog/posts','form.note','Note content','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2302,1,'en','plugins/blog/posts','form.format_type','Format','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2303,1,'en','plugins/blog/posts','cannot_delete','Post could not be deleted','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2304,1,'en','plugins/blog/posts','post_deleted','Post deleted','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2305,1,'en','plugins/blog/posts','posts','Posts','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2306,1,'en','plugins/blog/posts','post','Post','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2307,1,'en','plugins/blog/posts','edit_this_post','Edit this post','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2308,1,'en','plugins/blog/posts','no_new_post_now','There is no new post now!','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2309,1,'en','plugins/blog/posts','menu_name','Posts','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2310,1,'en','plugins/blog/posts','widget_posts_recent','Recent Posts','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2311,1,'en','plugins/blog/posts','categories','Categories','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2312,1,'en','plugins/blog/posts','category','Category','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2313,1,'en','plugins/blog/posts','author','Author','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2314,1,'en','plugins/blog/settings','select','-- Select --','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2315,1,'en','plugins/blog/settings','blog_page_id','Blog page','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2316,1,'en','plugins/blog/tags','form.name','Name','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2317,1,'en','plugins/blog/tags','form.name_placeholder','Tag\'s name (Maximum 120 characters)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2318,1,'en','plugins/blog/tags','form.description','Description','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2319,1,'en','plugins/blog/tags','form.description_placeholder','Short description for tag (Maximum 400 characters)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2320,1,'en','plugins/blog/tags','form.categories','Categories','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2321,1,'en','plugins/blog/tags','notices.no_select','Please select at least one tag to take this action!','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2322,1,'en','plugins/blog/tags','create','Create new tag','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2323,1,'en','plugins/blog/tags','edit','Edit tag','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2324,1,'en','plugins/blog/tags','cannot_delete','Tag could not be deleted','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2325,1,'en','plugins/blog/tags','deleted','Tag deleted','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2326,1,'en','plugins/blog/tags','menu','Tags','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2327,1,'en','plugins/blog/tags','edit_this_tag','Edit this tag','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2328,1,'en','plugins/blog/tags','menu_name','Tags','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2329,1,'vi','plugins/blog/base','menu_name','Blog','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2330,1,'vi','plugins/blog/base','blog_page','Trang Blog','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2331,1,'vi','plugins/blog/base','select','-- Lựa chọn --','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2332,1,'vi','plugins/blog/base','blog_page_id','Trang Blog','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2333,1,'vi','plugins/blog/categories','create','Thêm danh mục mới','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2334,1,'vi','plugins/blog/categories','edit','Sửa danh mục','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2335,1,'vi','plugins/blog/categories','menu','Danh mục','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2336,1,'vi','plugins/blog/categories','edit_this_category','Sửa danh mục này','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2337,1,'vi','plugins/blog/categories','menu_name','Danh mục','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2338,1,'vi','plugins/blog/categories','none','Không','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2339,1,'vi','plugins/blog/member','dob','Born :date','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2340,1,'vi','plugins/blog/member','draft_posts','Draft Posts','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2341,1,'vi','plugins/blog/member','pending_posts','Pending Posts','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2342,1,'vi','plugins/blog/member','published_posts','Published Posts','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2343,1,'vi','plugins/blog/member','posts','Posts','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2344,1,'vi','plugins/blog/member','write_post','Write a post','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2345,1,'vi','plugins/blog/posts','create','Thêm bài viết','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2346,1,'vi','plugins/blog/posts','edit','Sửa bài viết','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2347,1,'vi','plugins/blog/posts','form.name','Tên','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2348,1,'vi','plugins/blog/posts','form.name_placeholder','Tên bài viết (Tối đa 120 kí tự)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2349,1,'vi','plugins/blog/posts','form.description','Mô tả','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2350,1,'vi','plugins/blog/posts','form.description_placeholder','Mô tả ngắn cho bài viết (Tối đa 400 kí tự)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2351,1,'vi','plugins/blog/posts','form.categories','Chuyên mục','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2352,1,'vi','plugins/blog/posts','form.tags','Từ khóa','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2353,1,'vi','plugins/blog/posts','form.tags_placeholder','Thêm từ khóa','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2354,1,'vi','plugins/blog/posts','form.content','Nội dung','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2355,1,'vi','plugins/blog/posts','form.is_featured','Bài viết nổi bật?','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2356,1,'vi','plugins/blog/posts','form.note','Nội dung ghi chú','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2357,1,'vi','plugins/blog/posts','form.format_type','Định dạng','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2358,1,'vi','plugins/blog/posts','post_deleted','Xóa bài viết thành công','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2359,1,'vi','plugins/blog/posts','cannot_delete','Không thể xóa bài viết','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2360,1,'vi','plugins/blog/posts','menu_name','Bài viết','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2361,1,'vi','plugins/blog/posts','edit_this_post','Sửa bài viết này','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2362,1,'vi','plugins/blog/posts','no_new_post_now','Hiện tại không có bài viết mới!','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2363,1,'vi','plugins/blog/posts','posts','Bài viết','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2364,1,'vi','plugins/blog/posts','post','Bài viết','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2365,1,'vi','plugins/blog/posts','widget_posts_recent','Bài viết gần đây','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2366,1,'vi','plugins/blog/posts','author','Tác giả','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2367,1,'vi','plugins/blog/posts','categories','Danh mục','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2368,1,'vi','plugins/blog/posts','category','Danh mục','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2369,1,'vi','plugins/blog/tags','create','Thêm thẻ mới','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2370,1,'vi','plugins/blog/tags','edit','Sửa thẻ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2371,1,'vi','plugins/blog/tags','form.name','Tên','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2372,1,'vi','plugins/blog/tags','form.name_placeholder','Tên thẻ (Tối đa 120 kí tự)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2373,1,'vi','plugins/blog/tags','form.description','Mô tả','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2374,1,'vi','plugins/blog/tags','form.description_placeholder','Mô tả ngắn cho tag (Tối đa 400 kí tự)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2375,1,'vi','plugins/blog/tags','form.categories','Chuyên mục','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2376,1,'vi','plugins/blog/tags','notices.no_select','Chọn ít nhất 1 bài viết để thực hiện hành động này!','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2377,1,'vi','plugins/blog/tags','cannot_delete','Không thể xóa thẻ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2378,1,'vi','plugins/blog/tags','deleted','Xóa thẻ thành công','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2379,1,'vi','plugins/blog/tags','menu_name','Thẻ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2380,1,'vi','plugins/blog/tags','edit_this_tag','Sửa thẻ này','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2381,1,'vi','plugins/blog/tags','menu','Thẻ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2382,1,'en','plugins/captcha/captcha','settings.title','Captcha','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2383,1,'en','plugins/captcha/captcha','settings.description','Settings for Google Captcha','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2384,1,'en','plugins/captcha/captcha','settings.captcha_site_key','Captcha Site Key','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2385,1,'en','plugins/captcha/captcha','settings.captcha_secret','Captcha Secret','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2386,1,'en','plugins/captcha/captcha','settings.enable_captcha','Enable Captcha?','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2387,1,'en','plugins/captcha/captcha','settings.helper','Go here to get credentials https://www.google.com/recaptcha/admin#list.','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2388,1,'en','plugins/captcha/captcha','settings.hide_badge','Hide recaptcha badge (for v3)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2389,1,'en','plugins/captcha/captcha','settings.type','Type','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2390,1,'en','plugins/captcha/captcha','settings.v2_description','V2 (Verify requests with a challenge)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2391,1,'en','plugins/captcha/captcha','settings.v3_description','V3 (Verify requests with a score)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2392,1,'en','plugins/captcha/captcha','failed_validate','Failed to validate the captcha.','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2393,1,'en','plugins/captcha/captcha','numbers.0','Zero','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2394,1,'en','plugins/captcha/captcha','numbers.1','One','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2395,1,'en','plugins/captcha/captcha','numbers.2','Two','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2396,1,'en','plugins/captcha/captcha','numbers.3','Three','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2397,1,'en','plugins/captcha/captcha','numbers.4','Four','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2398,1,'en','plugins/captcha/captcha','numbers.5','Five','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2399,1,'en','plugins/captcha/captcha','numbers.6','Six','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2400,1,'en','plugins/captcha/captcha','numbers.7','Seven','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2401,1,'en','plugins/captcha/captcha','numbers.8','Eight','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2402,1,'en','plugins/captcha/captcha','numbers.9','Nine','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2403,1,'en','plugins/captcha/captcha','numbers.10','Ten','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2404,1,'en','plugins/captcha/captcha','numbers.11','Eleven','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2405,1,'en','plugins/captcha/captcha','numbers.12','Twelve','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2406,1,'en','plugins/captcha/captcha','operands.+','plus','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2407,1,'en','plugins/captcha/captcha','operands.-','minus','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2408,1,'en','plugins/captcha/captcha','operands.*','times','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2409,1,'en','plugins/captcha/captcha','operands./','divided by','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2410,1,'vi','plugins/captcha/captcha','settings.title','Captcha','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2411,1,'vi','plugins/captcha/captcha','settings.description','Cài đặt cho Google Captcha','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2412,1,'vi','plugins/captcha/captcha','settings.captcha_site_key','Captcha Site Key','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2413,1,'vi','plugins/captcha/captcha','settings.captcha_secret','Captcha Secret','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2414,1,'vi','plugins/captcha/captcha','settings.enable_captcha','Bật Captcha?','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2415,1,'vi','plugins/captcha/captcha','settings.helper','Truy cập https://www.google.com/recaptcha/admin#list để lấy thông tin về Site key và Secret.','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2416,1,'en','plugins/contact/contact','menu','Contact','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2417,1,'en','plugins/contact/contact','edit','View contact','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2418,1,'en','plugins/contact/contact','tables.phone','Phone','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2419,1,'en','plugins/contact/contact','tables.email','Email','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2420,1,'en','plugins/contact/contact','tables.full_name','Full Name','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2421,1,'en','plugins/contact/contact','tables.time','Time','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2422,1,'en','plugins/contact/contact','tables.address','Address','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2423,1,'en','plugins/contact/contact','tables.subject','Subject','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2424,1,'en','plugins/contact/contact','tables.content','Content','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2425,1,'en','plugins/contact/contact','contact_information','Contact information','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2426,1,'en','plugins/contact/contact','replies','Replies','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2427,1,'en','plugins/contact/contact','email.header','Email','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2428,1,'en','plugins/contact/contact','email.title','New contact from your site','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2429,1,'en','plugins/contact/contact','form.name.required','Name is required','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2430,1,'en','plugins/contact/contact','form.email.required','Email is required','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2431,1,'en','plugins/contact/contact','form.email.email','The email address is not valid','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2432,1,'en','plugins/contact/contact','form.content.required','Content is required','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2433,1,'en','plugins/contact/contact','contact_sent_from','This contact information sent from','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2434,1,'en','plugins/contact/contact','sender','Sender','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2435,1,'en','plugins/contact/contact','sender_email','Email','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2436,1,'en','plugins/contact/contact','sender_address','Address','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2437,1,'en','plugins/contact/contact','sender_phone','Phone','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2438,1,'en','plugins/contact/contact','message_content','Message content','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2439,1,'en','plugins/contact/contact','sent_from','Email sent from','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2440,1,'en','plugins/contact/contact','form_name','Name','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2441,1,'en','plugins/contact/contact','form_email','Email','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2442,1,'en','plugins/contact/contact','form_address','Address','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2443,1,'en','plugins/contact/contact','form_subject','Subject','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2444,1,'en','plugins/contact/contact','form_phone','Phone','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2445,1,'en','plugins/contact/contact','form_message','Message','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2446,1,'en','plugins/contact/contact','required_field','The field with (<span style=\"color: red\">*</span>) is required.','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2447,1,'en','plugins/contact/contact','send_btn','Send message','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2448,1,'en','plugins/contact/contact','new_msg_notice','You have <span class=\"bold\">:count</span> New Messages','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2449,1,'en','plugins/contact/contact','view_all','View all','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2450,1,'en','plugins/contact/contact','statuses.read','Read','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2451,1,'en','plugins/contact/contact','statuses.unread','Unread','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2452,1,'en','plugins/contact/contact','phone','Phone','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2453,1,'en','plugins/contact/contact','address','Address','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2454,1,'en','plugins/contact/contact','message','Message','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2455,1,'en','plugins/contact/contact','settings.email.title','Contact','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2456,1,'en','plugins/contact/contact','settings.email.description','Contact email configuration','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2457,1,'en','plugins/contact/contact','settings.email.templates.notice_title','Send notice to administrator','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2458,1,'en','plugins/contact/contact','settings.email.templates.notice_description','Email template to send notice to administrator when system get new contact','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2459,1,'en','plugins/contact/contact','settings.title','Contact','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2460,1,'en','plugins/contact/contact','settings.description','Settings for contact plugin','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2461,1,'en','plugins/contact/contact','settings.blacklist_keywords','Blacklist keywords','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2462,1,'en','plugins/contact/contact','settings.blacklist_keywords_placeholder','keywords...','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2463,1,'en','plugins/contact/contact','settings.blacklist_keywords_helper','Blacklist contact requests if it includes those keywords in the content field (separate by comma).','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2464,1,'en','plugins/contact/contact','settings.blacklist_email_domains','Blacklist email domains','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2465,1,'en','plugins/contact/contact','settings.blacklist_email_domains_placeholder','domain...','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2466,1,'en','plugins/contact/contact','settings.blacklist_email_domains_helper','Blacklist contact requests if the email domain is in blacklist domains (separate by comma).','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2467,1,'en','plugins/contact/contact','settings.enable_math_captcha','Enable math captcha?','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2468,1,'en','plugins/contact/contact','no_reply','No reply yet!','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2469,1,'en','plugins/contact/contact','reply','Reply','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2470,1,'en','plugins/contact/contact','send','Send','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2471,1,'en','plugins/contact/contact','shortcode_name','Contact form','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2472,1,'en','plugins/contact/contact','shortcode_description','Add a contact form','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2473,1,'en','plugins/contact/contact','shortcode_content_description','Add shortcode [contact-form][/contact-form] to editor?','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2474,1,'en','plugins/contact/contact','message_sent_success','Message sent successfully!','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2475,1,'vi','plugins/contact/contact','menu','Liên hệ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2476,1,'vi','plugins/contact/contact','edit','Xem liên hệ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2477,1,'vi','plugins/contact/contact','tables.phone','Điện thoại','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2478,1,'vi','plugins/contact/contact','tables.email','Email','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2479,1,'vi','plugins/contact/contact','tables.full_name','Họ tên','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2480,1,'vi','plugins/contact/contact','tables.time','Thời gian','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2481,1,'vi','plugins/contact/contact','tables.address','Địa địa chỉ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2482,1,'vi','plugins/contact/contact','tables.subject','Tiêu đề','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2483,1,'vi','plugins/contact/contact','tables.content','Nội dung','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2484,1,'vi','plugins/contact/contact','contact_information','Thông tin liên hệ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2485,1,'vi','plugins/contact/contact','email.title','Thông tin liên hệ mới','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2486,1,'vi','plugins/contact/contact','email.header','Email','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2487,1,'vi','plugins/contact/contact','form.name.required','Tên là bắt buộc','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2488,1,'vi','plugins/contact/contact','form.email.required','Email là bắt buộc','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2489,1,'vi','plugins/contact/contact','form.email.email','Địa chỉ email không hợp lệ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2490,1,'vi','plugins/contact/contact','form.content.required','Nội dung là bắt buộc','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2491,1,'vi','plugins/contact/contact','contact_sent_from','Liên hệ này được gửi từ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2492,1,'vi','plugins/contact/contact','form_address','Địa chỉ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2493,1,'vi','plugins/contact/contact','form_email','Thư điện tử','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2494,1,'vi','plugins/contact/contact','form_message','Thông điệp','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2495,1,'vi','plugins/contact/contact','form_name','Họ tên','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2496,1,'vi','plugins/contact/contact','form_phone','Số điện thoại','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2497,1,'vi','plugins/contact/contact','message_content','Nội dung thông điệp','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2498,1,'vi','plugins/contact/contact','required_field','Những trường có dấu (<span style=\"color: red\">*</span>) là bắt buộc.','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2499,1,'vi','plugins/contact/contact','send_btn','Gửi tin nhắn','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2500,1,'vi','plugins/contact/contact','sender','Người gửi','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2501,1,'vi','plugins/contact/contact','sender_address','Địa chỉ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2502,1,'vi','plugins/contact/contact','sender_email','Thư điện tử','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2503,1,'vi','plugins/contact/contact','sender_phone','Số điện thoại','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2504,1,'vi','plugins/contact/contact','sent_from','Thư được gửi từ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2505,1,'vi','plugins/contact/contact','address','Địa chỉ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2506,1,'vi','plugins/contact/contact','message','Liên hệ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2507,1,'vi','plugins/contact/contact','new_msg_notice','Bạn có <span class=\"bold\">:count</span> tin nhắn mới','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2508,1,'vi','plugins/contact/contact','phone','Điện thoại','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2509,1,'vi','plugins/contact/contact','statuses.read','Đã đọc','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2510,1,'vi','plugins/contact/contact','statuses.unread','Chưa đọc','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2511,1,'vi','plugins/contact/contact','view_all','Xem tất cả','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2512,1,'vi','plugins/contact/contact','settings.email.title','Liên hệ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2513,1,'vi','plugins/contact/contact','settings.email.description','Cấu hình thông tin cho mục liên hệ','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2514,1,'vi','plugins/contact/contact','settings.email.templates.notice_title','Thông báo tới admin','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2515,1,'vi','plugins/contact/contact','settings.email.templates.notice_description','Mẫu nội dung email gửi tới admin khi có liên hệ mới','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2516,1,'vi','plugins/contact/contact','replies','Trả lời','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2517,1,'vi','plugins/contact/contact','form_subject','Tiêu đề','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2518,1,'en','plugins/cookie-consent/cookie-consent','theme_options.name','Cookie Consent','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2519,1,'en','plugins/cookie-consent/cookie-consent','theme_options.description','Cookie consent settings','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2520,1,'en','plugins/cookie-consent/cookie-consent','theme_options.enable','Enable cookie consent?','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2521,1,'en','plugins/cookie-consent/cookie-consent','theme_options.message','Message','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2522,1,'en','plugins/cookie-consent/cookie-consent','theme_options.button_text','Button text','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2523,1,'en','plugins/cookie-consent/cookie-consent','theme_options.max_width','Max width (px)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2524,1,'en','plugins/cookie-consent/cookie-consent','theme_options.background_color','Background color','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2525,1,'en','plugins/cookie-consent/cookie-consent','theme_options.text_color','Text color','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2526,1,'en','plugins/cookie-consent/cookie-consent','theme_options.learn_more_url','Learn more URL','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2527,1,'en','plugins/cookie-consent/cookie-consent','theme_options.learn_more_text','Learn more text','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2528,1,'en','plugins/cookie-consent/cookie-consent','theme_options.style','Style','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2529,1,'en','plugins/cookie-consent/cookie-consent','theme_options.full_width','Full width','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2530,1,'en','plugins/cookie-consent/cookie-consent','theme_options.minimal','Minimal','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2531,1,'en','plugins/cookie-consent/cookie-consent','message','Your experience on this site will be improved by allowing cookies.','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2532,1,'en','plugins/cookie-consent/cookie-consent','button_text','Allow cookies','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2533,1,'en','plugins/ecommerce/brands','name','Brands','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2534,1,'en','plugins/ecommerce/brands','create','New brand','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2535,1,'en','plugins/ecommerce/brands','edit','Edit brand','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2536,1,'en','plugins/ecommerce/brands','form.name','Name','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2537,1,'en','plugins/ecommerce/brands','form.name_placeholder','Brand\'s name (Maximum 255 characters)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2538,1,'en','plugins/ecommerce/brands','form.description','Description','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2539,1,'en','plugins/ecommerce/brands','form.description_placeholder','Short description for brand (Maximum 400 characters)','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2540,1,'en','plugins/ecommerce/brands','form.website','Website','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2541,1,'en','plugins/ecommerce/brands','form.logo','Logo','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2542,1,'en','plugins/ecommerce/brands','form.is_featured','Is featured','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2543,1,'en','plugins/ecommerce/brands','logo','Logo','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2544,1,'en','plugins/ecommerce/brands','website','Website','2022-11-10 21:04:51','2022-11-10 21:04:51'),(2545,1,'en','plugins/ecommerce/brands','notices.no_select','Please select at least one record to take this action!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2546,1,'en','plugins/ecommerce/brands','notices.update_success_message','Update successfully','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2547,1,'en','plugins/ecommerce/brands','cannot_delete','Brand could not be deleted','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2548,1,'en','plugins/ecommerce/brands','brand_deleted','Brand deleted','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2549,1,'en','plugins/ecommerce/brands','menu','Brands','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2550,1,'en','plugins/ecommerce/brands','no_brand','No brand','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2551,1,'en','plugins/ecommerce/brands','intro.title','Manage brands','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2552,1,'en','plugins/ecommerce/brands','intro.description','Manage product brands such as Nike, Adidas, Bitis ...','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2553,1,'en','plugins/ecommerce/brands','intro.button_text','Create brand','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2554,1,'en','plugins/ecommerce/bulk-import','name','Bulk Import','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2555,1,'en','plugins/ecommerce/bulk-import','loading_text','Importing','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2556,1,'en','plugins/ecommerce/bulk-import','imported_successfully','Imported successfully.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2557,1,'en','plugins/ecommerce/bulk-import','please_choose_the_file_mime','Please choose the file mime :types','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2558,1,'en','plugins/ecommerce/bulk-import','please_choose_the_file','Please choose the file','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2559,1,'en','plugins/ecommerce/bulk-import','start_import','Start Import','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2560,1,'en','plugins/ecommerce/bulk-import','note','Note!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2561,1,'en','plugins/ecommerce/bulk-import','warning_before_importing','If this is your first time using this feature, please read the documentation or contact the Administrator for access to the correct functionality!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2562,1,'en','plugins/ecommerce/bulk-import','results','Result: :success successes, :failed failures','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2563,1,'en','plugins/ecommerce/bulk-import','failures','Failures','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2564,1,'en','plugins/ecommerce/bulk-import','tables.import','Import','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2565,1,'en','plugins/ecommerce/bulk-import','template','Template','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2566,1,'en','plugins/ecommerce/bulk-import','rules','Rules','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2567,1,'en','plugins/ecommerce/bulk-import','choose_file_with_mime','Choose file with mime: (:types)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2568,1,'en','plugins/ecommerce/bulk-import','choose_file','Choose file','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2569,1,'en','plugins/ecommerce/bulk-import','menu','Import products','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2570,1,'en','plugins/ecommerce/bulk-import','download-csv-file','Download CSV template','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2571,1,'en','plugins/ecommerce/bulk-import','download-excel-file','Download Excel template','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2572,1,'en','plugins/ecommerce/bulk-import','downloading','Downloading...','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2573,1,'en','plugins/ecommerce/bulk-import','export.template.input_error','Input error','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2574,1,'en','plugins/ecommerce/bulk-import','export.template.number_not_allowed','Number is not allowed!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2575,1,'en','plugins/ecommerce/bulk-import','export.template.allowed_input','Allowed input','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2576,1,'en','plugins/ecommerce/bulk-import','export.template.prompt_decimal','Only numbers or decimals are accepted and greater than or equal to :min.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2577,1,'en','plugins/ecommerce/bulk-import','export.template.prompt_whole_number','Only numbers are accepted and greater than or equal to :min.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2578,1,'en','plugins/ecommerce/bulk-import','export.template.prompt_list','Please pick a value from the drop-down list.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2579,1,'en','plugins/ecommerce/bulk-import','export.template.pick_from_list','Pick from list','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2580,1,'en','plugins/ecommerce/bulk-import','export.template.value_not_in_list','Value is not in list.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2581,1,'en','plugins/ecommerce/bulk-import','import_failed_description','Import failed, please check the errors below!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2582,1,'en','plugins/ecommerce/currency','currencies','Currencies','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2583,1,'en','plugins/ecommerce/currency','setting_description','List of currencies using on website','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2584,1,'en','plugins/ecommerce/currency','name','Name','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2585,1,'en','plugins/ecommerce/currency','symbol','Symbol','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2586,1,'en','plugins/ecommerce/currency','number_of_decimals','Number of decimals','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2587,1,'en','plugins/ecommerce/currency','exchange_rate','Exchange rate','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2588,1,'en','plugins/ecommerce/currency','is_prefix_symbol','Position of symbol','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2589,1,'en','plugins/ecommerce/currency','is_default','Is default?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2590,1,'en','plugins/ecommerce/currency','remove','Remove','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2591,1,'en','plugins/ecommerce/currency','new_currency','Add a new currency','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2592,1,'en','plugins/ecommerce/currency','save_settings','Save settings','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2593,1,'en','plugins/ecommerce/currency','before_number','Before number','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2594,1,'en','plugins/ecommerce/currency','after_number','After number','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2595,1,'en','plugins/ecommerce/currency','require_at_least_one_currency','The system requires at least one currency!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2596,1,'en','plugins/ecommerce/currency','enable_auto_detect_visitor_currency','Enable auto-detect visitor currency?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2597,1,'en','plugins/ecommerce/currency','add_space_between_price_and_currency','Add a space between price and currency?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2598,1,'en','plugins/ecommerce/currency','invalid_currency_name','Invalid currency code, it must be in :currencies.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2599,1,'en','plugins/ecommerce/currency','instruction','Please check list currency code here: https://en.wikipedia.org/wiki/ISO_4217','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2600,1,'en','plugins/ecommerce/currency','code','Code','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2601,1,'en','plugins/ecommerce/customer','name','Customers','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2602,1,'en','plugins/ecommerce/customer','create','Create a customer','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2603,1,'en','plugins/ecommerce/customer','edit','Edit customer \":name\"','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2604,1,'en','plugins/ecommerce/customer','email','Email','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2605,1,'en','plugins/ecommerce/customer','email_placeholder','Ex: example@gmail.com','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2606,1,'en','plugins/ecommerce/customer','password','Password','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2607,1,'en','plugins/ecommerce/customer','change_password','Change password?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2608,1,'en','plugins/ecommerce/customer','password_confirmation','Password confirmation','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2609,1,'en','plugins/ecommerce/customer','intro.title','Manage customers','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2610,1,'en','plugins/ecommerce/customer','intro.description','When a customer buy your product(s), you will know their order histories.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2611,1,'en','plugins/ecommerce/customer','intro.button_text','Create customer','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2612,1,'en','plugins/ecommerce/customer','phone','Phone','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2613,1,'en','plugins/ecommerce/customer','phone_placeholder','Phone','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2614,1,'en','plugins/ecommerce/customer','avatar','Avatar','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2615,1,'en','plugins/ecommerce/customer','dob','Date of birth','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2616,1,'en','plugins/ecommerce/customer','statuses.activated','Activated','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2617,1,'en','plugins/ecommerce/customer','statuses.locked','Locked','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2618,1,'en','plugins/ecommerce/customer','email_verified','Email verified?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2619,1,'en','plugins/ecommerce/discount','name','Discounts','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2620,1,'en','plugins/ecommerce/discount','create','Create discount','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2621,1,'en','plugins/ecommerce/discount','invalid_coupon','This coupon is invalid or expired!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2622,1,'en','plugins/ecommerce/discount','cannot_use_same_time_with_other_discount_program','Cannot use this coupon in the same time with other discount program!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2623,1,'en','plugins/ecommerce/discount','not_used','This coupon is not used yet!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2624,1,'en','plugins/ecommerce/discount','detail','Detail','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2625,1,'en','plugins/ecommerce/discount','used','Used','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2626,1,'en','plugins/ecommerce/discount','intro.title','Manage discount/coupon code','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2627,1,'en','plugins/ecommerce/discount','intro.description','Create coupon code or promotion for your products.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2628,1,'en','plugins/ecommerce/discount','intro.button_text','Create discount','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2629,1,'en','plugins/ecommerce/discount','expired','Expired','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2630,1,'en','plugins/ecommerce/discount','discount_promotion','Discount promotion','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2631,1,'en','plugins/ecommerce/discount','can','can','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2632,1,'en','plugins/ecommerce/discount','cannot','cannot','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2633,1,'en','plugins/ecommerce/discount','use_with_promotion','be used with promotion','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2634,1,'en','plugins/ecommerce/discount','create_discount_validate_title_required_if','Please enter the name of the promotion','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2635,1,'en','plugins/ecommerce/discount','create_discount_validate_code_required_if','Please enter the promotion code','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2636,1,'en','plugins/ecommerce/discount','create_discount_validate_value_required','Amount must be greater than 0','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2637,1,'en','plugins/ecommerce/discount','create_discount_validate_target_required','No object selected for promotion','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2638,1,'en','plugins/ecommerce/discount','enums.type-options.amount','Amount - Fixed','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2639,1,'en','plugins/ecommerce/discount','enums.type-options.percentage','Discount %','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2640,1,'en','plugins/ecommerce/discount','enums.type-options.shipping','Free shipping','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2641,1,'en','plugins/ecommerce/discount','enums.type-options.same-price','Same price','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2642,1,'en','plugins/ecommerce/discount','discount','Discount','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2643,1,'en','plugins/ecommerce/discount','create_coupon_code','Create coupon code','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2644,1,'en','plugins/ecommerce/discount','create_discount_promotion','Create discount promotion','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2645,1,'en','plugins/ecommerce/discount','generate_coupon_code','Generate coupon code','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2646,1,'en','plugins/ecommerce/discount','customers_will_enter_this_coupon_code_when_they_checkout','Customers will enter this coupon code when they checkout','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2647,1,'en','plugins/ecommerce/discount','select_type_of_discount','Select type of discount','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2648,1,'en','plugins/ecommerce/discount','coupon_code','Coupon code','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2649,1,'en','plugins/ecommerce/discount','promotion','Promotion','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2650,1,'en','plugins/ecommerce/discount','can_be_used_with_promotion','Can be used with promotion','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2651,1,'en','plugins/ecommerce/discount','unlimited_coupon','Unlimited coupon','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2652,1,'en','plugins/ecommerce/discount','enter_number','Enter number','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2653,1,'en','plugins/ecommerce/discount','coupon_type','Coupon type','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2654,1,'en','plugins/ecommerce/discount','percentage_discount','Percentage discount (%)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2655,1,'en','plugins/ecommerce/discount','free_shipping','Free shipping','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2656,1,'en','plugins/ecommerce/discount','same_price','Same price','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2657,1,'en','plugins/ecommerce/discount','apply_for','apply for','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2658,1,'en','plugins/ecommerce/discount','all_orders','All orders','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2659,1,'en','plugins/ecommerce/discount','order_amount_from','Order amount from','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2660,1,'en','plugins/ecommerce/discount','product_collection','Product collection','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2661,1,'en','plugins/ecommerce/discount','product','Product','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2662,1,'en','plugins/ecommerce/discount','customer','Customer','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2663,1,'en','plugins/ecommerce/discount','variant','Variant','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2664,1,'en','plugins/ecommerce/discount','search_product','Search product','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2665,1,'en','plugins/ecommerce/discount','no_products_found','No products found!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2666,1,'en','plugins/ecommerce/discount','search_customer','Search customer','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2667,1,'en','plugins/ecommerce/discount','no_customer_found','No customer found!','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2668,1,'en','plugins/ecommerce/discount','one_time_per_order','One time per order','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2669,1,'en','plugins/ecommerce/discount','one_time_per_product_in_cart','One time per product in cart','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2670,1,'en','plugins/ecommerce/discount','number_of_products','Number of products required to apply','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2671,1,'en','plugins/ecommerce/discount','selected_products','Selected products','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2672,1,'en','plugins/ecommerce/discount','selected_customers','Selected customers','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2673,1,'en','plugins/ecommerce/discount','time','Time','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2674,1,'en','plugins/ecommerce/discount','start_date','Start date','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2675,1,'en','plugins/ecommerce/discount','end_date','End date','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2676,1,'en','plugins/ecommerce/discount','never_expired','Never expired','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2677,1,'en','plugins/ecommerce/discount','save','Save','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2678,1,'en','plugins/ecommerce/discount','enter_promotion_name','Enter promotion name','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2679,1,'en','plugins/ecommerce/discount','enter_coupon_name','Enter coupon name','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2680,1,'en','plugins/ecommerce/discount','cancel','Cancel','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2681,1,'en','plugins/ecommerce/discount','is','Is','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2682,1,'en','plugins/ecommerce/discount','when_shipping_fee_less_than','when shipping fee less than','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2683,1,'en','plugins/ecommerce/discount','minimum_order_amount_error','You are under :minimum_amount to apply the coupon, you must add :add_more more items to your cart','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2684,1,'en','plugins/ecommerce/ecommerce','settings','Settings','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2685,1,'en','plugins/ecommerce/ecommerce','name','Ecommerce','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2686,1,'en','plugins/ecommerce/ecommerce','setting.email.title','E-commerce','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2687,1,'en','plugins/ecommerce/ecommerce','setting.email.description','Ecommerce email config','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2688,1,'en','plugins/ecommerce/ecommerce','setting.email.order_confirm_subject','Subject of order confirmation email','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2689,1,'en','plugins/ecommerce/ecommerce','setting.email.order_confirm_subject_placeholder','The subject of email confirmation send to the customer','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2690,1,'en','plugins/ecommerce/ecommerce','setting.email.order_confirm_content','Content of order confirmation email','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2691,1,'en','plugins/ecommerce/ecommerce','setting.email.order_status_change_subject','Subject of email when changing order\'s status','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2692,1,'en','plugins/ecommerce/ecommerce','setting.email.order_status_change_subject_placeholder','Subject of email when changing order\'s status send to customer','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2693,1,'en','plugins/ecommerce/ecommerce','setting.email.order_status_change_content','Content of email when changing order\'s status','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2694,1,'en','plugins/ecommerce/ecommerce','setting.email.from_email','Email from','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2695,1,'en','plugins/ecommerce/ecommerce','setting.email.from_email_placeholder','Email from address to display in mail. Ex: example@gmail.com','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2696,1,'en','plugins/ecommerce/ecommerce','setting.title','Basic information','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2697,1,'en','plugins/ecommerce/ecommerce','setting.state','State','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2698,1,'en','plugins/ecommerce/ecommerce','setting.city','City','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2699,1,'en','plugins/ecommerce/ecommerce','setting.country','Country','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2700,1,'en','plugins/ecommerce/ecommerce','setting.weight_unit_gram','Gram (g)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2701,1,'en','plugins/ecommerce/ecommerce','setting.weight_unit_kilogram','Kilogram (kg)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2702,1,'en','plugins/ecommerce/ecommerce','setting.weight_unit_lb','Pound (lb)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2703,1,'en','plugins/ecommerce/ecommerce','setting.weight_unit_oz','Ounce (oz)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2704,1,'en','plugins/ecommerce/ecommerce','setting.height_unit_cm','Centimeter (cm)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2705,1,'en','plugins/ecommerce/ecommerce','setting.height_unit_m','Meter (m)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2706,1,'en','plugins/ecommerce/ecommerce','setting.height_unit_inch','Inch','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2707,1,'en','plugins/ecommerce/ecommerce','setting.store_locator_title','Store locators','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2708,1,'en','plugins/ecommerce/ecommerce','setting.store_locator_description','All the lists of your chains, main stores, branches, etc. The locations can be used to track sales and to help us configure tax rates to charge when selling products.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2709,1,'en','plugins/ecommerce/ecommerce','setting.phone','Phone','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2710,1,'en','plugins/ecommerce/ecommerce','setting.address','Address','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2711,1,'en','plugins/ecommerce/ecommerce','setting.is_primary','Primary?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2712,1,'en','plugins/ecommerce/ecommerce','setting.add_new','Add new','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2713,1,'en','plugins/ecommerce/ecommerce','setting.or','Or','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2714,1,'en','plugins/ecommerce/ecommerce','setting.change_primary_store','change default store locator','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2715,1,'en','plugins/ecommerce/ecommerce','setting.other_settings','Other settings','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2716,1,'en','plugins/ecommerce/ecommerce','setting.other_settings_description','Settings for cart, review...','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2717,1,'en','plugins/ecommerce/ecommerce','setting.enable_cart','Enable shopping cart?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2718,1,'en','plugins/ecommerce/ecommerce','setting.enable_tax','Enable tax?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2719,1,'en','plugins/ecommerce/ecommerce','setting.display_product_price_including_taxes','Display product price including taxes?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2720,1,'en','plugins/ecommerce/ecommerce','setting.enable_review','Enable review?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2721,1,'en','plugins/ecommerce/ecommerce','setting.enable_quick_buy_button','Enable quick buy button?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2722,1,'en','plugins/ecommerce/ecommerce','setting.quick_buy_target','Quick buy target page?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2723,1,'en','plugins/ecommerce/ecommerce','setting.checkout_page','Checkout page','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2724,1,'en','plugins/ecommerce/ecommerce','setting.cart_page','Cart page','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2725,1,'en','plugins/ecommerce/ecommerce','setting.add_location','Add location','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2726,1,'en','plugins/ecommerce/ecommerce','setting.edit_location','Edit location','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2727,1,'en','plugins/ecommerce/ecommerce','setting.delete_location','Delete location','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2728,1,'en','plugins/ecommerce/ecommerce','setting.change_primary_location','Change primary location','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2729,1,'en','plugins/ecommerce/ecommerce','setting.delete_location_confirmation','Are you sure you want to delete this location? This action cannot be undo.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2730,1,'en','plugins/ecommerce/ecommerce','setting.save_location','Save location','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2731,1,'en','plugins/ecommerce/ecommerce','setting.accept','Accept','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2732,1,'en','plugins/ecommerce/ecommerce','setting.select_country','Select country...','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2733,1,'en','plugins/ecommerce/ecommerce','setting.zip_code_enabled','Enable Zip Code?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2734,1,'en','plugins/ecommerce/ecommerce','setting.thousands_separator','Thousands separator','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2735,1,'en','plugins/ecommerce/ecommerce','setting.decimal_separator','Decimal separator','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2736,1,'en','plugins/ecommerce/ecommerce','setting.separator_period','Period (.)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2737,1,'en','plugins/ecommerce/ecommerce','setting.separator_comma','Comma (,)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2738,1,'en','plugins/ecommerce/ecommerce','setting.separator_space','Space ( )','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2739,1,'en','plugins/ecommerce/ecommerce','setting.available_countries','Available countries','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2740,1,'en','plugins/ecommerce/ecommerce','setting.all','All','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2741,1,'en','plugins/ecommerce/ecommerce','setting.verify_customer_email','Verify customer\'s email?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2742,1,'en','plugins/ecommerce/ecommerce','setting.minimum_order_amount','Minimum order amount to place an order (:currency).','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2743,1,'en','plugins/ecommerce/ecommerce','setting.enable_guest_checkout','Enable guest checkout?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2744,1,'en','plugins/ecommerce/ecommerce','setting.show_number_of_products','Show number of products in the product single','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2745,1,'en','plugins/ecommerce/ecommerce','setting.payment_method_cod_minimum_amount','Minimum order amount - :currency (Optional)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2746,1,'en','plugins/ecommerce/ecommerce','setting.review.max_file_size','Review max file size (MB)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2747,1,'en','plugins/ecommerce/ecommerce','setting.review.max_file_number','Review max file number','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2748,1,'en','plugins/ecommerce/ecommerce','setting.using_custom_font_for_invoice','Using custom font for invoice?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2749,1,'en','plugins/ecommerce/ecommerce','setting.invoice_font_family','Invoice font family (Only work for Latin language)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2750,1,'en','plugins/ecommerce/ecommerce','setting.enable_invoice_stamp','Enable invoice stamp?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2751,1,'en','plugins/ecommerce/ecommerce','setting.invoice_support_arabic_language','Support Arabic language in invoice?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2752,1,'en','plugins/ecommerce/ecommerce','setting.make_phone_field_at_the_checkout_optional','Make phone field at the checkout optional?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2753,1,'en','plugins/ecommerce/ecommerce','setting.disable_order_invoice_until_order_confirmed','Disable order invoice until order confirmed?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2754,1,'en','plugins/ecommerce/ecommerce','setting.vat_number','VAT number','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2755,1,'en','plugins/ecommerce/ecommerce','setting.enable_recaptcha_in_register_page','Enable Recaptcha in the registration page?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2756,1,'en','plugins/ecommerce/ecommerce','setting.enable_recaptcha_in_register_page_description','Need to setup Captcha in Admin -> Settings -> General first.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2757,1,'en','plugins/ecommerce/ecommerce','setting.show_out_of_stock_products','Show out of stock products?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2758,1,'en','plugins/ecommerce/ecommerce','setting.default_tax_rate','Default tax rate','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2759,1,'en','plugins/ecommerce/ecommerce','setting.default_tax_rate_description','Important: it will be applied if no tax selected in product.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2760,1,'en','plugins/ecommerce/ecommerce','setting.how_to_display_product_variation_images','How to display product variation images?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2761,1,'en','plugins/ecommerce/ecommerce','setting.only_variation_images','Only variation images','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2762,1,'en','plugins/ecommerce/ecommerce','setting.variation_images_and_main_product_images','Variation images + main product images','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2763,1,'en','plugins/ecommerce/ecommerce','setting.load_countries_states_cities_from_location_plugin','Load countries, states, cities from plugin location?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2764,1,'en','plugins/ecommerce/ecommerce','setting.enable_wishlist','Enable wishlist?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2765,1,'en','plugins/ecommerce/ecommerce','setting.enable_compare','Enable compare?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2766,1,'en','plugins/ecommerce/ecommerce','setting.enable_order_tracking','Enable order tracking?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2767,1,'en','plugins/ecommerce/ecommerce','setting.recently_viewed.enable','Enable customer recently viewed products?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2768,1,'en','plugins/ecommerce/ecommerce','setting.recently_viewed.max','Maximum number of customer recently viewed products','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2769,1,'en','plugins/ecommerce/ecommerce','setting.recently_viewed.max_helper','If you set 0, it will save all products.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2770,1,'en','plugins/ecommerce/ecommerce','setting.search_products','Search products','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2771,1,'en','plugins/ecommerce/ecommerce','setting.search_products_description','Config rules to search products','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2772,1,'en','plugins/ecommerce/ecommerce','setting.search_for_an_exact_phrase','Search for an exact phrase?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2773,1,'en','plugins/ecommerce/ecommerce','setting.search_products_by','Search products by:','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2774,1,'en','plugins/ecommerce/ecommerce','setting.tracking_settings','Tracking settings','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2775,1,'en','plugins/ecommerce/ecommerce','setting.tracking_settings_description','Manage tracking: UTM, Facebook, Google Tag Manager...','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2776,1,'en','plugins/ecommerce/ecommerce','setting.enable_facebook_pixel','Enable Facebook Pixel (Meta Pixel)?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2777,1,'en','plugins/ecommerce/ecommerce','setting.facebook_pixel_id','Facebook Pixel ID','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2778,1,'en','plugins/ecommerce/ecommerce','setting.facebook_pixel_helper','Go to https://developers.facebook.com/docs/meta-pixel to create Facebook Pixel.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2779,1,'en','plugins/ecommerce/ecommerce','setting.enable_google_tag_manager','Enable Google Tag Manager?','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2780,1,'en','plugins/ecommerce/ecommerce','setting.google_tag_manager_code','Google Tag Mana\n        ger code','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2781,1,'en','plugins/ecommerce/ecommerce','setting.google_tag_manager_helper','Go to https://ads.google.com/aw/conversions to create Google Ads Conversions.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2782,1,'en','plugins/ecommerce/ecommerce','setting.webhook','Webhook','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2783,1,'en','plugins/ecommerce/ecommerce','setting.webhook_description','Send webhook when order placed.','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2784,1,'en','plugins/ecommerce/ecommerce','setting.order_placed_webhook_url','Order placed webhook URL (method: POST)','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2785,1,'en','plugins/ecommerce/ecommerce','setting.return_request','Return Request','2022-11-10 21:04:52','2022-11-10 21:04:52'),(2786,1,'en','plugins/ecommerce/ecommerce','setting.return_request_description','Number of days a customer can request a return after the order is completed.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2787,1,'en','plugins/ecommerce/ecommerce','setting.returnable_days','Refundable days','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2788,1,'en','plugins/ecommerce/ecommerce','setting.billing_address_enabled','Enable billing address?','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2789,1,'en','plugins/ecommerce/ecommerce','setting.activate_custom_return_product_quantity','Activate custom return product quantity?','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2790,1,'en','plugins/ecommerce/ecommerce','setting.allow_partial_return','Allow partial return?','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2791,1,'en','plugins/ecommerce/ecommerce','setting.allow_partial_return_description','Customer can return a few products, do not need to return all products in an order.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2792,1,'en','plugins/ecommerce/ecommerce','setting.activate_custom_return_product_quantity_description','Allow customer to change the quantity of the product they want to return.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2793,1,'en','plugins/ecommerce/ecommerce','setting.digital_product','Digital product','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2794,1,'en','plugins/ecommerce/ecommerce','setting.digital_product_title','Is enabled to support the digital products?','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2795,1,'en','plugins/ecommerce/ecommerce','setting.company_settings','Company settings','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2796,1,'en','plugins/ecommerce/ecommerce','setting.company_settings_description','Settings Company information for invoicing','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2797,1,'en','plugins/ecommerce/ecommerce','setting.company_name','Company name','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2798,1,'en','plugins/ecommerce/ecommerce','setting.company_address','Company address','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2799,1,'en','plugins/ecommerce/ecommerce','setting.company_email','Company email','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2800,1,'en','plugins/ecommerce/ecommerce','setting.company_phone','Company phone','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2801,1,'en','plugins/ecommerce/ecommerce','setting.company_logo','Company logo','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2802,1,'en','plugins/ecommerce/ecommerce','setting.company_tax_id','Company tax ID','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2803,1,'en','plugins/ecommerce/ecommerce','setting.invoice_code_prefix','Invoice code prefix','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2804,1,'en','plugins/ecommerce/ecommerce','store_address','Store address','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2805,1,'en','plugins/ecommerce/ecommerce','store_phone','Store phone','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2806,1,'en','plugins/ecommerce/ecommerce','order_id','Order ID','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2807,1,'en','plugins/ecommerce/ecommerce','order_token','Order token','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2808,1,'en','plugins/ecommerce/ecommerce','customer_name','Customer name','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2809,1,'en','plugins/ecommerce/ecommerce','customer_email','Customer email','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2810,1,'en','plugins/ecommerce/ecommerce','customer_phone','Customer phone','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2811,1,'en','plugins/ecommerce/ecommerce','customer_address','Customer address','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2812,1,'en','plugins/ecommerce/ecommerce','product_list','List products in order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2813,1,'en','plugins/ecommerce/ecommerce','payment_detail','Payment detail','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2814,1,'en','plugins/ecommerce/ecommerce','shipping_method','Shipping method','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2815,1,'en','plugins/ecommerce/ecommerce','payment_method','Payment method','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2816,1,'en','plugins/ecommerce/ecommerce','standard_and_format','Standard & Format','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2817,1,'en','plugins/ecommerce/ecommerce','standard_and_format_description','Standards and formats are used to calculate things like product prices, shipping weights, and order times.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2818,1,'en','plugins/ecommerce/ecommerce','change_order_format','Edit order code format (optional)','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2819,1,'en','plugins/ecommerce/ecommerce','change_order_format_description','The default order code starts at: number. You can change the start or end string to create the order code you want, for example \"DH-: number\" or \": number-A\"','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2820,1,'en','plugins/ecommerce/ecommerce','start_with','Start with','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2821,1,'en','plugins/ecommerce/ecommerce','end_with','End with','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2822,1,'en','plugins/ecommerce/ecommerce','order_will_be_shown','Your order code will be shown','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2823,1,'en','plugins/ecommerce/ecommerce','weight_unit','Unit of weight','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2824,1,'en','plugins/ecommerce/ecommerce','height_unit','Unit length / height','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2825,1,'en','plugins/ecommerce/ecommerce','theme_options.name','Ecommerce','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2826,1,'en','plugins/ecommerce/ecommerce','theme_options.description','Theme options for Ecommerce','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2827,1,'en','plugins/ecommerce/ecommerce','theme_options.number_products_per_page','Number of products per page','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2828,1,'en','plugins/ecommerce/ecommerce','theme_options.number_of_cross_sale_product','Number of cross sale products in product detail page','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2829,1,'en','plugins/ecommerce/ecommerce','theme_options.max_price_filter','Maximum price to filter','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2830,1,'en','plugins/ecommerce/ecommerce','theme_options.logo_in_the_checkout_page','Logo in the checkout page (Default is the main logo)','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2831,1,'en','plugins/ecommerce/ecommerce','basic_settings','Basic settings','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2832,1,'en','plugins/ecommerce/ecommerce','advanced_settings','Advanced settings','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2833,1,'en','plugins/ecommerce/email','customer_new_order_title','Order confirmation','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2834,1,'en','plugins/ecommerce/email','customer_new_order_description','Send email confirmation to customer when an order placed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2835,1,'en','plugins/ecommerce/email','order_cancellation_title','Order cancellation','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2836,1,'en','plugins/ecommerce/email','order_cancellation_description','Send to custom when they cancelled order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2837,1,'en','plugins/ecommerce/email','delivery_confirmation_title','Delivering confirmation','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2838,1,'en','plugins/ecommerce/email','delivery_confirmation_description','Send to customer when order is delivering','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2839,1,'en','plugins/ecommerce/email','admin_new_order_title','Notice about new order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2840,1,'en','plugins/ecommerce/email','admin_new_order_description','Send to administrators when an order placed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2841,1,'en','plugins/ecommerce/email','order_confirmation_title','Order confirmation','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2842,1,'en','plugins/ecommerce/email','order_confirmation_description','Send to customer when they order was confirmed by admins','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2843,1,'en','plugins/ecommerce/email','payment_confirmation_title','Payment confirmation','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2844,1,'en','plugins/ecommerce/email','payment_confirmation_description','Send to customer when their payment was confirmed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2845,1,'en','plugins/ecommerce/email','order_recover_title','Incomplete order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2846,1,'en','plugins/ecommerce/email','order_recover_description','Send to custom to remind them about incomplete orders','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2847,1,'en','plugins/ecommerce/email','view_order','View order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2848,1,'en','plugins/ecommerce/email','link_go_to_our_shop','or <a href=\":link\">Go to our shop</a>','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2849,1,'en','plugins/ecommerce/email','order_number','Order number: <strong>:order_id</strong>','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2850,1,'en','plugins/ecommerce/email','order_information','Order information:','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2851,1,'en','plugins/ecommerce/email','order_return_request_title','Order return request','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2852,1,'en','plugins/ecommerce/email','order_return_request_description','Send to customer when they return order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2853,1,'en','plugins/ecommerce/export','products.name','Export products','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2854,1,'en','plugins/ecommerce/export','products.title','Export Products (CSV)','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2855,1,'en','plugins/ecommerce/export','products.total_products','Total products','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2856,1,'en','plugins/ecommerce/export','products.total_variations','Total variations','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2857,1,'en','plugins/ecommerce/export','start_export','Start export','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2858,1,'en','plugins/ecommerce/export','exporting','Exporting...','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2859,1,'en','plugins/ecommerce/export','export','Export','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2860,1,'en','plugins/ecommerce/flash-sale','name','Flash sales','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2861,1,'en','plugins/ecommerce/flash-sale','create','New flash sale','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2862,1,'en','plugins/ecommerce/flash-sale','edit','Edit flash sale','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2863,1,'en','plugins/ecommerce/flash-sale','products','Products','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2864,1,'en','plugins/ecommerce/invoice','name','Invoices','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2865,1,'en','plugins/ecommerce/invoice','create','New invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2866,1,'en','plugins/ecommerce/invoice','edit','Edit invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2867,1,'en','plugins/ecommerce/invoice','print','Print Invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2868,1,'en','plugins/ecommerce/invoice','download','Download Invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2869,1,'en','plugins/ecommerce/invoice','heading','Invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2870,1,'en','plugins/ecommerce/invoice','invoice_for_job','','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2871,1,'en','plugins/ecommerce/invoice','table.code','Code','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2872,1,'en','plugins/ecommerce/invoice','table.amount','Amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2873,1,'en','plugins/ecommerce/invoice','detail.invoice_for','Invoice For','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2874,1,'en','plugins/ecommerce/invoice','detail.invoice_to','Invoice To','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2875,1,'en','plugins/ecommerce/invoice','detail.tax_id','Tax ID','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2876,1,'en','plugins/ecommerce/invoice','detail.code','Invoice Code','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2877,1,'en','plugins/ecommerce/invoice','detail.issue_at','Issue At','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2878,1,'en','plugins/ecommerce/invoice','detail.description','Description','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2879,1,'en','plugins/ecommerce/invoice','detail.qty','Qty','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2880,1,'en','plugins/ecommerce/invoice','detail.amount','Amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2881,1,'en','plugins/ecommerce/invoice','detail.discount','Discount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2882,1,'en','plugins/ecommerce/invoice','detail.grand_total','Grand Total','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2883,1,'en','plugins/ecommerce/invoice','detail.shipping_fee','Shipping Fee','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2884,1,'en','plugins/ecommerce/invoice','detail.sub_total','Sub Total','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2885,1,'en','plugins/ecommerce/invoice','detail.tax','Tax','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2886,1,'en','plugins/ecommerce/invoice','detail.total','Total','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2887,1,'en','plugins/ecommerce/invoice','total_amount','Total Amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2888,1,'en','plugins/ecommerce/invoice','payment_info','Payment Info','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2889,1,'en','plugins/ecommerce/invoice','payment_method','Payment Method','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2890,1,'en','plugins/ecommerce/invoice','payment_status','Payment Status','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2891,1,'en','plugins/ecommerce/order','statuses.pending','Pending','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2892,1,'en','plugins/ecommerce/order','statuses.processing','Processing','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2893,1,'en','plugins/ecommerce/order','statuses.completed','Completed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2894,1,'en','plugins/ecommerce/order','statuses.canceled','Canceled','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2895,1,'en','plugins/ecommerce/order','menu','Orders','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2896,1,'en','plugins/ecommerce/order','create','Create an order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2897,1,'en','plugins/ecommerce/order','cancel_error','The order is delivering or not completed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2898,1,'en','plugins/ecommerce/order','cancel_success','You do cancel the order successful','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2899,1,'en','plugins/ecommerce/order','return_error','The order is delivering or not completed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2900,1,'en','plugins/ecommerce/order','return_success','Requested product(s) return successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2901,1,'en','plugins/ecommerce/order','incomplete_order','Incomplete orders','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2902,1,'en','plugins/ecommerce/order','order_id','Order ID','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2903,1,'en','plugins/ecommerce/order','product_id','Product ID','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2904,1,'en','plugins/ecommerce/order','customer_label','Customer','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2905,1,'en','plugins/ecommerce/order','tax_amount','Tax Amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2906,1,'en','plugins/ecommerce/order','shipping_amount','Shipping amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2907,1,'en','plugins/ecommerce/order','payment_method','Payment method','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2908,1,'en','plugins/ecommerce/order','payment_status_label','Payment status','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2909,1,'en','plugins/ecommerce/order','manage_orders','Manage orders','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2910,1,'en','plugins/ecommerce/order','order_intro_description','Once your store has orders, this is where you will process and track those orders.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2911,1,'en','plugins/ecommerce/order','create_new_order','Create a new order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2912,1,'en','plugins/ecommerce/order','manage_incomplete_orders','Manage incomplete orders','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2913,1,'en','plugins/ecommerce/order','incomplete_orders_intro_description','Incomplete order is an order created when a customer adds a product to the cart, proceeds to fill out the purchase information but does not complete the checkout process.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2914,1,'en','plugins/ecommerce/order','invoice_for_order','Invoice for order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2915,1,'en','plugins/ecommerce/order','created','Created','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2916,1,'en','plugins/ecommerce/order','invoice','Invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2917,1,'en','plugins/ecommerce/order','return','Order Return Request','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2918,1,'en','plugins/ecommerce/order','is_return','Return checkbox','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2919,1,'en','plugins/ecommerce/order','total_refund_amount','Total refund amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2920,1,'en','plugins/ecommerce/order','total_amount_can_be_refunded','Total amount can be refunded','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2921,1,'en','plugins/ecommerce/order','refund_reason','Refund reason','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2922,1,'en','plugins/ecommerce/order','products','product(s)','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2923,1,'en','plugins/ecommerce/order','default','Default','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2924,1,'en','plugins/ecommerce/order','system','System','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2925,1,'en','plugins/ecommerce/order','new_order_from','New order :order_id from :customer','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2926,1,'en','plugins/ecommerce/order','confirmation_email_was_sent_to_customer','The email confirmation was sent to customer','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2927,1,'en','plugins/ecommerce/order','address_name_required','The name field is required.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2928,1,'en','plugins/ecommerce/order','address_phone_required','The phone field is required.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2929,1,'en','plugins/ecommerce/order','address_email_required','The email field is required.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2930,1,'en','plugins/ecommerce/order','address_email_unique','The customer with that email is existed, please choose other email or login with this email!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2931,1,'en','plugins/ecommerce/order','address_state_required','The state field is required.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2932,1,'en','plugins/ecommerce/order','address_city_required','The city field is required.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2933,1,'en','plugins/ecommerce/order','address_country_required','The country field is required.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2934,1,'en','plugins/ecommerce/order','address_address_required','The address field is required.','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2935,1,'en','plugins/ecommerce/order','create_order_from_payment_page','Order was created from checkout page','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2936,1,'en','plugins/ecommerce/order','order_was_verified_by','Order was verified by %user_name%','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2937,1,'en','plugins/ecommerce/order','new_order','New order :order_id','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2938,1,'en','plugins/ecommerce/order','payment_was_confirmed_by','Payment was confirmed (amount :money) by %user_name%','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2939,1,'en','plugins/ecommerce/order','edit_order','Edit order :code','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2940,1,'en','plugins/ecommerce/order','confirm_order_success','Confirm order successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2941,1,'en','plugins/ecommerce/order','error_when_sending_email','There is an error when sending email','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2942,1,'en','plugins/ecommerce/order','sent_confirmation_email_success','Sent confirmation email successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2943,1,'en','plugins/ecommerce/order','order_was_sent_to_shipping_team','Order was sent to shipping team','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2944,1,'en','plugins/ecommerce/order','by_username','by %user_name%','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2945,1,'en','plugins/ecommerce/order','shipping_was_created_from','Shipping was created from order %order_id%','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2946,1,'en','plugins/ecommerce/order','shipping_was_canceled_success','Shipping was cancelled successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2947,1,'en','plugins/ecommerce/order','shipping_was_canceled_by','Shipping was cancelled by %user_name%','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2948,1,'en','plugins/ecommerce/order','update_shipping_address_success','Update shipping address successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2949,1,'en','plugins/ecommerce/order','order_was_canceled_by','Order was cancelled by %user_name%','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2950,1,'en','plugins/ecommerce/order','order_was_returned_by','Order was returned by %user_name%','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2951,1,'en','plugins/ecommerce/order','confirm_payment_success','Confirm payment successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2952,1,'en','plugins/ecommerce/order','refund_amount_invalid','Refund amount must be lower or equal :price','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2953,1,'en','plugins/ecommerce/order','number_of_products_invalid','Number of products refund is not valid!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2954,1,'en','plugins/ecommerce/order','cannot_found_payment_for_this_order','Cannot found payment for this order!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2955,1,'en','plugins/ecommerce/order','refund_success_with_price','Refund success :price','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2956,1,'en','plugins/ecommerce/order','refund_success','Refund successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2957,1,'en','plugins/ecommerce/order','order_is_not_existed','Order is not existed!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2958,1,'en','plugins/ecommerce/order','reorder','Reorder','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2959,1,'en','plugins/ecommerce/order','sent_email_incomplete_order_success','Sent email to remind about incomplete order successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2960,1,'en','plugins/ecommerce/order','applied_coupon_success','Applied coupon \":code\" successfully!','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2961,1,'en','plugins/ecommerce/order','new_order_notice','You have <span class=\"bold\">:count</span> New Order(s)','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2962,1,'en','plugins/ecommerce/order','view_all','View all','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2963,1,'en','plugins/ecommerce/order','cancel_order','Cancel order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2964,1,'en','plugins/ecommerce/order','order_canceled','Order canceled','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2965,1,'en','plugins/ecommerce/order','order_was_canceled_at','Order was canceled at','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2966,1,'en','plugins/ecommerce/order','return_order','Return order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2967,1,'en','plugins/ecommerce/order','order_returned','Order returned','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2968,1,'en','plugins/ecommerce/order','order_was_returned_at','Order was returned at','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2969,1,'en','plugins/ecommerce/order','completed','Completed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2970,1,'en','plugins/ecommerce/order','uncompleted','Uncompleted','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2971,1,'en','plugins/ecommerce/order','sku','SKU','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2972,1,'en','plugins/ecommerce/order','warehouse','Warehouse','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2973,1,'en','plugins/ecommerce/order','sub_amount','Sub amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2974,1,'en','plugins/ecommerce/order','coupon_code','Coupon code: \":code\"','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2975,1,'en','plugins/ecommerce/order','shipping_fee','Shipping fee','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2976,1,'en','plugins/ecommerce/order','tax','Tax','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2977,1,'en','plugins/ecommerce/order','refunded_amount','Refunded amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2978,1,'en','plugins/ecommerce/order','amount_received','The amount actually received','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2979,1,'en','plugins/ecommerce/order','download_invoice','Download invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2980,1,'en','plugins/ecommerce/order','print_invoice','Print invoice','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2981,1,'en','plugins/ecommerce/order','add_note','Add note...','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2982,1,'en','plugins/ecommerce/order','order_was_confirmed','Order was confirmed','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2983,1,'en','plugins/ecommerce/order','confirm_order','Confirm order','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2984,1,'en','plugins/ecommerce/order','confirm','Confirm','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2985,1,'en','plugins/ecommerce/order','order_was_canceled','Order was canceled','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2986,1,'en','plugins/ecommerce/order','order_was_returned','Order was returned','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2987,1,'en','plugins/ecommerce/order','pending_payment','Pending payment','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2988,1,'en','plugins/ecommerce/order','payment_was_accepted','Payment :money was accepted','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2989,1,'en','plugins/ecommerce/order','payment_was_refunded','Payment was refunded','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2990,1,'en','plugins/ecommerce/order','confirm_payment','Confirm payment','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2991,1,'en','plugins/ecommerce/order','refund','Refund','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2992,1,'en','plugins/ecommerce/order','all_products_are_not_delivered','All products are not delivered','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2993,1,'en','plugins/ecommerce/order','delivery','Delivery','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2994,1,'en','plugins/ecommerce/order','history','History','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2995,1,'en','plugins/ecommerce/order','order_number','Order number','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2996,1,'en','plugins/ecommerce/order','from','from','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2997,1,'en','plugins/ecommerce/order','status','Status','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2998,1,'en','plugins/ecommerce/order','successfully','Successfully','2022-11-10 21:04:53','2022-11-10 21:04:53'),(2999,1,'en','plugins/ecommerce/order','transaction_type','Transaction\'s type','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3000,1,'en','plugins/ecommerce/order','staff','Staff','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3001,1,'en','plugins/ecommerce/order','refund_date','Refund date','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3002,1,'en','plugins/ecommerce/order','n_a','N\\A','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3003,1,'en','plugins/ecommerce/order','payment_date','Payment date','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3004,1,'en','plugins/ecommerce/order','payment_gateway','Payment gateway','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3005,1,'en','plugins/ecommerce/order','transaction_amount','Transaction amount','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3006,1,'en','plugins/ecommerce/order','resend','Resend','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3007,1,'en','plugins/ecommerce/order','default_store','Default store','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3008,1,'en','plugins/ecommerce/order','update_address','Update address','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3009,1,'en','plugins/ecommerce/order','have_an_account_already','Have an account already','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3010,1,'en','plugins/ecommerce/order','dont_have_an_account_yet','Don\'t have an account yet','2022-11-10 21:04:53','2022-11-10 21:04:53'),(3011,1,'en','plugins/ecommerce/order','mark_payment_as_confirmed','Mark <span>:method</span> as confirmed','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3012,1,'en','plugins/ecommerce/order','resend_order_confirmation','Resend order confirmation','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3013,1,'en','plugins/ecommerce/order','resend_order_confirmation_description','Confirmation email will be sent to <strong>:email</strong>?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3014,1,'en','plugins/ecommerce/order','send','Send','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3015,1,'en','plugins/ecommerce/order','update','Update','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3016,1,'en','plugins/ecommerce/order','cancel_shipping_confirmation','Cancel shipping confirmation?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3017,1,'en','plugins/ecommerce/order','cancel_shipping_confirmation_description','Cancel shipping confirmation?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3018,1,'en','plugins/ecommerce/order','cancel_order_confirmation','Cancel order confirmation?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3019,1,'en','plugins/ecommerce/order','cancel_order_confirmation_description','Are you sure you want to cancel this order? This action cannot rollback','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3020,1,'en','plugins/ecommerce/order','return_order_confirmation','Return order confirmation?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3021,1,'en','plugins/ecommerce/order','return_order_confirmation_description','Are you sure you want to return this order? This action cannot rollback','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3022,1,'en','plugins/ecommerce/order','confirm_payment_confirmation_description','Processed by <strong>:method</strong>. Did you receive payment outside the system? This payment won\'t be saved into system and cannot be refunded','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3023,1,'en','plugins/ecommerce/order','save_note','Save note','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3024,1,'en','plugins/ecommerce/order','order_note','Order note','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3025,1,'en','plugins/ecommerce/order','order_note_placeholder','Note about order, ex: time or shipping instruction.','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3026,1,'en','plugins/ecommerce/order','order_amount','Order amount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3027,1,'en','plugins/ecommerce/order','additional_information','Additional information','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3028,1,'en','plugins/ecommerce/order','notice_about_incomplete_order','Notice about incomplete order','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3029,1,'en','plugins/ecommerce/order','notice_about_incomplete_order_description','Remind email about uncompleted order will be send to <strong>:email</strong>?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3030,1,'en','plugins/ecommerce/order','incomplete_order_description_1','An incomplete order is when a potential customer places items in their shopping cart, and goes all the way through to the payment page, but then doesn\'t complete the transaction.','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3031,1,'en','plugins/ecommerce/order','incomplete_order_description_2','If you have contacted customers and they want to continue buying, you can help them complete their order by following the link:','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3032,1,'en','plugins/ecommerce/order','send_an_email_to_recover_this_order','Send an email to customer to recover this order','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3033,1,'en','plugins/ecommerce/order','see_maps','See maps','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3034,1,'en','plugins/ecommerce/order','one_or_more_products_dont_have_enough_quantity','One or more products don\'t have enough quantity!','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3035,1,'en','plugins/ecommerce/order','cannot_send_order_recover_to_mail','The email could not be found so it can\'t send a recovery email to the customer.','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3036,1,'en','plugins/ecommerce/order','payment_info','Payment Info','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3037,1,'en','plugins/ecommerce/order','payment_method_refund_automatic','Your customer will be refunded using :method automatically.','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3038,1,'en','plugins/ecommerce/order','order','Order','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3039,1,'en','plugins/ecommerce/order','order_information','Order information','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3040,1,'en','plugins/ecommerce/order','create_a_new_product','Create a new product','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3041,1,'en','plugins/ecommerce/order','out_of_stock','Out of stock','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3042,1,'en','plugins/ecommerce/order','products_available','product(s) available','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3043,1,'en','plugins/ecommerce/order','no_products_found','No products found!','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3044,1,'en','plugins/ecommerce/order','note','Note','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3045,1,'en','plugins/ecommerce/order','note_for_order','Note for order...','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3046,1,'en','plugins/ecommerce/order','amount','Amount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3047,1,'en','plugins/ecommerce/order','add_discount','Add discount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3048,1,'en','plugins/ecommerce/order','discount','Discount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3049,1,'en','plugins/ecommerce/order','add_shipping_fee','Add shipping fee','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3050,1,'en','plugins/ecommerce/order','shipping','Shipping','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3051,1,'en','plugins/ecommerce/order','total_amount','Total amount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3052,1,'en','plugins/ecommerce/order','confirm_payment_and_create_order','Confirm payment and create order','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3053,1,'en','plugins/ecommerce/order','paid','Paid','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3054,1,'en','plugins/ecommerce/order','pay_later','Pay later','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3055,1,'en','plugins/ecommerce/order','customer_information','Customer information','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3056,1,'en','plugins/ecommerce/order','create_new_customer','Create new customer','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3057,1,'en','plugins/ecommerce/order','no_customer_found','No customer found!','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3058,1,'en','plugins/ecommerce/order','customer','Customer','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3059,1,'en','plugins/ecommerce/order','orders','order(s)','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3060,1,'en','plugins/ecommerce/order','shipping_address','Shipping Address','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3061,1,'en','plugins/ecommerce/order','billing_address','Billing Address','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3062,1,'en','plugins/ecommerce/order','see_on_maps','See on maps','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3063,1,'en','plugins/ecommerce/order','name','Name','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3064,1,'en','plugins/ecommerce/order','price','Price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3065,1,'en','plugins/ecommerce/order','sku_optional','SKU (optional)','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3066,1,'en','plugins/ecommerce/order','with_storehouse_management','With storehouse management?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3067,1,'en','plugins/ecommerce/order','quantity','Quantity','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3068,1,'en','plugins/ecommerce/order','allow_customer_checkout_when_this_product_out_of_stock','Allow customer checkout when this product out of stock?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3069,1,'en','plugins/ecommerce/order','address','Address','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3070,1,'en','plugins/ecommerce/order','phone','Phone','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3071,1,'en','plugins/ecommerce/order','country','Country','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3072,1,'en','plugins/ecommerce/order','state','State','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3073,1,'en','plugins/ecommerce/order','city','City','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3074,1,'en','plugins/ecommerce/order','zip_code','Zip code','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3075,1,'en','plugins/ecommerce/order','discount_based_on','Discount based on','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3076,1,'en','plugins/ecommerce/order','or_coupon_code','Or coupon code','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3077,1,'en','plugins/ecommerce/order','description','Description','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3078,1,'en','plugins/ecommerce/order','how_to_select_configured_shipping','How to select configured shipping?','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3079,1,'en','plugins/ecommerce/order','please_add_customer_information_with_the_complete_shipping_address_to_see_the_configured_shipping_rates','Please add customer information with the complete shipping address to see the configured shipping rates','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3080,1,'en','plugins/ecommerce/order','free_shipping','Free shipping','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3081,1,'en','plugins/ecommerce/order','custom','Custom','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3082,1,'en','plugins/ecommerce/order','email','Email','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3083,1,'en','plugins/ecommerce/order','create_order','Create order','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3084,1,'en','plugins/ecommerce/order','close','Close','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3085,1,'en','plugins/ecommerce/order','confirm_payment_is_paid_for_this_order','Confirm payment is paid for this order','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3086,1,'en','plugins/ecommerce/order','payment_status_of_the_order_is_paid_once_the_order_has_been_created_you_cannot_change_the_payment_method_or_status','Payment status of the order is Paid. Once the order has been created, you cannot change the payment method or status','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3087,1,'en','plugins/ecommerce/order','select_payment_method','Select payment method','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3088,1,'en','plugins/ecommerce/order','cash_on_delivery_cod','Cash on delivery (COD)','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3089,1,'en','plugins/ecommerce/order','bank_transfer','Bank transfer','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3090,1,'en','plugins/ecommerce/order','paid_amount','Paid amount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3091,1,'en','plugins/ecommerce/order','confirm_that_payment_for_this_order_will_be_paid_later','Confirm that payment for this order will be paid later','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3092,1,'en','plugins/ecommerce/order','payment_status_of_the_order_is_pending_once_the_order_has_been_created_you_cannot_change_the_payment_method_or_status','Payment status of the order is Pending. Once the order has been created, you cannot change the payment method or status','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3093,1,'en','plugins/ecommerce/order','pending_amount','Pending amount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3094,1,'en','plugins/ecommerce/order','update_email','Update email','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3095,1,'en','plugins/ecommerce/order','save','Save','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3096,1,'en','plugins/ecommerce/order','cancel','Cancel','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3097,1,'en','plugins/ecommerce/order','create_a_new_order','Create a new order','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3098,1,'en','plugins/ecommerce/order','search_or_create_new_product','Search or create a new product','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3099,1,'en','plugins/ecommerce/order','search_or_create_new_customer','Search or create a new customer','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3100,1,'en','plugins/ecommerce/order','discount_description','Discount description','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3101,1,'en','plugins/ecommerce/order','cant_select_out_of_stock_product','Cannot select out of stock product!','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3102,1,'en','plugins/ecommerce/order','referral','Referral','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3103,1,'en','plugins/ecommerce/order','return_order_unique','Same :attribute already exists in a previous return request.','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3104,1,'en','plugins/ecommerce/order','total_return_amount','Total return amount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3105,1,'en','plugins/ecommerce/order','change_return_order_status','Change return order status','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3106,1,'en','plugins/ecommerce/order','return_reason','Return reason','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3107,1,'en','plugins/ecommerce/order','referral_data.ip','IP','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3108,1,'en','plugins/ecommerce/order','referral_data.landing_domain','Landing domain','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3109,1,'en','plugins/ecommerce/order','referral_data.landing_page','Landing page','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3110,1,'en','plugins/ecommerce/order','referral_data.landing_params','Landing params','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3111,1,'en','plugins/ecommerce/order','referral_data.gclid','Gclid','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3112,1,'en','plugins/ecommerce/order','referral_data.fclid','Fclid','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3113,1,'en','plugins/ecommerce/order','referral_data.utm_source','UTM source','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3114,1,'en','plugins/ecommerce/order','referral_data.utm_campaign','UTM campaign','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3115,1,'en','plugins/ecommerce/order','referral_data.utm_medium','UTM medium','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3116,1,'en','plugins/ecommerce/order','referral_data.utm_term','UTM term','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3117,1,'en','plugins/ecommerce/order','referral_data.utm_content','UTM content','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3118,1,'en','plugins/ecommerce/order','referral_data.referral','Referral','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3119,1,'en','plugins/ecommerce/order','referral_data.referrer_url','Referral URL','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3120,1,'en','plugins/ecommerce/order','referral_data.referrer_domain','Referral domain','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3121,1,'en','plugins/ecommerce/order','order_address_types.shipping_address','Shipping address','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3122,1,'en','plugins/ecommerce/order','order_address_types.billing_address','Billing address','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3123,1,'en','plugins/ecommerce/order','order_return_reasons.damaged','Damaged product','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3124,1,'en','plugins/ecommerce/order','order_return_reasons.defective','Defective','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3125,1,'en','plugins/ecommerce/order','order_return_reasons.incorrect_item','Incorrect item','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3126,1,'en','plugins/ecommerce/order','order_return_reasons.arrived_late','Arrived late','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3127,1,'en','plugins/ecommerce/order','order_return_reasons.not_as_described','Not as described','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3128,1,'en','plugins/ecommerce/order','order_return_reasons.no_longer_want','No longer want','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3129,1,'en','plugins/ecommerce/order','order_return_reasons.other','Other','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3130,1,'en','plugins/ecommerce/order','order_return_reason','Return reason','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3131,1,'en','plugins/ecommerce/order','notices.update_return_order_status_error','Cannot update return order status! Maybe the return order status is not valid.','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3132,1,'en','plugins/ecommerce/order','notices.update_return_order_status_success','Update return order status successfully!','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3133,1,'en','plugins/ecommerce/order','order_return','Order returns','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3134,1,'en','plugins/ecommerce/order','order_return_items_count','Product item(s)','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3135,1,'en','plugins/ecommerce/payment','name','Payments','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3136,1,'en','plugins/ecommerce/payment','payment_method','Payment methods','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3137,1,'en','plugins/ecommerce/payment','view_payment','View payment #','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3138,1,'en','plugins/ecommerce/payment','charge_id','Charge ID','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3139,1,'en','plugins/ecommerce/payment','amount','Amount','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3140,1,'en','plugins/ecommerce/payment','currency','Currency','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3141,1,'en','plugins/ecommerce/payment','user','User','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3142,1,'en','plugins/ecommerce/payment','paypal_name_required','PayPal\'s name is required!','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3143,1,'en','plugins/ecommerce/payment','paypal_name_max','PayPal\'s name is too long!','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3144,1,'en','plugins/ecommerce/payment','status','Status','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3145,1,'en','plugins/ecommerce/payment','enabled','Enabled','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3146,1,'en','plugins/ecommerce/payment','disabled','Disabled','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3147,1,'en','plugins/ecommerce/payment','client_id','Client ID','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3148,1,'en','plugins/ecommerce/payment','client_secret','Client Secret','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3149,1,'en','plugins/ecommerce/payment','mode','Mode','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3150,1,'en','plugins/ecommerce/payment','sandbox','Sandbox','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3151,1,'en','plugins/ecommerce/payment','live','Live','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3152,1,'en','plugins/ecommerce/payment','enable_payment_log','Enable Payment Log','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3153,1,'en','plugins/ecommerce/payment','yes','Yes','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3154,1,'en','plugins/ecommerce/payment','no','No','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3155,1,'en','plugins/ecommerce/payment','client_key','Client Key','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3156,1,'en','plugins/ecommerce/payment','paypal','PayPal','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3157,1,'en','plugins/ecommerce/payment','action','Action','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3158,1,'en','plugins/ecommerce/payment','go_back','Go back','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3159,1,'en','plugins/ecommerce/payment','view','View','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3160,1,'en','plugins/ecommerce/payment','cash_on_delivery','Cash on delivery (COD)','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3161,1,'en','plugins/ecommerce/payment','via_bank_transfer','Via bank transfer','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3162,1,'en','plugins/ecommerce/payment','payment_via_cart','Payment via card','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3163,1,'en','plugins/ecommerce/payment','card_number','Card number','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3164,1,'en','plugins/ecommerce/payment','full_name','Full name','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3165,1,'en','plugins/ecommerce/payment','payment_via_paypal','Payment via PayPal','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3166,1,'en','plugins/ecommerce/payment','mm_yy','MM/YY','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3167,1,'en','plugins/ecommerce/payment','cvc','CVC','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3168,1,'en','plugins/ecommerce/payment','details','Details','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3169,1,'en','plugins/ecommerce/payment','payer_name','Payer Name','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3170,1,'en','plugins/ecommerce/payment','email','Email','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3171,1,'en','plugins/ecommerce/payment','phone','Phone','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3172,1,'en','plugins/ecommerce/payment','country','Country','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3173,1,'en','plugins/ecommerce/payment','shipping_address','Shipping Address','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3174,1,'en','plugins/ecommerce/payment','payment_details','Payment Details','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3175,1,'en','plugins/ecommerce/payment','card','Card','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3176,1,'en','plugins/ecommerce/payment','address','Address','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3177,1,'en','plugins/ecommerce/payment','new_payment','Payment for order :id','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3178,1,'en','plugins/ecommerce/payment','payment_id','Payment ID','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3179,1,'en','plugins/ecommerce/prices','name','Price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3180,1,'en','plugins/ecommerce/prices','create','New price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3181,1,'en','plugins/ecommerce/prices','edit','Edit price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3182,1,'en','plugins/ecommerce/prices','list','List price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3183,1,'en','plugins/ecommerce/product-attribute-sets','name','Product attribute sets','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3184,1,'en','plugins/ecommerce/product-attribute-sets','create','New product attribute set','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3185,1,'en','plugins/ecommerce/product-attribute-sets','edit','Edit product attribute set','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3186,1,'en','plugins/ecommerce/product-attribute-sets','visible_in_categories','Visible in categories','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3187,1,'en','plugins/ecommerce/product-attribute-sets','product_with_more_version','Product with more version','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3188,1,'en','plugins/ecommerce/product-attribute-sets','create_a_version','Create a version','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3189,1,'en','plugins/ecommerce/product-attribute-sets','enabled','Enabled','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3190,1,'en','plugins/ecommerce/product-attribute-sets','attributes','Attributes','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3191,1,'en','plugins/ecommerce/product-attribute-sets','price','Price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3192,1,'en','plugins/ecommerce/product-attribute-sets','edit_btn','Edit','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3193,1,'en','plugins/ecommerce/product-attribute-sets','remove_btn','Remove','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3194,1,'en','plugins/ecommerce/product-attribute-sets','product','Product','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3195,1,'en','plugins/ecommerce/product-attribute-sets','back_to_product','Back to product','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3196,1,'en','plugins/ecommerce/product-attribute-sets','save','Save','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3197,1,'en','plugins/ecommerce/product-attribute-sets','other_existing_versions','Other existing versions','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3198,1,'en','plugins/ecommerce/product-attribute-sets','version_information','Version information','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3199,1,'en','plugins/ecommerce/product-attribute-sets','add_rule','Add rule','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3200,1,'en','plugins/ecommerce/product-attribute-sets','rules','Rules','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3201,1,'en','plugins/ecommerce/product-attribute-sets','pricing','Pricing','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3202,1,'en','plugins/ecommerce/product-attribute-sets','sale_price','Sale price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3203,1,'en','plugins/ecommerce/product-attribute-sets','sale_type','Sale type','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3204,1,'en','plugins/ecommerce/product-attribute-sets','no_sale_price','No sale price','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3205,1,'en','plugins/ecommerce/product-attribute-sets','always_on_sale','Always on sale','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3206,1,'en','plugins/ecommerce/product-attribute-sets','limited_time','Limited time','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3207,1,'en','plugins/ecommerce/product-attribute-sets','from','From','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3208,1,'en','plugins/ecommerce/product-attribute-sets','to','To','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3209,1,'en','plugins/ecommerce/product-attribute-sets','storehouse','Storehouse','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3210,1,'en','plugins/ecommerce/product-attribute-sets','no_storehouse_management','No storehouse management','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3211,1,'en','plugins/ecommerce/product-attribute-sets','with_storehouse_management','With storehouse management','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3212,1,'en','plugins/ecommerce/product-attribute-sets','quantity','Quantity','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3213,1,'en','plugins/ecommerce/product-attribute-sets','allow_customer_checkout_out_of_stock','Allow customer checkout when this product out of stock','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3214,1,'en','plugins/ecommerce/product-attribute-sets','shipping','Shipping','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3215,1,'en','plugins/ecommerce/product-attribute-sets','length','Length','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3216,1,'en','plugins/ecommerce/product-attribute-sets','wide','Wide','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3217,1,'en','plugins/ecommerce/product-attribute-sets','height','Height','2022-11-10 21:04:54','2022-11-10 21:04:54'),(3218,1,'en','plugins/ecommerce/product-attribute-sets','weight','Weight','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3219,1,'en','plugins/ecommerce/product-attribute-sets','version_images','Version images','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3220,1,'en','plugins/ecommerce/product-attribute-sets','add_new_image','Add new image','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3221,1,'en','plugins/ecommerce/product-attribute-sets','attribute_set','Attribute set','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3222,1,'en','plugins/ecommerce/product-attribute-sets','value','Value','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3223,1,'en','plugins/ecommerce/product-attribute-sets','dropdown_swatch','Dropdown Swatch','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3224,1,'en','plugins/ecommerce/product-attribute-sets','visual_swatch','Visual Swatch','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3225,1,'en','plugins/ecommerce/product-attribute-sets','text_swatch','Text Swatch','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3226,1,'en','plugins/ecommerce/product-attribute-sets','display_layout','Display Layout','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3227,1,'en','plugins/ecommerce/product-attribute-sets','searchable','Searchable','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3228,1,'en','plugins/ecommerce/product-attribute-sets','comparable','Comparable','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3229,1,'en','plugins/ecommerce/product-attribute-sets','use_in_product_listing','Used in product listing','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3230,1,'en','plugins/ecommerce/product-attribute-sets','attributes_list','Attributes list','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3231,1,'en','plugins/ecommerce/product-attribute-sets','is_default','Is default?','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3232,1,'en','plugins/ecommerce/product-attribute-sets','title','Title','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3233,1,'en','plugins/ecommerce/product-attribute-sets','slug','Slug','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3234,1,'en','plugins/ecommerce/product-attribute-sets','color','Color','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3235,1,'en','plugins/ecommerce/product-attribute-sets','image','Image','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3236,1,'en','plugins/ecommerce/product-attribute-sets','remove','Remove','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3237,1,'en','plugins/ecommerce/product-attribute-sets','add_new_attribute','Add new attribute','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3238,1,'en','plugins/ecommerce/product-attribute-sets','use_image_from_product_variation','Use image from product variation (for Visual Swatch only)','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3239,1,'en','plugins/ecommerce/product-attributes','name','Product attributes','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3240,1,'en','plugins/ecommerce/product-attributes','create','New product attribute','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3241,1,'en','plugins/ecommerce/product-attributes','edit','Edit product attribute','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3242,1,'en','plugins/ecommerce/product-attributes','intro.title','Manage product attributes','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3243,1,'en','plugins/ecommerce/product-attributes','intro.description','Product attribute such as color, width, height ...','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3244,1,'en','plugins/ecommerce/product-attributes','intro.button_text','Create product attribute','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3245,1,'en','plugins/ecommerce/product-categories','name','Product categories','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3246,1,'en','plugins/ecommerce/product-categories','create','Create new product category','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3247,1,'en','plugins/ecommerce/product-categories','edit','Edit product category','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3248,1,'en','plugins/ecommerce/product-categories','list','List product categories','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3249,1,'en','plugins/ecommerce/product-categories','none','None','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3250,1,'en','plugins/ecommerce/product-categories','menu','Product categories','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3251,1,'en','plugins/ecommerce/product-categories','intro.title','Manage product categories','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3252,1,'en','plugins/ecommerce/product-categories','intro.description','Such as clothes, shoes, bags, jewelry ...','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3253,1,'en','plugins/ecommerce/product-categories','intro.button_text','Create product category','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3254,1,'en','plugins/ecommerce/product-categories','total_products','Total products: :total','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3255,1,'en','plugins/ecommerce/product-collections','name','Product collections','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3256,1,'en','plugins/ecommerce/product-collections','create','New product collection','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3257,1,'en','plugins/ecommerce/product-collections','edit','Edit product collection','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3258,1,'en','plugins/ecommerce/product-collections','slug_help_block','Label key: <code>:slug</code>. We will use this key for filter.','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3259,1,'en','plugins/ecommerce/product-collections','intro.title','Manage product collections','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3260,1,'en','plugins/ecommerce/product-collections','intro.description','Group your products into collections to make it easier for customers to find them by category.','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3261,1,'en','plugins/ecommerce/product-collections','intro.button_text','Create product collection','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3262,1,'en','plugins/ecommerce/product-label','name','Product labels','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3263,1,'en','plugins/ecommerce/product-label','create','New product label','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3264,1,'en','plugins/ecommerce/product-label','edit','Edit product label','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3265,1,'en','plugins/ecommerce/product-label','color','Color','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3266,1,'en','plugins/ecommerce/product-label','color_placeholder','Example: #f0f0f0','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3267,1,'en','plugins/ecommerce/product-option','name','Product Options','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3268,1,'en','plugins/ecommerce/product-option','options','Options','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3269,1,'en','plugins/ecommerce/product-option','create','New option','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3270,1,'en','plugins/ecommerce/product-option','edit','Edit option','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3271,1,'en','plugins/ecommerce/product-option','required','Is required?','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3272,1,'en','plugins/ecommerce/product-option','option_value','Option value','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3273,1,'en','plugins/ecommerce/product-option','option_type','Type','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3274,1,'en','plugins/ecommerce/product-option','label','Label','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3275,1,'en','plugins/ecommerce/product-option','price','Price','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3276,1,'en','plugins/ecommerce/product-option','price_type','Price Type','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3277,1,'en','plugins/ecommerce/product-option','percent','Percent','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3278,1,'en','plugins/ecommerce/product-option','fixed','Fixed','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3279,1,'en','plugins/ecommerce/product-option','label_placeholder','Please fill label','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3280,1,'en','plugins/ecommerce/product-option','affect_price_label','Please fill affect price','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3281,1,'en','plugins/ecommerce/product-option','add_new_row','Add new row','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3282,1,'en','plugins/ecommerce/product-option','add_new_option','Add new option','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3283,1,'en','plugins/ecommerce/product-option','select_global_option','Select Global Option','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3284,1,'en','plugins/ecommerce/product-option','add_global_option','Add Global Option','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3285,1,'en','plugins/ecommerce/product-option','please_select_option','Please select option','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3286,1,'en','plugins/ecommerce/product-option','add_to_cart_value_required','Option :value is required','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3287,1,'en','plugins/ecommerce/product-option','option_value_attribute','value :item of :value_key on option #:option_key','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3288,1,'en','plugins/ecommerce/product-option','option_name_attribute','Option :key','2022-11-10 21:04:55','2022-11-10 21:04:55'),(3289,1,'en','plugins/ecommerce/product-option','option_type_attribute','Type of option :key','2022-11-1