<?php

namespace Botble\Theme\Commands;

use Botble\Theme\Commands\Traits\ThemeTrait;
use Botble\Theme\Services\ThemeService;
use Illuminate\Console\Command;
use Illuminate\Console\ConfirmableTrait;

class ThemeRemoveCommand extends Command
{
    use ThemeTrait;
    use ConfirmableTrait;

    /**
     * @var ThemeService
     */
    public $themeService;

    /**
     * The console command name.
     *
     * @var string
     */
    protected $signature = 'cms:theme:remove
        {name : The theme that you want to remove}
        {--force : Force to remove theme without confirmation}
        {--path= : Path to theme directory}
    ';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Remove an existing theme';

    /**
     * ThemeRemoveCommand constructor.
     * @param ThemeService $themeService
     */
    public function __construct(ThemeService $themeService)
    {
        parent::__construct();
        $this->themeService = $themeService;
    }

    /**
     * Execute the console command.
     *
     * @return int
     * @throws \Exception
     */
    public function handle()
    {
        if (!$this->confirmToProceed('Are you sure you want to permanently delete?', true)) {
            return 1;
        }

        if (!preg_match('/^[a-z0-9\-]+$/i', $this->argument('name'))) {
            $this->error('Only alphabetic characters are allowed.');

            return 1;
        }

        $result = $this->themeService->remove($this->getTheme());

        if ($result['error']) {
            $this->error($result['message']);

            return 1;
        }

        $this->info($result['message']);

        return 0;
    }
}
