<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <div class="invoice-info">
                <div class="mb-3">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <?php if($invoice->company_logo): ?>
                                <img src="<?php echo e(RvMedia::getImageUrl($invoice->company_logo)); ?>" style="max-height: 150px;" alt="<?php echo e($invoice->company_name); ?>">
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6 text-end">
                            <h2 class="mb-0 uppercase"><?php echo e(trans('plugins/ecommerce::invoice.heading')); ?></h2>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6"></div>
                        <div class="col-md-6 text-end">
                            <ul class="mb-0">
                                <?php if($invoice->customer_name): ?>
                                    <li><?php echo e($invoice->customer_name); ?></li>
                                <?php endif; ?>
                                <?php if($invoice->customer_email): ?>
                                    <li><?php echo e($invoice->customer_email); ?></li>
                                <?php endif; ?>
                                <?php if($invoice->customer_phone): ?>
                                    <li><?php echo e($invoice->customer_phone); ?></li>
                                <?php endif; ?>
                                <?php if($invoice->customer_address): ?>
                                    <li><?php echo e($invoice->customer_address); ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="row mb-3">
                    <div class="col-12">
                        <hr>
                    </div>
                    <div class="col-lg-4">
                        <strong class="text-brand"><?php echo e(trans('plugins/ecommerce::invoice.detail.code')); ?>:</strong>
                        <?php echo e($invoice->code); ?>

                    </div>
                    <?php if($invoice->created_at): ?>
                        <div class="col-lg-4">
                            <strong class="text-brand"><?php echo e(trans('plugins/ecommerce::invoice.detail.issue_at')); ?>:</strong>
                            <?php echo e($invoice->created_at->translatedFormat('j F, Y')); ?>

                        </div>
                    <?php endif; ?>
                    <?php if($invoice->payment->payment_channel->label()): ?>
                        <div class="col-lg-4">
                            <strong class="text-brand"><?php echo e(trans('plugins/ecommerce::invoice.payment_method')); ?>:</strong>
                            <?php echo e($invoice->payment->payment_channel->label()); ?>

                        </div>
                    <?php endif; ?>
                    <div class="col-12">
                        <hr>
                    </div>
                </div>
                <table class="table table-striped mb-3">
                    <thead>
                    <tr>
                        <th><?php echo e(trans('plugins/ecommerce::invoice.detail.description')); ?></th>
                        <th><?php echo e(trans('plugins/ecommerce::invoice.detail.qty')); ?></th>
                        <th class="text-center"><?php echo e(trans('plugins/ecommerce::invoice.total_amount')); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $invoice->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td style="width: 70%">
                                <p class="mb-0"><?php echo e($item->name); ?></p>
                                <?php if($item->description): ?>
                                    <small><?php echo e($item->description); ?></small>
                                <?php endif; ?>
                            </td>
                            <td style="width: 5%"><?php echo e($item->qty); ?></td>
                            <td style="width: 25%" class="text-center"><?php echo e(format_price($item->amount)); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th colspan="2" class="text-end"><?php echo e(trans('plugins/ecommerce::invoice.detail.sub_total')); ?>:
                        </th>
                        <th class="text-center"><?php echo e(format_price($invoice->sub_total)); ?></th>
                    </tr>
                    <?php if($invoice->tax_amount > 0): ?>
                        <tr>
                            <th colspan="2" class="text-end"><?php echo e(trans('plugins/ecommerce::invoice.detail.tax')); ?>:</th>
                            <th class="text-center"><?php echo e(format_price($invoice->tax_amount)); ?></th>
                        </tr>
                    <?php endif; ?>
                    <?php if($invoice->shipping_amount > 0): ?>
                        <tr>
                            <th colspan="2"
                                class="text-end"><?php echo e(trans('plugins/ecommerce::invoice.detail.shipping_fee')); ?>:
                            </th>
                            <th class="text-center"><?php echo e(format_price($invoice->shipping_amount)); ?></th>
                        </tr>
                    <?php endif; ?>
                    <?php if($invoice->discount_amount > 0): ?>
                        <tr>
                            <th colspan="2" class="text-end"><?php echo e(trans('plugins/ecommerce::invoice.detail.discount')); ?>:
                            </th>
                            <th class="text-center"><?php echo e(format_price($invoice->discount_amount)); ?></th>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <th colspan="2" class="text-end"><?php echo e(trans('plugins/ecommerce::invoice.detail.grand_total')); ?>:
                        </th>
                        <th class="text-center"><?php echo e(format_price($invoice->amount)); ?></th>
                    </tr>
                    </tfoot>
                </table>
                <div class="row">
                    <div class="col-md-6">
                        <h5><?php echo e(trans('plugins/ecommerce::invoice.detail.invoice_for')); ?></h5>
                        <p class="font-sm">
                            <?php if($invoice->created_at): ?>
                                <strong><?php echo e(trans('plugins/ecommerce::invoice.detail.issue_at')); ?>:</strong> <?php echo e($invoice->created_at->format('j F, Y')); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->company_name): ?>
                                <strong><?php echo e(trans('plugins/ecommerce::invoice.detail.invoice_to')); ?>:</strong> <?php echo e($invoice->company_name); ?><br>
                            <?php endif; ?>

                            <?php if($invoice->customer_tax_id): ?>
                                <strong><?php echo e(trans('plugins/ecommerce::invoice.detail.tax_id')); ?>:</strong> <?php echo e($invoice->customer_tax_id); ?><br>
                            <?php endif; ?>
                        </p>
                    </div>
                    <div class="col-md-6 text-end">
                        <h5><?php echo e(trans('plugins/ecommerce::invoice.total_amount')); ?></h5>
                        <h3 class="mt-0 mb-0 text-danger"><?php echo e(format_price($invoice->amount)); ?></h3>
                    </div>
                </div>
                <hr>
            </div>
        </div>
        <div class="card-footer text-center">
            <a href="<?php echo e(route('ecommerce.invoice.generate-invoice', ['id' => $invoice->id, 'type' => 'print'])); ?>" target="_blank"
               class="btn btn-danger">
                <i class="fas fa-print"></i> <?php echo e(trans('plugins/ecommerce::invoice.print')); ?>

            </a>
            <a href="<?php echo e(route('ecommerce.invoice.generate-invoice', ['id' => $invoice->id, 'type' => 'download'])); ?>"
               target="_blank" class="btn btn-success">
                <i class="fas fa-download"></i> <?php echo e(trans('plugins/ecommerce::invoice.download')); ?>

            </a>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('core/base::layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/baronmac/public_html/platform/plugins/ecommerce//resources/views//invoices/edit.blade.php ENDPATH**/ ?>